/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.adapter.manager.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Joiner;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.manager.model.ReattchParam;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.msg.IAsyncTaskResponseChecker;
import com.huawei.ism.drm.openstack.adapter.util.ClientUtil;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.cache.OpenstackCache;
import com.huawei.ism.drm.openstack.sdk.constants.OpenStackVMActionEnum;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.msg.AdderssPrivateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.AggregateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.CreateServerInfo;
import com.huawei.ism.drm.openstack.sdk.msg.HypervisorInfo;
import com.huawei.ism.drm.openstack.sdk.msg.ReconnectVolumeInfo;
import com.huawei.ism.drm.openstack.sdk.msg.ServerInfo;
import com.huawei.ism.drm.openstack.sdk.msg.SystemCapability;
import com.huawei.ism.drm.openstack.sdk.msg.VMFlavor;
import com.huawei.ism.drm.openstack.sdk.msg.VMInterface;
import com.huawei.ism.drm.openstack.sdk.msg.VolAttachInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeAttachmentInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.task.ForkJoinPoolManager;
import com.huawei.lego.core.base.thread.Enhancer;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.om.util.endpointutil.ServiceEndpointUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveTask;
import java.util.concurrent.TimeUnit;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.net.URLEncodedUtils;

public class NovaManager
implements INovaManager {
    private static final Log LOG = LogFactory.getInstance(NovaManager.class);
    private static final List<String> NORMAL_MIDDLE_VOLUME_STATUSES = Arrays.asList(OpenstackEnumDefine.VolumeStatusE.ATTACHING.getType(), OpenstackEnumDefine.VolumeStatusE.AVAILABLE.getType(), OpenstackEnumDefine.VolumeStatusE.RESERVED.getType());

    @Override
    public AsyncTaskResponse createVm(String regionUuid, String projUuid, String tokenId, CreateServerInfo createInfo) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((Object)createInfo)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "compute");
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.NOVA_CREATE_SERVERS.getUri(), projId);
        JSONObject json = new JSONObject();
        json.put((Object)"server", (Object)JsonUtil.beanToJson(createInfo));
        String respStr = ClientUtil.sendPostRequest(newUrlStr, json.toString(), tokenId);
        LOG.info((Object)"Create VM response: %s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Response string is empty");
            throw new LegoCheckedException(1073948363L);
        }
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || jsonNode.path("server").isMissingNode()) {
            LOG.error((Object)("Bad Request createVM :" + createInfo));
            throw new LegoCheckedException(1073948363L);
        }
        ServerInfo serverInfo = JsonUtil.jsonToBean(jsonNode.path("server").toString(), ServerInfo.class);
        if (null == serverInfo) {
            LOG.error((Object)("Bad Request createVM :" + jsonNode.path("server").toString()));
            throw new LegoCheckedException(1073948363L);
        }
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        OpenStackVM vm = new OpenStackVM();
        vm.setUuid(openstackUuid + ":" + serverInfo.getId());
        return this.checkCreateVmResponse(regionUuid, projUuid, tokenId, vm);
    }

    @Override
    public AsyncTaskResponse deleteVm(String regionUuid, String projUuid, String tokenId, String vmUuid) {
        OpenStackVM vm = this.getVm(regionUuid, tokenId, projUuid, vmUuid, new int[0]);
        if (null == vm) {
            LOG.info((Object)"Delete vm(%s) not exist.", new Object[]{vmUuid});
            AsyncTaskResponse response = new AsyncTaskResponse();
            response.setSuccess(true);
            return response;
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String serverId = OpenStackCommonUtil.getIdFromUuid(vmUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "compute");
        String newUrlStr = urlStr + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.NOVA_DELETE_VM.getUri(), projId, serverId);
        LOG.debug((Object)"Delete vm(%s).request str=%s", new Object[]{vmUuid, newUrlStr});
        ClientUtil.sendDeleteRequest(newUrlStr, tokenId);
        return this.checkDeleteteVmResponse(regionUuid, tokenId, projUuid, serverId, vmUuid);
    }

    private AsyncTaskResponse checkDeleteteVmResponse(final String regionUuid, final String tokenId, final String projUuid, String serverId, final String vmUuid) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(serverId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                OpenStackVM openStackVM = NovaManager.this.getVm(regionUuid, tokenId, projUuid, vmUuid, new int[0]);
                if (null == openStackVM) {
                    response.setSuccess(true);
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    private AsyncTaskResponse checkCreateVmResponse(final String regionUuid, final String projUuid, final String tokenId, final OpenStackVM vmInfo) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(vmInfo, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                OpenStackVM vm = NovaManager.this.getVm(regionUuid, tokenId, projUuid, vmInfo.getUuid(), new int[0]);
                if (null == vm) {
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.VmStatusE.ACTIVE.getValue() == vm.getStatus().intValue()) {
                    response.setSuccess(true);
                    response.setTaskResult(vm);
                    return true;
                }
                if (OpenstackEnumDefine.VmStatusE.BUILD.getValue() != vm.getStatus().intValue()) {
                    LOG.error((Object)("Vm status is not excepted, excepted status: active or build, current status : " + vm.getStatus() + ", vm id: " + vm.getUuid()));
                    response.setSuccess(false);
                    response.setErrorCode("1073948406");
                    response.setTaskResult(vm);
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    @Override
    public List<OpenStackVM> getVms(String regionUuid, String tokenId, String projUuid) {
        return this.getVms(regionUuid, tokenId, projUuid, "2.26");
    }

    @Override
    public List<OpenStackVM> getVms(String regionUuid, String tokenId, String projUuid, String novaApiVersion) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid)) {
            LOG.error((Object)"Failed to get vms.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String cacheKey = Joiner.on((String)"_@_").join((Object[])new String[]{regionUuid, projUuid});
        List vmList = (List)OpenstackCache.getCache(OpenstackCache.CacheType.OPENSTACK_VM_LIST, cacheKey, Enhancer.timeSupplier((String)("Get all vms for project " + projUuid), () -> {
            try {
                return this.getOpenStackVMs(regionUuid, tokenId, projUuid, novaApiVersion);
            }
            catch (LegoCheckedException e) {
                LOG.error((Object)"Get vms error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                throw e;
            }
        }));
        return new ArrayList<OpenStackVM>(vmList);
    }

    private List<OpenStackVM> getOpenStackVMs(String regionUuid, String tokenId, String projUuid, String apiVersion) {
        ForkJoinPool novaForkJoinPool = ForkJoinPoolManager.getInstance().createForkJoinPool(0);
        try {
            OpenStackVmsTask openStackVmsTask = new OpenStackVmsTask(regionUuid, tokenId, projUuid, 1, apiVersion);
            ForkJoinTask<List<OpenStackVM>> openStackVms = novaForkJoinPool.submit(openStackVmsTask);
            List<OpenStackVM> list = openStackVms.get(5L, TimeUnit.MINUTES);
            return list;
        }
        catch (Exception e) {
            LOG.error((Object)"Query OpenStackVms error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073949734L);
        }
        finally {
            novaForkJoinPool.shutdown();
        }
    }

    private Map<String, Object> getVmsFromRespStr(String regionUuid, String projUuid, String respStr) {
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)("Failed to get vms.response string is empty.request str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (!json.containsKey((Object)"servers")) {
            LOG.error((Object)("Failed to get vms.bad Request getServers.request response str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        List<ServerInfo> list = JsonUtil.jsonArrayToList(json.getString("servers"), ServerInfo.class);
        List<OpenStackVM> vmList = this.constructVmList(list, regionUuid, projUuid);
        HashMap<String, String> imageIdMap = new HashMap<String, String>();
        JSONArray jArray = JSONArray.fromObject((Object)json.getString("servers"));
        int size = jArray.size();
        for (int i = 0; i < size; ++i) {
            JSONObject imageObj;
            String imageStr;
            JSONObject jObj = jArray.getJSONObject(i);
            String serverId = jObj.getString("id");
            if (!jObj.containsKey((Object)"image") || VerifyUtil.isEmpty((String)(imageStr = jObj.getString("image"))) || !(imageObj = JSONObject.fromObject((Object)imageStr)).containsKey((Object)"id") || VerifyUtil.isEmpty((String)imageObj.getString("id"))) continue;
            String imageId = imageObj.getString("id");
            imageIdMap.put(serverId, imageId);
        }
        for (OpenStackVM openStackVM : vmList) {
            String serverId = OpenStackCommonUtil.getIdFromUuid(openStackVM.getUuid());
            String imageId = (String)imageIdMap.get(serverId);
            if (VerifyUtil.isEmpty((String)imageId)) continue;
            openStackVM.setImageId(imageId);
        }
        vmList = new ArrayList<OpenStackVM>(vmList);
        Map<String, Object> map = this.getStringObjectMap(json, vmList);
        return map;
    }

    private Map<String, Object> getStringObjectMap(JSONObject json, List<OpenStackVM> vmList) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("servers", vmList);
        map.put("count", json.getInt("count"));
        if (json.containsKey((Object)"servers_links")) {
            JSONArray serversLinks = json.getJSONArray("servers_links");
            String href = serversLinks.getJSONObject(0).getString("href");
            List nameList = URLEncodedUtils.parse((CharSequence)href, (Charset)StandardCharsets.UTF_8);
            for (NameValuePair pair : nameList) {
                if (!"marker".equalsIgnoreCase(pair.getName())) continue;
                map.put("marker", pair.getValue());
            }
        }
        return map;
    }

    private List<OpenStackVM> constructVmList(List<ServerInfo> serverList, String regionUuid, String projUuid) {
        ArrayList<OpenStackVM> vmList = new ArrayList<OpenStackVM>();
        for (ServerInfo server : serverList) {
            OpenStackVM vm = this.constructVm(regionUuid, projUuid, server);
            vmList.add(vm);
        }
        return vmList;
    }

    private OpenStackVM constructVm(String regionUuid, String projUuid, ServerInfo server) {
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        OpenStackVM vm = new OpenStackVM();
        if (null != server.getVolumesAttached()) {
            vm.setVolumeAttached(this.getVolsStr(server.getVolumesAttached(), openstackUuid));
        }
        vm.setUuid(openstackUuid + ":" + server.getId());
        vm.setRegionUuid(regionUuid);
        vm.setRegionName(OpenStackCommonUtil.getIdFromUuid(regionUuid));
        vm.setProjectUuid(projUuid);
        vm.setAzName(server.getAvailabilityZone());
        vm.setName(server.getName());
        vm.setHypervisorHostName(server.getHypervisorHostName());
        vm.setAddresses(server.getAddresses());
        this.extracted(regionUuid, server, vm);
        vm.setTags(server.getTags());
        vm.setMetadata(server.getMetadata());
        vm.setArchitecture(server.getArchitecture());
        vm.setCpuVendor(server.getCpuVendor());
        if (VerifyUtil.isEmpty((String)vm.getArchitecture())) {
            if (VerifyUtil.isEmpty((String)vm.getCpuVendor())) {
                vm.setArchitecture(OpenstackEnumDefine.ArchitectureAndCpuVendor.INTEL.getArchitecture());
                vm.setCpuVendor(OpenstackEnumDefine.ArchitectureAndCpuVendor.INTEL.getCpuVendor());
            } else {
                vm.setArchitecture(OpenstackEnumDefine.ArchitectureAndCpuVendor.getArchitectureByCpuVendor((String)vm.getCpuVendor()));
            }
        }
        if (VerifyUtil.isEmpty((String)vm.getCpuVendor())) {
            vm.setCpuVendor(OpenstackEnumDefine.ArchitectureAndCpuVendor.getCpuVendorByArchitecture((String)vm.getArchitecture()));
        }
        return vm;
    }

    private void extracted(String regionUuid, ServerInfo server, OpenStackVM vm) {
        if (null != server.getStatus()) {
            vm.setStatus(Integer.valueOf(OpenstackEnumDefine.VmStatusE.getStatus((String)server.getStatus()).getValue()));
        }
        if (null == server.getLocked()) {
            vm.setLocked(Boolean.valueOf(!VerifyUtil.isEmpty((String)server.getLockedBy())));
        } else {
            vm.setLocked(server.getLocked());
        }
        vm.setBootDevName(server.getBootDev());
        vm.setTopMoUuid(OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid));
        if (null != server.getFlavor()) {
            vm.setFlavorId(server.getFlavor().getId());
        }
        vm.setVmTaskState(server.getTaskState());
        if (null != server.getAddresses() && null != CommonUtil.getFirstElement(server.getAddresses().values()) && null != CommonUtil.getFirstElement((Collection)((Collection)CommonUtil.getFirstElement(server.getAddresses().values())))) {
            for (AdderssPrivateInfo adderssPrivateInfo : (List)CommonUtil.getFirstElement(server.getAddresses().values())) {
                if (Objects.equals("floating", adderssPrivateInfo.getType())) continue;
                if (!VerifyUtil.isEmpty((String)adderssPrivateInfo.getAddr()) && adderssPrivateInfo.getAddr().indexOf(":") != -1) {
                    vm.setAddressIpv6(adderssPrivateInfo.getAddr());
                    continue;
                }
                vm.setAddressIp(adderssPrivateInfo.getAddr());
            }
        }
    }

    private String getVolsStr(List<VolumeInfo> volList, String openstackUuid) {
        StringBuffer volStr = new StringBuffer();
        for (VolumeInfo vol : volList) {
            String uuid = openstackUuid + ":" + vol.getId();
            volStr.append(uuid + ",");
        }
        if (volStr.length() > 0) {
            return volStr.substring(0, volStr.length() - 1);
        }
        return "";
    }

    @Override
    public OpenStackVM getVm(String regionUuid, String tokenId, String projUuid, String vmUuid, int ... retryTimes) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)vmUuid)) {
            LOG.error((Object)("Query Vm.parameter is empty, regionUuid: " + regionUuid + ", projUuid: " + projUuid + ", vmUuid: " + vmUuid));
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String serverId = OpenStackCommonUtil.getIdFromUuid(vmUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "compute");
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.NOVA_QUERY_SERVER.getUri(), projId, serverId);
        LOG.debug((Object)"Start get servers infomation.serverID=%s,request str=%s", new Object[]{vmUuid, newUrlStr});
        HashMap<String, String> novaVersion = new HashMap<String, String>();
        novaVersion.put("X_OPENSTACK_NOVA_API_VERSION", "2.26");
        String respStr = ClientUtil.sendGetRequest(newUrlStr, null, tokenId, novaVersion, retryTimes);
        LOG.info((Object)"Get servers success:servers=%s", new Object[]{SecurityUtil.desensitization((String)respStr)});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)("Get servers serverID=" + vmUuid + " infomation failed.response string is empty.request str=" + newUrlStr + "reponse str=" + SecurityUtil.desensitization((String)respStr)));
            throw new LegoCheckedException(0x300001L);
        }
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || !jsonNode.path("itemNotFound").isMissingNode()) {
            LOG.error((Object)("Get servers infomation failed.jsnode is null.request str=" + newUrlStr + "reponse str=" + SecurityUtil.desensitization((String)respStr)));
            return null;
        }
        if (jsonNode.path("server").isMissingNode()) {
            LOG.error((Object)("Get servers infomation failed.response string do not contain server keywords.request str=" + newUrlStr + "reponse str=" + SecurityUtil.desensitization((String)respStr)));
            throw new LegoCheckedException(0x300001L);
        }
        ServerInfo server = JsonUtil.jsonToBean(jsonNode.path("server").toString(), ServerInfo.class);
        if (null == server) {
            LOG.error((Object)("Get servers infomation failed.server is null.request str=" + newUrlStr + "reponse str=" + SecurityUtil.desensitization((String)respStr)));
            return null;
        }
        return this.constructVm(regionUuid, projUuid, server);
    }

    @Override
    public List<VMInterface> getVmInterfaces(String regionUuid, String tokenId, String projUuid, String vmUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)vmUuid)) {
            LOG.error((Object)"Get server interfaces failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String serverId = OpenStackCommonUtil.getIdFromUuid(vmUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "compute");
        String newUrlStr = urlStr + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.NOVA_LIST_SERVER_INTERFACES.getUri(), projId, serverId);
        LOG.info((Object)"Get server interfaces request str = %s,vmUuid=%s", new Object[]{newUrlStr, vmUuid});
        String respStr = ClientUtil.sendGetRequest(newUrlStr, tokenId);
        LOG.info((Object)"Get server interfaces response = %s,vmUuid=%s", new Object[]{respStr, vmUuid});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)("Get server interfaces failed.response string is empty, request str = " + newUrlStr + "vmUuid=" + vmUuid));
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (json.containsKey((Object)"itemNotFound")) {
            LOG.error((Object)("Get server interfaces failed.server is not found, server id\uff1a" + serverId + "request str=" + newUrlStr + "response str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        if (!json.containsKey((Object)"interfaceAttachments")) {
            LOG.error((Object)("Get server interfaces failed.bad Request getServerInterfaces,server id\uff1a" + serverId + ",request str=" + newUrlStr + "response str =" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        String arrayStr = json.getString("interfaceAttachments");
        return JsonUtil.jsonArrayToList(arrayStr, VMInterface.class);
    }

    @Override
    public List<VMFlavor> getVmFlavors(String regionUuid, String tokenId, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid)) {
            LOG.error((Object)"Failed to get vm flavors.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "compute");
        String newUrlStr = urlStr + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.NOVA_QUERY_SERVER_FLAVORS.getUri(), projId);
        LOG.debug((Object)"Get vm flavors.request str=%s", new Object[]{newUrlStr});
        String respStr = ClientUtil.sendGetRequest(newUrlStr, tokenId);
        LOG.debug((Object)"Get vm flavors.response str=%s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)("Failed to get vm flavors.response string is empty.request str=" + newUrlStr));
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (!json.containsKey((Object)"flavors")) {
            LOG.error((Object)("\"Failed to get vm flavors.bad Request getFlavors.request str=" + newUrlStr + ", response str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        return JsonUtil.jsonArrayToList(json.getString("flavors"), VMFlavor.class);
    }

    @Override
    public AsyncTaskResponse lockVm(String regionUuid, String tokenId, String projUuid, String vmUuid) {
        return this.lockOrUnlockVm(regionUuid, tokenId, projUuid, vmUuid, true);
    }

    @Override
    public AsyncTaskResponse unlockVm(String regionUuid, String tokenId, String projUuid, String vmUuid) {
        return this.lockOrUnlockVm(regionUuid, tokenId, projUuid, vmUuid, false);
    }

    private AsyncTaskResponse lockOrUnlockVm(String regionUuid, String tokenId, String projUuid, String vmUuid, boolean lockVm) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)vmUuid)) {
            LOG.error((Object)"Operation lockAndUnlockVm.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String serverId = OpenStackCommonUtil.getIdFromUuid(vmUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "compute");
        String newUrlStr = urlStr + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.NOVA_SERVER_ACTION.getUri(), projId, serverId);
        LOG.debug((Object)"Lock/unlock vm:%s", new Object[]{vmUuid});
        String message = lockVm ? "{\"lock\":null}" : "{\"unlock\":null}";
        String respStr = ClientUtil.sendPostRequest(newUrlStr, message, tokenId);
        LOG.info((Object)"LockOrUnlockVm response is:%s, requestStr:%s", new Object[]{respStr, newUrlStr});
        if (!VerifyUtil.isEmpty((String)respStr)) {
            return this.checkLockVmResponse(regionUuid, tokenId, projUuid, vmUuid, lockVm);
        }
        AsyncTaskResponse response = new AsyncTaskResponse();
        LOG.info((Object)"Operation LockAndUnlockVm succeed.vmUuid=%s", new Object[]{vmUuid});
        response.setSuccess(true);
        return response;
    }

    private AsyncTaskResponse checkLockVmResponse(final String regionUuid, final String tokenId, final String projUuid, final String vmUuid, final boolean expectLockStatus) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(vmUuid, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                OpenStackVM vm = NovaManager.this.getVm(regionUuid, tokenId, projUuid, vmUuid, new int[0]);
                if (null == vm) {
                    LOG.error((Object)("Check Lock Vm failed. vm not found, Vm id: " + vmUuid));
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (expectLockStatus == vm.getLocked()) {
                    LOG.error((Object)("Check Lock Vm succeed.  Vm id: " + vmUuid));
                    response.setSuccess(true);
                    return true;
                }
                LOG.error((Object)("Vm locked status is not excepted, excepted status: " + expectLockStatus + ", current status :" + vm.getLocked() + ", vm id: " + vmUuid));
                response.setSuccess(false);
                response.setErrorCode("3145729");
                return false;
            }
        });
        return response;
    }

    @Override
    public void addTagToVm(String regionUuid, String tokenId, String projUuid, String vmUuid, String tag) {
        this.addOrDeleteTag(regionUuid, tokenId, projUuid, vmUuid, tag, true);
    }

    @Override
    public void deleteTagFromVm(String regionUuid, String tokenId, String projUuid, String vmUuid, String tag) {
        this.addOrDeleteTag(regionUuid, tokenId, projUuid, vmUuid, tag, false);
    }

    @Override
    public void deleteDrBackUpTagFromVm(String regionUuid, String tokenId, String projUuid, String vmUuid, OpenStackVM vm) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)vmUuid)) {
            LOG.error((Object)"Delete drback tag failed. parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Object)vm) || VerifyUtil.isEmpty((Collection)vm.getTags())) {
            LOG.info((Object)"Failed to delete the drBackup tag because the vm or vm.getTags parameter is empty, vmUuid=%s", new Object[]{vmUuid});
            return;
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String serverId = OpenStackCommonUtil.getIdFromUuid(vmUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "compute");
        for (String tag : vm.getTags()) {
            if (!tag.startsWith("dr_backup_vm::") && !tag.startsWith("dr_backup_region::")) continue;
            String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.NOVA_SERVER_TAG.getUri(), projId, serverId, tag);
            ClientUtil.sendDeleteRequest(newUrlStr, tokenId);
            LOG.debug((Object)"Delete drBackup tag succeed. Tag: %s is existed on server: %s.", new Object[]{tag, vmUuid});
        }
    }

    private void addOrDeleteTag(String regionUuid, String tokenId, String projUuid, String vmUuid, String tag, boolean isAdd) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)vmUuid)) {
            LOG.error((Object)"Add or delete tag failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)tag)) {
            LOG.info((Object)"Add or delete tag succeed.tag is empty, vmUuid=%s", new Object[]{vmUuid});
            return;
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String serverId = OpenStackCommonUtil.getIdFromUuid(vmUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "compute");
        String newUrlStr = urlStr + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.NOVA_SERVER_TAG.getUri(), projId, serverId, tag);
        LOG.debug((Object)"Add or delete tag failed.tag is empty.request str=%s, vmUuid=%s", new Object[]{newUrlStr, vmUuid});
        String respStr = ClientUtil.sendGetRequest(newUrlStr, tokenId);
        LOG.debug((Object)"Add or delete tag failed.tag is empty.response str=%s, vmUuid=%s", new Object[]{respStr, vmUuid});
        if (isAdd) {
            if (VerifyUtil.isEmpty((String)respStr)) {
                LOG.info((Object)"Add or delete tag succeed.tag(%s) is existed on server %s.", new Object[]{tag, serverId});
                return;
            }
            JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
            if (null == jsonNode || !jsonNode.path("itemNotFound").isMissingNode()) {
                ClientUtil.sendPutRequest(newUrlStr, null, tokenId);
                return;
            }
        } else if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.debug((Object)"Tag(%s) is existed on server %s.", new Object[]{tag, serverId});
            ClientUtil.sendDeleteRequest(newUrlStr, tokenId);
        }
    }

    @Override
    public AsyncTaskResponse attachVolumeToVM(String tokenId, String projcetUuid, String regionUuid, String vmUuid, String vmType, String volumeId, String deviceName) {
        if (VerifyUtil.isEmpty((String)projcetUuid) || VerifyUtil.isEmpty((String)vmUuid) || VerifyUtil.isEmpty((String)volumeId) || VerifyUtil.isEmpty((String)deviceName) || VerifyUtil.isEmpty((String)tokenId)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projcetUuid);
        String serverId = OpenStackCommonUtil.getIdFromUuid(vmUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "compute");
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.NOVA_VOLUME_ATTACH.getUri(), projId, serverId);
        JSONObject reqJson = new JSONObject();
        reqJson.put((Object)"volumeId", (Object)volumeId);
        if ("BMS".equals(vmType)) {
            urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "apicom");
            newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.APICOM_VOLUME_ATTACH.getUri(), projId, serverId);
        } else {
            reqJson.put((Object)"device", (Object)deviceName);
        }
        JSONObject msg = new JSONObject();
        msg.put((Object)"volumeAttachment", (Object)reqJson.toString());
        LOG.debug((Object)"Attach volume to VM.request str is:%s,request url=%s", new Object[]{msg, newUrlStr});
        String respStr = ClientUtil.sendPostRequest(newUrlStr, msg.toString(), tokenId);
        LOG.debug((Object)"Attach volume to VM. response: %s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)("Failed to attach volume to VM.response string is empty.request str is:" + msg + ",request url=" + newUrlStr));
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (!json.containsKey((Object)"volumeAttachment") && !"BMS".equals(vmType)) {
            LOG.error((Object)("Failed to attach volume to VM.bad Request attachVolumeToVM :" + volumeId + ", request str is:" + msg + ",request url=" + newUrlStr + ", response: " + respStr));
            response.setSuccess(false);
            response.setErrorCode("3145729");
            return response;
        }
        return this.checkAttachVolResponse(regionUuid, tokenId, projcetUuid, volumeId, serverId);
    }

    private AsyncTaskResponse checkAttachVolResponse(final String regionUuid, final String tokenId, final String projcetUuid, final String volumeId, final String serverId) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(volumeId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                LOG.debug((Object)"Check volume(%s) attach to server(%s)", new Object[]{volumeId, serverId});
                CinderManager cinderMgr = new CinderManager();
                VolumeInfo volume = cinderMgr.queryVolume(regionUuid, tokenId, projcetUuid, volumeId);
                if (null == volume) {
                    LOG.error((Object)("Failed to check volume(" + volumeId + ") attach to server(" + serverId + ")"));
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.VolumeStatusE.INUSE.getType().equals(volume.getStatus())) {
                    if (null == volume.getAttachments()) {
                        return false;
                    }
                    for (VolumeAttachmentInfo attach : volume.getAttachments()) {
                        LOG.debug((Object)"Attach info: serverId is: %s, devname is\uff1a%s", new Object[]{attach.getServerId(), attach.getDevice()});
                        if (!serverId.equals(attach.getServerId())) continue;
                        response.setSuccess(true);
                        return true;
                    }
                } else if (!NORMAL_MIDDLE_VOLUME_STATUSES.contains(volume.getStatus())) {
                    LOG.error((Object)("Volume status is not excepted, excepted status: available or attaching, current status : " + volume.getStatus() + ", volume id: " + volumeId));
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    @Override
    public VMInterface attachPortToVM(String portId, String vmUuid, String projectUuid, String regionUuid, String tokenId) {
        if (VerifyUtil.isEmpty((String)projectUuid) || VerifyUtil.isEmpty((String)vmUuid) || VerifyUtil.isEmpty((String)portId) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)regionUuid)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        String serverId = OpenStackCommonUtil.getIdFromUuid(vmUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "compute");
        String newUrlStr = urlStr + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.NOVA_PORT_ATTACH.getUri(), projId, serverId);
        JSONObject jsonInfo = new JSONObject();
        jsonInfo.put((Object)"port_id", (Object)portId);
        JSONObject reqJson = new JSONObject();
        reqJson.put((Object)"interfaceAttachment", (Object)jsonInfo);
        LOG.info((Object)"AddPortToVm, reqJson is:%s", new Object[]{reqJson});
        String respStr = ClientUtil.sendPostRequest(newUrlStr, reqJson.toString(), tokenId);
        LOG.info((Object)"AddPortToVM response is:%s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)("Failed to add port to VM.response string is empty.request str=" + newUrlStr));
            throw new LegoCheckedException(1073948911L);
        }
        JSONObject result = JSONObject.fromObject((Object)respStr);
        if (!result.containsKey((Object)"interfaceAttachment")) {
            LOG.error((Object)("Failed to add port to VM.Not include interfaceAttachment.request str=" + newUrlStr + ",response str=" + respStr));
            throw new LegoCheckedException(1073948911L);
        }
        LOG.debug((Object)"InterfaceAttachment is:%s", new Object[]{result.getJSONObject("interfaceAttachment")});
        return JsonUtil.jsonToBean(result.getJSONObject("interfaceAttachment").toString(), VMInterface.class);
    }

    @Override
    public AsyncTaskResponse detachPortFromVM(String portId, String vmUuid, String projectUuid, String regionUuid, String tokenId) {
        if (VerifyUtil.isEmpty((String)projectUuid) || VerifyUtil.isEmpty((String)vmUuid) || VerifyUtil.isEmpty((String)portId) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)regionUuid)) {
            LOG.error((Object)"Detach port from VM failed. parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        List<VMInterface> srcVmPortList = this.getVmInterfaces(regionUuid, tokenId, projectUuid, vmUuid);
        boolean hasPort = false;
        for (VMInterface vMInterface : srcVmPortList) {
            if (!portId.equals(vMInterface.getPortId())) continue;
            hasPort = true;
            break;
        }
        if (!hasPort) {
            LOG.info((Object)"Detach port from VM succeed.port(%s) is not in the vm:%s", new Object[]{portId, vmUuid});
            AsyncTaskResponse response = new AsyncTaskResponse();
            response.setSuccess(true);
            return response;
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        String serverId = OpenStackCommonUtil.getIdFromUuid(vmUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "compute");
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.NOVA_PORT_DETACH.getUri(), projId, serverId, portId);
        LOG.debug((Object)"Detach port from VM request str is:%s", new Object[]{newUrlStr});
        String respStr = ClientUtil.sendDeleteRequest(newUrlStr, tokenId);
        LOG.debug((Object)"Detach port from VM response is:%s", new Object[]{respStr});
        if (!VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)("Detach port from VM failed.response string is not empty,vmUuid=" + vmUuid + "response is:" + respStr + "request str is:" + newUrlStr));
            throw new LegoCheckedException(1073948912L);
        }
        return this.checkDeletePortResponse(regionUuid, tokenId, projectUuid, portId, vmUuid);
    }

    private AsyncTaskResponse checkDeletePortResponse(final String regionUuid, final String tokenId, final String projectUuid, final String portId, final String vmUuid) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(portId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                List<VMInterface> interfaces = NovaManager.this.getVmInterfaces(regionUuid, tokenId, projectUuid, vmUuid);
                LOG.info((Object)"Interfaces is:%s,vmuuid is:%s,portId is:%s", new Object[]{interfaces, vmUuid, portId});
                if (VerifyUtil.isEmpty(interfaces)) {
                    LOG.info((Object)"Check delete port response succeed. interfaces is empty.vmuuid is:%s", new Object[]{vmUuid});
                    response.setSuccess(true);
                    return true;
                }
                for (VMInterface vmInterface : interfaces) {
                    if (!vmInterface.getPortId().equals(portId)) continue;
                    LOG.error((Object)("Check delete port response failed.vmInterface port id" + vmInterface.getPortId() + " is not equals portid" + portId + ", vmuuid is" + vmUuid));
                    return false;
                }
                LOG.info((Object)"Check delete port response succeed.vmuuid is:%s", new Object[]{vmUuid});
                response.setSuccess(true);
                return true;
            }
        });
        return response;
    }

    @Override
    public AsyncTaskResponse vmActionWithoutCheck(String vmUuid, String projectUuid, String regionUuid, String tokenId, OpenStackVMActionEnum action) {
        JSONObject json;
        String respStr = this.getActionRespStr(vmUuid, projectUuid, regionUuid, tokenId, action);
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (!VerifyUtil.isEmpty((String)respStr) && (json = JSONObject.fromObject((Object)respStr)).containsKey((Object)"itemNotFound")) {
            response.setSuccess(false);
            return response;
        }
        response.setSuccess(true);
        return response;
    }

    @Override
    public AsyncTaskResponse vmAction(String vmUuid, String projectUuid, String regionUuid, String tokenId, OpenStackVMActionEnum action) {
        String respStr = this.getActionRespStr(vmUuid, projectUuid, regionUuid, tokenId, action);
        if (VerifyUtil.isEmpty((String)respStr) || OpenStackVMActionEnum.HARD_STOP.equals((Object)action)) {
            return this.checkVmActionResponse(regionUuid, tokenId, projectUuid, vmUuid, action);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (json.containsKey((Object)"itemNotFound")) {
            response.setSuccess(false);
            return response;
        }
        response.setSuccess(false);
        LOG.error((Object)("Bad Request vmAction: " + vmUuid));
        response.setErrorCode("3145729");
        return response;
    }

    private String getActionRespStr(String vmUuid, String projectUuid, String regionUuid, String tokenId, OpenStackVMActionEnum action) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projectUuid) || VerifyUtil.isEmpty((String)vmUuid) || VerifyUtil.isEmpty((Object)action)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        String serverId = OpenStackCommonUtil.getIdFromUuid(vmUuid);
        String urlStr = "";
        String newUrlStr = "";
        if (OpenStackVMActionEnum.HARD_STOP_IGNORE_CHECK.equals((Object)action)) {
            urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "compute-ext");
            newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.NOVA_EXT_SERVER_ACTION.getUri(), projId, serverId);
        } else {
            urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "compute");
            newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.NOVA_SERVER_ACTION.getUri(), projId, serverId);
        }
        String message = this.getMessageByAction(action);
        if (null == message) {
            LOG.error((Object)("Dont support this opt:" + action.getAction()));
            throw new LegoCheckedException(1073947393L);
        }
        LOG.debug((Object)"VmAction request is: %s", new Object[]{newUrlStr});
        String respStr = ClientUtil.sendPostRequest(newUrlStr, message, tokenId);
        LOG.info((Object)"VmAction response is: %s", new Object[]{respStr});
        return respStr;
    }

    private String getMessageByAction(OpenStackVMActionEnum action) {
        if (action == OpenStackVMActionEnum.START) {
            return "{\"os-start\":null}";
        }
        if (action == OpenStackVMActionEnum.STOP) {
            return "{\"os-stop\":null}";
        }
        if (action == OpenStackVMActionEnum.HARD_STOP) {
            return "{\"os-stop\":{\"type\": \"HARD\"}}";
        }
        if (action == OpenStackVMActionEnum.HARD_REBOOT) {
            return "{\"reboot\":{\"type\": \"HARD\"}}";
        }
        if (action == OpenStackVMActionEnum.HARD_STOP_IGNORE_CHECK) {
            return "{\"os-stop\":{\"type\": \"HARD\",\"force\": \"True\"}}";
        }
        return null;
    }

    private AsyncTaskResponse checkVmActionResponse(final String regionUuid, final String tokenId, final String projectUuid, final String vmUuid, final OpenStackVMActionEnum action) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(vmUuid, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                OpenStackVM vm = NovaManager.this.getVm(regionUuid, tokenId, projectUuid, vmUuid, new int[0]);
                if (null == vm) {
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                LOG.debug((Object)"Current status : %s, vm id: %s, action:", new Object[]{vm.getStatus().toString(), vmUuid, action.toString()});
                if (action == OpenStackVMActionEnum.START && vm.getStatus().intValue() == OpenstackEnumDefine.VmStatusE.ACTIVE.getValue()) {
                    response.setSuccess(true);
                    return true;
                }
                if (!(action != OpenStackVMActionEnum.STOP && action != OpenStackVMActionEnum.HARD_STOP && action != OpenStackVMActionEnum.HARD_STOP_IGNORE_CHECK || vm.getStatus().intValue() != OpenstackEnumDefine.VmStatusE.SHUTOFF.getValue() && vm.getStatus().intValue() != OpenstackEnumDefine.VmStatusE.STOPPED.getValue())) {
                    response.setSuccess(true);
                    return true;
                }
                if (action == OpenStackVMActionEnum.HARD_REBOOT && vm.getStatus().intValue() == OpenstackEnumDefine.VmStatusE.ACTIVE.getValue()) {
                    response.setSuccess(true);
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    @Override
    public AsyncTaskResponse detachVolFromVm(String tokenId, String projcetUuid, String regionUuid, String vmUuid, String vmType, String volumeId) {
        if (VerifyUtil.isEmpty((String)projcetUuid) || VerifyUtil.isEmpty((String)vmUuid) || VerifyUtil.isEmpty((String)volumeId) || VerifyUtil.isEmpty((String)tokenId)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        LOG.info((Object)"Detach volume %s, for vm: %s, vm type: %s", new Object[]{volumeId, vmUuid, vmType});
        String projId = OpenStackCommonUtil.getIdFromUuid(projcetUuid);
        String serverId = OpenStackCommonUtil.getIdFromUuid(vmUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "compute");
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.NOVA_VOLUME_DETACH.getUri(), projId, serverId, volumeId);
        if ("BMS".equals(vmType)) {
            LOG.info((Object)"Detach volume for bms: %s", new Object[]{vmUuid});
            urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "apicom");
            newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.APICOM_VOLUME_DETACH.getUri(), projId, serverId, volumeId);
        }
        LOG.debug((Object)"DetachVolFromVm request str: %s", new Object[]{newUrlStr});
        String respStr = ClientUtil.sendDeleteRequest(newUrlStr, tokenId);
        LOG.info((Object)"DetachVolFromVm response: %s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr) || respStr.contains("job_id") && "BMS".equals(vmType)) {
            return this.checkDetachVolResponse(regionUuid, tokenId, projcetUuid, volumeId, serverId);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (json.containsKey((Object)"itemNotFound")) {
            LOG.info((Object)"DetachVolFromVm succeed.vmUuid = %s,volumeId=%s", new Object[]{vmUuid, volumeId});
            response.setSuccess(true);
            return response;
        }
        response.setSuccess(false);
        LOG.error((Object)("DetachVolFromVm failed.vmUuid = " + vmUuid + ",volumeId=" + volumeId));
        response.setErrorCode("3145729");
        return response;
    }

    private AsyncTaskResponse checkDetachVolResponse(final String regionUuid, final String tokenId, final String projcetUuid, final String volumeId, final String serverId) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(volumeId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                CinderManager cinderMgr = new CinderManager();
                VolumeInfo volume = cinderMgr.queryVolume(regionUuid, tokenId, projcetUuid, volumeId);
                if (null == volume) {
                    LOG.info((Object)"CheckDetachVolResponse failed.volume is null. volumeId = %s", new Object[]{volumeId});
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.VolumeStatusE.AVAILABLE.getType().equals(volume.getStatus())) {
                    LOG.info((Object)"CheckDetachVolResponse succeed.volume status is available. volumeId = %s", new Object[]{volumeId});
                    response.setSuccess(true);
                    return true;
                }
                if (null == volume.getAttachments()) {
                    LOG.info((Object)"CheckDetachVolResponse succeed. Attachment of volume is null");
                    response.setSuccess(true);
                    return true;
                }
                for (VolumeAttachmentInfo attach : volume.getAttachments()) {
                    if (!serverId.equals(attach.getServerId())) continue;
                    LOG.debug((Object)"Share volume(%s) is still in vm(%s).", new Object[]{volumeId, serverId});
                    return false;
                }
                LOG.info((Object)"CheckDetachVolResponse succeed.volumeId = %s", new Object[]{volumeId});
                response.setSuccess(true);
                return true;
            }
        });
        return response;
    }

    @Override
    public void reattachVolume(ReattchParam reattchParam, String vmUuid, ReconnectVolumeInfo reconnVolumeInfo) {
        LOG.error((Object)("Failed to reattach volume.not support this operation under current openstack!, vmUuid=" + vmUuid));
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    @Override
    public void reattachAndCheckVolume(ReattchParam reattchParam, String vmUuid, ReconnectVolumeInfo reconnVolumeInfo) {
        LOG.error((Object)("Failed to reattach volume.not support this operation under current openstack!, vmUuid=" + vmUuid));
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    @Override
    public void forceDetachPortFromVM(String portUuid, String vmUuid, String projectUuid, String regionUuid, String tokenId, boolean isClearBackData) {
        LOG.error((Object)("Failed to force detach port from VM.not support this operation under current openstack!.vmUuid=" + vmUuid));
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    @Override
    public AsyncTaskResponse rebootVMAction(String vmUuid, String projectUuid, String regionUuid, String tokenId, OpenStackVMActionEnum action) {
        AsyncTaskResponse asyncTaskResponse;
        OpenStackVM vm = this.getVm(regionUuid, tokenId, projectUuid, vmUuid, new int[0]);
        if (null == vm) {
            LOG.error((Object)"Get vm return null.");
            throw new LegoCheckedException(1073947393L);
        }
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (!(OpenstackEnumDefine.VmStatusE.SHUTOFF.getValue() == vm.getStatus().intValue() || (asyncTaskResponse = this.vmAction(vmUuid, projectUuid, regionUuid, tokenId, OpenStackVMActionEnum.STOP)) != null && asyncTaskResponse.isSuccess())) {
            LOG.error((Object)("Shutdown vm failed,vmUuid is " + vmUuid));
            response.setSuccess(false);
            return response;
        }
        String respStr = this.getActionRespStr(vmUuid, projectUuid, regionUuid, tokenId, action);
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkVmActionResponse(regionUuid, tokenId, projectUuid, vmUuid, action);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (json.containsKey((Object)"itemNotFound")) {
            LOG.error((Object)("Failed to reboot VM action.bad Request vmAction:vmUuid=" + vmUuid));
            response.setSuccess(false);
            return response;
        }
        response.setSuccess(false);
        LOG.error((Object)("Failed to reboot VM action.bad Request vmAction: vmUuid=" + vmUuid));
        response.setErrorCode("3145729");
        return response;
    }

    @Override
    public AsyncTaskResponse resetVMState(String vmUuid, String projectUuid, String regionUuid, String tokenId, OpenstackEnumDefine.VmStatusE vmState) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projectUuid) || VerifyUtil.isEmpty((String)vmUuid) || VerifyUtil.isEmpty((Object)vmState)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        String serverId = OpenStackCommonUtil.getIdFromUuid(vmUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "compute");
        String newUrlStr = urlStr + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.NOVA_RESET_SERVER_STATE.getUri(), projId, serverId);
        String message = this.getStateMessage(vmState);
        if (null == message) {
            LOG.error((Object)("Modify vm state error : " + vmState + ", serverId=" + serverId));
            throw new LegoCheckedException(1073947393L);
        }
        LOG.info((Object)"The vm will reset status , vm  uuid is %s", new Object[]{vmUuid});
        ClientUtil.sendPostRequest(newUrlStr, message, tokenId);
        return this.checkResetVmResponse(regionUuid, projectUuid, tokenId, vmUuid, vmState);
    }

    private AsyncTaskResponse checkResetVmResponse(final String regionUuid, final String projectUuid, final String tokenId, final String vmUuid, final OpenstackEnumDefine.VmStatusE vmState) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(vmUuid, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                OpenStackVM vm = NovaManager.this.getVm(regionUuid, tokenId, projectUuid, vmUuid, new int[0]);
                if (null == vm) {
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return false;
                }
                LOG.debug((Object)"Current status : %s, vm id: %s", new Object[]{String.valueOf(vm.getStatus()), vmUuid});
                if (vmState.getValue() == vm.getStatus().intValue()) {
                    response.setSuccess(true);
                    return true;
                }
                LOG.error((Object)("Failed to check reset Vm.current status : " + vm.getStatus() + ", vm id: " + vmUuid + ", expect status=" + vmState.getValue()));
                response.setSuccess(false);
                response.setErrorCode("3145729");
                return false;
            }
        });
        return response;
    }

    private String getStateMessage(OpenstackEnumDefine.VmStatusE vmState) {
        if (OpenstackEnumDefine.VmStatusE.ACTIVE.getValue() == vmState.getValue()) {
            return "{\"os-resetState\": {\"state\": \"active\"}}";
        }
        if (OpenstackEnumDefine.VmStatusE.ERROR.getValue() == vmState.getValue()) {
            return "{\"os-resetState\": {\"state\": \"error\"}}";
        }
        return null;
    }

    @Override
    public void updateVMmetadata(String vmUuid, String projectUuid, String regionUuid, String tokenId, Map<String, String> metadata) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projectUuid) || VerifyUtil.isEmpty((String)vmUuid) || VerifyUtil.isEmpty(metadata)) {
            LOG.error((Object)"Update VM metadata failed. parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        String serverId = OpenStackCommonUtil.getIdFromUuid(vmUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "compute");
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.NOVA_METADATA.getUri(), projId, serverId);
        String message = this.makeMetadataStr(metadata);
        LOG.info((Object)"The vm will update metadata, vm  uuid is %s, message id :%s", new Object[]{vmUuid, message});
        String respStr = ClientUtil.sendPostRequest(newUrlStr, message, tokenId);
        LOG.debug((Object)"Start update VMmetadata, reqponse str=%s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr) || !respStr.contains("metadata")) {
            LOG.error((Object)("Update VMmetadata failed. response is null or not contain metatata, reqponse str=" + respStr + ",request newUrlStr=" + newUrlStr));
            throw new LegoCheckedException(1073948133L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr).getJSONObject("metadata");
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            String key = entry.getKey();
            if (entry.getValue().equalsIgnoreCase((String)json.get(key))) continue;
            LOG.error((Object)("Update VMmetadata failed. query metadata is not equal metatata, source metadata key=" + entry.getValue() + ",query metadata=" + (String)json.get(key) + ", reqponse str=" + respStr + ",request newUrlStr=" + newUrlStr));
            throw new LegoCheckedException(1073948133L);
        }
        LOG.debug((Object)"Update VMmetadata succeed, vmUuid id=%s", new Object[]{vmUuid});
    }

    private String makeMetadataStr(Map<String, String> metadataMap) {
        JSONObject json = new JSONObject();
        for (Map.Entry<String, String> entry : metadataMap.entrySet()) {
            json.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        JSONObject retJson = new JSONObject();
        retJson.put((Object)"metadata", (Object)json);
        return retJson.toString();
    }

    @Override
    public List<AggregateInfo> getAggregateInfosByAz(String regionUuid, String projectUuid, String tokenId, String azName) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projectUuid) || VerifyUtil.isEmpty((String)azName)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "compute");
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        String url = urlStr + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.NOVA_AGGREGATES_BY_AZ.getUri(), projId);
        uriVariables.put("availability_zone", azName);
        String respStr = ClientUtil.sendGetRequest(url, uriVariables, tokenId, new int[0]);
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Response string is empty");
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (!json.containsKey((Object)"aggregates")) {
            LOG.error((Object)("Bad Request get os-aggregates:" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        String arrayStr = json.getString("aggregates");
        return JsonUtil.jsonArrayToList(arrayStr, AggregateInfo.class);
    }

    @Override
    public List<HypervisorInfo> getHypervisorInfoByName(String regionUuid, String projectUuid, String tokenId, String hypervisorName) {
        if (VerifyUtil.isEmpty((String)hypervisorName)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        return this.getHypervisorInfo(regionUuid, projectUuid, tokenId, hypervisorName);
    }

    @Override
    public List<HypervisorInfo> getAllHypervisorInfo(String regionUuid, String projectUuid, String tokenId) {
        return this.getHypervisorInfo(regionUuid, projectUuid, tokenId, null);
    }

    private List<HypervisorInfo> getHypervisorInfo(String regionUuid, String projectUuid, String tokenId, String hypervisorName) {
        String cacheKey;
        String url;
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projectUuid)) {
            LOG.error((Object)"Failed to get hypervisorInfo.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "compute");
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        if (!VerifyUtil.isEmpty((String)hypervisorName)) {
            url = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.NOVA_HYPERVISORS_DETAILS_BY_HOSTNAME.getUri(), projId);
            uriVariables.put("hypervisor_hostname_pattern", hypervisorName);
            cacheKey = Joiner.on((String)"_@_").join((Object[])new String[]{regionUuid, projId, hypervisorName});
        } else {
            url = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.NOVA_ALL_HYPERVISORS_DETAILS.getUri(), projId);
            cacheKey = Joiner.on((String)"_@_").join((Object[])new String[]{regionUuid, projId});
        }
        if (OpenstackCache.containsKey(OpenstackCache.CacheType.OPENSTACK_HYPERVISOR_LIST, cacheKey)) {
            List hypervisorList = (List)OpenstackCache.getCache(OpenstackCache.CacheType.OPENSTACK_HYPERVISOR_LIST, cacheKey);
            return new ArrayList<HypervisorInfo>(hypervisorList);
        }
        String respStr = ClientUtil.sendGetRequest(url, uriVariables, tokenId, new int[0]);
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Failed to get hypervisorInfo.response string is empty");
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (!json.containsKey((Object)"hypervisors")) {
            LOG.error((Object)("Failed to get hypervisorInfo.bad Request get os-hypervisors:" + respStr + ", request hypervisorName" + hypervisorName));
            throw new LegoCheckedException(0x300001L);
        }
        String arrayStr = json.getString("hypervisors");
        List<HypervisorInfo> hypervisorList = JsonUtil.jsonArrayToList(arrayStr, HypervisorInfo.class);
        OpenstackCache.putCache(OpenstackCache.CacheType.OPENSTACK_HYPERVISOR_LIST, cacheKey, hypervisorList);
        return new ArrayList<HypervisorInfo>(hypervisorList);
    }

    @Override
    public VolAttachInfo getVolumeAttachInfo(String vmUuid, String regionUuid, String tokenId, String volId) {
        LOG.error((Object)"Not support this operation under current openstack.");
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    @Override
    public List<HypervisorInfo> getHypervisorInfoByAz(String regionUuid, String projectUuid, String tokenId, String azId) {
        LOG.error((Object)"Not support this operation under current openstack.");
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    @Override
    public Map<String, String> getVmsAddressMap(String regionUuid, String projectUuid, List<String> uuids) {
        LOG.error((Object)"Not support this operation under current openstack.");
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    @Override
    public String getVmAddressMap(String regionUuid, String tokenId, String projectUuid, String vmUuid) {
        LOG.error((Object)"Not support this operation under current openstack.");
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    @Override
    public void refreshVMAddressMap(String regionUuid, String projectUuid, String vmUuid, String addressMap, String tokenId) {
        LOG.error((Object)"Not support this operation under current openstack.");
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    @Override
    public List<SystemCapability> getSIAInfoByOsType(String guestOsType, String regionUuid, String tokenId) {
        LOG.error((Object)"Not support this operation under current openstack.");
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    static class OpenStackVmsTask
    extends RecursiveTask<List<OpenStackVM>> {
        private static final long serialVersionUID = -100164329337063101L;
        private static final int THRESHLOD = 500;
        private int start;
        private Map<String, String> headerMap;
        private String urlStr;
        private String tokenId;
        private String regionUuid;
        private String projUuid;
        private String novaApiVersion;

        public OpenStackVmsTask(String regionUuid, String tokenId, String projUuid, int start, String apiVersion) {
            String endurlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "compute-ext");
            HashMap<String, String> tmpHeaderMap = new HashMap<String, String>();
            tmpHeaderMap.put("X_OPENSTACK_NOVA_API_VERSION", apiVersion);
            StringBuilder newUrlStr = new StringBuilder(endurlStr).append(String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.NOVA_EXT_QUERY_SERVERS.getUri(), OpenStackCommonUtil.getIdFromUuid(projUuid)));
            this.start = start;
            this.headerMap = tmpHeaderMap;
            this.urlStr = newUrlStr.toString();
            this.tokenId = tokenId;
            this.regionUuid = regionUuid;
            this.projUuid = projUuid;
            this.novaApiVersion = apiVersion;
        }

        @Override
        protected List<OpenStackVM> compute() {
            ArrayList<OpenStackVM> vmList = new ArrayList<OpenStackVM>();
            if (this.start > 1) {
                Map<String, Object> map = this.getVmsByPage();
                List list = (List)map.get("servers");
                vmList.addAll(list);
            } else {
                Map<String, Object> map = this.getVmsByPage();
                List list = (List)map.get("servers");
                int count = (Integer)map.get("count");
                vmList.addAll(list);
                int times = count / 500;
                int remain = count % 500;
                if (remain != 0) {
                    ++times;
                }
                if (times < 2) {
                    return vmList;
                }
                ArrayList<OpenStackVmsTask> openStackVmsTasks = new ArrayList<OpenStackVmsTask>();
                for (int i = 1; i < times; ++i) {
                    OpenStackVmsTask processTask = new OpenStackVmsTask(this.regionUuid, this.tokenId, this.projUuid, i + 1, this.novaApiVersion);
                    openStackVmsTasks.add(processTask);
                    processTask.fork();
                }
                for (OpenStackVmsTask openStackVmsTask : openStackVmsTasks) {
                    vmList.addAll((Collection)openStackVmsTask.join());
                }
            }
            return vmList;
        }

        private Map<String, Object> getVmsByPage() {
            HashMap<String, String> filterProp = new HashMap<String, String>();
            filterProp.put("limit", String.valueOf(500));
            NovaManager novaManager = new NovaManager();
            filterProp.put("offset", String.valueOf(this.start));
            String respStr = ClientUtil.sendGetRequest(this.urlStr, filterProp, this.tokenId, this.headerMap, new int[0]);
            return novaManager.getVmsFromRespStr(this.regionUuid, this.projUuid, respStr);
        }
    }
}

