/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.adapter.manager.impl;

import com.huawei.ism.drm.galax.sdk.model.HypermetroDomain;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ISfsFilemeterManager;
import com.huawei.ism.drm.openstack.adapter.manager.ISfsManilaManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.ClientUtil;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.sdk.bo.FileSystem;
import com.huawei.ism.drm.openstack.sdk.bo.OsAllowAccess;
import com.huawei.ism.drm.openstack.sdk.bo.Share;
import com.huawei.ism.drm.openstack.sdk.bo.SharePair;
import com.huawei.ism.drm.openstack.sdk.bo.SharePairDelete;
import com.huawei.ism.drm.openstack.sdk.bo.UrlBaseParams;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.om.util.endpointutil.ServiceEndpointUtil;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class SfsFilemeterManager
implements ISfsFilemeterManager {
    private static final Log LOG = LogFactory.getInstance(SfsFilemeterManager.class);
    private static final ISfsManilaManager MANILA_MANAGER = ManagerFactory.getInstance().getSfsManilaManager();

    @Override
    public FileSystem createFileSystem(UrlBaseParams urlBaseParams, FileSystem fileSystem) {
        if (OpenStackBasicUtil.checkUrlBaseParamsIsNull(urlBaseParams) || VerifyUtil.isEmpty((Object)fileSystem)) {
            LOG.error((Object)"Operation lockAndUnlockVm.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(urlBaseParams.getRegionUuid(), "filemeter");
        String urlStr = baseUrl + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.FILEMETER_CREATE_FILE_SYSTEM.getUri(), OpenStackCommonUtil.getIdFromUuid(urlBaseParams.getProjectUuid()));
        String respStr = null;
        try {
            respStr = ClientUtil.sendPostRequest(urlStr, JSONObject.fromObject((Object)fileSystem).toString(), urlBaseParams.getTokenId());
        }
        catch (LegoCheckedException exception) {
            LOG.error((Object)"CreateFileSystem error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)exception)});
            throw new LegoCheckedException(1073949766L, new String[]{fileSystem.getFsName()}, (Throwable)exception);
        }
        LOG.info((Object)"Create file system:%s", new Object[]{SecurityUtil.desensitization((String)respStr)});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Failed to create the file system.response string is empty");
            throw new LegoCheckedException(1073949766L, new String[]{fileSystem.getFsName()});
        }
        return JsonUtil.jsonToBean(respStr, FileSystem.class);
    }

    @Override
    public SharePair createSharePair(UrlBaseParams urlBaseParams, SharePair sharePair, String fileSystemName) {
        if (OpenStackBasicUtil.checkUrlBaseParamsIsNull(urlBaseParams)) {
            LOG.error((Object)"CreateSharePair failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(urlBaseParams.getRegionUuid(), "filemeter");
        String urlStr = baseUrl + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.FILEMETER_CREATE_SHARE_PAIR.getUri(), OpenStackCommonUtil.getIdFromUuid(urlBaseParams.getProjectUuid()));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"share_pair", (Object)JSONObject.fromObject((Object)sharePair));
        String respStr = null;
        try {
            respStr = ClientUtil.sendPostRequest(urlStr, jsonObject.toString(), urlBaseParams.getTokenId());
        }
        catch (LegoCheckedException exception) {
            if (exception.getMessage().contains("Share pair already exist")) {
                LOG.error((Object)"SharePair(%s,%s) already exist, no need create.", new Object[]{sharePair.getLocalFsId(), sharePair.getRemoteFsId()});
                return sharePair;
            }
            LOG.error((Object)"CreateSharePair error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)exception)});
            throw new LegoCheckedException(1073947483L, new String[]{fileSystemName}, (Throwable)exception);
        }
        LOG.info((Object)"Create share pair:%s", new Object[]{SecurityUtil.desensitization((String)respStr)});
        SharePair responseShare = JsonUtil.jsonToBean(respStr, SharePair.class);
        AsyncTaskResponse response = this.checkCreateSharePairResponse(urlBaseParams, responseShare.getSharePairId());
        if (!response.isSuccess()) {
            if (response.getTaskResult() != null && response.getTaskResult() instanceof SharePair) {
                SharePair result = (SharePair)response.getTaskResult();
                LOG.error((Object)("Create sharePair failed:" + result.getSharePairId()));
            }
            throw new LegoCheckedException(1073947483L, new String[]{fileSystemName});
        }
        return responseShare;
    }

    private AsyncTaskResponse checkCreateSharePairResponse(UrlBaseParams urlBaseParams, String sharePairId) {
        return AsyncTaskResponse.queryTaskResponse(sharePairId, response1 -> {
            SharePair sharePair = this.querySharePairById(urlBaseParams, sharePairId);
            if (sharePair == null) {
                response1.setSuccess(false);
                response1.setErrorCode("2117645");
                return true;
            }
            if (OpenstackEnumDefine.SharePairRunningStatus.NORMAL.getValue().equals(sharePair.getRunningStatus())) {
                response1.setSuccess(true);
                response1.setTaskResult(sharePair);
                return true;
            }
            return false;
        });
    }

    @Override
    public Share createShare(UrlBaseParams urlBaseParams, Share share) {
        if (OpenStackBasicUtil.checkUrlBaseParamsIsNull(urlBaseParams) || VerifyUtil.isEmpty((Object)share)) {
            LOG.error((Object)"CreateShare failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(urlBaseParams.getRegionUuid(), "filemeter");
        String urlStr = baseUrl + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.FILEMETER_CREATE_SHARE.getUri(), OpenStackCommonUtil.getIdFromUuid(urlBaseParams.getProjectUuid()));
        String respStr = null;
        try {
            respStr = ClientUtil.sendPostRequest(urlStr, JSONObject.fromObject((Object)share).toString(), urlBaseParams.getTokenId());
        }
        catch (LegoCheckedException exception) {
            LOG.error((Object)"CreateShare error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)exception)});
            throw new LegoCheckedException(1073949765L, new String[]{share.getName()}, (Throwable)exception);
        }
        LOG.info((Object)"Create share:%s", new Object[]{SecurityUtil.desensitization((String)respStr)});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Failed to create the share.response string is empty.");
            throw new LegoCheckedException(1073949765L, new String[]{share.getName()});
        }
        return JsonUtil.jsonToBean(respStr, Share.class);
    }

    @Override
    public void addTagToShare(UrlBaseParams urlBaseParams, Share share, List<String> tagList) {
        if (OpenStackBasicUtil.checkUrlBaseParamsIsNull(urlBaseParams)) {
            LOG.error((Object)"AddTagToShare failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(urlBaseParams.getRegionUuid(), "filemeter");
        String urlStr = baseUrl + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.UPDATE_SHARE_TAGS.getUri(), OpenStackCommonUtil.getIdFromUuid(urlBaseParams.getProjectUuid()), share.getId());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"hypermetro_tags", tagList);
        String respStr = null;
        try {
            respStr = ClientUtil.sendPutRequest(urlStr, jsonObject.toString(), urlBaseParams.getTokenId());
        }
        catch (LegoCheckedException exception) {
            LOG.error((Object)"AddTagToShare error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)exception)});
            throw new LegoCheckedException(1073949764L, new String[]{share.getName()}, (Throwable)exception);
        }
        LOG.info((Object)"Update share tag:share=%s", new Object[]{SecurityUtil.desensitization((String)respStr)});
        if (!VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Failed to update the tag of the share(%s).response string is empty.", new Object[]{share.getId()});
            throw new LegoCheckedException(1073949764L, new String[]{share.getName()});
        }
    }

    @Override
    public void deleteTagToShare(UrlBaseParams urlBaseParams, String shareId, String shareName) {
        if (OpenStackBasicUtil.checkUrlBaseParamsIsNull(urlBaseParams)) {
            LOG.error((Object)"DeleteTagToShare failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(urlBaseParams.getRegionUuid(), "filemeter");
        String urlStr = baseUrl + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.DELETE_SHARE_TAGS.getUri(), OpenStackCommonUtil.getIdFromUuid(urlBaseParams.getProjectUuid()), shareId);
        String respStr = null;
        try {
            respStr = ClientUtil.sendDeleteRequest(urlStr, null, urlBaseParams.getTokenId());
        }
        catch (LegoCheckedException exception) {
            LOG.error((Object)"DeleteTagToShare error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)exception)});
            throw new LegoCheckedException(1073949763L, new String[]{shareName}, (Throwable)exception);
        }
        LOG.info((Object)"delete share tag:share=%s", new Object[]{SecurityUtil.desensitization((String)respStr)});
        if (!VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Failed to update the tag of the share(%s).response string is empty.", new Object[]{shareId});
            throw new LegoCheckedException(1073949763L, new String[]{shareName});
        }
    }

    @Override
    public FileSystem getPdFileSystemByShareId(UrlBaseParams urlBaseParams, String shareId) {
        if (OpenStackBasicUtil.checkUrlBaseParamsIsNull(urlBaseParams) || VerifyUtil.isEmpty((String)shareId)) {
            LOG.error((Object)"Get file system failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(urlBaseParams.getRegionUuid(), "filemeter");
        String urlStr = baseUrl + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.FILEMETER_QUERY_FILE_SYSTEM_BY_SHARE_ID.getUri(), OpenStackCommonUtil.getIdFromUuid(urlBaseParams.getProjectUuid()), shareId);
        String respStr = null;
        try {
            respStr = ClientUtil.sendGetRequest(urlStr, null, urlBaseParams.getTokenId(), new int[0]);
        }
        catch (LegoCheckedException exception) {
            LOG.error((Object)"Get file system error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)exception)});
            throw new LegoCheckedException(1073949762L, new String[]{shareId}, (Throwable)exception);
        }
        LOG.info((Object)"Get file system success:share=%s", new Object[]{SecurityUtil.desensitization((String)respStr)});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Get share(%s) information failed.response string is empty.", new Object[]{shareId});
            throw new LegoCheckedException(1073949762L, new String[]{shareId});
        }
        return JsonUtil.jsonToBean(respStr, FileSystem.class);
    }

    @Override
    public SharePair querySharePairById(UrlBaseParams urlBaseParams, String sharePairId) {
        if (OpenStackBasicUtil.checkUrlBaseParamsIsNull(urlBaseParams)) {
            LOG.error((Object)"QueryShareById failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(urlBaseParams.getRegionUuid(), "filemeter");
        String urlStr = baseUrl + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.FILEMETER_QUERY_SHARE_PAIR.getUri(), OpenStackCommonUtil.getIdFromUuid(urlBaseParams.getProjectUuid()), sharePairId);
        try {
            String respStr = ClientUtil.sendGetRequest(urlStr, urlBaseParams.getTokenId());
            LOG.info((Object)"Query share pair:%s", new Object[]{SecurityUtil.desensitization((String)respStr)});
            if (VerifyUtil.isEmpty((String)respStr)) {
                LOG.error((Object)"Get sharePair(%s) information failed.response string is empty.", new Object[]{sharePairId});
                return null;
            }
            return JsonUtil.jsonToBean(respStr, SharePair.class);
        }
        catch (Exception e) {
            LOG.error((Object)"Get sharePair(%s) information failed.response string is empty.", new Object[]{sharePairId});
            return null;
        }
    }

    @Override
    public void deleteShare(UrlBaseParams urlBaseParams, String shareId, String shareName) {
        if (OpenStackBasicUtil.checkUrlBaseParamsIsNull(urlBaseParams)) {
            LOG.error((Object)"DeleteShare failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        Share tmp = ManagerFactory.getInstance().getSfsManilaManager().queryShareById(urlBaseParams, shareId);
        if (VerifyUtil.isEmpty((Object)tmp) || VerifyUtil.isEmpty((String)tmp.getId())) {
            LOG.info((Object)"The share(%s) does not exist or has been deleted.", new Object[]{shareId});
            return;
        }
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(urlBaseParams.getRegionUuid(), "manila");
        String urlStr = baseUrl + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.DELETE_SHARE.getUri(), OpenStackCommonUtil.getIdFromUuid(urlBaseParams.getProjectUuid()), shareId);
        String respStr = null;
        try {
            respStr = ClientUtil.sendDeleteRequest(urlStr, null, urlBaseParams.getTokenId());
        }
        catch (LegoCheckedException exception) {
            LOG.error((Object)"Delete share(%s) error:%s.", new Object[]{shareId, ExceptionUtil.getErrorMessage((Throwable)exception)});
            throw new LegoCheckedException(1073949768L, new String[]{shareName}, (Throwable)exception);
        }
        LOG.info((Object)"Delete share:share=%s", new Object[]{SecurityUtil.desensitization((String)respStr)});
        if (!VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Failed to delete the share(%s).response string is empty.", new Object[]{shareId});
            throw new LegoCheckedException(1073949768L, new String[]{shareName});
        }
    }

    @Override
    public OsAllowAccess addOsAllowAccess(UrlBaseParams urlBaseParams, String shareId, OsAllowAccess osAllowAccess, String shareName) {
        if (OpenStackBasicUtil.checkUrlBaseParamsIsNull(urlBaseParams)) {
            LOG.error((Object)"AddOsAllowAccess failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(urlBaseParams.getRegionUuid(), "manila");
        String urlStr = baseUrl + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.ADD_ALLOW_ACCESS.getUri(), OpenStackCommonUtil.getIdFromUuid(urlBaseParams.getProjectUuid()), shareId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"os-allow_access", (Object)osAllowAccess);
        String respStr = null;
        try {
            respStr = ClientUtil.sendPostRequest(urlStr, jsonObject.toString(), urlBaseParams.getTokenId());
        }
        catch (LegoCheckedException exception) {
            LOG.error((Object)"Add allow access error:%s.", new Object[]{shareId, ExceptionUtil.getErrorMessage((Throwable)exception)});
            throw new LegoCheckedException(1073947484L, new String[]{shareName}, (Throwable)exception);
        }
        LOG.info((Object)"Add allow access:%s", new Object[]{SecurityUtil.desensitization((String)respStr)});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Add allow access(shareId:%s) information failed.response string is empty.request str=%s.", new Object[]{shareId, urlStr});
            throw new LegoCheckedException(1073947484L, new String[]{shareName});
        }
        OsAllowAccess resp = OpenStackBasicUtil.checkAndGetInfo(urlStr, respStr, "access", OsAllowAccess.class);
        AsyncTaskResponse response = this.checkAddOsAllowAccessResponse(urlBaseParams, shareId, resp, shareName);
        if (!response.isSuccess()) {
            if (response.getTaskResult() != null && response.getTaskResult() instanceof OsAllowAccess) {
                LOG.error((Object)"Add allow access failed:%s.", new Object[]{shareId});
            }
            throw new LegoCheckedException(1073947484L, new String[]{shareName});
        }
        return resp;
    }

    @Override
    public void deleteFileSystem(UrlBaseParams urlBaseParams, String fileSystemId, String shareTypeName, String fileSystemName) {
        if (OpenStackBasicUtil.checkUrlBaseParamsIsNull(urlBaseParams)) {
            LOG.error((Object)"DeleteFileSystem failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(urlBaseParams.getRegionUuid(), "filemeter");
        String urlStr = baseUrl + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.DELETE_FILE_SYSTEM.getUri(), OpenStackCommonUtil.getIdFromUuid(urlBaseParams.getProjectUuid()), fileSystemId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"share_type_name", (Object)shareTypeName);
        String respStr = null;
        try {
            respStr = ClientUtil.sendDeleteRequest(urlStr, JSONObject.fromObject((Object)jsonObject).toString(), urlBaseParams.getTokenId());
        }
        catch (LegoCheckedException exception) {
            LOG.error((Object)"DeleteFileSystem error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)exception)});
            throw new LegoCheckedException(1073949761L, new String[]{fileSystemName}, (Throwable)exception);
        }
        LOG.info((Object)"DeleteFileSystem:%s", new Object[]{SecurityUtil.desensitization((String)respStr)});
        if (!VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Delete fileSystem(%s) failed.response string is empty.", new Object[]{fileSystemId});
            throw new LegoCheckedException(1073949761L, new String[]{fileSystemName});
        }
    }

    @Override
    public void deleteShareAndPair(UrlBaseParams urlBaseParams, UrlBaseParams drParams, String pairId, boolean deleteInStorage, boolean deleteLocalShare) {
        if (OpenStackBasicUtil.checkUrlBaseParamsIsNull(urlBaseParams)) {
            LOG.error((Object)"DeleteShareAndPair failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(urlBaseParams.getRegionUuid(), "filemeter");
        String urlStr = baseUrl + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.DELETE_SHARE_AND_PAIR.getUri(), OpenStackCommonUtil.getIdFromUuid(urlBaseParams.getProjectUuid()), pairId);
        SharePairDelete sharePairDelete = new SharePairDelete(deleteInStorage, deleteLocalShare);
        String respStr = null;
        try {
            respStr = ClientUtil.sendDeleteRequest(urlStr, JSONObject.fromObject((Object)sharePairDelete).toString(), urlBaseParams.getTokenId());
        }
        catch (LegoCheckedException exception) {
            String exceptionMsg = exception.getMessage();
            if (exceptionMsg.contains("The specified HyperMetro does not exist") || exceptionMsg.contains("get error msg error")) {
                LOG.info((Object)"The specified HyperMetro does not exist.");
                return;
            }
            LOG.error((Object)"DeleteShareAndPair error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)exception)});
            throw new LegoCheckedException(1073949760L, new String[]{pairId}, (Throwable)exception);
        }
        LOG.info((Object)"DeleteShareAndPair:%s", new Object[]{SecurityUtil.desensitization((String)respStr)});
        if (!VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Delete sharePair(%s) failed.response string is empty.", new Object[]{pairId});
            throw new LegoCheckedException(1073949760L, new String[]{pairId});
        }
        if (drParams != null) {
            this.checkDeleteShareAndPairResponse(drParams, pairId);
        }
    }

    private void checkDeleteShareAndPairResponse(UrlBaseParams params, String shareId) {
        AsyncTaskResponse.queryTaskResponse(shareId, response1 -> {
            SharePair sharePair = this.querySharePairById(params, shareId);
            if (VerifyUtil.isEmpty((Object)sharePair) || VerifyUtil.isEmpty((Object)sharePair.getFetchFromStorage())) {
                LOG.debug((Object)"The SharePair(shareId:%s) is null, delete succeed.", new Object[]{shareId});
                return true;
            }
            if (!sharePair.getFetchFromStorage().booleanValue()) {
                response1.setSuccess(true);
                response1.setTaskResult(sharePair);
                return true;
            }
            return false;
        });
    }

    @Override
    public HypermetroDomain queryHypermetroDomain(UrlBaseParams urlBaseParams, String shareTypeName) {
        if (OpenStackBasicUtil.checkUrlBaseParamsIsNull(urlBaseParams)) {
            LOG.error((Object)"QueryShareById failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(urlBaseParams.getRegionUuid(), "filemeter");
        String urlStr = baseUrl + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.FILEMETER_QUERY_HYPERMETRO_DOMAIN.getUri(), OpenStackCommonUtil.getIdFromUuid(urlBaseParams.getProjectUuid()), shareTypeName);
        String respStr = null;
        try {
            respStr = ClientUtil.sendGetRequest(urlStr, urlBaseParams.getTokenId());
        }
        catch (LegoCheckedException exception) {
            LOG.error((Object)"QueryHypermetroDomain error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)exception)});
            throw new LegoCheckedException(1073949759L, new String[]{shareTypeName}, (Throwable)exception);
        }
        LOG.info((Object)"QueryHypermetroDomain:%s", new Object[]{SecurityUtil.desensitization((String)respStr)});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Get sharePair(%s) information failed.response string is empty.", new Object[]{shareTypeName});
            throw new LegoCheckedException(1073949759L, new String[]{shareTypeName});
        }
        return JsonUtil.jsonToBean(respStr, HypermetroDomain.class);
    }

    @Override
    public void splitHypermetroDomain(UrlBaseParams urlBaseParams, String shareTypeName) {
        if (OpenStackBasicUtil.checkUrlBaseParamsIsNull(urlBaseParams)) {
            LOG.error((Object)"SplitHypermetroDomain failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(urlBaseParams.getRegionUuid(), "filemeter");
        String urlStr = baseUrl + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.FILEMETER_SPLIT_HYPERMETRO_DOMAIN.getUri(), OpenStackCommonUtil.getIdFromUuid(urlBaseParams.getProjectUuid()), shareTypeName);
        String respStr = null;
        try {
            respStr = ClientUtil.sendPostRequest(urlStr, null, urlBaseParams.getTokenId());
        }
        catch (LegoCheckedException exception) {
            LOG.error((Object)"SplitHypermetroDomain error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)exception)});
            throw new LegoCheckedException(1073949758L, new String[]{shareTypeName}, (Throwable)exception);
        }
        if (!VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"SplitHypermetroDomain(%s) failed.", new Object[]{shareTypeName});
            throw new LegoCheckedException(1073949758L, new String[]{shareTypeName});
        }
    }

    @Override
    public void cancelSecondaryResourceProtection(UrlBaseParams urlBaseParams, String shareTypeName) {
        if (OpenStackBasicUtil.checkUrlBaseParamsIsNull(urlBaseParams)) {
            LOG.error((Object)"CancelSecondaryResourceProtection failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(urlBaseParams.getRegionUuid(), "filemeter");
        String urlStr = baseUrl + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.FILEMETER_CANCEL_SECONDARY_RESOURCE_PROTECTION.getUri(), OpenStackCommonUtil.getIdFromUuid(urlBaseParams.getProjectUuid()), shareTypeName);
        String respStr = null;
        try {
            respStr = ClientUtil.sendPostRequest(urlStr, null, urlBaseParams.getTokenId());
        }
        catch (LegoCheckedException exception) {
            LOG.error((Object)"CancelSecondaryResourceProtection error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)exception)});
            throw new LegoCheckedException(1073949757L, new String[]{shareTypeName});
        }
        if (!VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"CancelSecondaryResourceProtection(%s) failed.", new Object[]{shareTypeName});
            throw new LegoCheckedException(1073949757L, new String[]{shareTypeName});
        }
    }

    @Override
    public void activeStandbySwitchover(UrlBaseParams urlBaseParams, String shareTypeName) {
        if (OpenStackBasicUtil.checkUrlBaseParamsIsNull(urlBaseParams)) {
            LOG.error((Object)"ActiveStandbySwitchover failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(urlBaseParams.getRegionUuid(), "filemeter");
        String urlStr = baseUrl + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.FILEMETER_SWITCHOVER_HYPERMETRO_DOMAIN.getUri(), OpenStackCommonUtil.getIdFromUuid(urlBaseParams.getProjectUuid()), shareTypeName);
        String respStr = null;
        try {
            respStr = ClientUtil.sendPostRequest(urlStr, null, urlBaseParams.getTokenId());
        }
        catch (LegoCheckedException exception) {
            LOG.error((Object)"ActiveStandbySwitchover error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)exception)});
            throw new LegoCheckedException(1073949756L, new String[]{shareTypeName}, (Throwable)exception);
        }
        if (!VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"ActiveStandbySwitchover(%s).", new Object[]{shareTypeName});
            throw new LegoCheckedException(1073949756L, new String[]{shareTypeName});
        }
    }

    @Override
    public List<OsAllowAccess> queryOsAllowAccess(UrlBaseParams urlBaseParams, String shareId, String shareName) {
        if (OpenStackBasicUtil.checkUrlBaseParamsIsNull(urlBaseParams)) {
            LOG.error((Object)"QueryOsAllowAccess failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(urlBaseParams.getRegionUuid(), "manila");
        String urlStr = baseUrl + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.ADD_ALLOW_ACCESS.getUri(), OpenStackCommonUtil.getIdFromUuid(urlBaseParams.getProjectUuid()), shareId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"os-access_list", (Object)"null");
        String respStr = null;
        try {
            respStr = ClientUtil.sendPostRequest(urlStr, jsonObject.toString(), urlBaseParams.getTokenId());
        }
        catch (LegoCheckedException exception) {
            LOG.error((Object)"QueryOsAllowAccess error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)exception)});
            throw new LegoCheckedException(1073947485L, new String[]{shareName}, (Throwable)exception);
        }
        LOG.info((Object)"QueryOsAllowAccess access:%s", new Object[]{SecurityUtil.desensitization((String)respStr)});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"QueryOsAllowAccess(shareId:%s) information failed.response string is empty.request str=%s.", new Object[]{shareId, urlStr});
            throw new LegoCheckedException(1073947485L, new String[]{shareName});
        }
        return OpenStackBasicUtil.checkAndGetListInfo(urlStr, respStr, "access_list", OsAllowAccess.class);
    }

    private AsyncTaskResponse checkAddOsAllowAccessResponse(UrlBaseParams urlBaseParams, String shareId, OsAllowAccess osAllowAccess, String shareName) {
        return AsyncTaskResponse.queryTaskResponse(shareId, response1 -> {
            List<OsAllowAccess> osAllowAccessList = this.queryOsAllowAccess(urlBaseParams, shareId, shareName);
            Optional<OsAllowAccess> optional = osAllowAccessList.stream().filter(e -> e.getId().equals(osAllowAccess.getId())).findFirst();
            if (!optional.isPresent()) {
                response1.setSuccess(false);
                return true;
            }
            OsAllowAccess allowAccess = optional.get();
            if (OpenstackEnumDefine.OsAllowAccessStatus.ACTIVE.getValue().equals(allowAccess.getState())) {
                response1.setSuccess(true);
                response1.setTaskResult(allowAccess);
                return true;
            }
            if (OpenstackEnumDefine.OsAllowAccessStatus.ERROR.getValue().equals(allowAccess.getState())) {
                response1.setSuccess(false);
                response1.setTaskResult(allowAccess);
                return true;
            }
            return false;
        });
    }

    @Override
    public void addProtection(UrlBaseParams urlBaseParams, String shareTypeName) {
        if (OpenStackBasicUtil.checkUrlBaseParamsIsNull(urlBaseParams)) {
            LOG.error((Object)"AddProtection failed.parameter is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(urlBaseParams.getRegionUuid(), "filemeter");
        String urlStr = baseUrl + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.ADD_PROTECTION.getUri(), OpenStackCommonUtil.getIdFromUuid(urlBaseParams.getProjectUuid()), shareTypeName);
        String respStr = null;
        try {
            respStr = ClientUtil.sendPostRequest(urlStr, null, urlBaseParams.getTokenId());
        }
        catch (LegoCheckedException exception) {
            LOG.error((Object)"AddProtection error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)exception)});
            throw new LegoCheckedException(1073947486L, new String[]{shareTypeName}, (Throwable)exception);
        }
        LOG.info((Object)"AddProtection(%s):%s.", new Object[]{shareTypeName, SecurityUtil.desensitization((String)respStr)});
    }

    @Override
    public void recoverHypermetroDomain(UrlBaseParams urlBaseParams, String shareTypeName) {
        if (OpenStackBasicUtil.checkUrlBaseParamsIsNull(urlBaseParams)) {
            LOG.error((Object)"RecoverHypermetroDomain failed.parameter is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(urlBaseParams.getRegionUuid(), "filemeter");
        String urlStr = baseUrl + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.RECOVER_HYPERMETRO_DOMAIN.getUri(), OpenStackCommonUtil.getIdFromUuid(urlBaseParams.getProjectUuid()), shareTypeName);
        String respStr = null;
        try {
            respStr = ClientUtil.sendPostRequest(urlStr, null, urlBaseParams.getTokenId());
        }
        catch (LegoCheckedException exception) {
            LOG.error((Object)"RecoverHypermetroDomain error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)exception)});
            throw new LegoCheckedException(1073949767L, new String[]{shareTypeName}, (Throwable)exception);
        }
        if (!VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"RecoverHypermetroDomain(%s) failed.", new Object[]{shareTypeName});
            throw new LegoCheckedException(1073949767L, new String[]{shareTypeName});
        }
    }
}

