/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.adapter.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JsonUtil {
    private static final Log LOG = LogFactory.getInstance(JsonUtil.class);

    public static JsonNode getJsonNodeFromStr(String jsonStr) {
        if (VerifyUtil.isEmpty((String)jsonStr)) {
            LOG.error((Object)"Parameter error");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.readTree(jsonStr);
        }
        catch (Exception e) {
            LOG.error((Object)("Parse json failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            return null;
        }
    }

    public static <T> T jsonToBean(String jsonStr, Class<T> clazz) {
        if (VerifyUtil.isEmpty((String)jsonStr) || VerifyUtil.isEmpty(clazz)) {
            LOG.error((Object)"Parameter error");
            throw new LegoCheckedException(1073947393L);
        }
        ObjectMapper objMapper = JsonUtil.initObjMapper();
        Object body = null;
        try {
            body = objMapper.readValue(jsonStr, clazz);
        }
        catch (Exception e) {
            LOG.error((Object)("Json to bean failed:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            ExceptionUtil.rethrowException((Throwable)e, (String)"json to bean failed", (long)2097932L, null, (Log)LOG);
        }
        return (T)body;
    }

    private static ObjectMapper initObjMapper() {
        ObjectMapper objMapper = new ObjectMapper();
        objMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        return objMapper;
    }

    public static String beanToJson(Object obj) {
        if (VerifyUtil.isEmpty((Object)obj)) {
            LOG.error((Object)"Parameter error:is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String jsonStr = null;
        try {
            ObjectMapper objMapper = JsonUtil.initObjMapper();
            jsonStr = objMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            LOG.error((Object)("Bean to json failed:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            ExceptionUtil.rethrowException((Throwable)e, (String)"bean to json failed", (long)2097932L, null, (Log)LOG);
        }
        return jsonStr;
    }

    public static <T> List<T> jsonArrayToList(String jsonStr, Class<T> clazz) {
        if (VerifyUtil.isEmpty((String)jsonStr) || VerifyUtil.isEmpty(clazz)) {
            LOG.error((Object)"Parameter error:is empty");
            throw new LegoCheckedException(1073947393L);
        }
        ObjectMapper objMapper = JsonUtil.initObjMapper();
        List list = new ArrayList();
        try {
            list = (List)objMapper.readValue(jsonStr, (JavaType)objMapper.getTypeFactory().constructCollectionType(List.class, clazz));
        }
        catch (Exception e) {
            LOG.error((Object)("Convert array to list failed:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            ExceptionUtil.rethrowException((Throwable)e, (String)"convert array to list failed", (long)2097932L, null, (Log)LOG);
        }
        return list;
    }

    public static String listToJsonArray(Collection<?> collection) {
        if (VerifyUtil.isEmpty(collection)) {
            LOG.warn((Object)"Parameter error:is empty");
            return "[]";
        }
        ObjectMapper objMapper = JsonUtil.initObjMapper();
        try {
            return objMapper.writeValueAsString(collection);
        }
        catch (Exception e) {
            LOG.error((Object)("Convert array to list failed:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            ExceptionUtil.rethrowException((Throwable)e, (String)"convert array to list failed", (long)2097932L, null, (Log)LOG);
            return null;
        }
    }
}

