/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.cert;

import com.huawei.ism.drm.cert.CertificateDockingWidget;
import com.huawei.ism.drm.cert.sdk.service.ICertificateManagementService;
import com.huawei.ism.drm.cert.sdk.service.ICertificateManagementWidget;
import com.huawei.ism.drm.openstack.adapter.util.ClientUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.cert.OpenStackCertificateConstants;
import com.huawei.ism.drm.openstack.cert.task.OpenStackCertificateKeepAliveTask;
import com.huawei.ism.drm.openstack.cert.task.OpenStackCertificateRegisterTask;
import com.huawei.ism.drm.openstack.cert.task.OpenStackHttpsConnectionCheckTask;
import com.huawei.ism.drm.openstack.cert.task.OpenStackQueryCrlTask;
import com.huawei.ism.drm.openstack.resource.authentication.AuthenticationHelper;
import com.huawei.ism.drm.openstack.resource.authentication.CertificateCache;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class OpenStackCertManagementService
implements ICertificateManagementService {
    private static final Log LOG = LogFactory.getInstance(OpenStackCertManagementService.class);

    public List<String> getCertificateSummaryCategories() {
        return Arrays.asList("default", "hcs");
    }

    public boolean available() {
        String urlStr = LegoConfig.getInstance().getKeyValue("config.hcs.cert.management.url");
        if (VerifyUtil.isEmpty((String)urlStr)) {
            LOG.info((Object)"Certificate server url is empty, certificate management is not supported.");
            return false;
        }
        LOG.info((Object)"Certificate management is supported.");
        return true;
    }

    public List<ICertificateManagementWidget> getCertificateManagementWidgets() {
        LOG.info((Object)"GetCertificateManagementWidgets");
        return Arrays.asList(new CertificateDockingWidget((ICertificateManagementService)this, OpenStackCertificateRegisterTask::new, "once:startup"), new CertificateDockingWidget((ICertificateManagementService)this, OpenStackCertificateKeepAliveTask::new, "cron:0 0 0 * * ?"), new CertificateDockingWidget((ICertificateManagementService)this, OpenStackHttpsConnectionCheckTask::new, "cron:0 0 0 * * ?"), new CertificateDockingWidget((ICertificateManagementService)this, OpenStackQueryCrlTask::new, "once:startup"), new CertificateDockingWidget((ICertificateManagementService)this, OpenStackQueryCrlTask::new, "cron:20 0/10 * * * ?"));
    }

    public void notifyCertificateStatus(String taskId, String updateStatus, String details, String certName) {
        LOG.info((Object)"Update certificate result, taskId: %s, status: %s, detail: %s", new Object[]{taskId, updateStatus, details});
        HashMap<String, String> status = new HashMap<String, String>();
        status.put("11111111", "failed");
        status.put("00000000", "success");
        String urlStr = LegoConfig.getInstance().getKeyValue("config.hcs.cert.management.url");
        LOG.debug((Object)"Certificate, url: %s", new Object[]{urlStr});
        if (VerifyUtil.isEmpty((String)urlStr)) {
            LOG.error((Object)"Notify certificate status, but server url is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject updateStatusJo = new JSONObject();
        updateStatusJo.put((Object)"taskId", (Object)taskId);
        updateStatusJo.put((Object)"updateStatus", status.get(updateStatus));
        if (!"00000000".equals(updateStatus)) {
            updateStatusJo.put((Object)"detail", (Object)(details + "##" + details));
        }
        LOG.info((Object)"Upload update certificate result, request body: %s", new Object[]{updateStatusJo});
        OpenstackInfo open = AuthenticationHelper.getInstance().getOpenstackInfo();
        String tokenId = TokenUtil.getInstance().getTokenId(open, null);
        String fullUrl = "https://" + urlStr + OpenStackCertificateConstants.RequestUrl.UPLOAD_UPDATE_STATUS.getUri();
        String response = ClientUtil.sendPutRequest(fullUrl, updateStatusJo.toString(), tokenId);
        LOG.info((Object)"Upload update certificate result, response: %s", new Object[]{response});
        if (VerifyUtil.isEmpty((String)response)) {
            LOG.error((Object)"Openstack notify certificate status's response is empty.");
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject result = null;
        try {
            result = JSONObject.fromObject((Object)response);
        }
        catch (Exception e) {
            LOG.error((Object)"Resolve notify certificate status's response failed.", (Throwable)e);
        }
        if (null != result && result.containsKey((Object)"resultCode")) {
            String resultCode = result.getString("resultCode");
            if ("00000000".equals(resultCode)) {
                LOG.info((Object)"Notify certificate status succeed.");
                if ("eReplication-IAM".equalsIgnoreCase(certName)) {
                    LOG.info((Object)"Need change IAM ceart.");
                    CertificateCache.getInstance().setNeedUpdate(true);
                }
            } else {
                LOG.error((Object)("Notify certificate status failed, error: " + result.getString("errorMsg")));
            }
        }
    }
}

