/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.cert.checker;

import com.huawei.ism.drm.openstack.cert.checker.AbstractConnectionCheck;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Optional;
import java.util.Set;

public class SfsConnectionCheck
extends AbstractConnectionCheck {
    private static final Log LOG = LogFactory.getInstance(SfsConnectionCheck.class);

    @Override
    public void doConnect() throws Exception {
        Set<String> regionUuids = this.getRegionUuids();
        for (String regionUuid : regionUuids) {
            this.doConnectBaseUrl(regionUuid, "manila");
            this.doConnectBaseUrl(regionUuid, "filemeter");
        }
    }

    @Override
    String getServiceName() {
        return "SFS";
    }

    private void doConnectBaseUrl(String regionUuid, String serviceType) throws Exception {
        Optional<String> baseUrl = this.getBaseUrl(regionUuid, serviceType);
        if (!baseUrl.isPresent()) {
            LOG.warn((Object)"End to execute SfsConnectionCheck, cause %s is null.", new Object[]{serviceType});
            return;
        }
        this.sendTestConnection(baseUrl.get());
    }
}

