/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.action;

import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.IDrExtendManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Locale;

public class OpenStackArraySyncAction
extends AbstractBaseProtectAction {
    private static final Log LOG = LogFactory.getInstance(OpenStackArraySyncAction.class);

    public boolean doExecute(ActionContext context) {
        ProtectGroup pg = (ProtectGroup)context.getObject("PG_ENTITY");
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        String replicationUuid = (String)pg.getProps().get("replicaCgUuid");
        IDrExtendManager drExtendManager = ManagerFactory.getInstance().getDrExtendManager(pg.getPoProviderSN());
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        try {
            VolumeReplicationCgInfo cgInfo = drExtendManager.queryRealtimeVolumeReplicationCG(regionUuid, tokenId, projUuid, replicationUuid, this.setSyncRetryTimes(context));
            if (null == cgInfo) {
                LOG.error((Object)"Sync protectGroup(%s) failed. Replica(%s) is null.", new Object[]{pg.getName(), replicationUuid});
                throw new LegoCheckedException(1073948448L);
            }
            if ((34 == pg.getTemplate().getType() || 37 == pg.getTemplate().getType()) && OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue().equals(cgInfo.getReplicationStatus())) {
                replicationUuid = (String)pg.getProps().get("hyperProRemoteCgUuid");
            }
            LOG.debug((Object)"Begin sync protectGroup(%s). ReplicaUuid:%s, regionUuid:%s, projUuid:%s", new Object[]{pg.getName(), replicationUuid, regionUuid, projUuid});
            AsyncTaskResponse response = drExtendManager.syncVolumeReplicationCG(regionUuid, tokenId, projUuid, replicationUuid);
            if (!response.isSuccess()) {
                throw new LegoCheckedException(1073948448L);
            }
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)String.format(Locale.ROOT, "Sync protectGroup(%s) error. ReplicaUuid:%s, regionUuid:%s, projUuid:%s", pg.getName(), replicationUuid, regionUuid, projUuid), (Throwable)e);
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            return false;
        }
        catch (Exception e) {
            LOG.error((Object)String.format(Locale.ROOT, "Sync protectGroup(%s) error. ReplicaUuid:%s, regionUuid:%s, projUuid:%s", pg.getName(), replicationUuid, regionUuid, projUuid), (Throwable)e);
            this.setDetail("lego.err.1073948448");
            return false;
        }
        return true;
    }

    private int setSyncRetryTimes(ActionContext context) {
        int retryTimes = 3;
        Schedule schedule = this.getSchedule(context);
        if (null == schedule) {
            LOG.info((Object)"Schedule is null.");
            return retryTimes;
        }
        if (schedule.getPeriodType() == 0 && schedule.getPeriodInterval() < 7) {
            retryTimes = 0;
        }
        return retryTimes;
    }

    public String getName() {
        return "com.huawei.ism.drm.protection.framework.engine.action.BaseAsyncReplicateAction";
    }
}

