/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.path.builder;

import com.huawei.ism.drm.openstack.protection.path.builder.OpenStackVhaAsyncReplicaProtectionPath;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.path.sdk.model.ProtectionPath;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;

public class OpenStackCshaAsyncReplicaProtectionPath
extends OpenStackVhaAsyncReplicaProtectionPath {
    private static final Log LOG = LogFactory.getInstance(OpenStackCshaAsyncReplicaProtectionPath.class);

    @Override
    protected ProtectionPath constructRdProtectionPath(ProtectGroup pg) {
        ArrayList<String> rdPathDetails = new ArrayList<String>();
        ProtectionPath rdProtectionPath = new ProtectionPath();
        Boolean isCsdrVhaModel = OpenStackCommonUtil.isCsdrCshaMode(pg);
        String orginalAz = OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("originalAvailableZone"));
        String projName = (String)pg.getProps().get("projectName");
        String drProjName = (String)pg.getProps().get("drProjectName");
        String azName = (String)pg.getProps().get("zoneName");
        String hyperDrAzName = (String)pg.getProps().get("prod_region_drZoneName");
        String drAzName = (String)pg.getProps().get("drZoneName");
        StringBuffer rdRelationBuff = new StringBuffer();
        ArrayList<String> volumeUuids = new ArrayList<String>();
        for (ProtectObject po : pg.getPolist()) {
            PoReplicaInfo poReplicaInfo = this.getPoReplicaInfo(po, "replicationInfo");
            for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
                if (!OpenstackEnumDefine.VolProtectStatusE.PROTECTED.getStatus().equals(pairInfo.getVolumeStatus())) {
                    LOG.info((Object)"Volume's replica pair is not protected, status: %s", new Object[]{pairInfo.getVolumeStatus()});
                    continue;
                }
                if (volumeUuids.contains(pairInfo.getVolumeUuid())) continue;
                volumeUuids.add(pairInfo.getVolumeUuid());
                rdRelationBuff.append(pairInfo.getVolumeName()).append("(").append(projName).append("/").append(azName).append(")");
                rdRelationBuff.append(isCsdrVhaModel != false ? " --> " : " -- ");
                rdRelationBuff.append(this.getDrVolumName(pairInfo.getVolumeName(), isCsdrVhaModel, orginalAz, isCsdrVhaModel != false ? drAzName : hyperDrAzName)).append("(").append(isCsdrVhaModel != false ? drProjName : projName).append("/").append(isCsdrVhaModel != false ? drAzName : hyperDrAzName).append(")");
                rdRelationBuff.append(isCsdrVhaModel != false ? " -- " : " --> ");
                rdRelationBuff.append(this.getDrVolumName(pairInfo.getVolumeName(), isCsdrVhaModel, orginalAz, isCsdrVhaModel != false ? hyperDrAzName : drAzName)).append("(").append(drProjName).append("/").append(isCsdrVhaModel != false ? hyperDrAzName : drAzName).append(")");
                rdRelationBuff.append(";").append(System.lineSeparator());
            }
        }
        rdPathDetails.add(rdRelationBuff.toString());
        rdProtectionPath.setPathDetails(rdPathDetails);
        return rdProtectionPath;
    }

    @Override
    public int getPolicyTemplateType() {
        return 37;
    }
}

