/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.service;

import com.huawei.ism.drm.openstack.protection.service.CreateRingTaskResult;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.msg.CreateVhaCsdrRingInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VhaCsdrRingInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.openstack.tools.OpenstackResourceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Map;
import java.util.concurrent.Callable;

public class CreateRingTask
implements Callable<CreateRingTaskResult> {
    private static final Log LOG = LogFactory.getInstance(CreateRingTask.class);
    private IVolumeService volumeService;
    private Map<String, PoReplicaInfo> poReplicaInfoMap;
    private ProtectGroup pg;
    private String ringSide;

    public CreateRingTask(IVolumeService volumeService, ProtectGroup pg, Map<String, PoReplicaInfo> poReplicaInfoMap, String ringSide) {
        this.volumeService = volumeService;
        this.pg = pg;
        this.poReplicaInfoMap = poReplicaInfoMap;
        this.ringSide = ringSide;
    }

    @Override
    public CreateRingTaskResult call() {
        this.checkPoReplicaInfoMap();
        Map pgProps = this.pg.getProps();
        String createRingType = null;
        VhaCsdrRingInfo ringInfo = new VhaCsdrRingInfo();
        ringInfo.setName(this.pg.getName());
        CreateRingTaskResult result = new CreateRingTaskResult();
        CreateVhaCsdrRingInfo ringCreateInfo = null;
        String ringIDType = "standbyDRRingUuid";
        try {
            String cgDRID;
            String cgID;
            String azName;
            String projUuid;
            String regionUuid;
            if ("ring_active".equals(this.ringSide)) {
                regionUuid = (String)pgProps.get("regionId");
                projUuid = (String)pgProps.get("projectId");
                azName = (String)pgProps.get("zoneName");
                cgID = OpenStackCommonUtil.getIdFromUuid((String)pgProps.get("replicaCgUuid"));
                cgDRID = OpenStackCommonUtil.getIdFromUuid((String)pgProps.get("hyperProCgUuid"));
                createRingType = "active";
                ringIDType = "prodRingID";
            } else if ("ring_hypermetor".equals(this.ringSide)) {
                regionUuid = (String)pgProps.get("regionId");
                projUuid = (String)pgProps.get("projectId");
                azName = this.getAzName(pgProps);
                cgID = OpenStackCommonUtil.getIdFromUuid((String)pgProps.get("hyperProdrCgUuid"));
                cgDRID = OpenStackCommonUtil.getIdFromUuid((String)pgProps.get("hyperProRemoteCgUuid"));
                createRingType = "hypermetro";
                ringIDType = "hyperDRRingID";
            } else {
                regionUuid = (String)pgProps.get("drRegionId");
                projUuid = (String)pgProps.get("drProjectId");
                azName = (String)pgProps.get("drZoneName");
                cgID = OpenStackCommonUtil.getIdFromUuid((String)pgProps.get("drReplicaCgUuid"));
                cgDRID = OpenStackCommonUtil.getIdFromUuid((String)pgProps.get("hyperProRemotedrCgUuid"));
                createRingType = "remote";
                ringIDType = "standbyDRRingUuid";
            }
            LOG.info((Object)"Start create ring ringType=%s, replicaCGIDStr=%s, replicaDRCGIDStr=%s, protectGroup name=%s", new Object[]{createRingType, cgID, cgDRID, this.pg.getName()});
            ringCreateInfo = this.getCreateVhaCsdrRingInfo(cgID, cgDRID, azName);
            ringInfo = this.getVhaCsdrRingInfo(regionUuid, projUuid, result, ringCreateInfo, ringIDType);
            LOG.info((Object)"Create replication Ring ringType=%s sucessfully.replicationRingId=%s, protectGroup name=%s", new Object[]{createRingType, ringInfo.getId(), this.pg.getName()});
        }
        catch (LegoCheckedException e) {
            this.setResultWhenException(createRingType, ringInfo, result, ringCreateInfo, ringIDType, e);
        }
        catch (Exception e) {
            LOG.error((Object)"Create %s ring failed,protectGroup name=%s, ringCreateInfo=%s, Exception:%s", new Object[]{createRingType, this.pg.getName(), ringCreateInfo, ExceptionUtil.getErrorMessage((Throwable)e)});
            this.setResult(result, ringInfo, false);
        }
        return result;
    }

    private VhaCsdrRingInfo getVhaCsdrRingInfo(String regionUuid, String projUuid, CreateRingTaskResult result, CreateVhaCsdrRingInfo ringCreateInfo, String ringIDType) {
        VhaCsdrRingInfo ringInfo = this.volumeService.createReplicaRing(ringCreateInfo, regionUuid, projUuid);
        this.pg.getProps().put(ringIDType, ringInfo.getId());
        OpenStackCommonUtil.switchRing(ringInfo.getId(), true, regionUuid, projUuid);
        this.setResult(result, ringInfo, true);
        return ringInfo;
    }

    private void checkPoReplicaInfoMap() {
        if (VerifyUtil.isEmpty(this.poReplicaInfoMap)) {
            LOG.error((Object)("CreateReplicaRing:replicaList is empty,protectGroup name=" + this.pg.getName()), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private String getAzName(Map<String, String> pgProps) {
        String azName = pgProps.get("zoneName");
        if (this.pg.getTemplate().getType() == 37) {
            azName = pgProps.get("prod_region_drZoneName");
        }
        return azName;
    }

    private void setResultWhenException(String createRingType, VhaCsdrRingInfo ringInfo, CreateRingTaskResult result, CreateVhaCsdrRingInfo ringCreateInfo, String ringIDType, LegoCheckedException e) {
        if (!VerifyUtil.isEmpty((Object[])e.getParameters())) {
            LOG.error((Object)"Create %s ring failed, ring id = %s,protectGroup name=%s, ringCreateInfo=%s, Exception:%s", new Object[]{createRingType, e.getParameters()[0], this.pg.getName(), ringCreateInfo, ExceptionUtil.getErrorMessage((Throwable)e)});
            this.pg.getProps().put(ringIDType, e.getParameters()[0]);
        } else {
            LOG.error((Object)"Create %s ring failed,protectGroup name=%s, ringCreateInfo=%s, Exception:%s", new Object[]{createRingType, this.pg.getName(), ringCreateInfo, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        this.setResult(result, ringInfo, false);
    }

    private void setResult(CreateRingTaskResult result, VhaCsdrRingInfo ringInfo, boolean flag) {
        result.setVhaCsdrRingInfo(ringInfo);
        result.setResultFlag(flag);
    }

    private CreateVhaCsdrRingInfo getCreateVhaCsdrRingInfo(String cgID, String cgDRID, String azName) {
        CreateVhaCsdrRingInfo ringCreateInfo = new CreateVhaCsdrRingInfo();
        ringCreateInfo.setName(this.pg.getName());
        ringCreateInfo.setAzName(azName);
        ringCreateInfo.setDescription(this.pg.getName());
        ringCreateInfo.setSwapStrategy(OpenstackResourceUtil.getInstance().getValue("openstack_ring_switch_policy"));
        ringCreateInfo.setSwapTime(OpenstackResourceUtil.getInstance().getValue("openstack_ring_swap_time"));
        ringCreateInfo.setReplicationcgs(cgID + "," + cgDRID);
        return ringCreateInfo;
    }
}

