/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.service;

import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.PhVmInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeAttachmentInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.List;
import java.util.concurrent.Callable;

public class DelPlaceHoldVMTask
implements Callable<PhVmInfo> {
    private static final Log LOG = LogFactory.getInstance(DelPlaceHoldVMTask.class);
    private ProtectGroup pg;
    private ProtectObject po;
    private final PhVmInfo vm;
    private boolean needDelete;

    public DelPlaceHoldVMTask(PhVmInfo vm, ProtectGroup pg, ProtectObject po, boolean needDelete) {
        this.pg = pg;
        this.po = po;
        this.vm = vm;
        this.needDelete = needDelete;
    }

    @Override
    public PhVmInfo call() {
        String openstackUuid = this.pg.getPoProviderSN();
        String drProjId = (String)this.pg.getProps().get("drProjectId");
        String drRegionId = (String)this.pg.getProps().get("drRegionId");
        String splitFlag = (String)this.pg.getProps().get("PG_PROP_REPLICATION_SPLIT_KEY");
        String instanceType = (String)this.pg.getProps().get("serviceInstanceType");
        INovaManager novaManager = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        this.attachVol(drProjId, drRegionId, instanceType, novaManager);
        if (Boolean.toString(true).equals(splitFlag)) {
            LOG.info((Object)"Do not delelte placeHold VMTask.Because splitFlag(Force delete)=%s, ProtectGroup name=%s", new Object[]{splitFlag, this.pg.getName()});
            return this.vm;
        }
        String tokenId = TokenUtil.getInstance().getRegionTokenId(drRegionId, drProjId);
        try {
            OpenStackVM phvm = novaManager.getVm(drRegionId, tokenId, drProjId, this.vm.getVmUuid(), new int[0]);
            if (null == phvm) {
                LOG.info((Object)"Delelte placeHold VMTask.Because splitFlag(Force delete)=%s, ProtectGroup name=%s", new Object[]{splitFlag, this.pg.getName()});
                return this.vm;
            }
            if (!OpenStackCommonUtil.isBareMetalServer(phvm)) {
                AsyncTaskResponse response = novaManager.unlockVm(drRegionId, tokenId, drProjId, this.vm.getVmUuid());
                this.checkResponse(drProjId, drRegionId, novaManager, tokenId, response);
            }
        }
        catch (LegoCheckedException e) {
            if (201L == e.getErrorCode()) {
                LOG.info((Object)"Delete placeHold VMTask success. vm %s has no exist., protectGroup name=%s", new Object[]{this.vm.getVmUuid(), this.pg.getName()});
            } else {
                LOG.error((Object)"Delete placeHold VMTask failed.vmID=%s,protectGroup name=%s", new Object[]{this.vm.getVmUuid(), this.pg.getName()});
                ExceptionUtil.rethrowException((Throwable)e, (String)"task execute failed:", (long)1073948412L, (String[])new String[0], (Log)LOG);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Delete placeHold VMTask failed. vmID=%s, protectGroup name=%s", new Object[]{this.vm.getVmUuid(), this.pg.getName()});
            ExceptionUtil.rethrowException((Throwable)e, (String)"task execute failed:", (long)1073948412L, (String[])new String[0], (Log)LOG);
        }
        return this.vm;
    }

    private void checkResponse(String drProjId, String drRegionId, INovaManager novaManager, String tokenId, AsyncTaskResponse response) {
        if (!response.isSuccess()) {
            LOG.error((Object)"Unlock placeHold VMTask failed.Vmuuid=%s, protectGroup name=%s", new Object[]{this.vm.getVmUuid(), this.pg.getName()});
            throw new LegoCheckedException(response.getErrorCode());
        }
        if (this.needDelete && !(response = novaManager.deleteVm(drRegionId, drProjId, tokenId, this.vm.getVmUuid())).isSuccess()) {
            LOG.error((Object)"Delete placeHold VMTask failed.Vmuuid=%s, protectGroup name=%s", new Object[]{this.vm.getVmUuid(), this.pg.getName()});
            throw new LegoCheckedException(response.getErrorCode());
        }
    }

    private void attachVol(String drProjId, String drRegionId, String instanceType, INovaManager novaManager) {
        boolean attachBootVolume;
        boolean bl = attachBootVolume = ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.isCurrent(instanceType) || ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.isCurrent(instanceType) || ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.isCurrent(instanceType);
        if (attachBootVolume) {
            this.attachPrdBootVol(novaManager, this.pg, this.po);
            try {
                this.attachVolume(drProjId, drRegionId, novaManager);
            }
            catch (Exception e) {
                LOG.error((Object)("AttachPhBootVol failed. vmID=" + this.po.getMoUuid() + ", protectGroup name=" + this.pg.getName()));
            }
        }
    }

    private void attachVolume(String drProjId, String drRegionId, INovaManager novaManager) {
        if (!this.needDelete) {
            String tokenId = TokenUtil.getInstance().getRegionTokenId(drRegionId, drProjId);
            OpenStackVM phvm = novaManager.getVm(drRegionId, tokenId, drProjId, this.vm.getVmUuid(), new int[0]);
            if (null != phvm && !OpenStackCommonUtil.isBareMetalServer(phvm)) {
                this.attachPhBootVolume(drProjId, drRegionId, novaManager, tokenId, phvm);
            } else if (null == phvm) {
                this.unreserveVolumeForPhVMNotExist(drRegionId, drProjId);
            }
        }
    }

    private void attachPhBootVolume(String drProjId, String drRegionId, INovaManager novaManager, String tokenId, OpenStackVM phvm) {
        if (null == this.po) {
            LOG.warn((Object)"Po is null.Vmuuid=%s, protectGroup name=%s", new Object[]{this.vm.getVmUuid(), this.pg.getName()});
            return;
        }
        String replicationInfo = (String)this.po.getProperty("replicationInfo", String.class);
        if (null == replicationInfo) {
            LOG.warn((Object)"ReplicationInfo is null.Vmuuid=%s, protectGroup name=%s", new Object[]{this.vm.getVmUuid(), this.pg.getName()});
            return;
        }
        PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class);
        if (null == poReplicaInfo) {
            LOG.warn((Object)"PoReplicaInfo is null.Vmuuid=%s, protectGroup name=%s", new Object[]{this.vm.getVmUuid(), this.pg.getName()});
            return;
        }
        String srcBootVolumeUuid = (String)this.po.getProps().get("VM_BOOTABLE_VOLUME");
        for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
            if (VerifyUtil.isEmpty((String)srcBootVolumeUuid) || !srcBootVolumeUuid.equals(pairInfo.getVolumeUuid())) continue;
            String drVmUuid = this.vm.getVmUuid();
            String drVolumeUuid = pairInfo.getDrVolumeUuid();
            this.attachVolume(drProjId, drRegionId, novaManager, tokenId, phvm, drVmUuid, drVolumeUuid);
        }
    }

    private void attachVolume(String projId, String regionId, INovaManager novaManager, String tokenId, OpenStackVM openStackVm, String ... args) {
        String vmUuid = args.length > 0 ? args[0] : null;
        String volumeUuid = args.length > 1 ? args[1] : null;
        IVolumeService volService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        VolumeInfo volumeInfo = volService.queryVolumeInfoByUuid(regionId, projId, volumeUuid);
        if (!VerifyUtil.isEmpty((Object)volumeInfo)) {
            boolean alreadyAttach = false;
            for (VolumeAttachmentInfo attachmentInfo : volumeInfo.getAttachments()) {
                if (!attachmentInfo.getServerId().equals(vmUuid) || !OpenstackEnumDefine.VolumeStatusE.INUSE.getType().equals(volumeInfo.getStatus())) continue;
                alreadyAttach = true;
                LOG.info((Object)"Vol(%s) is areadly attached to vm(%s)", new Object[]{volumeUuid, openStackVm.getName()});
            }
            if (!alreadyAttach) {
                ((IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class)).unreserveVolume(OpenStackCommonUtil.getIdFromUuid(volumeUuid), regionId, projId);
                volService.deleteVolMetadatas(regionId, projId, OpenStackCommonUtil.getIdFromUuid(volumeUuid), "occupied_volume");
                String vmType = (String)this.po.getProps().get("vm_type");
                AsyncTaskResponse attachResponse = novaManager.attachVolumeToVM(tokenId, projId, regionId, vmUuid, vmType, OpenStackCommonUtil.getIdFromUuid(volumeUuid), openStackVm.getBootDevName());
                if (attachResponse.isSuccess()) {
                    LOG.info((Object)"Vol(%s) success attached to vm(%s)", new Object[]{volumeUuid, openStackVm.getName()});
                } else {
                    LOG.error((Object)("vol(" + volumeUuid + ") error to attached to vm(" + openStackVm.getName() + ")"));
                }
            } else {
                LOG.info((Object)"Vol(%s) allready attached to vm(%s)", new Object[]{volumeUuid, openStackVm.getName()});
            }
        } else {
            LOG.warn((Object)"DrVolume is null.drVolumeUuid=%s, protectGroup name=%s", new Object[]{volumeUuid, this.pg.getName()});
        }
    }

    private void attachPrdBootVol(INovaManager novaManager, ProtectGroup protectGroup, ProtectObject protectObject) {
        try {
            String regionUuid = (String)protectGroup.getProps().get("regionId");
            String projUuid = (String)protectGroup.getProps().get("projectId");
            String vmUuid = protectObject.getMoUuid();
            String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
            OpenStackVM openStackVM = novaManager.getVm(regionUuid, tokenId, projUuid, vmUuid, new int[0]);
            if (null == openStackVM) {
                LOG.error((Object)"Vm not exist:%s, ProtectGroup name=%s", new Object[]{protectObject.getName(), protectGroup.getName()});
                return;
            }
            String srcBootVolumeUuid = (String)protectObject.getProps().get("VM_BOOTABLE_VOLUME");
            if (!VerifyUtil.isEmpty((String)openStackVM.getVolumeAttached())) {
                List<String> attachedVol = OpenStackCommonUtil.getListFromStr(openStackVM.getVolumeAttached(), ",");
                for (String volUuid : attachedVol) {
                    if (!volUuid.equals(srcBootVolumeUuid)) continue;
                    LOG.info((Object)"Boot volume already attached vm:%s", new Object[]{openStackVM.getName()});
                    return;
                }
            }
            if (!OpenStackCommonUtil.isBareMetalServer(openStackVM)) {
                AsyncTaskResponse response = novaManager.unlockVm(regionUuid, tokenId, projUuid, openStackVM.getUuid());
                if (!response.isSuccess()) {
                    LOG.error((Object)"Unlock VMTask failed.Vmuuid=%s, protectGroup name=%s", new Object[]{openStackVM.getUuid(), protectGroup.getName()});
                    return;
                }
                this.attachVolume(projUuid, regionUuid, novaManager, tokenId, openStackVM, openStackVM.getUuid(), srcBootVolumeUuid);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"AttachPrdBootVol failed.vmID=%s,protectGroup name=%s", new Object[]{protectObject.getMoUuid(), this.pg.getName()});
        }
    }

    private void unreserveVolumeForPhVMNotExist(String drRegionId, String drProjId) {
        PoReplicaInfo poReplicaInfo = (PoReplicaInfo)this.po.getProperty("replicationInfo", PoReplicaInfo.class);
        if (null == poReplicaInfo) {
            LOG.warn((Object)"PoReplicaInfo is null.Vmuuid=%s, protectGroup name=%s", new Object[]{this.vm.getVmUuid(), this.pg.getName()});
            return;
        }
        String srcBootVolumeUuid = (String)this.po.getProps().get("VM_BOOTABLE_VOLUME");
        for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
            if (VerifyUtil.isEmpty((String)srcBootVolumeUuid) || !srcBootVolumeUuid.equals(pairInfo.getVolumeUuid())) continue;
            String drVolumeUuid = pairInfo.getDrVolumeUuid();
            ((IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class)).unreserveVolume(OpenStackCommonUtil.getIdFromUuid(drVolumeUuid), drRegionId, drProjId);
            IVolumeService volService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
            volService.deleteVolMetadatas(drRegionId, drProjId, OpenStackCommonUtil.getIdFromUuid(drVolumeUuid), "occupied_volume");
        }
    }
}

