/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.template.provider;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.template.provider.AbstractPolicyTemplateProvider;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.lego.core.sdk.util.UUIDGenerator;

public class OpenStackPolicyTemplateProvider
extends AbstractPolicyTemplateProvider {
    protected void buildAllTemplate() {
        this.addPolicyTemplate(this.buildArraySyncReplicationPt());
        this.addPolicyTemplate(this.buildArrayAsyncReplicationPt());
        this.addPolicyTemplate(this.buildHyperMetroPt(25));
        this.addPolicyTemplate(this.buildHyperMetroPt(29));
        this.addPolicyTemplate(this.buildHyperMetorArrayAsyncReplicationRingPt(34));
        this.addPolicyTemplate(this.buildHyperMetorArrayAsyncReplicationRingPt(37));
        this.addPolicyTemplate(this.buildSfsArraySyncReplicationPt());
    }

    private PolicyTemplate buildHyperMetroPt(int policyType) {
        Schedule scheduleAB = new Schedule();
        scheduleAB.setScheduleId(UUIDGenerator.getUUID());
        scheduleAB.setProtectLocation(DrmEnumDefine.ProtectLocation.A_B.getValue());
        scheduleAB.setScheduleMode(1);
        PolicyTemplate policyTemplate = new PolicyTemplate();
        policyTemplate.setType(policyType);
        policyTemplate.setIsSystemDefine(Boolean.valueOf(true));
        OpenStackPolicyTemplateProvider.initHyperMetroPolicyTemplate(policyTemplate);
        policyTemplate.getSchedules().add(scheduleAB);
        return policyTemplate;
    }

    public static void initHyperMetroPolicyTemplate(PolicyTemplate policyTemplate) {
        policyTemplate.setName("vis.active.name");
        policyTemplate.setDescription("vis.active.active.desc");
        policyTemplate.setSketch("policy_template_15_hypermetro.png");
        policyTemplate.setViewTemplateUrl("/ism/drm/policyTemplate/viewTemplate.do");
        policyTemplate.setEditTemplateUrl(null);
    }

    private PolicyTemplate buildArraySyncReplicationPt() {
        Schedule scheduleAB = new Schedule();
        scheduleAB.setScheduleId(UUIDGenerator.getUUID());
        scheduleAB.setProtectLocation(DrmEnumDefine.ProtectLocation.A_B.getValue());
        scheduleAB.setScheduleMode(1);
        PolicyTemplate policyTemplate = new PolicyTemplate();
        policyTemplate.setType(21);
        policyTemplate.setIsSystemDefine(Boolean.valueOf(true));
        policyTemplate.setName("array.replica.sync.name");
        policyTemplate.setDescription("array.replica.sync.desc");
        policyTemplate.setSketch("policy_template_2_synchronous.png");
        policyTemplate.setViewTemplateUrl("/ism/drm/policyTemplate/viewTemplate.do");
        policyTemplate.setEditTemplateUrl(null);
        policyTemplate.getSchedules().add(scheduleAB);
        return policyTemplate;
    }

    private PolicyTemplate buildArrayAsyncReplicationPt() {
        Schedule schedule = new Schedule();
        schedule.setScheduleId(UUIDGenerator.getUUID());
        schedule.setProtectLocation(DrmEnumDefine.ProtectLocation.A_B.getValue());
        schedule.setStartTime(String.valueOf(this.getCalendar().getTimeInMillis()));
        schedule.setScheduleMode(1);
        PolicyTemplate policyTemplate = new PolicyTemplate();
        policyTemplate.setType(22);
        policyTemplate.setIsSystemDefine(Boolean.valueOf(true));
        OpenStackPolicyTemplateProvider.initAsyncReplicationPolicyTemplate(policyTemplate);
        policyTemplate.getSchedules().add(schedule);
        return policyTemplate;
    }

    public static void initAsyncReplicationPolicyTemplate(PolicyTemplate policyTemplate) {
        policyTemplate.setName("array.replica.async.name");
        policyTemplate.setDescription("array.replica.async.desc");
        policyTemplate.setSketch("policy_template_3_asynchronous.png");
        policyTemplate.setViewTemplateUrl("/ism/drm/policyTemplate/viewTemplate.do");
        policyTemplate.setEditTemplateUrl("/ism/drm/policyTemplate/toModifyTemplateLink.do");
    }

    private PolicyTemplate buildHyperMetorArrayAsyncReplicationRingPt(int addPolicyTemplateType) {
        Schedule schedule = new Schedule();
        schedule.setScheduleId(UUIDGenerator.getUUID());
        schedule.setProtectLocation(DrmEnumDefine.ProtectLocation.C_C.getValue());
        schedule.setStartTime(String.valueOf(this.getCalendar().getTimeInMillis()));
        schedule.setScheduleMode(1);
        PolicyTemplate policyTemplate = new PolicyTemplate();
        policyTemplate.setType(addPolicyTemplateType);
        policyTemplate.setIsSystemDefine(Boolean.valueOf(true));
        policyTemplate.setName("array.activeactive.async.ring.name");
        policyTemplate.setDescription("array.activeactive.async.desc");
        policyTemplate.setSketch("policy_template_26_hypermetroasync_ring.png");
        policyTemplate.setViewTemplateUrl("/ism/drm/policyTemplate/viewTemplate.do");
        policyTemplate.setEditTemplateUrl("/ism/drm/policyTemplate/toHypermetroAsyncRingModifyTemplateLink.do");
        policyTemplate.getSchedules().add(schedule);
        return policyTemplate;
    }

    private PolicyTemplate buildSfsArraySyncReplicationPt() {
        Schedule scheduleAB = new Schedule();
        scheduleAB.setScheduleId(UUIDGenerator.getUUID());
        scheduleAB.setProtectLocation(DrmEnumDefine.ProtectLocation.A_B.getValue());
        scheduleAB.setScheduleMode(1);
        PolicyTemplate policyTemplate = new PolicyTemplate();
        policyTemplate.setType(38);
        policyTemplate.setIsSystemDefine(Boolean.valueOf(true));
        policyTemplate.setName("array.replica.sync.name");
        policyTemplate.setDescription("array.replica.sync.desc");
        policyTemplate.setSketch("policy_template_2_synchronous.png");
        policyTemplate.setViewTemplateUrl("/ism/drm/policyTemplate/viewTemplate.do");
        policyTemplate.setEditTemplateUrl(null);
        policyTemplate.getSchedules().add(scheduleAB);
        return policyTemplate;
    }
}

