/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackAttachPortSubProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDetachPortSubProcessor;
import com.huawei.ism.drm.openstack.sdk.bo.PhVmInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class OpenStackAttachPortProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 495921386988768027L;
    private static final Log LOG = LogFactory.getInstance(OpenStackAttachPortProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            try {
                this.generateSubProcessors(context);
            }
            catch (LegoCheckedException e) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                return false;
            }
        }
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            LOG.debug((Object)"No ports need to attach", 90160758786816L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        ArrayList list = new ArrayList(this.getChildProc());
        RecoveryProcessConcurrentExecutor executor = RecoveryProcessConcurrentExecutor.createExecutor(list);
        executor.process(context);
        return this.calcProcessResultBySubProc();
    }

    private void generateSubProcessors(RecoveryProcessorContext context) {
        List detachProcessors = this.getRecoveryProcessors(context.getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()), OpenStackDetachPortSubProcessor.class);
        if (VerifyUtil.isEmpty((Collection)detachProcessors)) {
            LOG.error((Object)"The detach port processor is empty");
            return;
        }
        Map<String, PhVmInfo> vmUuid2PhVmMap = this.getVmUuidReplicaInfoMap();
        HashSet<OpenStackAttachPortSubProcessor> subProcSet = new HashSet<OpenStackAttachPortSubProcessor>();
        for (RecoveryProcessor recoveryProc : detachProcessors) {
            OpenStackDetachPortSubProcessor detachPortProc = (OpenStackDetachPortSubProcessor)recoveryProc;
            String portIdStr = detachPortProc.getString("portIdsOfVM");
            String vmUuid = detachPortProc.getString("vmUuid");
            String vmName = detachPortProc.getString("vmName");
            PhVmInfo phVmInfo = vmUuid2PhVmMap.get(vmUuid);
            if (VerifyUtil.isEmpty((Object)phVmInfo)) {
                LOG.error((Object)"The vm %s has no placehold vm, can't attach port.", new Object[]{vmName});
                throw new LegoCheckedException(1073947393L);
            }
            ProtectGroup pg = context.getProtectGroup();
            boolean isCshaCsdrWithinRegionRecovery = PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg);
            String regionUuid = isCshaCsdrWithinRegionRecovery ? detachPortProc.getString("regionUuid") : (String)pg.getProps().get("drRegionId");
            String projectUuid = isCshaCsdrWithinRegionRecovery ? detachPortProc.getString("projUuid") : (String)pg.getProps().get("drProjectId");
            OpenStackAttachPortSubProcessor subProc = new OpenStackAttachPortSubProcessor(regionUuid, projectUuid, portIdStr, phVmInfo.getName(), phVmInfo.getVmUuid());
            this.initProc((RecoveryProcessor)subProc);
            subProcSet.add(subProc);
        }
        this.setChildProc(subProcSet);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private Map<String, PhVmInfo> getVmUuidReplicaInfoMap() {
        ProtectGroup pg = this.getContextRef().getProtectGroup();
        boolean isCshaCsdrWithinRegionRecovery = PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg);
        HashMap<String, PhVmInfo> map = new HashMap<String, PhVmInfo>();
        for (ProtectObject po : pg.getPolist()) {
            PoReplicaInfo replicaInfo;
            String replicaStr = (String)po.getProps().get("replicationInfo");
            if (isCshaCsdrWithinRegionRecovery) {
                replicaStr = po.getProperty("hypermetor_replicationInfo");
            }
            if (null == (replicaInfo = JsonUtil.jsonToBean(replicaStr, PoReplicaInfo.class))) {
                LOG.error((Object)"Convert PoReplicaInfo return null, replicaStr=%s", new Object[]{replicaStr});
                throw new LegoCheckedException(0x300001L);
            }
            map.put(po.getMoUuid(), replicaInfo.getPhVmInfo());
        }
        return map;
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    protected boolean calcProcessResultBySubProc() {
        LOG.debug((Object)"CalcProcessResultBySubProc start");
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() != procStatus.getValue() && DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() != procStatus.getValue();
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

