/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.processor.CreateLinkedCloneVolumeProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackAttachVolToVMProcessor;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class OpenStackAttachVolSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -7717321080198109736L;
    private static final Log LOG = LogFactory.getInstance(OpenStackAttachVolSubProcessor.class);
    private ProtectObject po;
    private String bootDevName;

    public OpenStackAttachVolSubProcessor() {
        LOG.debug((Object)"Enter OpenStackAttachVolSubProcessor ");
    }

    public OpenStackAttachVolSubProcessor(String poUuid, String drVmUuid, String drRegionUuid, String drProjUuid, String poReplicationInfoStr) {
        LOG.debug((Object)"Enter OpenStackAttachVolSubProcessor");
        this.addString("protectobjectUuid", poUuid);
        this.addString("regionUuid", drRegionUuid);
        this.addString("projUuid", drProjUuid);
        this.addString("vmUuid", drVmUuid);
        this.addString("poReplicaInfo", poReplicationInfoStr);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        LOG.debug((Object)"Enter into OpenStackAttachVolSubProcessor");
        String drVmUuid = this.getString("vmUuid");
        String poUuid = this.getString("protectobjectUuid");
        String drRegionUuid = this.getString("regionUuid");
        String drProjUuid = this.getString("projUuid");
        this.po = OpenStackRecoveryTool.getProtectObjectFromRecoveryPlan(context.getRecoveryPlan(), poUuid);
        if (null == this.po) {
            return this.checkProtectObject(drVmUuid, poUuid);
        }
        LOG.info((Object)"Enter into OpenStackAttachVolSubProcessor:%s", new Object[]{this.po.getName()});
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(drRegionUuid);
        INovaManager novaManager = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(drRegionUuid, drProjUuid);
        OpenStackVM vm = novaManager.getVm(drRegionUuid, tokenId, drProjUuid, drVmUuid, new int[0]);
        if (null == vm) {
            this.updateProcessNameParams(new String[]{OpenStackCommonUtil.getIdFromUuid(drVmUuid)});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948375", null);
            LOG.error((Object)"Placeholder vm(%s) doesn't exits.", new Object[]{drVmUuid});
            return false;
        }
        this.bootDevName = vm.getBootDevName();
        this.addString("vmName", vm.getName());
        this.updateProcessNameParams(new String[]{vm.getName()});
        LOG.debug((Object)"Enter into OpenStackAttachVolSubProcessor_1:%s", new Object[]{this.po.getName()});
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == this.getProcType()) {
            this.generateDrillingSubProcessors();
        } else if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() == this.getProcType()) {
            this.generatePlanMotionSubProcessors();
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
            return true;
        }
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor((Set)this.getChildProc(), (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
        if (null == recoveryTemplate) {
            LOG.info((Object)"RecoveryTemplate is null");
            throw new LegoCheckedException(2117645L);
        }
        LOG.debug((Object)"Enter into OpenStackAttachVolSubProcessor_,before process,po name=%s", new Object[]{this.po.getName()});
        recoveryTemplate.process(context);
        LOG.info((Object)"Leave OpenStackAttachVolSubProcessor,po name=%s", new Object[]{this.po.getName()});
        return this.calcProcessResultBySubProc();
    }

    private boolean checkProtectObject(String drVmUuid, String poUuid) {
        this.updateProcessNameParams(new String[]{OpenStackCommonUtil.getIdFromUuid(drVmUuid)});
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        this.updateProcessDetail("lego.err.1073947393", new String[0]);
        LOG.error((Object)"Po(%s) isn't in plan.", new Object[]{poUuid});
        return false;
    }

    private void generatePlanMotionSubProcessors() {
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            return;
        }
        HashMap<String, String> productVolIdToDrVolId = new HashMap<String, String>();
        String replicaInfoStr = this.getString("poReplicaInfo");
        PoReplicaInfo replicaInfo = JsonUtil.jsonToBean(replicaInfoStr, PoReplicaInfo.class);
        if (null == replicaInfo) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("ism.drm.pg.po.replicainfo.error", null);
            LOG.error((Object)"Vm  replicaInfo(%s) doesn't exits.", new Object[]{this.po.getName()});
            return;
        }
        HashSet<OpenStackAttachVolToVMProcessor> subProcessors = new HashSet<OpenStackAttachVolToVMProcessor>();
        HashSet<OpenStackAttachVolToVMProcessor> readyProcs = new HashSet<OpenStackAttachVolToVMProcessor>();
        HashSet<OpenStackAttachVolToVMProcessor> errorProcs = new HashSet<OpenStackAttachVolToVMProcessor>();
        this.generateAttachProcessor(productVolIdToDrVolId, replicaInfo, readyProcs, errorProcs);
        ArrayList<String> deviceNames = new ArrayList<String>();
        HashMap<String, String> deviceNameToProductVolId = new HashMap<String, String>();
        HashMap<String, String> productVolIdToVolName = new HashMap<String, String>();
        this.updateSrcDevNameInfo(deviceNames, deviceNameToProductVolId, productVolIdToVolName);
        List<String> sortedDevNames = this.getSortedDeviceNames(deviceNames);
        Object preProcessor = this.dealBootVolumeProcessor(productVolIdToDrVolId, readyProcs, productVolIdToVolName, sortedDevNames);
        for (String devName : sortedDevNames) {
            String srcVolId = (String)deviceNameToProductVolId.get(devName);
            String drVolId = (String)productVolIdToDrVolId.get(srcVolId);
            OpenStackAttachVolToVMProcessor subProcessor = this.getProcByVolId(readyProcs, drVolId);
            if (null == subProcessor) continue;
            subProcessor.addString("deviceName", devName);
            LOG.info((Object)"Set %s to %s on %s", new Object[]{devName, productVolIdToVolName.get(srcVolId), this.po.getName()});
            if (preProcessor != null) {
                preProcessor.setNextProcessor((RecoveryProcessor)subProcessor);
                subProcessor.setPreviousProcessor((RecoveryProcessor)preProcessor);
            }
            preProcessor = subProcessor;
        }
        for (OpenStackAttachVolToVMProcessor errorProc : errorProcs) {
            if (preProcessor != null) {
                preProcessor.setNextProcessor((RecoveryProcessor)errorProc);
                errorProc.setPreviousProcessor((RecoveryProcessor)preProcessor);
            }
            preProcessor = errorProc;
        }
        subProcessors.addAll(readyProcs);
        subProcessors.addAll(errorProcs);
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private RecoveryProcessor dealBootVolumeProcessor(Map<String, String> productVolIdToDrVolId, Set<OpenStackAttachVolToVMProcessor> readyProcs, Map<String, String> productVolIdToVolName, List<String> sortedDevNames) {
        OpenStackAttachVolToVMProcessor preProcessor = null;
        String srcBootVolumeUuid = (String)this.po.getProps().get("VM_BOOTABLE_VOLUME");
        if (!VerifyUtil.isEmpty((String)srcBootVolumeUuid) && !VerifyUtil.isEmpty((String)this.bootDevName)) {
            LOG.info((Object)"%s's bootdev is %s and srcvolume is %s", new Object[]{this.po.getName(), this.bootDevName, productVolIdToVolName.get(srcBootVolumeUuid)});
            String drBootVolId = productVolIdToDrVolId.get(srcBootVolumeUuid);
            OpenStackAttachVolToVMProcessor proc = this.getProcByVolId(readyProcs, drBootVolId);
            if (null != proc) {
                proc.addString("deviceName", this.bootDevName);
                preProcessor = proc;
                sortedDevNames.remove(this.bootDevName);
                productVolIdToDrVolId.remove(srcBootVolumeUuid);
                LOG.info((Object)"Set boot vol(%s)'devname %s", new Object[]{productVolIdToVolName.get(srcBootVolumeUuid), this.bootDevName});
            }
        }
        return preProcessor;
    }

    private void generateAttachProcessor(Map<String, String> productVolIdToDrVolId, PoReplicaInfo replicaInfo, Set<OpenStackAttachVolToVMProcessor> readyProcs, Set<OpenStackAttachVolToVMProcessor> errorProcs) {
        String drVmUuid = this.getString("vmUuid");
        String drRegionUuid = this.getString("regionUuid");
        String drProjUuid = this.getString("projUuid");
        List pairInfos = replicaInfo.getPairInfos();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(drRegionUuid, drProjUuid);
        for (PoReplicaPairInfo repPair : pairInfos) {
            String drVolumeUuid = repPair.getDrVolumeUuid();
            productVolIdToDrVolId.put(repPair.getVolumeUuid(), drVolumeUuid);
            String drVolumeId = OpenStackCommonUtil.getIdFromUuid(drVolumeUuid);
            CinderManager cinderMgr = new CinderManager();
            String drVolName = drVolumeId;
            if (VerifyUtil.isEmpty((String)drVolumeId)) {
                String volumeName = repPair.getVolumeName();
                LOG.debug((Object)"The volume name is : %s, don't have drVolume", new Object[]{volumeName});
            } else {
                VolumeInfo volInfo = cinderMgr.queryVolume(drRegionUuid, tokenId, drProjUuid, drVolumeId);
                if (!VerifyUtil.isEmpty((Object)volInfo)) {
                    drVolName = volInfo.getName();
                }
            }
            OpenStackAttachVolToVMProcessor subProcessor = new OpenStackAttachVolToVMProcessor(drVolumeUuid, drVolName, repPair.getVolumeStatus(), drVmUuid, drProjUuid, drRegionUuid);
            subProcessor.addString("vmType", (String)this.po.getProps().get("vm_type"));
            this.initProc((RecoveryProcessor)subProcessor);
            if (OpenstackEnumDefine.VolProtectStatusE.PROTECTED.getStatus().equals(repPair.getVolumeStatus())) {
                readyProcs.add(subProcessor);
                LOG.info((Object)"%s is in readyProcs.", new Object[]{repPair.getVolumeName()});
                continue;
            }
            if (OpenstackEnumDefine.VolProtectStatusE.UNPROTECTED.getStatus().equals(repPair.getVolumeStatus()) && !VerifyUtil.isEmpty((String)((String)this.po.getProps().get("vm_type"))) && "BMS".equals(this.po.getProps().get("vm_type"))) {
                LOG.debug((Object)"Generate atttach processor, vm name=%s,volumeName=%s, is not in errorProcs.because vm is BMS.vmtype=%s", new Object[]{this.po.getName(), repPair.getVolumeName(), this.po.getProps().get("vm_type")});
                continue;
            }
            errorProcs.add(subProcessor);
            LOG.info((Object)"%s is in errorProcs.", new Object[]{repPair.getVolumeName()});
        }
    }

    private OpenStackAttachVolToVMProcessor getProcByVolId(Set<OpenStackAttachVolToVMProcessor> readyProcs, String volId) {
        LOG.debug((Object)"Enter getProcByVolId");
        if (VerifyUtil.isEmpty(readyProcs) || VerifyUtil.isEmpty((String)volId)) {
            return null;
        }
        for (OpenStackAttachVolToVMProcessor proc : readyProcs) {
            if (!volId.equals(proc.getString("volUuid"))) continue;
            return proc;
        }
        return null;
    }

    private void generateDrillingSubProcessors() {
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            return;
        }
        HashMap<String, String> cloneVolIdAndName = new HashMap<String, String>();
        Map<String, String> drVolIdToLinkedCloneVolId = this.calDrVolIdToLinkedCloneVolId(cloneVolIdAndName);
        Map<String, String> productVolIdToLinkedCloneVolId = this.calProductVolToLinkedCloneVol(drVolIdToLinkedCloneVolId);
        ArrayList<String> deviceNames = new ArrayList<String>();
        HashMap<String, String> deviceNameToProductVolId = new HashMap<String, String>();
        HashMap<String, String> productVolIdToVolName = new HashMap<String, String>();
        this.updateSrcDevNameInfo(deviceNames, deviceNameToProductVolId, productVolIdToVolName);
        List<String> sortedDevNames = this.getSortedDeviceNames(deviceNames);
        this.setChildProc(this.generateSubProcessors(cloneVolIdAndName, productVolIdToLinkedCloneVolId, deviceNameToProductVolId, sortedDevNames));
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private Set<RecoveryProcessor> generateSubProcessors(Map<String, String> cloneVolIdAndName, Map<String, String> productVolIdToLinkedCloneVolId, Map<String, String> deviceNameToProductVolId, List<String> sortedDevNames) {
        String drBootVolId;
        String drVmUuid = this.getString("vmUuid");
        String drRegionUuid = this.getString("regionUuid");
        String drProjUuid = this.getString("projUuid");
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        OpenStackAttachVolToVMProcessor preProcessor = null;
        String srcBootVolumeUuid = (String)this.po.getProps().get("VM_BOOTABLE_VOLUME");
        if (!(VerifyUtil.isEmpty((String)srcBootVolumeUuid) || VerifyUtil.isEmpty((String)this.bootDevName) || VerifyUtil.isEmpty((String)(drBootVolId = productVolIdToLinkedCloneVolId.get(srcBootVolumeUuid))))) {
            OpenStackAttachVolToVMProcessor subProcessor = new OpenStackAttachVolToVMProcessor(drBootVolId, cloneVolIdAndName.get(drBootVolId), OpenstackEnumDefine.VolProtectStatusE.PROTECTED.getStatus(), drVmUuid, drProjUuid, drRegionUuid);
            subProcessor.addString("deviceName", this.bootDevName);
            subProcessor.addString("vmType", (String)this.po.getProps().get("vm_type"));
            this.initProc((RecoveryProcessor)subProcessor);
            subProcessor.setPreviousProcessor(null);
            preProcessor = subProcessor;
            subProcessors.add((RecoveryProcessor)subProcessor);
            sortedDevNames.remove(this.bootDevName);
            productVolIdToLinkedCloneVolId.remove(srcBootVolumeUuid);
            LOG.info((Object)"Set boot vol(%s)'devname %s", new Object[]{drBootVolId, this.bootDevName});
        }
        LOG.info((Object)"Generate subProcessors");
        for (String devName : sortedDevNames) {
            String srcVolId = deviceNameToProductVolId.get(devName);
            String linkedCloneVolId = productVolIdToLinkedCloneVolId.get(srcVolId);
            if (linkedCloneVolId == null) continue;
            OpenStackAttachVolToVMProcessor subProcessor = new OpenStackAttachVolToVMProcessor(linkedCloneVolId, cloneVolIdAndName.get(linkedCloneVolId), OpenstackEnumDefine.VolProtectStatusE.PROTECTED.getStatus(), drVmUuid, drProjUuid, drRegionUuid);
            subProcessor.addString("deviceName", devName);
            subProcessor.addString("vmType", (String)this.po.getProps().get("vm_type"));
            this.initProc((RecoveryProcessor)subProcessor);
            if (preProcessor != null) {
                preProcessor.setNextProcessor((RecoveryProcessor)subProcessor);
                subProcessor.setPreviousProcessor((RecoveryProcessor)preProcessor);
            }
            preProcessor = subProcessor;
            subProcessors.add((RecoveryProcessor)subProcessor);
        }
        return subProcessors;
    }

    private void updateSrcDevNameInfo(List<String> deviceNames, Map<String, String> deviceNameToProductVolId, Map<String, String> productVolIdToVolName) {
        for (ProtectObjectStorageInfo storInfo : this.po.getUsedStorageResourceSet()) {
            LOG.info((Object)"Prepare attach dev(%s): %s", new Object[]{storInfo.getResourceName(), storInfo.getDeviceName()});
            String devName = this.getDeviceName(storInfo);
            if (VerifyUtil.isEmpty((String)devName)) {
                if ("BMS".equals(this.po.getProps().get("vm_type"))) {
                    devName = "NA:" + storInfo.getResourceId();
                    LOG.info((Object)"Po type is BMS, set devname=%s", new Object[]{devName});
                } else {
                    LOG.error((Object)"Dev(%s) has not devicename", new Object[]{storInfo.getResourceId()});
                    throw new LegoCheckedException(1073947393L);
                }
            }
            if (!VerifyUtil.isEmpty((String)deviceNameToProductVolId.get(devName)) && deviceNameToProductVolId.get(devName).equals(storInfo.getResourceId())) {
                LOG.error((Object)"The deviceName and volId is repeat:%s, volId:%s", new Object[]{devName, storInfo.getResourceId()});
                continue;
            }
            deviceNames.add(devName);
            deviceNameToProductVolId.put(devName, storInfo.getResourceId());
            productVolIdToVolName.put(storInfo.getResourceId(), storInfo.getResourceName());
        }
    }

    private String getDeviceName(ProtectObjectStorageInfo storInfo) {
        return "NA".equals(storInfo.getDeviceName()) ? "NA:" + storInfo.getResourceId() : storInfo.getDeviceName();
    }

    private List<String> getSortedDeviceNames(List<String> deviceNames) {
        ArrayList<String> sortedDevNames = new ArrayList<String>();
        ArrayList<String> sortedDevNames1 = new ArrayList<String>();
        ArrayList<String> sortedDevNames2 = new ArrayList<String>();
        ArrayList<String> sortedDevNames3 = new ArrayList<String>();
        String reg1 = "/dev/\\w{3}";
        String reg2 = "/dev/\\w{4}";
        for (String devName : deviceNames) {
            if (Pattern.matches(reg1, Normalizer.normalize(devName, Normalizer.Form.NFKC))) {
                LOG.info((Object)"Dev add to sortedDevNames1:%s", new Object[]{devName});
                sortedDevNames1.add(devName);
                continue;
            }
            if (Pattern.matches(reg2, Normalizer.normalize(devName, Normalizer.Form.NFKC))) {
                LOG.info((Object)"Dev add to sortedDevNames2:%s", new Object[]{devName});
                sortedDevNames2.add(devName);
                continue;
            }
            LOG.info((Object)"Dev add to sortedDevNames3:%s", new Object[]{devName});
            sortedDevNames3.add(devName);
        }
        Collections.sort(sortedDevNames1);
        Collections.sort(sortedDevNames2);
        Collections.sort(sortedDevNames3);
        sortedDevNames.addAll(sortedDevNames1);
        sortedDevNames.addAll(sortedDevNames2);
        sortedDevNames.addAll(sortedDevNames3);
        return sortedDevNames;
    }

    private Map<String, String> calDrVolIdToLinkedCloneVolId(Map<String, String> cloneVolIdAndName) {
        LOG.debug((Object)"Enter calDrVolIdToLinkedCloneVolId");
        HashMap<String, String> drVolIdToLinkedCloneVolId = new HashMap<String, String>();
        List createProcessors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue()), CreateLinkedCloneVolumeProcessor.class);
        if (VerifyUtil.isEmpty((Collection)createProcessors)) {
            return drVolIdToLinkedCloneVolId;
        }
        for (RecoveryProcessor processor : createProcessors) {
            CreateLinkedCloneVolumeProcessor process = (CreateLinkedCloneVolumeProcessor)processor;
            drVolIdToLinkedCloneVolId.put(process.getString("volUuid"), process.getString("linkedCloneVolId"));
            cloneVolIdAndName.put(process.getString("linkedCloneVolId"), process.getString("linkedCloneVolName"));
        }
        return drVolIdToLinkedCloneVolId;
    }

    private Map<String, String> calProductVolToLinkedCloneVol(Map<String, String> drVolIdToLinkedCloneVolId) {
        LOG.debug((Object)"Enter calProductVolToLinkedCloneVol");
        HashMap<String, String> productVolIdToLinkedCloneVolId = new HashMap<String, String>();
        String replicaInfoStr = (String)this.po.getProps().get("replicationInfo");
        PoReplicaInfo replicaInfo = JsonUtil.jsonToBean(replicaInfoStr, PoReplicaInfo.class);
        if (null == replicaInfo) {
            return productVolIdToLinkedCloneVolId;
        }
        List pairInfos = replicaInfo.getPairInfos();
        for (PoReplicaPairInfo repPair : pairInfos) {
            productVolIdToLinkedCloneVolId.put(repPair.getVolumeUuid(), drVolIdToLinkedCloneVolId.get(repPair.getDrVolumeUuid()));
        }
        return productVolIdToLinkedCloneVolId;
    }

    private void initProc(RecoveryProcessor proc) {
        LOG.debug((Object)"Enter initProc");
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    protected String generateResultKey() {
        LOG.debug((Object)"Enter generateResultKey");
        return ((Object)((Object)this)).getClass().getName();
    }
}

