/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.NovaManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.processor.AttachVolTask;
import com.huawei.ism.drm.openstack.recovery.processor.AttachVolTaskQueue;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeAttachmentInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class OpenStackAttachVolToVMProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 3863861299455306336L;
    private static final Log LOG = LogFactory.getInstance(OpenStackAttachVolToVMProcessor.class);

    public OpenStackAttachVolToVMProcessor() {
    }

    public OpenStackAttachVolToVMProcessor(String volumeUuid, String volName, String volStatus, String vmUuid, String projUuid, String regionUuid) {
        this.addString("volUuid", volumeUuid);
        this.addString("volName", volName);
        this.addString("volStatus", volStatus);
        this.addString("vmUuid", vmUuid);
        this.addString("regionUuid", regionUuid);
        this.addString("projUuid", projUuid);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        LOG.info((Object)"Enter into AttachVolumeToVMProcessor");
        String volumeUuid = this.getString("volUuid");
        String deviceName = this.getString("deviceName");
        String volName = this.getString("volName");
        String volStatus = this.getString("volStatus");
        String projUuid = this.getString("projUuid");
        String regionUuid = this.getString("regionUuid");
        String vmUuid = this.getString("vmUuid");
        String vmType = this.getString("vmType");
        String attachPoint = deviceName;
        LOG.info((Object)"Attach volume to vm: %s, type: %s", new Object[]{vmUuid, vmType});
        if ("BMS".equals(vmType)) {
            OpenStackVM drVm = OpenStackCommonUtil.getServerByUuid(projUuid, regionUuid, vmUuid);
            attachPoint = null == drVm ? "" : drVm.getName();
            LOG.info((Object)"Attach volume to bms: %s", new Object[]{attachPoint});
        }
        this.updateProcessNameParams(new String[]{volName, VerifyUtil.isEmpty((String)attachPoint) ? "UNKNOWN" : attachPoint});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        if (this.checkVolStatus(volStatus)) {
            return true;
        }
        NovaManager novaMgr = new NovaManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        OpenStackVM vm = novaMgr.getVm(regionUuid, tokenId, projUuid, vmUuid, new int[0]);
        if (null == vm) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948375", null);
            LOG.error((Object)"Placeholder vm(%s) doesn't exits.", new Object[]{vmUuid});
            return false;
        }
        IVolumeService volService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        VolumeInfo volumeInfo = volService.queryVolumeInfoByUuid(regionUuid, projUuid, volumeUuid);
        if (this.checkVolumeInfo(volumeUuid, volumeInfo)) {
            return false;
        }
        String serverId = OpenStackCommonUtil.getIdFromUuid(vmUuid);
        if (this.checkVolumeNeedAttach(volumeUuid, vm, volumeInfo, serverId)) {
            return true;
        }
        return this.reTryTask(context, projUuid, regionUuid, vmUuid, vmType, volumeUuid, deviceName);
    }

    private boolean checkVolStatus(String volStatus) {
        if (OpenstackEnumDefine.VolProtectStatusE.REMOVED.getStatus().equals(volStatus) || OpenstackEnumDefine.VolProtectStatusE.RELEASING.getStatus().equals(volStatus)) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("openstackattachvoltovmprocessor.vol.status.removed", null);
            LOG.error((Object)"Vol status is error and it is %s", new Object[]{volStatus});
            return true;
        }
        if (OpenstackEnumDefine.VolProtectStatusE.UNPROTECTED.getStatus().equals(volStatus) || OpenstackEnumDefine.VolProtectStatusE.CONFIGING.getStatus().equals(volStatus)) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("openstackattachvoltovmprocessor.vol.status.unportected", null);
            LOG.error((Object)"Vol status is error and it is %s", new Object[]{volStatus});
            return true;
        }
        return false;
    }

    private boolean checkVolumeInfo(String volumeUuid, VolumeInfo volumeInfo) {
        if (VerifyUtil.isEmpty((Object)volumeInfo)) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.2117645", null);
            LOG.error((Object)"The volume(%s)is not exist", new Object[]{volumeUuid});
            return true;
        }
        return false;
    }

    private boolean checkVolumeNeedAttach(String volumeUuid, OpenStackVM vm, VolumeInfo volumeInfo, String serverId) {
        for (VolumeAttachmentInfo attachmentInfo : volumeInfo.getAttachments()) {
            if (!attachmentInfo.getServerId().equals(serverId) || !OpenstackEnumDefine.VolumeStatusE.INUSE.getType().equals(volumeInfo.getStatus())) continue;
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            LOG.info((Object)"vol(%s) is areadly attached to vm(%s)", new Object[]{volumeUuid, vm.getName()});
            return true;
        }
        return false;
    }

    private boolean reTryTask(RecoveryProcessorContext context, String projUuid, String regionUuid, String vmUuid, String vmType, String volumeUuid, String deviceName) {
        AttachVolTaskQueue attachVolTaskQueue = (AttachVolTaskQueue)context.getAttribute("AttachVolTaskQueue");
        AttachVolTask task = new AttachVolTask(projUuid, regionUuid, vmUuid, vmType, OpenStackCommonUtil.getIdFromUuid(volumeUuid), deviceName);
        if (null == attachVolTaskQueue || !attachVolTaskQueue.push(task)) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.3145729", null);
            LOG.error((Object)"Add task to AttachVolTaskQueue failed.");
            return true;
        }
        for (int reTryTimes = 30; reTryTimes > 0; --reTryTimes) {
            if (0 == task.getStatus()) {
                CommUtil.pauseThread((long)20000L);
                continue;
            }
            if (1 == task.getStatus()) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                LOG.info((Object)"Attach volume to vm(%s) success.reTryTimes=%s", new Object[]{vmUuid, reTryTimes});
                return true;
            }
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err." + task.getErrorCode(), task.getErrorParam());
            LOG.error((Object)"Attach volume to vm(%s) failed.reTryTimes=%s", new Object[]{vmUuid, reTryTimes});
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        this.updateProcessDetail("com.huawei.ism.drm.openstack.recovery.processor.OpenStackAttachVolToVMProcessor.timout", null);
        return true;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getName() {
        String volStatus = this.getString("volStatus");
        if (!OpenstackEnumDefine.VolProtectStatusE.PROTECTED.getStatus().equals(volStatus)) {
            return ((Object)((Object)this)).getClass().getName() + ".error";
        }
        return ((Object)((Object)this)).getClass().getName();
    }
}

