/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.DrExtendManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDcCinderStatusCheckProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDcDrExtendStatusCheckProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDcNeutronStatusCheckProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDcNovaStatusCheckProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDcStatusCheck;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.serviceinstance.checker.VmChecker;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OpenStackBeginProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 4201315307435990544L;
    private static final Log LOG = LogFactory.getInstance(OpenStackBeginProcessor.class);
    private List<Integer> procList = Arrays.asList(DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue(), DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue(), DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue());
    private List<Integer> replicaTemplateList = Arrays.asList(21, 22, 34, 37);

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            LOG.error((Object)"Failed to execute openStack beginProcessor, because recoveryPlan is null or do not have protectGroup");
            throw new LegoCheckedException(1073947393L);
        }
        LOG.debug((Object)"Enter into OpenStackBeginProcessor, recoveryPlan name=%s", new Object[]{recoveryPlan.getName()});
        Site remoteSite = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(RecoveryServiceUtil.getProductSiteId((RecoveryPlan)recoveryPlan));
        context.setAttribute("productionSite", (Object)remoteSite);
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        ProtectGroup pg = context.getProtectGroup();
        if ((DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION.getValue() == this.getProcType()) && PolicyTemplateTools.getInstance().isHyperMetroTemplate(pg)) {
            OpenStackRecoveryTool.operateReplicationFlagOfPg(pg, true);
        }
        if (this.checkVmAllInProtectGroup(context, recoveryPlan)) {
            return false;
        }
        if (this.checkBmsStatus(context, recoveryPlan, pg)) {
            return false;
        }
        if (!this.checkNormalReplicaAndSwitchRing(pg)) {
            return false;
        }
        this.checkNeedSwitchWhenReprotect(context, pg);
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() == this.getProcType()) {
            context.removeAttribute("needChangeHyperMaster");
        }
        if (this.isNeedCheckOpenStack(pg)) {
            this.generateSubProcessors();
            ArrayList subProcessorList = new ArrayList(this.getChildProc());
            RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(subProcessorList, (boolean)false);
            recoveryTemplate.process(context);
            DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
            this.setProcStatus(procStatus.getValue());
            return DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == procStatus.getValue();
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        LOG.info((Object)"Leave OpenStackBeginProcessor, recoveryPlan name=%s", new Object[]{recoveryPlan.getName()});
        return true;
    }

    private boolean isNeedCheckOpenStack(ProtectGroup pg) {
        return DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType() && (pg.getTemplate().getType() == 25 || pg.getTemplate().getType() == 34 || pg.getTemplate().getType() == 37);
    }

    private boolean checkVmAllInProtectGroup(RecoveryProcessorContext context, RecoveryPlan recoveryPlan) {
        List<String> sharedVolumeNotInPgVmList;
        if (!(DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() != this.getProcType() && DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() != this.getProcType() || VerifyUtil.isEmpty(sharedVolumeNotInPgVmList = this.checkSharedVolums(context)))) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948135", new String[]{sharedVolumeNotInPgVmList.toString()});
            LOG.info((Object)"Leave OpenStackDcNovaStatusCheckProcessor:check failed. sharedVolumeNotInPgVmList:%s, recoveryPlan name=%s", new Object[]{sharedVolumeNotInPgVmList.toString(), recoveryPlan.getName()});
            return true;
        }
        return false;
    }

    private void checkNeedSwitchWhenReprotect(RecoveryProcessorContext context, ProtectGroup pg) {
        if (VerifyUtil.isEmpty((Object)context.getAttribute("needChangeHyperMaster")) && PolicyTemplateTools.getInstance().isCshaCsdrBetweenRegionRecovery(pg) && !OpenStackCommonUtil.isCsdrCshaMode(pg) && DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType()) {
            String replicaCgUuid;
            String projectUuid;
            String regionUuid = (String)pg.getProps().get("regionId");
            boolean isActive = OpenStackRecoveryTool.checkReplicationStatus(regionUuid, projectUuid = (String)pg.getProps().get("projectId"), replicaCgUuid = (String)pg.getProps().get("replicaCgUuid"));
            context.setAttribute("needChangeHyperMaster", (Object)(!isActive ? 1 : 0));
        }
    }

    private boolean checkBmsStatus(RecoveryProcessorContext context, RecoveryPlan recoveryPlan, ProtectGroup pg) {
        if (this.procList.contains(this.getProcType()) && this.replicaTemplateList.contains(pg.getTemplate().getType()) && !PolicyTemplateTools.getInstance().isHyperMetroTemplate(pg)) {
            HashSet<String> notActiveVmSet = new HashSet<String>();
            HashSet<String> notActiveDrVmSet = new HashSet<String>();
            this.obtainNotActivedVmSet(context, pg, notActiveVmSet, notActiveDrVmSet);
            if (!VerifyUtil.isEmpty(notActiveVmSet)) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                this.updateProcessDetail("lego.err.1073948805", new String[]{((Object)notActiveVmSet).toString()});
                LOG.info((Object)"Check bms vm status failed. there are not actived vm:%s, recoveryPlan name=%s", new Object[]{((Object)notActiveVmSet).toString(), recoveryPlan.getName()});
                return true;
            }
            if (!VerifyUtil.isEmpty(notActiveDrVmSet)) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                this.updateProcessDetail("lego.err.1073948920", new String[]{((Object)notActiveDrVmSet).toString()});
                LOG.info((Object)"Check bms vm status failed. there are not actived vm:%s, recoveryPlan name=%s", new Object[]{((Object)notActiveDrVmSet).toString(), recoveryPlan.getName()});
                return true;
            }
        }
        return false;
    }

    private void obtainNotActivedVmSet(RecoveryProcessorContext context, ProtectGroup pg, Set<String> notActiveVmSet, Set<String> notActiveDrVmSet) {
        Set vmSets = pg.getPolist();
        for (ProtectObject po : vmSets) {
            OpenStackVM pdVm;
            String phVmUuid = OpenStackRecoveryTool.getPoRecoverySetting(context.getRecoveryPlan(), po, "PLACEHOLDVM");
            String projectUuid = (String)po.getProtectGroup().getProps().get("projectId");
            String regionUuid = (String)po.getProtectGroup().getProps().get("regionId");
            String drProjectUuid = (String)po.getProtectGroup().getProps().get("drProjectId");
            String drRegionUuid = (String)po.getProtectGroup().getProps().get("drRegionId");
            if (VerifyUtil.isEmpty((String)((String)po.getProps().get("vm_type"))) || !"BMS".equals(po.getProps().get("vm_type"))) {
                LOG.info((Object)"Do not check VM  is active,because VM is ECS.ProtectGroupName=%s, VMname=%s,vmType=%s", new Object[]{pg.getName(), po.getName(), po.getProps().get("vm_type")});
                return;
            }
            OpenStackVM drVm = OpenStackCommonUtil.getServerByUuid(drProjectUuid, drRegionUuid, phVmUuid);
            if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() != this.getProcType() && (pdVm = OpenStackCommonUtil.getServerByUuid(projectUuid, regionUuid, po.getMoUuid())).getStatus().intValue() != OpenstackEnumDefine.VmStatusE.ACTIVE.getValue() && OpenStackCommonUtil.isBareMetalServer(pdVm)) {
                notActiveVmSet.add(pdVm.getName());
            }
            if (!OpenStackCommonUtil.isBareMetalServer(drVm) || drVm.getStatus().intValue() == OpenstackEnumDefine.VmStatusE.ACTIVE.getValue()) continue;
            notActiveDrVmSet.add(drVm.getName());
        }
    }

    private void generateSubProcessors() {
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            return;
        }
        HashSet<OpenStackDcStatusCheck> subProcessors = new HashSet<OpenStackDcStatusCheck>();
        OpenStackDcNovaStatusCheckProcessor novaCheckProcessor = new OpenStackDcNovaStatusCheckProcessor();
        this.initProc((RecoveryProcessor)novaCheckProcessor);
        subProcessors.add(novaCheckProcessor);
        OpenStackDcCinderStatusCheckProcessor cinderCheckProcessor = new OpenStackDcCinderStatusCheckProcessor();
        this.initProc((RecoveryProcessor)cinderCheckProcessor);
        subProcessors.add(cinderCheckProcessor);
        OpenStackDcNeutronStatusCheckProcessor neutronCheckProcessor = new OpenStackDcNeutronStatusCheckProcessor();
        this.initProc((RecoveryProcessor)neutronCheckProcessor);
        subProcessors.add(neutronCheckProcessor);
        OpenStackDcDrExtendStatusCheckProcessor drExtendCheckProcessor = new OpenStackDcDrExtendStatusCheckProcessor();
        this.initProc((RecoveryProcessor)drExtendCheckProcessor);
        subProcessors.add(drExtendCheckProcessor);
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private List<String> checkSharedVolums(RecoveryProcessorContext context) {
        ProtectGroup pg = context.getProtectGroup();
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        Set<String> notContainVmUuidSet = VmChecker.getAllSharedVolumeNotInPgVmUuids(regionUuid, projUuid, pg.getPolist(), pg.getPolist(), false, false, false);
        ArrayList<String> sharedVolumeNotInPgVmList = new ArrayList<String>();
        if (VerifyUtil.isEmpty(notContainVmUuidSet)) {
            LOG.info((Object)"Check sharedVolums and checkSharedVolums is empty, protectGroupName=%s", new Object[]{pg.getName()});
            return sharedVolumeNotInPgVmList;
        }
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        List<OpenStackVM> vmList = novaMgr.getVms(regionUuid, tokenId, projUuid);
        for (OpenStackVM vm : vmList) {
            if (!notContainVmUuidSet.contains(vm.getUuid())) continue;
            sharedVolumeNotInPgVmList.add(vm.getName());
        }
        return sharedVolumeNotInPgVmList;
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public void updateProcessName() {
        this.setProcName(this.calcProcessName());
    }

    private String calcProcessName() {
        String processName = DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() == this.getProcType() ? "ism.drm.clean.prepare.process.name" : (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == this.getProcType() ? "ism.drm.testing.prepare.process.name" : (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION.getValue() == this.getProcType() ? "ism.drm.planedmotion.prepare.process.name" : (DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType() ? "ism.drm.reprotect.prepare.process.name" : "ism.drm.recovery.prepare.process.name")));
        return processName;
    }

    public void updateDescription() {
        this.setDescription("ism.drm.recovery.prepare.process.des");
    }

    private boolean checkNormalReplicaAndSwitchRing(ProtectGroup pg) {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() != this.getProcType() || !PolicyTemplateTools.getInstance().isCshaCsdrBetweenRegionRecovery(pg) || OpenStackCommonUtil.isCsdrCshaMode(pg)) {
            return true;
        }
        String regionUuid = pg.getProperty("regionId");
        String projUuid = pg.getProperty("projectId");
        String replicationCgUuid = OpenStackRecoveryTool.getReplicaCgUuid(pg);
        String pgAZ = (String)pg.getProps().get("zoneName");
        String ringId = pg.getProperty("prodRingID");
        DrExtendManager mgr = new DrExtendManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        VolumeReplicationCgInfo repCGInfo = mgr.queryRealtimeVolumeReplicationCG(regionUuid, tokenId, projUuid, OpenStackCommonUtil.getIdFromUuid(replicationCgUuid), new int[0]);
        if (null == repCGInfo) {
            LOG.error((Object)"Cg not found, cg id:%s", new Object[]{replicationCgUuid});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        if (!pgAZ.equals(repCGInfo.getAzName())) {
            LOG.info((Object)"Need reverse ring. ringId is %s,current normal replicaCgId is %s. pgAz is %s, normal replication Az is %s", new Object[]{ringId, replicationCgUuid, pgAZ, repCGInfo.getAzName()});
            try {
                AsyncTaskResponse reverseResponse = mgr.reverseRing(regionUuid, tokenId, projUuid, ringId, replicationCgUuid);
                if (!reverseResponse.isSuccess()) {
                    LOG.error((Object)("Normal/Standby Reverse failed." + reverseResponse.getErrorCode()));
                    this.updateProcessDetail("lego.err." + reverseResponse.getErrorCode(), reverseResponse.getErrorParameter());
                    this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                    return false;
                }
                LOG.info((Object)"3DC ring normal/standby reverse successfully. normalReplicaCgUUID=%s", new Object[]{replicationCgUuid});
            }
            catch (LegoCheckedException e) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                return false;
            }
        }
        return true;
    }
}

