/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackClearPortSubProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDetachPortProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDetachPortSubProcessor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class OpenStackClearPortProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -6717845830095338632L;
    private static final Log LOG = LogFactory.getInstance(OpenStackDetachPortProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.generateSubProcessors();
        }
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            LOG.debug((Object)"No ports need to clear", 90160758786816L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        ArrayList list = new ArrayList(this.getChildProc());
        RecoveryProcessConcurrentExecutor executor = RecoveryProcessConcurrentExecutor.createExecutor(list);
        executor.process(context);
        return this.calcProcessResultBySubProc();
    }

    private void generateSubProcessors() {
        List createProcessors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue()), OpenStackDetachPortSubProcessor.class);
        if (VerifyUtil.isEmpty((Collection)createProcessors)) {
            return;
        }
        HashSet<OpenStackClearPortSubProcessor> subProcessors = new HashSet<OpenStackClearPortSubProcessor>();
        for (RecoveryProcessor openStackDetachPortSubProcessor : createProcessors) {
            OpenStackDetachPortSubProcessor processor = (OpenStackDetachPortSubProcessor)openStackDetachPortSubProcessor;
            String regionUuid = processor.getString("regionUuid");
            String projectUuid = processor.getString("projUuid");
            String vmUuid = processor.getString("vmUuid");
            String portIdsOfVM = processor.getString("portIdsOfVM");
            String vmName = processor.getString("vmName");
            OpenStackClearPortSubProcessor subProcessor = new OpenStackClearPortSubProcessor(regionUuid, projectUuid, portIdsOfVM, vmName, vmUuid);
            this.initProc((RecoveryProcessor)subProcessor);
            subProcessors.add(subProcessor);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    protected boolean calcProcessResultBySubProc() {
        LOG.debug((Object)"CalcProcessResultBySubProc start");
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() != procStatus.getValue() && DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() != procStatus.getValue();
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

