/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackConfigPhVmToNormalVmSubProcessor;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class OpenStackConfigPhVmToNormalVmProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 4000970521522919602L;
    private static final Log LOG = LogFactory.getInstance(OpenStackConfigPhVmToNormalVmProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        LOG.info((Object)"Enter into OpenStackSetPHVmToNormalVmProcessor recoveryPlan=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        this.generateSubProcessors(context);
        LOG.debug((Object)"OpenStackSetPHVmToNormalVmProcessor complete sub.recoveryPlan=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        ArrayList subProcessorList = new ArrayList(this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(subProcessorList, (boolean)false);
        recoveryTemplate.process(context);
        LOG.debug((Object)"Leave OpenStackSetPHVmToNormalVmProcessor, recoveryPlan=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        LOG.info((Object)"OpenStackSetPHVmToNormalVmProcessor,get status recoveryPlan=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        return DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == procStatus.getValue();
    }

    private void generateSubProcessors(RecoveryProcessorContext context) {
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            return;
        }
        ProtectGroup pg = context.getProtectGroup();
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        HashSet<OpenStackConfigPhVmToNormalVmSubProcessor> subProcessors = new HashSet<OpenStackConfigPhVmToNormalVmSubProcessor>();
        for (ProtectObject po : context.getProtectGroup().getPolist()) {
            String phVmUuid = OpenStackRecoveryTool.getPoRecoverySetting(context.getRecoveryPlan(), po, "PLACEHOLDVM");
            String phVmName = OpenStackRecoveryTool.getPoRecoverySetting(context.getRecoveryPlan(), po, "PLACEHOLDVMNAME");
            OpenStackConfigPhVmToNormalVmSubProcessor subProcessor = new OpenStackConfigPhVmToNormalVmSubProcessor(phVmUuid, VerifyUtil.isEmpty((String)phVmName) ? "Unknown" : phVmName, drRegionUuid, drProjUuid);
            this.initProc((RecoveryProcessor)subProcessor);
            subProcessors.add(subProcessor);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.openstack.recovery.processor.OpenStackConfigPhVmToNormalVmProcessor.des");
    }
}

