/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.NeutronManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.NovaManager;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.InterfaceSetBO;
import com.huawei.ism.drm.openstack.sdk.bo.RecoveryTestNetWorkConfigInfo;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackPort;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackPortFixedIp;
import com.huawei.ism.drm.openstack.sdk.msg.VMInterface;
import com.huawei.ism.drm.openstack.sdk.service.INetWorkService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OpenStackConfigVmTestNetWorkProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -1315928136888471177L;
    private static final long SLEEP_TIME = 5000L;
    private static final Log LOG = LogFactory.getInstance(OpenStackConfigVmTestNetWorkProcessor.class);

    public OpenStackConfigVmTestNetWorkProcessor() {
    }

    public OpenStackConfigVmTestNetWorkProcessor(String drProjUuid, String drRegionUuid, String vmUuid, String vmName, String testNetWorkConfig) {
        this.addString("regionUuid", drRegionUuid);
        this.addString("projUuid", drProjUuid);
        this.addString("vmUuid", vmUuid);
        this.addString("vmName", vmName);
        this.addString("testNetWorkConfig", testNetWorkConfig);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        LOG.info((Object)"Enter into OpenStackConfigVmTestNetWorkProcessor");
        String vmName = this.getString("vmName");
        this.updateProcessNameParams(new String[]{vmName});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
            return true;
        }
        boolean result = !OpenStackCommonUtil.isCurrentFCVersionHighThan63() ? this.setPortsDown() && this.createTestPort() && this.attachPortsToVm() : this.updatePortsStatus();
        if (result) {
            LOG.info((Object)"Leave OpenStackConfigVmTestNetWorkProcessor");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        LOG.info((Object)"Leave OpenStackConfigVmTestNetWorkProcessor");
        return false;
    }

    private boolean attachPortsToVm() {
        LOG.info((Object)"Start attachPortsToVm");
        String drProjUuid = this.getString("projUuid");
        String drRegionUuid = this.getString("regionUuid");
        String vmUuid = this.getString("vmUuid");
        String testPortIds = this.getString("testPortIds");
        NovaManager novaMgr = new NovaManager();
        NeutronManager neuMgr = new NeutronManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(drRegionUuid, drProjUuid);
        try {
            LOG.info((Object)"TestPortIds is:%s", new Object[]{testPortIds});
            List<String> testPortIdList = OpenStackCommonUtil.getListFromStr(testPortIds, ",");
            for (String portId : testPortIdList) {
                novaMgr.attachPortToVM(portId, vmUuid, drProjUuid, drRegionUuid, tokenId);
                neuMgr.updatePortAdminState(drRegionUuid, tokenId, drProjUuid, portId, true);
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            LOG.error((Object)"Add ports to vm failed", (Throwable)e);
            this.updateProcessDetail(e);
            return false;
        }
        return true;
    }

    private boolean createTestPort() {
        LOG.info((Object)"Start createTestPort");
        String drProjUuid = this.getString("projUuid");
        String drRegionUuid = this.getString("regionUuid");
        String testNetWorkConfig = this.getString("testNetWorkConfig");
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(drRegionUuid);
        HashSet<String> testPortIds = new HashSet<String>();
        INetWorkService netWorkService = (INetWorkService)ServiceLocator.getInstance().getService(INetWorkService.class);
        List<RecoveryTestNetWorkConfigInfo> configs = JsonUtil.jsonArrayToList(testNetWorkConfig, RecoveryTestNetWorkConfigInfo.class);
        boolean result = true;
        try {
            for (RecoveryTestNetWorkConfigInfo config : configs) {
                OpenStackPort port = new OpenStackPort();
                port.setName(config.getPortName());
                port.setNetworkUuid(config.getNetworkId());
                if (!VerifyUtil.isEmpty((String)config.getIpAddress()) || !VerifyUtil.isEmpty((String)config.getSubnetId())) {
                    OpenStackPortFixedIp ipSetting = new OpenStackPortFixedIp();
                    ipSetting.setIp(config.getIpAddress());
                    ipSetting.setSubnetUuid(config.getSubnetId());
                    port.getFixedIps().add(ipSetting);
                }
                OpenStackPort testPort = netWorkService.createPort(openstackUuid, drRegionUuid, drProjUuid, port);
                testPortIds.add(OpenStackCommonUtil.getIdFromUuid(testPort.getUuid()));
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail(e.getErrorMessageKey(), null);
            LOG.error((Object)"Create port failed:", (Throwable)e);
            result = false;
        }
        if (!VerifyUtil.isEmpty(testPortIds)) {
            this.addString("testPortIds", OpenStackCommonUtil.getStringFromCollection(testPortIds, ","));
            CommUtil.pauseThread((long)5000L);
        }
        return result;
    }

    private boolean setPortsDown() {
        LOG.info((Object)"Start setPortsDown");
        String drProjUuid = this.getString("projUuid");
        String drRegionUuid = this.getString("regionUuid");
        String vmUuid = this.getString("vmUuid");
        NovaManager novaMgr = new NovaManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(drRegionUuid, drProjUuid);
        List<VMInterface> interfaces = novaMgr.getVmInterfaces(drRegionUuid, tokenId, drProjUuid, vmUuid);
        if (interfaces == null) {
            LOG.info((Object)"Get interfaces on vm(%s) is empty.", new Object[]{vmUuid});
            return true;
        }
        boolean result = true;
        NeutronManager neuMgr = new NeutronManager();
        HashSet<String> oldPortIds = new HashSet<String>();
        String portId = "";
        try {
            for (VMInterface vmInterface : interfaces) {
                portId = vmInterface.getPortId();
                LOG.info((Object)"Start set adminstate down, portId is:%s", new Object[]{portId});
                neuMgr.updatePortAdminState(drRegionUuid, tokenId, drProjUuid, OpenStackCommonUtil.getIdFromUuid(portId), false);
                oldPortIds.add(vmInterface.getPortId());
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail(e.getErrorMessageKey(), null);
            LOG.error((Object)("Down port(" + portId + ") from vm(" + vmUuid + ") failed."), (Throwable)e);
            result = false;
        }
        if (!VerifyUtil.isEmpty(oldPortIds)) {
            this.addString("oldPortIds", OpenStackCommonUtil.getStringFromCollection(oldPortIds, ","));
        }
        LOG.info((Object)"OldNetWorkUuids is:%s", new Object[]{oldPortIds});
        return result;
    }

    private boolean updatePortsStatus() {
        String testNetWorkConfig = this.getString("testNetWorkConfig");
        List<InterfaceSetBO> configs = VerifyUtil.isEmpty((String)testNetWorkConfig) ? null : JsonUtil.jsonArrayToList(testNetWorkConfig, InterfaceSetBO.class);
        LOG.info((Object)"Start updatePortsStatus");
        String drProjUuid = this.getString("projUuid");
        String drRegionUuid = this.getString("regionUuid");
        String vmUuid = this.getString("vmUuid");
        NovaManager novaMgr = new NovaManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(drRegionUuid, drProjUuid);
        List<VMInterface> interfaces = novaMgr.getVmInterfaces(drRegionUuid, tokenId, drProjUuid, vmUuid);
        if (interfaces == null) {
            LOG.info((Object)"Get interfaces on vm(%s) is empty.", new Object[]{vmUuid});
            return true;
        }
        HashSet<String> nowPortIds = new HashSet<String>();
        HashSet<String> onlyTestPortIds = new HashSet<String>();
        HashSet<String> recoveryPortIds = new HashSet<String>();
        for (VMInterface vmInterface : interfaces) {
            nowPortIds.add(OpenStackCommonUtil.getIdFromUuid(vmInterface.getPortId()));
        }
        boolean result = true;
        NeutronManager neuMgr = new NeutronManager();
        String portId = "";
        try {
            if (VerifyUtil.isEmpty(configs)) {
                for (String nowPortId : nowPortIds) {
                    neuMgr.updatePortAdminState(drRegionUuid, tokenId, drProjUuid, nowPortId, true);
                    recoveryPortIds.add(nowPortId);
                }
            } else {
                for (InterfaceSetBO interfaceSet : configs) {
                    portId = interfaceSet.getPortId();
                    if (!nowPortIds.contains(interfaceSet.getPortId())) {
                        LOG.error((Object)"Update port is not belong the vm , portId:%s, vmId:%s", new Object[]{portId, vmUuid});
                        return false;
                    }
                    LOG.info((Object)"Start set adminstate up or down, portId is:%s", new Object[]{portId});
                    this.handleNetworkConfiguration(onlyTestPortIds, recoveryPortIds, portId, interfaceSet);
                }
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail(e.getErrorMessageKey(), null);
            LOG.error((Object)("Update port(" + portId + ") from vm(" + vmUuid + ") failed."), (Throwable)e);
            result = false;
        }
        this.toCleanProcess(onlyTestPortIds, recoveryPortIds);
        return result;
    }

    private void handleNetworkConfiguration(Set<String> onlyTestPortIds, Set<String> recoveryPortIds, String portId, InterfaceSetBO interfaceSet) {
        String drProjUuid = this.getString("projUuid");
        String drRegionUuid = this.getString("regionUuid");
        String tokenId = TokenUtil.getInstance().getRegionTokenId(drRegionUuid, drProjUuid);
        NeutronManager neuMgr = new NeutronManager();
        neuMgr.updatePortAdminState(drRegionUuid, tokenId, drProjUuid, portId, "true".equals(interfaceSet.getTestInterface()));
        if ("true".equals(interfaceSet.getRecoveryInterface())) {
            recoveryPortIds.add(portId);
        } else {
            onlyTestPortIds.add(portId);
        }
    }

    private void toCleanProcess(Set<String> onlyTestPortIds, Set<String> recoveryPortIds) {
        if (!VerifyUtil.isEmpty(recoveryPortIds)) {
            this.addString("oldPortIds", OpenStackCommonUtil.getStringFromCollection(recoveryPortIds, ","));
        }
        if (!VerifyUtil.isEmpty(onlyTestPortIds)) {
            this.addString("testPortIds", OpenStackCommonUtil.getStringFromCollection(onlyTestPortIds, ","));
        }
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

