/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackConfigPhVmToNormalVmSubProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackConfigVmToPhVmSubProcessor;
import com.huawei.ism.drm.openstack.sdk.bo.PhVmInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OpenStackConfigVmToPhVmProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 1516164717173535307L;
    private static final Log LOG = LogFactory.getInstance(OpenStackConfigVmToPhVmProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        LOG.info((Object)"Enter into OpenStackReSetVmToPhVmProcessor,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() == this.getProcType()) {
            this.generateCleanDrillingSubProcessors();
        } else if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType()) {
            this.generatePlanMotionAndReprotectSubProcessors(context);
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            LOG.info((Object)"No child processors.,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
            return true;
        }
        ArrayList subProcessorList = new ArrayList(this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(subProcessorList, (boolean)false);
        recoveryTemplate.process(context);
        LOG.info((Object)"Leave OpenStackReSetVmToPhVmProcessor,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == procStatus.getValue();
    }

    private void generatePlanMotionAndReprotectSubProcessors(RecoveryProcessorContext context) {
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            return;
        }
        ProtectGroup pg = context.getProtectGroup();
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        boolean csdrCshaReProtect = DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType() && PolicyTemplateTools.getInstance().isCshaCsdrBetweenRegionRecovery(pg) && !OpenStackCommonUtil.isCsdrCshaMode(pg);
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        for (ProtectObject po : pg.getPolist()) {
            OpenStackConfigVmToPhVmSubProcessor subProcessor = new OpenStackConfigVmToPhVmSubProcessor(po.getMoUuid(), po.getName(), regionUuid, projUuid);
            this.initProc((RecoveryProcessor)subProcessor);
            subProcessors.add((RecoveryProcessor)subProcessor);
            if (!csdrCshaReProtect) continue;
            this.generateConfigCshaPhVmSubProcessor(regionUuid, projUuid, subProcessors, po);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void generateConfigCshaPhVmSubProcessor(String regionUuid, String projUuid, Set<RecoveryProcessor> subProcessors, ProtectObject po) {
        String replicationInfo = po.getProperty("hypermetor_replicationInfo");
        PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class);
        if (null == poReplicaInfo) {
            LOG.error((Object)"Json to bean error:replicaInfoStr=%s", new Object[]{replicationInfo});
            return;
        }
        PhVmInfo phVm = poReplicaInfo.getPhVmInfo();
        if (null == phVm || VerifyUtil.isEmpty((String)phVm.getVmUuid())) {
            LOG.error((Object)"PhvmUuid is empty:replicaInfoStr=%s", new Object[]{replicationInfo});
            return;
        }
        String vmUuid = phVm.getVmUuid();
        String vmName = phVm.getName();
        OpenStackConfigVmToPhVmSubProcessor subProcessorForCshaPhVm = new OpenStackConfigVmToPhVmSubProcessor(vmUuid, vmName, regionUuid, projUuid);
        this.initProc((RecoveryProcessor)subProcessorForCshaPhVm);
        subProcessors.add((RecoveryProcessor)subProcessorForCshaPhVm);
    }

    private void generateCleanDrillingSubProcessors() {
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            return;
        }
        List createProcessors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue()), OpenStackConfigPhVmToNormalVmSubProcessor.class);
        if (VerifyUtil.isEmpty((Collection)createProcessors)) {
            return;
        }
        HashSet<OpenStackConfigVmToPhVmSubProcessor> subProcessors = new HashSet<OpenStackConfigVmToPhVmSubProcessor>();
        for (RecoveryProcessor processor : createProcessors) {
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() != processor.getProcStatus()) continue;
            OpenStackConfigPhVmToNormalVmSubProcessor configPhVmToNormalVmSubProcessor = (OpenStackConfigPhVmToNormalVmSubProcessor)processor;
            OpenStackConfigVmToPhVmSubProcessor subProcessor = new OpenStackConfigVmToPhVmSubProcessor(configPhVmToNormalVmSubProcessor.getString("vmUuid"), configPhVmToNormalVmSubProcessor.getString("vmName"), configPhVmToNormalVmSubProcessor.getString("regionUuid"), configPhVmToNormalVmSubProcessor.getString("projUuid"));
            this.initProc((RecoveryProcessor)subProcessor);
            subProcessors.add(subProcessor);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    public void updateProcessName() {
        String processName = ((Object)((Object)this)).getClass().getName();
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType()) {
            processName = "com.huawei.ism.drm.openstack.recovery.processor.OpenStackReSetPhVm";
        }
        this.setProcName(processName);
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    public void updateDescription() {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() == this.getProcType()) {
            this.setDescription("com.huawei.ism.drm.openstack.recovery.processor.OpenStackConfigVmToPhVmProcessor.des");
        }
    }
}

