/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCgCreateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCgInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCgUpdateInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OpenStackCreateVolCgProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -2871017380190213926L;
    private static final Log LOG = LogFactory.getInstance(OpenStackCreateVolCgProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        LOG.info((Object)"Enter into OpenStackCreateVolCgProcessor");
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        ProtectGroup pg = context.getProtectGroup();
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        this.addString("regionUuid", drRegionUuid);
        this.addString("projUuid", drProjUuid);
        CinderManager cinderMgr = new CinderManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(drRegionUuid, drProjUuid);
        try {
            LOG.info((Object)"Start to create volCg");
            AsyncTaskResponse response = this.createVolCg(drRegionUuid, drProjUuid, cinderMgr, tokenId);
            if (!response.isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                LOG.error((Object)("Create volCg failed." + response.getErrorCode()));
                this.updateProcessDetail("lego.err." + response.getErrorCode(), null);
                return false;
            }
            LOG.info((Object)"Start to add vol to volCg");
            Set<String> drVolUuidSet = this.getDrVolUuidSet(context);
            VolumeCgUpdateInfo volCgUpdateInfo = this.getVolumeCgUpdateInfo(drVolUuidSet);
            response = cinderMgr.updateVolumeConsistenceGroup(volCgUpdateInfo, drRegionUuid, tokenId, drProjUuid, this.getString("volCgUuid"));
            if (!response.isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                LOG.error((Object)("Update volCg failed." + response.getErrorCode()));
                this.updateProcessDetail("lego.err." + response.getErrorCode(), null);
                return false;
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            LOG.error((Object)("Create volCg or update volCg failed." + (Object)((Object)e)));
            this.updateProcessDetail(e);
            return false;
        }
        catch (Exception e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            LOG.error((Object)("Create volCg or update volCg failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
            this.updateProcessDetail("lego.err.1073948913", null);
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        LOG.info((Object)"Out OpenStackCreateVolCgProcessor");
        return true;
    }

    private VolumeCgUpdateInfo getVolumeCgUpdateInfo(Set<String> drVolUuidSet) {
        String drVolUuids = OpenStackCommonUtil.getStringFromCollection(drVolUuidSet, ",");
        LOG.info((Object)"DrVolUuids is:%s", new Object[]{drVolUuids});
        VolumeCgUpdateInfo volCgUpdateInfo = new VolumeCgUpdateInfo();
        volCgUpdateInfo.setAddVolUuids(drVolUuids);
        this.addString("volUuid", drVolUuids);
        return volCgUpdateInfo;
    }

    private Set<String> getDrVolUuidSet(RecoveryProcessorContext context) {
        Map<String, String> productVoldToDrVolId = OpenStackRecoveryTool.getProductVolIdToDrVolId(context.getRecoveryPlan());
        HashSet<String> drVolUuidSet = new HashSet<String>();
        for (Map.Entry<String, String> entry : productVoldToDrVolId.entrySet()) {
            String drVolUuid = entry.getValue();
            if (VerifyUtil.isEmpty((String)drVolUuid)) {
                LOG.warn((Object)"Vol has no drvol:%s", new Object[]{entry.getKey()});
                continue;
            }
            drVolUuidSet.add(OpenStackCommonUtil.getIdFromUuid(drVolUuid));
        }
        return drVolUuidSet;
    }

    private AsyncTaskResponse createVolCg(String drRegionUuid, String drProjUuid, CinderManager cinderMgr, String tokenId) {
        VolumeCgCreateInfo volCgCreateInfo = new VolumeCgCreateInfo();
        HashSet<String> volumeTypes = new HashSet<String>();
        for (ProtectObject po : this.getContextRef().getProtectGroup().getPolist()) {
            PoReplicaInfo replicaInfo = JsonUtil.jsonToBean((String)po.getProps().get("replicationInfo"), PoReplicaInfo.class);
            if (replicaInfo == null) continue;
            for (PoReplicaPairInfo pairInfo : replicaInfo.getPairInfos()) {
                volumeTypes.add(pairInfo.getDrVolumeType());
            }
        }
        volCgCreateInfo.setVolumeTypes(OpenStackCommonUtil.getStringFromCollection(volumeTypes, ","));
        AsyncTaskResponse response = cinderMgr.createVolumeConsistenceGroup(volCgCreateInfo, drRegionUuid, tokenId, drProjUuid);
        if (response.getTaskResult() != null && response.getTaskResult() instanceof VolumeCgInfo) {
            VolumeCgInfo volcg = (VolumeCgInfo)response.getTaskResult();
            this.addString("volCgUuid", volcg.getId());
        }
        return response;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

