/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackCreateVolCgSnapshotProcessor;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCgSnapShotInfo;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.List;

public class OpenStackDelVolCgSnapShotProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -8499070800369388069L;
    private static final Log LOG = LogFactory.getInstance(OpenStackDelVolCgSnapShotProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        LOG.info((Object)"Enter into OpenStackDelVolRepCgSnapShotProcessor");
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        List createProcessors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue()), OpenStackCreateVolCgSnapshotProcessor.class);
        if (VerifyUtil.isEmpty((Collection)createProcessors)) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        OpenStackCreateVolCgSnapshotProcessor createVolCgSnapShotProcessor = (OpenStackCreateVolCgSnapshotProcessor)((Object)CommonUtil.getFirstElement((Collection)createProcessors));
        String volCgSnapShotUuid = createVolCgSnapShotProcessor.getString("volCgSnapShotId");
        String drRegionUuid = createVolCgSnapShotProcessor.getString("regionUuid");
        String drProjUuid = createVolCgSnapShotProcessor.getString("projUuid");
        if (VerifyUtil.isEmpty((String)volCgSnapShotUuid)) {
            LOG.info((Object)"VolCgSnapShotUuid is null.no need to delete cg snapshot.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        try {
            CinderManager cinderMgr = new CinderManager();
            String tokenId = TokenUtil.getInstance().getRegionTokenId(drRegionUuid, drProjUuid);
            VolumeCgSnapShotInfo volCgSnapShot = cinderMgr.queryVolCgSnapShot(drRegionUuid, tokenId, drProjUuid, volCgSnapShotUuid);
            if (null == volCgSnapShot) {
                LOG.info((Object)"VolCgSnapShot(%s) doesn't exit.", new Object[]{volCgSnapShotUuid});
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                return true;
            }
            AsyncTaskResponse response = cinderMgr.deleteVolCgSnapShot(volCgSnapShotUuid, drRegionUuid, tokenId, drProjUuid);
            if (!response.isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                this.updateProcessDetail("lego.err." + response.getErrorCode(), null);
                return false;
            }
        }
        catch (LegoCheckedException e) {
            this.updateProcessDetail(e);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            LOG.info((Object)"Del volRepCgSnapshot(%s)failed.", new Object[]{volCgSnapShotUuid, e});
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        LOG.info((Object)"Leave OpenStackDelVolRepCgSnapShotProcessor");
        return true;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

