/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INeutronManager;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDetachPortSubProcessor;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackPort;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackRegion;
import com.huawei.ism.drm.openstack.sdk.msg.VMInterface;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class OpenStackDetachPortProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -6717845830095338632L;
    private static final Log LOG = LogFactory.getInstance(OpenStackDetachPortProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        LOG.debug((Object)"Enter into OpenStackDetachPortProcessor,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        if (!this.isSwitchNetWork(context)) {
            LOG.info((Object)String.format(Locale.ROOT, "Region config:isSwitchNetwork is false,recoveryPlan name=%s", OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)), 90160758786816L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.generateSubProcessors(context);
        }
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            LOG.debug((Object)String.format(Locale.ROOT, "No ports need to detach,recoveryPlan name=%s", OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)), 90160758786816L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        ArrayList list = new ArrayList(this.getChildProc());
        RecoveryProcessConcurrentExecutor executor = RecoveryProcessConcurrentExecutor.createExecutor(list);
        executor.process(context);
        return this.calcProcessResultBySubProc();
    }

    private boolean isSwitchNetWork(RecoveryProcessorContext context) {
        List<Integer> protype = Arrays.asList(DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue(), DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue(), DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue());
        ProtectGroup pg = context.getProtectGroup();
        String regionUuid = (String)pg.getProps().get("regionId");
        if (PolicyTemplateTools.getInstance().isHyperMetroTemplate(pg) && protype.contains(this.getProcType())) {
            List regions = CommonDAOLocator.getMoDao().getMoList(OpenStackRegion.class, "uuid", (Object)regionUuid);
            if (VerifyUtil.isEmpty((Collection)regions)) {
                LOG.error((Object)"Openstack region is not exist.");
                return true;
            }
            return ((OpenStackRegion)CommonUtil.getFirstElement((Collection)regions)).getRegionConfig().getIsSwitchNetwork();
        }
        return true;
    }

    private void generateSubProcessors(RecoveryProcessorContext context) {
        ProtectGroup pg = context.getProtectGroup();
        String regionUuid = (String)pg.getProps().get("regionId");
        String projectUuid = (String)pg.getProps().get("projectId");
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        INeutronManager neutronManager = ManagerFactory.getInstance().getNeutronManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
        List<OpenStackPort> portList = neutronManager.getPorts(openstackUuid, regionUuid, tokenId, projectUuid);
        HashSet<OpenStackDetachPortSubProcessor> subProcSet = new HashSet<OpenStackDetachPortSubProcessor>();
        for (ProtectObject po : pg.getPolist()) {
            if (OpenStackRecoveryTool.isMigration(context.getRecoveryPlan(), po.getMoUuid())) {
                LOG.info((Object)"Po:%s is migration,no need do this processor.", new Object[]{po.getName()});
                continue;
            }
            String srcVmUuid = po.getMoUuid();
            List<VMInterface> srcVmPortList = novaMgr.getVmInterfaces(regionUuid, tokenId, projectUuid, srcVmUuid);
            if (VerifyUtil.isEmpty(srcVmPortList)) {
                LOG.error((Object)"The vm has no port,vmName=%s", new Object[]{po.getName()});
                continue;
            }
            String portIdStr = OpenStackRecoveryTool.getSortedPortIdStr(srcVmPortList, portList);
            if (VerifyUtil.isEmpty((String)portIdStr)) {
                LOG.error((Object)"The vm has no valid portId,vmName=%s", new Object[]{po.getName()});
                continue;
            }
            String vmName = po.getName();
            String vmUuid = po.getMoUuid();
            OpenStackDetachPortSubProcessor subProc = new OpenStackDetachPortSubProcessor(regionUuid, projectUuid, portIdStr, vmName, vmUuid);
            this.initProc((RecoveryProcessor)subProc);
            subProcSet.add(subProc);
        }
        this.setChildProc(subProcSet);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    protected boolean calcProcessResultBySubProc() {
        LOG.debug((Object)"CalcProcessResultBySubProc start");
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() != procStatus.getValue() && DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() != procStatus.getValue();
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

