/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.NovaManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeAttachmentInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.util.SyncLockManager;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;

public class OpenStackDetachVolOnVmProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -6957370396347134253L;
    private static final Log LOG = LogFactory.getInstance(OpenStackDetachVolOnVmProcessor.class);
    private static final String VOL_LOCK_NAME = "_vol_detach_lock";

    public OpenStackDetachVolOnVmProcessor() {
    }

    public OpenStackDetachVolOnVmProcessor(String vmUuid, String volUuid, String regionUuid, String projUuid, String vmName, String vmType, String volName) {
        this.addString("vmUuid", vmUuid);
        this.addString("volUuid", volUuid);
        this.addString("regionUuid", regionUuid);
        this.addString("projUuid", projUuid);
        this.addString("vmName", vmName);
        this.addString("vmType", vmType);
        this.addString("volName", volName);
    }

    public void updateProcNameParams() {
        String volName = this.getString("volName");
        this.updateProcessNameParams(new String[]{volName});
    }

    protected boolean execute(RecoveryProcessorContext context) {
        LOG.info((Object)"Enter into OpenStackDetachVolOnVmProcessor");
        String vmUuid = this.getString("vmUuid");
        String volUuid = this.getString("volUuid");
        String regionUuid = this.getString("regionUuid");
        String projUuid = this.getString("projUuid");
        String volName = this.getString("volName");
        String vmType = this.getString("vmType");
        this.updateProcessNameParams(new String[]{volName});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
            return true;
        }
        try {
            IVolumeService volService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
            VolumeInfo volumeInfo = volService.queryVolumeInfoByUuid(regionUuid, projUuid, volUuid);
            if (null == volumeInfo) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                this.updateProcessDetail("lego.err.2117645", null);
                LOG.error((Object)"The volume(%s)is not exist", new Object[]{volUuid});
                return false;
            }
            if (this.volIsDetached(volumeInfo, vmUuid, volUuid)) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                LOG.info((Object)"The volume(%s) has detached", new Object[]{volUuid});
                return true;
            }
            if (this.uninstallVol(vmUuid, volUuid, regionUuid, projUuid, vmType)) {
                return true;
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail(e);
            LOG.error((Object)("Detach volume(" + volUuid + ") failed from vm(" + vmUuid + ")"), (Throwable)e);
            return true;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        LOG.info((Object)"Leave OpenStackDetachVolOnVmProcessor");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uninstallVol(String vmUuid, String volUuid, String regionUuid, String projUuid, String vmType) {
        String lockName;
        block3: {
            boolean bl;
            NovaManager novaMgr = new NovaManager();
            String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
            lockName = volUuid + VOL_LOCK_NAME;
            while (!SyncLockManager.tryLock((String)lockName)) {
                LOG.debug((Object)"OpenStackDetachVolOnVmProcessor get volUuid lock,lock is in use,wait 5s: %s, volId:%s", new Object[]{String.valueOf(Thread.currentThread().getId()), volUuid});
                CommonUtil.sleep((long)5000L);
            }
            LOG.debug((Object)"OpenStackDetachVolOnVmProcessor get volUuid lock:%s,volId:%s", new Object[]{String.valueOf(Thread.currentThread().getId()), volUuid});
            try {
                AsyncTaskResponse response = novaMgr.detachVolFromVm(tokenId, projUuid, regionUuid, vmUuid, vmType, OpenStackCommonUtil.getIdFromUuid(volUuid));
                if (response.isSuccess()) break block3;
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                this.updateProcessDetail("lego.err." + response.getErrorCode(), null);
                LOG.error((Object)"Detach volume(%s) failed from vm(%s), errorcode is:%s", new Object[]{volUuid, vmUuid, response.getErrorCode()});
                bl = true;
            }
            catch (Throwable throwable) {
                LOG.debug((Object)"OpenStackDetachVolOnVmProcessor relase volUuid lock:%s,volId:%s", new Object[]{String.valueOf(Thread.currentThread().getId()), volUuid});
                SyncLockManager.unLock((String)lockName);
                throw throwable;
            }
            LOG.debug((Object)"OpenStackDetachVolOnVmProcessor relase volUuid lock:%s,volId:%s", new Object[]{String.valueOf(Thread.currentThread().getId()), volUuid});
            SyncLockManager.unLock((String)lockName);
            return bl;
        }
        LOG.debug((Object)"OpenStackDetachVolOnVmProcessor relase volUuid lock:%s,volId:%s", new Object[]{String.valueOf(Thread.currentThread().getId()), volUuid});
        SyncLockManager.unLock((String)lockName);
        return false;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private boolean volIsDetached(VolumeInfo volumeInfo, String vmUuid, String volUuid) {
        if (OpenstackEnumDefine.VolumeStatusE.AVAILABLE.getType().equals(volumeInfo.getStatus())) {
            return true;
        }
        if (null == volumeInfo.getAttachments()) {
            return true;
        }
        String serverId = OpenStackCommonUtil.getIdFromUuid(vmUuid);
        if (null == serverId) {
            LOG.error((Object)"Get id from uuid get null value, vmuuid=%s", new Object[]{vmUuid});
            throw new LegoCheckedException(1073947393L);
        }
        for (VolumeAttachmentInfo attach : volumeInfo.getAttachments()) {
            if (!serverId.equals(attach.getServerId())) continue;
            LOG.debug((Object)"Volume(%s) is still in vm(%s).", new Object[]{volUuid, serverId});
            return false;
        }
        return true;
    }
}

