/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackHotMigrationVmProcessor;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashSet;

public class OpenStackHotMigrationProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -729290830188252874L;
    private static final Log LOG = LogFactory.getInstance(OpenStackHotMigrationProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        LOG.info((Object)"Enter into OpenStackHotMigrationProcessor,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        this.generateSubProcessors(context);
        ArrayList subProcessorList = new ArrayList(this.getChildProc());
        RecoveryProcessConcurrentExecutor excuter = RecoveryProcessConcurrentExecutor.createExecutor(subProcessorList, (boolean)false);
        excuter.process(context);
        LOG.info((Object)"Leave OpenStackHotMigrationProcessor,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        return this.calcProcessResultBySubProc();
    }

    protected boolean calcProcessResultBySubProc() {
        boolean executeResult = super.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            executeResult = false;
        }
        return executeResult;
    }

    private void generateSubProcessors(RecoveryProcessorContext context) {
        ProtectGroup pg = context.getProtectGroup();
        boolean isCshaCsdrWithinRegionRecovery = PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg);
        HashSet<OpenStackHotMigrationVmProcessor> subProcessors = new HashSet<OpenStackHotMigrationVmProcessor>();
        String regionUuid = pg.getProperty("regionId");
        String projectUuid = pg.getProperty("projectId");
        String azUuid = isCshaCsdrWithinRegionRecovery ? pg.getProperty("prod_region_drZoneName") : pg.getProperty("drZoneName");
        for (ProtectObject po : pg.getPolist()) {
            String replicaInfoStr;
            String vmUuid = po.getMoUuid();
            String vmName = po.getName();
            String string = replicaInfoStr = isCshaCsdrWithinRegionRecovery ? po.getProperty("hypermetor_replicationInfo") : (String)po.getProps().get("replicationInfo");
            if (VerifyUtil.isEmpty((String)replicaInfoStr)) {
                LOG.error((Object)"The vm has no replication info,vmName=%s", new Object[]{po.getName()});
                continue;
            }
            OpenStackHotMigrationVmProcessor subProcessor = new OpenStackHotMigrationVmProcessor(regionUuid, projectUuid, azUuid, vmUuid, vmName, replicaInfoStr);
            this.initProcessor((RecoveryProcessor)subProcessor);
            subProcessors.add(subProcessor);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }
}

