/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.IDrExtendManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.List;

public class OpenStackHyperMetroCgSplitProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -3302901062793527760L;
    private static final Log LOG = LogFactory.getInstance(OpenStackHyperMetroCgSplitProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        boolean result;
        String drReplicaCgUuid;
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        LOG.info((Object)"Enter into OpenStackHyperMetroCgSplitProcessor,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        ProtectGroup pg = context.getProtectGroup();
        boolean isCshaCsdrRegionWithinOperate = PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg);
        String drRegionUuid = isCshaCsdrRegionWithinOperate ? (String)pg.getProps().get("regionId") : (String)pg.getProps().get("drRegionId");
        String drProjUuid = isCshaCsdrRegionWithinOperate ? (String)pg.getProps().get("projectId") : (String)pg.getProps().get("drProjectId");
        String string = drReplicaCgUuid = isCshaCsdrRegionWithinOperate ? OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("hyperProdrCgUuid")) : OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("drReplicaCgUuid"));
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue()) {
            OpenStackRecoveryTool.updateReplicationCGRecoverStrategyForHyper(pg, drRegionUuid, drProjUuid, drReplicaCgUuid, OpenstackEnumDefine.RecoverStrategy.MANUAL);
        }
        if (result = this.volRepCgFaultSwitch(drRegionUuid, drProjUuid, drReplicaCgUuid)) {
            OpenStackRecoveryTool.operateReplicationFlagOfPg(context.getProtectGroup(), true);
            this.invalidProtectGroup(pg);
        }
        return result;
    }

    private void invalidProtectGroup(ProtectGroup pg) {
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        try {
            pgService.updateProtectGroupStatus(DrmEnumDefine.ProtectGroupStatus.INVALID, new String[]{pg.getUuid()});
        }
        catch (Exception e) {
            LOG.error((Object)"Setting protect policy invalid failed.ProtectGroup name=%s, %s", new Object[]{pg.getName(), ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    private boolean volRepCgFaultSwitch(String regionUuid, String projUuid, String replicaCgId) {
        IDrExtendManager drExtendMgr = ManagerFactory.getInstance().getDrExtendManager(OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid));
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        try {
            AsyncTaskResponse response = drExtendMgr.splitVolumeReplicationCG(regionUuid, tokenId, projUuid, replicaCgId);
            if (!response.isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                this.updateProcessDetail("lego.err.1073948904", null);
                LOG.info((Object)"Set volRepCg(%s) split failed: errorcode is %s", new Object[]{replicaCgId, response.getErrorCode()});
                return false;
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948904", null);
            LOG.error((Object)("VolRepCg(" + replicaCgId + ") fault switch failed."), (Throwable)e);
            return false;
        }
        return this.checkLocalAccess(regionUuid, projUuid, replicaCgId, drExtendMgr, tokenId);
    }

    private boolean checkLocalAccess(String regionUuid, String projUuid, String replicaCgId, IDrExtendManager drExtendMgr, String tokenId) {
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("replicationcg_id", replicaCgId);
        for (int i = 0; i < 7; ++i) {
            boolean isAccess = true;
            List<VolumeReplicationInfo> replicationInfos = drExtendMgr.getVolumeReplications(regionUuid, tokenId, projUuid, uriVariables, false);
            if (VerifyUtil.isEmpty(replicationInfos)) {
                LOG.error((Object)("VolRepCg(" + replicaCgId + ") is empty."));
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                this.updateProcessDetail("lego.err.1073948904", null);
                return false;
            }
            for (VolumeReplicationInfo replica : replicationInfos) {
                if (this.isLocalVolWrite(replica)) continue;
                LOG.error((Object)"Replica(%s) is not localaccess.ReplicationExtendedStatus is:%s", new Object[]{replica.getId(), replica.getReplicationExtendedStatus()});
                isAccess = false;
                break;
            }
            if (isAccess) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                return true;
            }
            CommUtil.pauseThread((long)10000L);
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        this.updateProcessDetail("lego.err.1073948904", null);
        return false;
    }

    private boolean isLocalVolWrite(VolumeReplicationInfo replicationInfo) {
        String jsonStr = replicationInfo.getReplicationExtendedStatus();
        JSONObject json = JSONObject.fromObject((Object)jsonStr);
        if (!json.containsKey((Object)"localaccessstatus")) {
            return false;
        }
        String accessStatus = json.getString("localaccessstatus");
        return "3".equals(accessStatus);
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.storage.recovery.process.SwapReplicationProcessor.des");
    }
}

