/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.recovery.framework.process.reprotect.RefactorProtectRelationProcessor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.reprotect.sdk.service.IReprotectService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;

public class OpenStackRefactorProtectRelationProcessor
extends RefactorProtectRelationProcessor {
    private static final long serialVersionUID = 6392314822415647384L;
    private static final String SUCCESS = "success";
    private static final String FAILED = "failed";
    private static final Log LOG = LogFactory.getInstance(OpenStackRefactorProtectRelationProcessor.class);

    public String getName() {
        return "com.huawei.ism.drm.recovery.framework.process.reprotect.RefactorProtectRelationProcessor";
    }

    public boolean execute(RecoveryProcessorContext context) {
        String lastResult;
        boolean result;
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        LOG.debug((Object)"Enter into OpenStackRefactorProtectRelationProcessor,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        int lastProcStatus = this.getProcStatus();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == lastProcStatus) {
            return true;
        }
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue() == lastProcStatus) {
            this.getProps().remove("isReverseProtectObject");
        }
        if (!(result = SUCCESS.equals(lastResult = this.getString("isReverseProtectObject")))) {
            result = super.execute(context);
            this.addString("isReverseProtectObject", result ? SUCCESS : FAILED);
        }
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(context.getProtectGroup().getUuid());
        if (result) {
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() != lastProcStatus && DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() != this.getProcType()) {
                OpenStackRecoveryTool.operateReplicationFlagOfPg(pg, false);
            }
            if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION.getValue() == this.getProcType()) {
                this.afterMigration(pg, context.getRecoveryPlan());
            }
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        }
        LOG.debug((Object)"Leave OpenStackRefactorProtectRelationProcessor,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        return result;
    }

    private boolean afterMigration(ProtectGroup pg, RecoveryPlan plan) {
        String pgId = pg.getUuid();
        ArrayList<String> pgIdList = new ArrayList<String>();
        pgIdList.add(pgId);
        boolean result = RecoveryProcessUtil.changeProtectGroupStatus((String[])pgIdList.toArray(new String[0]), (DrmEnumDefine.ProtectGroupStatus)DrmEnumDefine.ProtectGroupStatus.LOCKED);
        if (!result) {
            LOG.error((Object)"Change pg status failed:pgName=%s", new Object[]{pg.getName()});
            return false;
        }
        IReprotectService reprotectService = (IReprotectService)ServiceLocator.getInstance().getService(IReprotectService.class);
        reprotectService.sendReprotectSuccessMsg(plan);
        return true;
    }
}

