/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor.sfs;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.galax.sdk.model.HypermetroDomain;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ISfsFilemeterManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.UrlBaseParams;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class OpenStackSfsConfigNasProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 81777536125870562L;
    private static final Log LOG = LogFactory.getInstance(OpenStackSfsConfigNasProcessor.class);
    private static ISfsFilemeterManager sfsFilemeterManager = ManagerFactory.getInstance().getSfsFilemeterManager();

    protected boolean execute(RecoveryProcessorContext context) {
        LOG.info((Object)"Enter into OpenStackSfsConfigNasProcessor,recoveryPlan name=%s, procType=%s.", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(context.getRecoveryPlan()), this.getProcType()});
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType()) {
            ProtectGroup protectGroup = context.getProtectGroup();
            String projUuid = protectGroup.getProperty("projectId");
            String regionUuid = protectGroup.getProperty("regionId");
            String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
            String shareTypeName = OpenStackCommonUtil.getShareTypeNameFromProtectObject(context, "pd_share");
            UrlBaseParams urlBaseParams = new UrlBaseParams(projUuid, regionUuid, tokenId);
            this.splitHypermetroDomain(urlBaseParams, shareTypeName, DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType());
            String drprojUuid = protectGroup.getProperty("drProjectId");
            String drregionUuid = protectGroup.getProperty("drRegionId");
            String drTokenId = TokenUtil.getInstance().getTokenId(drprojUuid);
            UrlBaseParams drUrlBaseParams = new UrlBaseParams(drprojUuid, drregionUuid, drTokenId);
            String drShareTypeName = OpenStackCommonUtil.getShareTypeNameFromProtectObject(context, "dr_share");
            boolean splitResult = this.splitHypermetroDomain(drUrlBaseParams, drShareTypeName, true);
            boolean cancleResult = this.cancelSecondaryResourceProtection(urlBaseParams, shareTypeName) || this.cancelSecondaryResourceProtection(drUrlBaseParams, drShareTypeName);
            LOG.info((Object)"CancleResult:%s, splitResult:%s, shareTypeName(%s), drShareTypeName(%s).", new Object[]{cancleResult, splitResult, shareTypeName, drShareTypeName});
            if (splitResult && cancleResult) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                return true;
            }
            if (!splitResult) {
                this.updateProcessDetail("lego.err.1073949758", new String[]{drShareTypeName});
            }
            if (!cancleResult) {
                this.updateProcessDetail("lego.err.1073949757", new String[]{shareTypeName});
            }
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        return false;
    }

    private boolean splitHypermetroDomain(UrlBaseParams urlBaseParams, String shareTypeName, boolean isCheckResult) {
        boolean splitResult = false;
        try {
            sfsFilemeterManager.splitHypermetroDomain(urlBaseParams, shareTypeName);
            splitResult = true;
        }
        catch (Exception e) {
            LOG.error((Object)"SplitHypermetroDomain(%s) failed, error:%s.", new Object[]{shareTypeName, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType() && !splitResult) {
            LOG.error((Object)"SplitHypermetroDomain(%s) failed when planedMotion.", new Object[]{shareTypeName});
            throw new LegoCheckedException(1073949758L, new String[]{shareTypeName});
        }
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() == this.getProcType() && !splitResult) {
            LOG.error((Object)"SplitHypermetroDomain(%s) failed when disasterRecovery.", new Object[]{shareTypeName});
            return true;
        }
        if (!isCheckResult) {
            LOG.debug((Object)"No result check is required.");
            return true;
        }
        AsyncTaskResponse asyncTaskResponse = AsyncTaskResponse.queryTaskResponse(shareTypeName, response -> {
            HypermetroDomain hypermetroDomain = sfsFilemeterManager.queryHypermetroDomain(urlBaseParams, shareTypeName);
            if (VerifyUtil.isEmpty((Object)hypermetroDomain)) {
                LOG.error((Object)"The hypermetroDomain %s is not exist.", new Object[]{shareTypeName});
                return false;
            }
            if (OpenstackEnumDefine.HypermetroDomainStatus.SPLIT.getKey().equals(hypermetroDomain.getRunningStatus())) {
                response.setSuccess(true);
                return true;
            }
            LOG.error((Object)"Expected hypermetroDomain status of %s is %s, but actual status is %s.", new Object[]{shareTypeName, OpenstackEnumDefine.HypermetroDomainStatus.SPLIT.getValue(), hypermetroDomain.getRunningStatus()});
            return false;
        });
        if (!asyncTaskResponse.isSuccess()) {
            LOG.error((Object)"Split hypermetroDomain(%s) failed,%s.", new Object[]{shareTypeName, asyncTaskResponse.getErrorCode()});
            return false;
        }
        return true;
    }

    private boolean cancelSecondaryResourceProtection(UrlBaseParams urlBaseParams, String shareTypeName) {
        try {
            sfsFilemeterManager.cancelSecondaryResourceProtection(urlBaseParams, shareTypeName);
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)"CancelSecondaryResourceProtection(%s) failed.", new Object[]{shareTypeName});
            return false;
        }
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

