/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor.sfs;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.galax.sdk.model.HypermetroDomain;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ISfsFilemeterManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.UrlBaseParams;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class OpenStackSfsRecoveryHyperMetroDomainProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -2932601733262154652L;
    private static final Log LOG = LogFactory.getInstance(OpenStackSfsRecoveryHyperMetroDomainProcessor.class);
    private static ISfsFilemeterManager sfsFilemeterManager = ManagerFactory.getInstance().getSfsFilemeterManager();

    protected boolean execute(RecoveryProcessorContext context) {
        LOG.info((Object)"Enter into OpenStackSfsRecoveryHyperMetroDomainProcessor,recoveryPlan name=%s, procType=%s.", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(context.getRecoveryPlan()), this.getProcType()});
        ProtectGroup protectGroup = context.getProtectGroup();
        UrlBaseParams urlBaseParams = this.getDrUrlBaseParams(protectGroup);
        String shareTypeName = OpenStackCommonUtil.getShareTypeNameFromProtectObject(context, "dr_share");
        HypermetroDomain hypermetro = sfsFilemeterManager.queryHypermetroDomain(urlBaseParams, shareTypeName);
        if (OpenstackEnumDefine.HypermetroDomainRole.PRIMARY.getValue().equals(hypermetro.getConfigRole()) && OpenstackEnumDefine.HypermetroDomainStatus.NORMAL.getKey().equals(hypermetro.getRunningStatus())) {
            LOG.info((Object)"HypermetroDomain(%s) has already recovery.", new Object[]{shareTypeName});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        if (OpenstackEnumDefine.HypermetroDomainRole.SECONDARY.getValue().equals(hypermetro.getConfigRole()) && OpenstackEnumDefine.HypermetroDomainStatus.NORMAL.getKey().equals(hypermetro.getRunningStatus())) {
            LOG.error((Object)"The HypermetroDomain(%s) is still the standby end.", new Object[]{shareTypeName});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073949748", new String[]{hypermetro.getName(), OpenstackEnumDefine.HypermetroDomainStatus.getTypeFromValue((String)hypermetro.getRunningStatus()).getValue()});
            return false;
        }
        sfsFilemeterManager.addProtection(urlBaseParams, shareTypeName);
        sfsFilemeterManager.recoverHypermetroDomain(urlBaseParams, shareTypeName);
        AsyncTaskResponse asyncTaskResponse = AsyncTaskResponse.queryTaskResponse(shareTypeName, response -> {
            HypermetroDomain hypermetroDomain = sfsFilemeterManager.queryHypermetroDomain(urlBaseParams, shareTypeName);
            if (VerifyUtil.isEmpty((Object)hypermetroDomain)) {
                LOG.error((Object)"The hypermetroDomain %s is not exist.", new Object[]{shareTypeName});
                return false;
            }
            if (OpenstackEnumDefine.HypermetroDomainStatus.NORMAL.getKey().equals(hypermetroDomain.getRunningStatus())) {
                response.setSuccess(true);
                return true;
            }
            LOG.error((Object)"Expected hypermetroDomain status of %s is %s, but actual status is %s.", new Object[]{shareTypeName, OpenstackEnumDefine.HypermetroDomainStatus.NORMAL.getKey(), hypermetroDomain.getRunningStatus()});
            return false;
        });
        if (asyncTaskResponse.isSuccess()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        this.updateProcessDetail("lego.err.1073949756", new String[]{shareTypeName});
        return false;
    }

    private UrlBaseParams getDrUrlBaseParams(ProtectGroup protectGroup) {
        String drProjUuid = protectGroup.getProperty("drProjectId");
        String drRegionUuid = protectGroup.getProperty("drRegionId");
        String drTokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
        return new UrlBaseParams(drProjUuid, drRegionUuid, drTokenId);
    }

    public void updateProcessName() {
        this.setProcName(this.calcProcessName());
    }

    private String calcProcessName() {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType()) {
            return "com.huawei.ism.drm.openstack.recovery.processor.sfs.OpenStackSfsRecoveryHyperMetroDomainProcessor.planedMotion";
        }
        return this.getName();
    }
}

