/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor.sfs;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ISfsFilemeterManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.processor.sfs.OpenStackSfsStatusCheckProcessor;
import com.huawei.ism.drm.openstack.sdk.bo.FileSystem;
import com.huawei.ism.drm.openstack.sdk.bo.SharePair;
import com.huawei.ism.drm.openstack.sdk.bo.UrlBaseParams;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class OpenStackSfsShairPairStatusCheckProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 3677247111140261105L;
    private static final Log LOG = LogFactory.getInstance(OpenStackSfsStatusCheckProcessor.class);
    private static ISfsFilemeterManager sfsFilemeterManager = ManagerFactory.getInstance().getSfsFilemeterManager();
    private static final long QUERY_PAIR_RETRY_TIMES = 3L;
    private ProtectObject protectObject;
    private String pgPprojectIdKey;
    private String pgRegionIdKey;
    private String shareName;

    public OpenStackSfsShairPairStatusCheckProcessor() {
        LOG.debug((Object)"OpenStackSfsShairPairStatusCheckProcessor defautl constructor");
    }

    public OpenStackSfsShairPairStatusCheckProcessor(ProtectObject protectObject, String pgPprojectIdKey, String pgRegionIdKey, String shareName) {
        this.protectObject = protectObject;
        this.pgPprojectIdKey = pgPprojectIdKey;
        this.pgRegionIdKey = pgRegionIdKey;
        this.shareName = shareName;
    }

    public void updateProcNameParams() {
        this.updateProcessNameParams(new String[]{this.shareName});
    }

    protected boolean execute(RecoveryProcessorContext context) {
        String tokenId;
        String regionUuid;
        ProtectGroup protectGroup = this.protectObject.getProtectGroup();
        SharePair sharePair = JsonUtil.jsonToBean(this.protectObject.getProperty("share_pair"), SharePair.class);
        String sharePairId = sharePair.getSharePairId();
        String projUuid = protectGroup.getProperty(this.pgPprojectIdKey);
        UrlBaseParams urlBaseParams = new UrlBaseParams(projUuid, regionUuid = protectGroup.getProperty(this.pgRegionIdKey), tokenId = TokenUtil.getInstance().getTokenId(projUuid));
        AsyncTaskResponse querySharePairResponse = AsyncTaskResponse.queryTaskResponseTimeout(sharePair, response -> {
            SharePair sharePairInStorage = sfsFilemeterManager.querySharePairById(urlBaseParams, sharePairId);
            if (VerifyUtil.isEmpty((Object)sharePairInStorage) || OpenstackEnumDefine.SharePairRunningStatus.UNKNOWN.getValue().equals(sharePairInStorage.getRunningStatus())) {
                response.setSuccess(false);
                LOG.error((Object)"Query sharepair(%s) failed, retry.", new Object[]{sharePairId});
                return false;
            }
            response.setTaskResult(sharePairInStorage);
            response.setSuccess(true);
            return true;
        }, 3L);
        if (!querySharePairResponse.isSuccess()) {
            LOG.error((Object)"Shair pair of protectGroup(%s) is not exist.", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073947488L, new String[]{sharePairId});
        }
        Object sharePairInStorageObject = querySharePairResponse.getTaskResult();
        SharePair sharePairInStorage = sharePair;
        if (!VerifyUtil.isEmpty((Object)sharePairInStorageObject) && sharePairInStorageObject instanceof SharePair) {
            sharePairInStorage = (SharePair)sharePairInStorageObject;
        }
        this.checkSharePairDataState(sharePairInStorage, urlBaseParams);
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    private void checkSharePairDataState(SharePair sharePair, UrlBaseParams urlBaseParams) {
        FileSystem fileSystem = sfsFilemeterManager.getPdFileSystemByShareId(urlBaseParams, sharePair.getLocalShareId());
        if (VerifyUtil.isEmpty((Object)fileSystem)) {
            throw new LegoCheckedException(1073949754L, new String[]{sharePair.getLocalShareId()});
        }
        if (!OpenstackEnumDefine.SharePairDataState.COMPLETE.getValue().equals(sharePair.getLocalDataState())) {
            LOG.error((Object)"Shair pair(%s) local data state error.", new Object[]{sharePair.getSharePairId()});
            throw new LegoCheckedException(1073949753L, new String[]{fileSystem.getFsName()});
        }
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() != this.getProcType()) {
            LOG.debug((Object)"Remote data status does not need to be verified in unplanned migration scenarios.");
            return;
        }
        if (!OpenstackEnumDefine.SharePairDataState.COMPLETE.getValue().equals(sharePair.getRemoteDataState())) {
            LOG.error((Object)"Shair pair(%s) reomte data state error.", new Object[]{sharePair.getSharePairId()});
            throw new LegoCheckedException(1073949753L, new String[]{fileSystem.getFsName()});
        }
    }
}

