/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.utils;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INeutronManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.DrExtendManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackPort;
import com.huawei.ism.drm.openstack.sdk.msg.VMInterface;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.serviceinstance.checker.VmChecker;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OpenStackRecoveryTool {
    private static final Log LOG = LogFactory.getInstance(OpenStackRecoveryTool.class);

    public static String getPoRecoverySetting(RecoveryPlan plan, ProtectObject po, String key) {
        return plan.getPoRecoverySetting(po, key, "");
    }

    public static Map<String, String> getProductVolIdToDrVolId(RecoveryPlan recoveryPlan) {
        return OpenStackRecoveryTool.getProductVolIdToDrVolId(recoveryPlan, false);
    }

    public static Map<String, String> getProductVolIdToDrVolId(RecoveryPlan recoveryPlan, boolean cshaDrVol) {
        VerifyUtil.checkObjs((Object[])new Object[]{recoveryPlan, recoveryPlan.getProtectGroup()});
        ProtectGroup pg = recoveryPlan.getProtectGroup();
        LOG.info((Object)"Pg : %s, is get csha DrVol: %s", new Object[]{pg.getName(), cshaDrVol});
        HashMap<String, String> productVoldToDrVolId = new HashMap<String, String>();
        for (ProtectObject po : pg.getPolist()) {
            PoReplicaInfo replicaInfo;
            if (OpenStackRecoveryTool.isMigration(recoveryPlan, po.getMoUuid())) {
                LOG.info((Object)"Po:%s is migration,no need do this processor.", new Object[]{po.getName()});
                continue;
            }
            LOG.info((Object)"Po is:%s", new Object[]{po.getName()});
            String replicationInfo = (String)po.getProps().get("replicationInfo");
            if (cshaDrVol && 37 == pg.getTemplate().getType()) {
                replicationInfo = po.getProperty("hypermetor_replicationInfo");
            }
            if ((replicaInfo = JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class)) == null) continue;
            for (PoReplicaPairInfo pairInfo : replicaInfo.getPairInfos()) {
                if (!OpenstackEnumDefine.VolProtectStatusE.PROTECTED.getStatus().equals(pairInfo.getVolumeStatus())) continue;
                productVoldToDrVolId.put(pairInfo.getVolumeUuid(), pairInfo.getDrVolumeUuid());
            }
        }
        LOG.info((Object)"DrVolUuid is:%s", new Object[]{productVoldToDrVolId.values()});
        return productVoldToDrVolId;
    }

    public static ProtectObject getProtectObjectFromRecoveryPlan(RecoveryPlan plan, String poUuid) {
        if (null == plan || VerifyUtil.isEmpty((String)poUuid)) {
            return null;
        }
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)plan.getProtectGroups());
        if (null == pg) {
            return null;
        }
        for (ProtectObject po : pg.getPolist()) {
            if (!poUuid.equals(po.getUuid())) continue;
            return po;
        }
        return null;
    }

    public static void operateReplicationFlagOfPg(ProtectGroup pg, boolean hasSplit) {
        if (VerifyUtil.isEmpty((Object)pg)) {
            LOG.error((Object)"The protectGroup is empty");
            return;
        }
        LOG.info((Object)"Enter set replication flag :pgName=%s,hasSplit=:%s", new Object[]{pg.getName(), hasSplit});
        try {
            ProtectGroup tempPg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(pg.getUuid());
            tempPg.getProps().put("PG_PROP_REPLICATION_SPLIT_KEY", Boolean.toString(hasSplit));
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)tempPg);
        }
        catch (Exception e) {
            LOG.error((Object)("Update pg properties failed:pgname=" + pg.getName() + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    public static String getReplicaCgUuid(ProtectGroup pg) {
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        String replicatrionUuid = (String)pg.getProps().get("replicaCgUuid");
        if (!(34 != pg.getTemplate().getType() && 37 != pg.getTemplate().getType() || OpenStackRecoveryTool.checkReplicationStatus(regionUuid, projUuid, replicatrionUuid))) {
            replicatrionUuid = (String)pg.getProps().get("hyperProRemoteCgUuid");
        }
        return replicatrionUuid;
    }

    public static String getDrReplicaCgUuid(ProtectGroup pg) {
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        String drReplicaCgUuid = (String)pg.getProps().get("drReplicaCgUuid");
        if (!(34 != pg.getTemplate().getType() && 37 != pg.getTemplate().getType() || OpenStackRecoveryTool.checkReplicationStatus(drRegionUuid, drProjUuid, drReplicaCgUuid))) {
            drReplicaCgUuid = (String)pg.getProps().get("hyperProRemotedrCgUuid");
        }
        return drReplicaCgUuid;
    }

    public static String getHyperProCgUuid(ProtectGroup pg) {
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        String replicatrionUuid = (String)pg.getProps().get("replicaCgUuid");
        String hyperMetorCG = (String)pg.getProps().get("hyperProCgUuid");
        if (!(34 != pg.getTemplate().getType() && 37 != pg.getTemplate().getType() || OpenStackRecoveryTool.checkReplicationStatus(regionUuid, projUuid, replicatrionUuid))) {
            hyperMetorCG = (String)pg.getProps().get("hyperProdrCgUuid");
        }
        return hyperMetorCG;
    }

    public static String getSlaveHyperMetorCgUuid(ProtectGroup pg) {
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        String replicatrionUuid = (String)pg.getProps().get("hyperProRemoteCgUuid");
        String slaveHyperMetorCG = (String)pg.getProps().get("hyperProdrCgUuid");
        if (!(34 != pg.getTemplate().getType() && 37 != pg.getTemplate().getType() || OpenStackRecoveryTool.checkReplicationStatus(regionUuid, projUuid, replicatrionUuid))) {
            slaveHyperMetorCG = (String)pg.getProps().get("hyperProCgUuid");
        }
        return slaveHyperMetorCG;
    }

    public static String getReplicationInfo(ProtectGroup pg, ProtectObject po) {
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        String replicatrionUuid = (String)pg.getProps().get("replicaCgUuid");
        String replicaInfoStr = (String)po.getProps().get("replicationInfo");
        if (!(34 != pg.getTemplate().getType() && 37 != pg.getTemplate().getType() || OpenStackRecoveryTool.checkReplicationStatus(regionUuid, projUuid, replicatrionUuid))) {
            replicaInfoStr = (String)po.getProps().get("remote_replicationInfo");
        }
        return replicaInfoStr;
    }

    public static boolean checkReplicationStatus(String regionUuid, String projUuid, String replicatrionUuid) {
        boolean result = false;
        DrExtendManager mgr = new DrExtendManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        VolumeReplicationCgInfo repCGInfo = mgr.queryRealtimeVolumeReplicationCG(regionUuid, tokenId, projUuid, OpenStackCommonUtil.getIdFromUuid(replicatrionUuid), new int[0]);
        if (null == repCGInfo) {
            LOG.error((Object)("Cg not found, cg id: " + replicatrionUuid));
            return result;
        }
        String replicationStatus = repCGInfo.getReplicationStatus();
        if (OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue().equals(replicationStatus)) {
            return result;
        }
        result = true;
        return result;
    }

    public static void updateReplicationCGRecoverStrategyForHyper(ProtectGroup pg, String regionUuid, String projUuid, String replicaCgUuid, OpenstackEnumDefine.RecoverStrategy recoverStrategy) {
        if (VerifyUtil.isEmpty((Object)pg) || VerifyUtil.isEmpty((Object)pg.getTemplate())) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (!PolicyTemplateTools.getInstance().isHyperMetroTemplate(pg)) {
            LOG.debug((Object)"Not CSHA or CSHA+CSDR within region operate.");
            return;
        }
        OpenStackRecoveryTool.updateReplicationCGRecoverStrategy(regionUuid, projUuid, replicaCgUuid, recoverStrategy);
    }

    public static void updateReplicationCGRecoverStrategy(String regionUuid, String projUuid, String replicaCgUuid, OpenstackEnumDefine.RecoverStrategy recoverStrategy) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)replicaCgUuid) || VerifyUtil.isEmpty((Object)recoverStrategy) || VerifyUtil.isEmpty((String)projUuid)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (!VmChecker.supportSharedOrScsiVolume(regionUuid)) {
            LOG.debug((Object)"Not support SharedOrScsiVolume.");
            return;
        }
        DrExtendManager mgr = new DrExtendManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        AsyncTaskResponse response = mgr.updateReplicationCGRecoverStrategy(recoverStrategy, replicaCgUuid, regionUuid, tokenId, projUuid);
        if (!response.isSuccess()) {
            LOG.error((Object)"Update Replication CGRecoverStrategy ForHyper error.");
            throw new LegoCheckedException(1073949709L, new String[]{OpenStackCommonUtil.getIdFromUuid(replicaCgUuid)});
        }
    }

    public static String getPortName(ProtectGroup pg, String portId) {
        String regionUuid = (String)pg.getProps().get("regionId");
        String projectUuid = (String)pg.getProps().get("projectId");
        try {
            String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
            INeutronManager neutronMgr = ManagerFactory.getInstance().getNeutronManager(openstackUuid);
            String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
            OpenStackPort port = neutronMgr.getPort(regionUuid, tokenId, portId);
            if (null != port && !VerifyUtil.isEmpty((String)port.getName())) {
                return port.getName();
            }
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)("Query port failed, portId=" + portId), (Throwable)e);
        }
        return portId;
    }

    public static boolean isMigration(RecoveryPlan recoveryPlan, String vmUuid) {
        if (VerifyUtil.isEmpty((Object)recoveryPlan) || VerifyUtil.isEmpty((String)vmUuid)) {
            LOG.error((Object)"Parameter is empty, vmUuid=%s", new Object[]{vmUuid});
            throw new LegoCheckedException(1073947393L);
        }
        String hotMigrationVmsSetting = recoveryPlan.getProperty("HOT_MIGRATION_VMS");
        return OpenStackRecoveryTool.isMigration(hotMigrationVmsSetting, vmUuid);
    }

    public static boolean isMigration(String hotMigrationVmsSetting, String vmUuid) {
        if (VerifyUtil.isEmpty((String)hotMigrationVmsSetting)) {
            return false;
        }
        Set hotMigrationVms = (Set)JSONObject.toBean((String)hotMigrationVmsSetting, Set.class);
        if (VerifyUtil.isEmpty((Collection)hotMigrationVms)) {
            return false;
        }
        return hotMigrationVms.contains(vmUuid);
    }

    public static void setRecoveryRegionForCshaCsdrPg(ProtectGroup pg, String recoveryRegion, String recoveryRegionType, String recoveryAz) {
        if (VerifyUtil.isEmpty((Object)pg)) {
            LOG.error((Object)"The protectGroup is empty");
            return;
        }
        try {
            pg.setProperty("current_disaster_region", (Object)recoveryRegion);
            pg.setProperty("RECOVERY_REGION_TYPE", (Object)recoveryRegionType);
            pg.setProperty("recovery_az_id", (Object)recoveryAz);
        }
        catch (Exception e) {
            LOG.error((Object)("Update pg properties failed:pgname=" + pg.getName() + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public static String getSortedPortIdStr(List<VMInterface> portList, List<OpenStackPort> allPortList) {
        LinkedHashSet<String> portIdSet = new LinkedHashSet<String>();
        for (VMInterface port : portList) {
            if (VerifyUtil.isEmpty((String)port.getPortId()) || !OpenStackRecoveryTool.isPrimaryInterfacePort(allPortList, port.getPortId())) continue;
            portIdSet.add(port.getPortId());
        }
        for (VMInterface port : portList) {
            if (VerifyUtil.isEmpty((String)port.getPortId()) || portIdSet.contains(port.getPortId())) continue;
            portIdSet.add(port.getPortId());
        }
        return OpenStackCommonUtil.getStringFromCollection(portIdSet, ",");
    }

    public static boolean isPrimaryInterfacePort(List<OpenStackPort> allPortList, String portId) {
        if (VerifyUtil.isEmpty(allPortList)) {
            return false;
        }
        for (OpenStackPort port : allPortList) {
            if (!portId.equals(OpenStackCommonUtil.getIdFromUuid(port.getUuid()))) continue;
            return port.isPrimaryInterface();
        }
        return false;
    }
}

