/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.resource;

import com.google.common.base.Joiner;
import com.google.common.cache.Cache;
import com.huawei.ism.cbb.base.sdk.constant.DmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ICinderManager;
import com.huawei.ism.drm.openstack.adapter.manager.IDrExtendManager;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.DrExtendManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.cache.OpenstackCache;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackStoragePoolRemoteDevInfo;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackStorageResourcePool;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolAttachment;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolumeType;
import com.huawei.ism.drm.openstack.sdk.msg.CreateVhaCsdrRingInfo;
import com.huawei.ism.drm.openstack.sdk.msg.ImageMetadataInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VhaCsdrRingInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolReplicaCgCreateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolReplicaCgUpdateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeAttachmentInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCreateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicaSchedulerHintInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeSnapShotInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeTypeInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.task.ForkJoinPoolManager;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveTask;
import java.util.concurrent.TimeUnit;

@Service(name="com.huawei.ism.drm.openstack.sdk.service.IVolumeService", desc="", interfaceClass=IVolumeService.class)
public class VolumeServiceImpl
extends BaseService
implements IVolumeService {
    private static final Log LOG = LogFactory.getInstance(VolumeServiceImpl.class);
    private static final Set<String> REPLICATIONCG_STATUS_FOR_ADDORREMOVE_PAIR = new HashSet<String>();

    public List<OpenStackVolume> getVolumesByVm(String regionUuid, String projectUuid, boolean isAutoFresh, String ... vmUuids) {
        if (VerifyUtil.isEmpty((Object[])vmUuids)) {
            LOG.error((Object)"VM uuid is empty,", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        List<OpenStackVM> vms = this.getVms(regionUuid, projectUuid, isAutoFresh);
        HashSet vmUuidSet = new HashSet();
        Collections.addAll(vmUuidSet, vmUuids);
        ArrayList<String> uuidList = new ArrayList<String>();
        for (OpenStackVM vm : vms) {
            if (!vmUuidSet.contains(vm.getUuid())) continue;
            uuidList.addAll(OpenStackCommonUtil.getListFromStr(vm.getVolumeAttached(), ","));
        }
        return this.queryVolumesByUuid(regionUuid, projectUuid, uuidList, isAutoFresh);
    }

    public List<OpenStackVolume> queryVolumesByUuid(String regionUuid, String projectUuid, List<String> uuidList, boolean isAutoFresh) {
        if (VerifyUtil.isEmpty(uuidList)) {
            return new ArrayList<OpenStackVolume>();
        }
        List<Object> volumeList = new ArrayList();
        if (uuidList.size() > 30) {
            volumeList = this.getVolumesFromOpenstack(regionUuid, projectUuid);
            Iterator<Object> iterator = volumeList.iterator();
            while (iterator.hasNext()) {
                OpenStackVolume volume = (OpenStackVolume)iterator.next();
                if (uuidList.contains(volume.getUuid())) continue;
                iterator.remove();
            }
        } else {
            ForkJoinPool novaForkJoinPool = ForkJoinPoolManager.getInstance().createForkJoinPool(uuidList.size());
            OpenStackVolumeTask openStackVolumeTask = new OpenStackVolumeTask(regionUuid, projectUuid, uuidList, -1);
            ForkJoinTask<List<OpenStackVolume>> openStackVolumes = novaForkJoinPool.submit(openStackVolumeTask);
            try {
                volumeList.addAll((Collection<Object>)openStackVolumes.get(10L, TimeUnit.MINUTES));
            }
            catch (Exception e) {
                LOG.error((Object)"Query OpenStackVolume error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                throw new LegoCheckedException(1073949735L);
            }
            finally {
                novaForkJoinPool.shutdown();
            }
            if (!VerifyUtil.isEmpty(volumeList)) {
                this.transVolume(regionUuid, projectUuid, volumeList, isAutoFresh);
            }
        }
        return volumeList;
    }

    private void transVolume(String regionUuid, String projectUuid, List<OpenStackVolume> volumeList, boolean isAutoFresh) {
        List<OpenStackVM> vms = this.getVms(regionUuid, projectUuid, isAutoFresh);
        List<OpenStackVM> bmsVms = OpenStackCommonUtil.getBmsVms(vms);
        for (OpenStackVolume volume : volumeList) {
            Set<OpenStackVolAttachment> attachInfoList = this.generateAttachmentInfo(volume.getAttachmentStr());
            JSONArray attachmentArray = new JSONArray();
            for (OpenStackVolAttachment attachInfo : attachInfoList) {
                JSONObject attachmentObj = new JSONObject();
                String volVmUuid = attachInfo.getVmUuid();
                attachmentObj.put((Object)"vmUuid", (Object)volVmUuid);
                if (VerifyUtil.isEmpty((String)attachInfo.getDevice())) {
                    boolean isBmsVolume = OpenStackCommonUtil.isBmsServiceVolume(volVmUuid, bmsVms);
                    if (isBmsVolume) {
                        attachmentObj.put((Object)"device", (Object)"NA");
                    }
                } else {
                    attachmentObj.put((Object)"device", (Object)attachInfo.getDevice());
                }
                attachmentArray.add((Object)attachmentObj);
            }
            volume.setAttachmentStr(attachmentArray.toString());
        }
    }

    private List<OpenStackVM> getVms(String regionUuid, String projectUuid, boolean isAutoFresh) {
        List vms;
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(projectUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
        Cache<String, Object> cache = OpenstackCache.getCacheMap().get((Object)OpenstackCache.CacheType.OPENSTACK_VM_LIST);
        if (isAutoFresh) {
            try {
                vms = (List)cache.get((Object)(regionUuid + projectUuid), () -> {
                    List<OpenStackVM> vms0 = novaMgr.getVms(regionUuid, tokenId, projectUuid);
                    if (vms0 != null) {
                        cache.put((Object)(regionUuid + projectUuid), vms0);
                    }
                    return vms0;
                });
            }
            catch (ExecutionException e) {
                LOG.error((Object)"Failed to get vms to cache:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                throw new LegoCheckedException("Failed to get vms to cache");
            }
        } else {
            vms = novaMgr.getVms(regionUuid, tokenId, projectUuid);
        }
        return vms;
    }

    private Set<OpenStackVolAttachment> generateAttachmentInfo(String attachmentStr) {
        HashSet<OpenStackVolAttachment> attachments = new HashSet<OpenStackVolAttachment>();
        if (VerifyUtil.isEmpty((String)attachmentStr)) {
            return attachments;
        }
        JSONArray array = JSONArray.fromObject((Object)attachmentStr);
        for (int i = 0; i < array.size(); ++i) {
            JSONObject obj = array.getJSONObject(i);
            OpenStackVolAttachment attanchment = new OpenStackVolAttachment();
            if (obj.containsKey((Object)"vmUuid")) {
                attanchment.setVmUuid(obj.getString("vmUuid"));
            }
            if (obj.containsKey((Object)"device")) {
                attanchment.setDevice(obj.getString("device"));
            }
            attachments.add(attanchment);
        }
        return attachments;
    }

    public VolumeInfo queryVolumeInfoByUuid(String regionUuid, String projectUuid, String volumeUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projectUuid) || VerifyUtil.isEmpty((String)volumeUuid)) {
            LOG.error((Object)"Regionuuid or projuuid is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String volumeId = OpenStackCommonUtil.getIdFromUuid(volumeUuid);
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        ICinderManager cinderMgr = ManagerFactory.getInstance().getCinderManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
        return cinderMgr.queryVolume(regionUuid, tokenId, projectUuid, volumeId);
    }

    public List<OpenStackVolumeType> getVolumeTypes(String regionUuid, String projectUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projectUuid)) {
            LOG.error((Object)("RegionUuid or projectUuid is empty. regionUuid=" + regionUuid + " projectUuid=" + projectUuid));
            throw new LegoCheckedException(1073947393L);
        }
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        ICinderManager cinderManager = ManagerFactory.getInstance().getCinderManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
        return cinderManager.getVolumeTypes(regionUuid, tokenId, projectUuid);
    }

    public List<VolumeTypeInfo> queryVolumeTypes(String regionId, String projectId) {
        if (VerifyUtil.isEmpty((String)regionId) || VerifyUtil.isEmpty((String)projectId)) {
            LOG.error((Object)("RegionUuid or projectUuid is empty. regionId=" + regionId + " projectUuid=" + projectId));
            throw new LegoCheckedException(1073947393L);
        }
        FusionSphereOpenStack openStack = OpenStackCommonUtil.getOpenstack();
        String openstackUuid = openStack.getUuid();
        String regionUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, regionId);
        String projectUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, projectId);
        ICinderManager cinderManager = ManagerFactory.getInstance().getCinderManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
        return cinderManager.queryVolumeTypes(regionUuid, tokenId, projectUuid);
    }

    public List<OpenStackVolumeType> getVolumeTypesUsedByVMs(String regionUuid, String projectUuid, List<String> vmUuids) {
        if (VerifyUtil.isEmpty(vmUuids) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projectUuid)) {
            LOG.error((Object)"VmUuids is empty", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        List<OpenStackVolume> volList = this.getVolumesByVm(regionUuid, projectUuid, false, vmUuids.toArray(new String[0]));
        HashSet<String> volTypeNameList = new HashSet<String>();
        for (OpenStackVolume vol : volList) {
            String volTypeName = vol.getVolType();
            volTypeNameList.add(volTypeName);
        }
        if (VerifyUtil.isEmpty(volTypeNameList)) {
            LOG.error((Object)("VolTypeNameList or regionUuid or projUuid is empty. voluTypeNameList:" + volTypeNameList + " regionUuid:" + regionUuid + " projectUuid:" + projectUuid));
            return new ArrayList<OpenStackVolumeType>();
        }
        return this.getVolumeTypesByName(volTypeNameList, regionUuid, projectUuid);
    }

    public List<OpenStackVolumeType> getVolumeTypesByName(Set<String> volTypeNameList, String regionUuid, String projectUuid) {
        List<Object> volTypes;
        if (VerifyUtil.isEmpty(volTypeNameList) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projectUuid)) {
            LOG.error((Object)("VolTypeNameList or regionUuid or projectUuid is empty. voluTypeNameList:" + volTypeNameList + " regionUuid:" + regionUuid + " projectUuid:" + projectUuid));
            return new ArrayList<OpenStackVolumeType>();
        }
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        ICinderManager cinderManager = ManagerFactory.getInstance().getCinderManager(openstackUuid);
        String cacheKey = Joiner.on((String)"_@_").join((Object[])new String[]{regionUuid, projectUuid});
        if (OpenstackCache.containsKey(OpenstackCache.CacheType.VOLUME_TYPE_LIST, cacheKey)) {
            volTypes = (ArrayList)OpenstackCache.getCache(OpenstackCache.CacheType.VOLUME_TYPE_LIST, cacheKey);
            volTypes = new ArrayList(volTypes);
        } else {
            String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
            volTypes = cinderManager.getVolumeTypes(regionUuid, tokenId, projectUuid);
            OpenstackCache.putCache(OpenstackCache.CacheType.VOLUME_TYPE_LIST, cacheKey, volTypes);
            volTypes = new ArrayList<Object>(volTypes);
        }
        Iterator<Object> iterator = volTypes.iterator();
        while (iterator.hasNext()) {
            OpenStackVolumeType type = (OpenStackVolumeType)iterator.next();
            if (volTypeNameList.contains(type.getName())) continue;
            iterator.remove();
        }
        return volTypes;
    }

    public boolean isVolTypesFromSameDev(List<OpenStackVolumeType> volumeTypes) {
        if (VerifyUtil.isEmpty(volumeTypes)) {
            LOG.error((Object)"VolumeTypes is null or empty.");
            throw new LegoCheckedException(1073947393L);
        }
        String devSn = null;
        for (OpenStackVolumeType volType : volumeTypes) {
            String localDevSn;
            JSONObject json = JSONObject.fromObject((Object)volType.getExtraSpecs());
            String string = localDevSn = json.containsKey((Object)"hw:localdev") ? json.getString("hw:localdev") : "";
            if (VerifyUtil.isEmpty((String)localDevSn)) {
                LOG.error((Object)("Hw:localdev is empty. volumeType=" + volType.getUuid()));
                throw new LegoCheckedException(1073947393L);
            }
            if (VerifyUtil.isEmpty(devSn)) {
                devSn = localDevSn;
                continue;
            }
            if (localDevSn.equals(devSn)) continue;
            LOG.error((Object)"Volumes don't associate with the same device.");
            return false;
        }
        return true;
    }

    public VolumeReplicaSchedulerHintInfo getSchedulerHintInfoFromVolumeType(String volTypeName, String regionUuid, String projectUuid) {
        if (VerifyUtil.isEmpty((String)volTypeName) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projectUuid)) {
            LOG.error((Object)"Query scheduler hintInfo from volumeType failed.param is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        HashSet<String> volTypeNames = new HashSet<String>();
        volTypeNames.add(volTypeName);
        List<OpenStackVolumeType> volTypes = this.getVolumeTypesByName(volTypeNames, regionUuid, projectUuid);
        if (null == volTypes || volTypes.isEmpty()) {
            LOG.error((Object)("Query scheduler hintInfo from volumeType failed.no volumetype named" + volTypeName));
            return null;
        }
        OpenStackVolumeType volType = volTypes.get(0);
        JSONObject json = JSONObject.fromObject((Object)volType.getExtraSpecs());
        VolumeReplicaSchedulerHintInfo hintInfo = new VolumeReplicaSchedulerHintInfo();
        hintInfo.setAgentBackendName(json.getString("volume_backend_name"));
        hintInfo.setAgentStorageName(volType.getDevSn());
        return hintInfo;
    }

    public List<OpenStackStorageResourcePool> getStorageResourcePools(String openstackUuid, String regionUuid, String projectUuid) {
        if (VerifyUtil.isEmpty((String)openstackUuid) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projectUuid)) {
            LOG.error((Object)"Param is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
        IDrExtendManager manager = ManagerFactory.getInstance().getDrExtendManager(openstackUuid);
        return manager.getStoragePoolInfo(regionUuid, tokenId, projectUuid, true);
    }

    public OpenStackVolumeType getVolumeTypeByUuid(String regionUuid, String projectUuid, String volTypeUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projectUuid) || VerifyUtil.isEmpty((String)volTypeUuid)) {
            LOG.error((Object)"Param is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
        ICinderManager cinderMgr = ManagerFactory.getInstance().getCinderManager(openstackUuid);
        List<OpenStackVolumeType> typeList = cinderMgr.getVolumeTypes(regionUuid, tokenId, projectUuid);
        for (OpenStackVolumeType type : typeList) {
            if (!type.getUuid().equals(volTypeUuid)) continue;
            return type;
        }
        return null;
    }

    public VolumeInfo createVolume(Map<String, String> volumeDriverMetadata, VolumeCreateInfo volumeInfo, String regionUuid, String projUuid, boolean isBootable) {
        this.setVolumeOffsetForXENVolume(volumeDriverMetadata, volumeInfo);
        return this.createVolume(volumeInfo, regionUuid, projUuid, isBootable);
    }

    public VolumeInfo createVolume(VolumeCreateInfo volumeInfo, String regionUuid, String projUuid, boolean isBootable) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((Object)volumeInfo)) {
            LOG.error((Object)("Parameter is empty,  create volume: protectGroup name=" + volumeInfo.getProtectGroupName()));
            throw new LegoCheckedException(1073947393L);
        }
        LOG.info((Object)"Start to create volume: protectGroup name=%s,volumeInfo=%s", new Object[]{volumeInfo.getProtectGroupName(), volumeInfo});
        CinderManager mgr = new CinderManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        AsyncTaskResponse response = mgr.createVolume(volumeInfo, regionUuid, tokenId, projUuid);
        if (!response.isSuccess()) {
            String[] errParam = null;
            if (null != response.getTaskResult() && response.getTaskResult() instanceof VolumeInfo) {
                VolumeInfo result = (VolumeInfo)response.getTaskResult();
                errParam = new String[]{result.getId()};
                LOG.error((Object)("Create volume failed:" + result.getId() + "protectGroup name=" + volumeInfo.getProtectGroupName()));
            }
            throw new LegoCheckedException(1073948406L, errParam);
        }
        VolumeInfo result = (VolumeInfo)response.getTaskResult();
        if (null == result) {
            LOG.error((Object)("Create volume and get Task Result return null value.,protectGroup name=" + volumeInfo.getProtectGroupName()));
            throw new LegoCheckedException(1073947393L);
        }
        String volumeId = result.getId();
        if (isBootable && null != volumeId) {
            LOG.info((Object)"Create volume and check volume is a bootable volume.volumeId=%s,protectGroup name=%s", new Object[]{volumeId, volumeInfo.getProtectGroupName()});
            mgr.enableVolumeBootable(volumeId, regionUuid, tokenId, projUuid);
        }
        LOG.info((Object)"Create volume sucessfully:volumeId=%s,protectGroup name=%s", new Object[]{volumeId, volumeInfo.getProtectGroupName()});
        return result;
    }

    public void delVolume(String volumeId, String regionUuid, String projUuid) {
        String newVolumeId = OpenStackCommonUtil.getIdFromUuid(volumeId);
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)newVolumeId)) {
            LOG.error((Object)"Delete volume failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        LOG.info((Object)"Start to delete volume:volumeId=%s", new Object[]{volumeId});
        CinderManager mgr = new CinderManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        VolumeInfo volumeInfo = mgr.queryVolume(regionUuid, tokenId, projUuid, newVolumeId);
        if (null == volumeInfo) {
            LOG.info((Object)"Delete volume success.the volume is not exist:volumeId:%s", new Object[]{volumeId});
            return;
        }
        this.unreserveVolume(newVolumeId, regionUuid, projUuid);
        AsyncTaskResponse response = mgr.deleteVolume(newVolumeId, regionUuid, tokenId, projUuid);
        if (!response.isSuccess()) {
            LOG.error((Object)("Delete volume failed:volumeId=" + volumeId));
            throw new LegoCheckedException(1073948408L, new String[]{newVolumeId});
        }
        LOG.info((Object)"Delete volume successfully:volumeId=%s", new Object[]{volumeId});
    }

    public void reserveVolume(String volumeId, String regionUuid, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)volumeId)) {
            LOG.error((Object)("Reserve volume failed. parameter is empty. volumeId=" + volumeId));
            throw new LegoCheckedException(1073947393L);
        }
        String newVolumeId = OpenStackCommonUtil.getIdFromUuid(volumeId);
        CinderManager mgr = new CinderManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        AsyncTaskResponse response = mgr.reserveVolume(newVolumeId, regionUuid, tokenId, projUuid);
        LOG.debug((Object)"ReserveVolume volume. volumeID=%s,reponse str=%s", new Object[]{newVolumeId, response});
        if (!response.isSuccess()) {
            LOG.error((Object)("ReserveVolume volume failed. volumeID=" + newVolumeId + ",reponse str=" + response));
            throw new LegoCheckedException(1073948411L);
        }
        HashMap<String, String> metadataMap = new HashMap<String, String>();
        metadataMap.put("occupied_volume", "true");
        mgr.updateVolMetadatas(regionUuid, tokenId, projUuid, newVolumeId, metadataMap);
    }

    public void unreserveVolume(String volumeId, String regionUuid, String projUuid) {
        String newVolumeId = OpenStackCommonUtil.getIdFromUuid(volumeId);
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)newVolumeId)) {
            LOG.error((Object)"Unreserve volume failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        CinderManager mgr = new CinderManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        AsyncTaskResponse response = mgr.unreserveVolume(newVolumeId, regionUuid, tokenId, projUuid);
        if (!response.isSuccess()) {
            LOG.error((Object)("UnreserveVolume failed : volumeId=" + newVolumeId));
            throw new LegoCheckedException(1073948409L, new String[]{newVolumeId});
        }
        HashMap<String, String> metadataMap = new HashMap<String, String>();
        metadataMap.put("occupied_volume", "false");
        try {
            mgr.updateVolMetadatas(regionUuid, tokenId, projUuid, volumeId, metadataMap);
        }
        catch (LegoCheckedException exception) {
            LOG.error((Object)"UnreserveVolume occur exception:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)exception)});
            if (exception.getMessage().contains("Malformed request body")) {
                LOG.error((Object)"Catch the exception:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)exception)});
            }
            throw exception;
        }
    }

    public VolumeReplicationInfo createVolReplica(VolumeReplicationInfo volReplicaCreateInfo, String regionUuid, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((Object)volReplicaCreateInfo)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        LOG.info((Object)"Start to create Replica :replicaCreateInfo:%s", new Object[]{volReplicaCreateInfo});
        DrExtendManager mgr = new DrExtendManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        AsyncTaskResponse response = mgr.createVolumeReplication(volReplicaCreateInfo, regionUuid, tokenId, projUuid);
        if (response.isSuccess()) {
            return (VolumeReplicationInfo)response.getTaskResult();
        }
        LOG.error((Object)"Failed to create replica");
        String[] errParam = null;
        if (null != response.getTaskResult() && response.getTaskResult() instanceof VolumeReplicationInfo) {
            VolumeReplicationInfo result = (VolumeReplicationInfo)response.getTaskResult();
            errParam = new String[]{result.getId()};
            LOG.error((Object)("Create replication failed:" + result.getId()));
        }
        throw new LegoCheckedException(1073948407L, errParam);
    }

    public void delVolReplica(String regionUuid, String projUuid, String replicationId, boolean isForce, boolean isSingleDel) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)replicationId)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        LOG.info((Object)"Start to delete replica:replicaId=%s, isForce=%s, isSingleDel=%s", new Object[]{replicationId, isForce, isSingleDel});
        String newReplicationId = OpenStackCommonUtil.getIdFromUuid(replicationId);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        DrExtendManager drMgr = new DrExtendManager();
        VolumeReplicationInfo repliaInfo = drMgr.queryVolumeReplication(regionUuid, tokenId, projUuid, newReplicationId);
        if (null == repliaInfo) {
            LOG.info((Object)"Delelete replication success.the replica is not exist:replicaId=%s", new Object[]{replicationId});
            return;
        }
        AsyncTaskResponse response = drMgr.deleteVolumeReplication(regionUuid, tokenId, projUuid, newReplicationId, isForce, isSingleDel);
        if (!response.isSuccess()) {
            LOG.error((Object)("Delete replica failed:replicaId=" + replicationId + ",errorCode=" + response.getErrorCode()));
            throw new LegoCheckedException(1073948926L, new String[]{newReplicationId});
        }
        LOG.info((Object)"Delete replica sucessfully:replicaId=%s", new Object[]{replicationId});
    }

    public VolumeReplicationCgInfo createReplicaCG(VolReplicaCgCreateInfo createRepCgInfo, String regionUuid, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((Object)createRepCgInfo)) {
            String name = createRepCgInfo != null ? createRepCgInfo.getName() : null;
            LOG.error((Object)("Create replica CG failed. parameter is empty, protectGroup name=" + name));
            throw new LegoCheckedException(1073947393L);
        }
        LOG.info((Object)"Start to create replicaCG:replicas=%s,protectGroup name=%s", new Object[]{createRepCgInfo.getReplications(), createRepCgInfo.getName()});
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        DrExtendManager mgr = new DrExtendManager();
        AsyncTaskResponse response = mgr.createVolumeReplicationCG(createRepCgInfo, regionUuid, tokenId, projUuid);
        if (response.isSuccess()) {
            LOG.info((Object)"Create replicaCG successfully, protectGroup name=%s", new Object[]{createRepCgInfo.getName()});
            return (VolumeReplicationCgInfo)response.getTaskResult();
        }
        LOG.error((Object)("Failed to create replicaCG, protectGroup name=" + createRepCgInfo.getName()));
        String[] errParam = null;
        if (null != response.getTaskResult() && response.getTaskResult() instanceof VolumeReplicationCgInfo) {
            VolumeReplicationCgInfo result = (VolumeReplicationCgInfo)response.getTaskResult();
            errParam = new String[]{result.getId()};
            LOG.error((Object)("Create replicaCG failed:" + result.getId() + ",protectGroup name=" + createRepCgInfo.getName()));
        }
        throw new LegoCheckedException(1073948407L, errParam);
    }

    public VhaCsdrRingInfo createReplicaRing(CreateVhaCsdrRingInfo createRingInfo, String regionUuid, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((Object)createRingInfo)) {
            LOG.error((Object)("Parameter is empty, regionUuid: " + regionUuid + ", projUuid: " + projUuid + ", createRingInfo: " + createRingInfo));
            throw new LegoCheckedException(1073947393L);
        }
        LOG.info((Object)"Start to create RingCG:replicgs=%s, protectGroup name=%s", new Object[]{createRingInfo.getReplicationcgs(), createRingInfo.getName()});
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        DrExtendManager mgr = new DrExtendManager();
        AsyncTaskResponse response = mgr.createVolumeReplicationRing(createRingInfo, regionUuid, tokenId, projUuid);
        if (response.isSuccess()) {
            LOG.info((Object)"Create ReplicaRing successfully, protectGroup name=%s", new Object[]{createRingInfo.getName()});
            return (VhaCsdrRingInfo)response.getTaskResult();
        }
        LOG.error((Object)("Failed to create Ring , protectGroup name=" + createRingInfo.getName() + ", createRingInfo=" + createRingInfo));
        String[] errParam = null;
        if (null != response.getTaskResult() && response.getTaskResult() instanceof VhaCsdrRingInfo) {
            VhaCsdrRingInfo result = (VhaCsdrRingInfo)response.getTaskResult();
            errParam = new String[]{result.getId()};
            LOG.error((Object)("Create Ring failed:" + result.getId() + ", protectGroup name=" + createRingInfo.getName() + ", createRingInfo=" + createRingInfo));
        }
        throw new LegoCheckedException(1073948140L, errParam);
    }

    public VolumeReplicationCgInfo createReplicaRing(VolReplicaCgCreateInfo createRepCgInfo, String regionUuid, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((Object)createRepCgInfo)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        LOG.info((Object)"Start to create ReplicaCG:replicas=%s", new Object[]{createRepCgInfo.getReplications()});
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        DrExtendManager mgr = new DrExtendManager();
        AsyncTaskResponse response = mgr.createVolumeReplicationCG(createRepCgInfo, regionUuid, tokenId, projUuid);
        if (response.isSuccess()) {
            LOG.info((Object)"Create ReplicaCG successfully");
            return (VolumeReplicationCgInfo)response.getTaskResult();
        }
        LOG.error((Object)"Failed to create CG");
        String[] errParam = null;
        if (null != response.getTaskResult() && response.getTaskResult() instanceof VolumeReplicationCgInfo) {
            VolumeReplicationCgInfo result = (VolumeReplicationCgInfo)response.getTaskResult();
            errParam = new String[]{result.getId()};
            LOG.error((Object)("Create CG failed:" + result.getId()));
        }
        throw new LegoCheckedException(1073948407L, errParam);
    }

    public void delReplicaCG(String regionUuid, String projUuid, String replicationCgId, boolean isForce, boolean isSingleDel) {
        AsyncTaskResponse response;
        String newReplicationCgId = OpenStackCommonUtil.getIdFromUuid(replicationCgId);
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)newReplicationCgId)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        LOG.info((Object)"Start to delete replicaCG:cgId=%s", new Object[]{replicationCgId});
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        DrExtendManager mgr = new DrExtendManager();
        VolumeReplicationCgInfo cgInfo = mgr.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, newReplicationCgId);
        if (null == cgInfo) {
            LOG.info((Object)"Delete ReplicaCG.the cg is not exist:cgId=%s", new Object[]{replicationCgId});
            return;
        }
        if (!isSingleDel) {
            LOG.info((Object)"First remove replication because is not singleDelete.isSingleDel=%s,cgId=%s", new Object[]{isSingleDel, replicationCgId});
            List<VolumeReplicationInfo> replicationList = mgr.getRepsByRepCgId(newReplicationCgId, regionUuid, tokenId, projUuid);
            if (replicationList != null && !replicationList.isEmpty()) {
                Set<String> replicaIdSet = this.getReplicationIdSet(replicationList);
                this.updateVolumeReplicationCG(regionUuid, projUuid, newReplicationCgId, null, replicaIdSet);
            }
        }
        if (!(response = mgr.deleteVolumeReplicationCG(regionUuid, tokenId, projUuid, newReplicationCgId, isForce, isSingleDel)).isSuccess()) {
            LOG.error((Object)("Delete cg failed:cgId=" + replicationCgId));
            throw new LegoCheckedException(1073948410L, new String[]{newReplicationCgId});
        }
        LOG.info((Object)"Delete cg successfully: cgid=%s", new Object[]{replicationCgId});
    }

    public Set<String> getReplicaIdsOfCg(String regionUuid, String projUuid, String cgUuid) {
        String cgId = OpenStackCommonUtil.getIdFromUuid(cgUuid);
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)cgId)) {
            LOG.error((Object)"Parameter is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        IDrExtendManager mgr = ManagerFactory.getInstance().getDrExtendManager(openstackUuid);
        VolumeReplicationCgInfo cgInfo = mgr.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, cgId);
        if (null == cgInfo) {
            LOG.info((Object)"The cg is not exist:cgId=%s", new Object[]{cgId});
            return new HashSet<String>();
        }
        List<VolumeReplicationInfo> replicationList = mgr.getRepsByRepCgId(cgId, regionUuid, tokenId, projUuid);
        HashSet<String> repliaIdSet = new HashSet<String>();
        for (VolumeReplicationInfo replica : replicationList) {
            repliaIdSet.add(replica.getId());
        }
        return repliaIdSet;
    }

    private Set<String> getReplicationIdSet(List<VolumeReplicationInfo> replicationList) {
        HashSet<String> replicaIdSet = new HashSet<String>();
        for (VolumeReplicationInfo replicationInfo : replicationList) {
            String replicaId = replicationInfo.getId();
            if (null == replicaId || replicaIdSet.contains(replicaId)) continue;
            replicaIdSet.add(replicaId);
        }
        return replicaIdSet;
    }

    public void updateVolumeReplicationCG(String regionUuid, String projUuid, String replicationCgId, Set<String> addReplications, Set<String> removeReplications) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)replicationCgId)) {
            LOG.error((Object)"Update volume replicationCG failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty(addReplications) && VerifyUtil.isEmpty(removeReplications)) {
            LOG.debug((Object)"Update volume replicationCG successed.there is no replication to update.replicationCgId=%s", new Object[]{replicationCgId});
            return;
        }
        String newRelicationCgId = OpenStackCommonUtil.getIdFromUuid(replicationCgId);
        DrExtendManager mgr = new DrExtendManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        VolumeReplicationCgInfo info = mgr.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, newRelicationCgId);
        if (null == info || !REPLICATIONCG_STATUS_FOR_ADDORREMOVE_PAIR.contains(info.getStatus())) {
            LOG.error((Object)("Update volume replicationCG failed.cg is not exist,cgId=" + replicationCgId + ", or cg status is not available,or not error or not error_deleting.cg status is" + (info != null ? info.getStatus() : "cg is null.")));
            throw new LegoCheckedException(1073948414L);
        }
        Set<String> addReplicaIdSet = OpenStackCommonUtil.getIdFromUuid(addReplications);
        Set<String> removeReplicaIdSet = OpenStackCommonUtil.getIdFromUuid(removeReplications);
        LOG.info((Object)"Update volume replicationCG.add Replica:%s remove replica:%s from cgid=%s", new Object[]{addReplicaIdSet, removeReplicaIdSet, replicationCgId});
        if (!VerifyUtil.isEmpty(removeReplications)) {
            removeReplicaIdSet = this.filterNotExistReplicaOfRemove(regionUuid, projUuid, newRelicationCgId, tokenId, mgr, removeReplicaIdSet);
            LOG.info((Object)"Update volume replicationCG.exist Replica to remove:%s,cgid=%s", new Object[]{removeReplicaIdSet, replicationCgId});
        }
        if (VerifyUtil.isEmpty(addReplicaIdSet) && VerifyUtil.isEmpty(removeReplicaIdSet)) {
            LOG.debug((Object)"Update volume replicationCG succeed.none replica to operate,cgid=%s", new Object[]{replicationCgId});
            return;
        }
        VolReplicaCgUpdateInfo updateRepCgInfo = this.getVolReplicaCgUpdateInfo(addReplicaIdSet, removeReplicaIdSet);
        AsyncTaskResponse response = mgr.updateVolumeReplicationCG(updateRepCgInfo, newRelicationCgId, regionUuid, tokenId, projUuid);
        if (!response.isSuccess()) {
            LOG.error((Object)("Update volume replicationCG failed.cgid=" + replicationCgId));
            throw new LegoCheckedException(1073948414L);
        }
    }

    private VolReplicaCgUpdateInfo getVolReplicaCgUpdateInfo(Set<String> addReplicaIdSet, Set<String> removeReplicaIdSet) {
        VolReplicaCgUpdateInfo updateRepCgInfo = new VolReplicaCgUpdateInfo();
        String addRpIds = OpenStackCommonUtil.getStringFromCollection(addReplicaIdSet, ",");
        String rmRpIds = OpenStackCommonUtil.getStringFromCollection(removeReplicaIdSet, ",");
        updateRepCgInfo.setAddReplicas(addRpIds);
        updateRepCgInfo.setRemoveReplicas(rmRpIds);
        return updateRepCgInfo;
    }

    public void updateReplicationCGBandwidth(String regionUuid, String projUuid, String replicationCgId, DmEnumDefine.SpeedLevelE bandwidth) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)replicationCgId)) {
            LOG.error((Object)"parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String newRelicationCgId = OpenStackCommonUtil.getIdFromUuid(replicationCgId);
        DrExtendManager mgr = new DrExtendManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        VolumeReplicationCgInfo info = mgr.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, newRelicationCgId);
        if (null == info || !OpenstackEnumDefine.ReplicationStatusE.AVAILABLE.getValue().equals(info.getStatus())) {
            LOG.error((Object)("Cg is not exist,cgId=" + replicationCgId));
            throw new LegoCheckedException(1073947393L);
        }
        AsyncTaskResponse response = mgr.updateReplicationCGBandwidth(bandwidth, newRelicationCgId, regionUuid, tokenId, projUuid);
        if (!response.isSuccess()) {
            throw new LegoCheckedException(1073949710L, new String[]{newRelicationCgId});
        }
    }

    private Set<String> filterNotExistReplicaOfRemove(String regionUuid, String projUuid, String newRelicationCgId, String tokenId, DrExtendManager mgr, Set<String> removeReplicaIdSet) {
        List<VolumeReplicationInfo> replicaInfoList = mgr.getRepsByRepCgId(newRelicationCgId, regionUuid, tokenId, projUuid);
        HashSet<String> allExistReplicaIds = new HashSet<String>();
        HashSet<String> existReplicaOfRemove = new HashSet<String>();
        existReplicaOfRemove.addAll(removeReplicaIdSet);
        for (VolumeReplicationInfo replicaInfo : replicaInfoList) {
            String existReplicaId = replicaInfo.getId();
            if (VerifyUtil.isEmpty((String)existReplicaId) || allExistReplicaIds.contains(existReplicaId)) continue;
            allExistReplicaIds.add(existReplicaId);
        }
        if (VerifyUtil.isEmpty(allExistReplicaIds)) {
            return new HashSet<String>();
        }
        for (String replicaId : removeReplicaIdSet) {
            if (allExistReplicaIds.contains(replicaId)) continue;
            existReplicaOfRemove.remove(replicaId);
        }
        return existReplicaOfRemove;
    }

    public void syncReplication(String regionUuid, String projUuid, String replicatrionUuid, boolean isCg) {
        String replicationId = OpenStackCommonUtil.getIdFromUuid(replicatrionUuid);
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)replicationId)) {
            LOG.error((Object)"ReplicatrionUuid is emoty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!isCg) {
            LOG.error((Object)"Current not support replication.");
            throw new LegoCheckedException(1073947393L);
        }
        DrExtendManager mgr = new DrExtendManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        AsyncTaskResponse response = mgr.syncVolumeReplicationCG(regionUuid, tokenId, projUuid, replicationId);
        if (!response.isSuccess()) {
            throw new LegoCheckedException(1073948448L);
        }
    }

    public void splitReplication(String regionUuid, String projUuid, String replicatrionUuid, boolean isCg) {
        String replicationId = OpenStackCommonUtil.getIdFromUuid(replicatrionUuid);
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)replicationId)) {
            LOG.error((Object)"ReplicatrionUuid is emoty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!isCg) {
            LOG.error((Object)"Current not support replication.");
            throw new LegoCheckedException(1073947393L);
        }
        DrExtendManager mgr = new DrExtendManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        AsyncTaskResponse response = mgr.splitVolumeReplicationCG(regionUuid, tokenId, projUuid, replicationId);
        if (!response.isSuccess()) {
            throw new LegoCheckedException(1073948448L);
        }
    }

    public int getReplicationSyncProcess(String regionUuid, String projUuid, String replicatrionUuid, boolean isCg) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)replicatrionUuid)) {
            LOG.error((Object)"ReplicatrionUuid is emoty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!isCg) {
            LOG.error((Object)"Current not support replication.");
            throw new LegoCheckedException(1073947393L);
        }
        DrExtendManager mgr = new DrExtendManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        VolumeReplicationCgInfo cgInfo = mgr.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, OpenStackCommonUtil.getIdFromUuid(replicatrionUuid));
        if (null == cgInfo) {
            LOG.error((Object)("VolumeReplicationCgInfo is not existed:" + replicatrionUuid));
            throw new LegoCheckedException(2117645L);
        }
        if (OpenstackEnumDefine.ReplicationRepStatusE.ACTIVE.getValue().equals(cgInfo.getReplicationStatus())) {
            return 100;
        }
        if (OpenstackEnumDefine.ReplicationRepStatusE.COPYING.getValue().equals(cgInfo.getReplicationStatus())) {
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("replicationcg_id", OpenStackCommonUtil.getIdFromUuid(replicatrionUuid));
            List<VolumeReplicationInfo> replicationInfos = mgr.getVolumeReplications(regionUuid, tokenId, projUuid, uriVariables, false);
            if (VerifyUtil.isEmpty(replicationInfos)) {
                LOG.warn((Object)("The cg(" + replicatrionUuid + ") has no replication."));
                throw new LegoCheckedException(1073948448L);
            }
            int progress = 99;
            for (VolumeReplicationInfo replicationInfo : replicationInfos) {
                int tempProgress = this.getReplicationProcess(replicationInfo);
                progress = Math.min(progress, tempProgress);
            }
            return progress;
        }
        LOG.error((Object)("Replication'status is error.repid is " + cgInfo.getId() + " and status is " + cgInfo.getReplicationStatus()));
        throw new LegoCheckedException(1073948448L);
    }

    private int getReplicationProcess(VolumeReplicationInfo replicationInfo) {
        String jsonStr = replicationInfo.getReplicationExtendedStatus();
        JSONObject json = JSONObject.fromObject((Object)jsonStr);
        if (!json.containsKey((Object)"progress")) {
            return 0;
        }
        String process = json.getString("progress");
        if (VerifyUtil.isEmpty((String)process)) {
            return 0;
        }
        try {
            return Integer.parseInt(process);
        }
        catch (NumberFormatException e) {
            LOG.error((Object)("Parse int error:" + process), (Throwable)e);
            return 0;
        }
    }

    public List<OpenStackVolume> getVolumesFromOpenstack(String regionUuid, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid)) {
            LOG.error((Object)"Regionuuid or projuuid is empty");
            throw new LegoCheckedException(1073947393L);
        }
        CinderManager cinderMgr = new CinderManager();
        String cacheKey = Joiner.on((String)"_@_").join((Object[])new String[]{regionUuid, projUuid});
        List openStackVolumes = OpenstackCache.getCache(OpenstackCache.CacheType.OPENSTACK_VOLUME_LIST, cacheKey, () -> {
            String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
            return cinderMgr.getVolumes(regionUuid, tokenId, projUuid, null);
        });
        return new ArrayList<OpenStackVolume>(openStackVolumes);
    }

    public void updateVolumeMetadata(String volumeId, Map<String, String> metadata, String regionUuid, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)volumeId) || VerifyUtil.isEmpty(metadata)) {
            LOG.error((Object)"Update volume metadata failed.regionuuid or projuuid is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        ICinderManager mgr = ManagerFactory.getInstance().getCinderManager(openstackUuid);
        mgr.updateVolMetadatas(regionUuid, tokenId, projUuid, volumeId, metadata);
    }

    public void deleteVolMetadatas(String regionUuid, String projUuid, String volumeId, String metadataKey) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)volumeId) || VerifyUtil.isEmpty((String)metadataKey)) {
            LOG.error((Object)"Delete volume metadata failed.sregionuuid or projuuid is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        ICinderManager mgr = ManagerFactory.getInstance().getCinderManager(openstackUuid);
        mgr.deleteVolMetadatas(regionUuid, tokenId, projUuid, volumeId, metadataKey);
    }

    public ImageMetadataInfo queryImageMetadata(String srcVolumeId, String regionUuid, String projUuid) {
        return JsonUtil.jsonToBean(JSONObject.fromObject((Object)this.queryImageMetadataMap(srcVolumeId, regionUuid, projUuid)).toString(), ImageMetadataInfo.class);
    }

    public Map queryImageMetadataMap(String srcVolumeId, String regionUuid, String projUuid) {
        Map imageMetadataInfo;
        LOG.debug((Object)"Query and update image medata.");
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)srcVolumeId)) {
            LOG.error((Object)"Query image metadata.regionuuid or projuuid is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        ICinderManager mgr = ManagerFactory.getInstance().getCinderManager(openstackUuid);
        LOG.info((Object)"Query image metadata info, srcVolumeId=%s", new Object[]{srcVolumeId});
        String cacheKey = Joiner.on((String)"_@_").join((Object[])new String[]{regionUuid, projUuid, srcVolumeId});
        if (OpenstackCache.containsKey(OpenstackCache.CacheType.IMAGE_META_DATA, cacheKey)) {
            imageMetadataInfo = (Map)OpenstackCache.getCache(OpenstackCache.CacheType.IMAGE_META_DATA, cacheKey);
        } else {
            String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
            imageMetadataInfo = mgr.queryImageMetadataMap(regionUuid, tokenId, projUuid, srcVolumeId);
            OpenstackCache.putCache(OpenstackCache.CacheType.IMAGE_META_DATA, cacheKey, imageMetadataInfo);
        }
        return imageMetadataInfo;
    }

    public void updateImageMetadata(String drVolumeId, String regionUuid, String projUuid, ImageMetadataInfo metadateInfo) {
        if (null == metadateInfo || VerifyUtil.isEmpty((String)metadateInfo.getHwDiskBus())) {
            LOG.error((Object)"Update image metadata failed. volume's imageMetaData is empty.");
            return;
        }
        if (VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)drVolumeId) || VerifyUtil.isEmpty((String)regionUuid)) {
            LOG.error((Object)"Update image metadata failed.regionuuid or projuuid is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        ICinderManager mgr = ManagerFactory.getInstance().getCinderManager(openstackUuid);
        mgr.updateImageMetadata(regionUuid, tokenId, projUuid, metadateInfo, drVolumeId);
    }

    public void updateImageMetadata(String drVolumeId, String regionUuid, String projUuid, Map metadateInfo) {
        if (VerifyUtil.isEmpty((Map)metadateInfo)) {
            LOG.error((Object)"Update image metadata failed. volume's imageMetaData is empty.");
            return;
        }
        if (VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)drVolumeId) || VerifyUtil.isEmpty((String)regionUuid)) {
            LOG.error((Object)"Update image metadata failed.regionuuid or projuuid is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        ICinderManager mgr = ManagerFactory.getInstance().getCinderManager(openstackUuid);
        mgr.updateImageMetadata(regionUuid, tokenId, projUuid, metadateInfo, drVolumeId);
    }

    public boolean isAttachVM(String regionUuid, String projectUuid, String vmUuid, String volumeUuid) {
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        ICinderManager cinderMgr = ManagerFactory.getInstance().getCinderManager(openstackUuid);
        if (VerifyUtil.isEmpty((String)volumeUuid) || VerifyUtil.isEmpty((String)vmUuid)) {
            LOG.info((Object)"Argument error: volumeUuid:%s, vmUuid:%s ", new Object[]{volumeUuid, vmUuid});
            return false;
        }
        String volumeId = OpenStackCommonUtil.getIdFromUuid(volumeUuid);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
        VolumeInfo volumeInfo = cinderMgr.queryVolume(regionUuid, tokenId, projectUuid, volumeId);
        if (VerifyUtil.isEmpty((Object)volumeInfo)) {
            LOG.info((Object)"Volume is not exist: %s, vmUuid=%s", new Object[]{volumeUuid, vmUuid});
            return false;
        }
        List attachmentInfos = volumeInfo.getAttachments();
        String serverId = OpenStackCommonUtil.getIdFromUuid(vmUuid);
        for (VolumeAttachmentInfo attachInfo : attachmentInfos) {
            if (!serverId.equals(attachInfo.getServerId())) continue;
            LOG.info((Object)"Volume is attachVm: %s, vmUuid=%s", new Object[]{volumeUuid, vmUuid});
            return true;
        }
        LOG.info((Object)"Volume is not attached:%s, vmUuid=%s ", new Object[]{volumeUuid, vmUuid});
        return false;
    }

    public void checkVolumesExitSnapshots(String regionUuid, String projectUuid, List<String> volumesId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projectUuid) || VerifyUtil.isEmpty(volumesId)) {
            LOG.error((Object)"CheckVolumesExitSnapshots param is null");
            return;
        }
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(projectUuid);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
        ICinderManager cinderMgr = ManagerFactory.getInstance().getCinderManager(openstackUuid);
        List<VolumeSnapShotInfo> volSnapShotList = cinderMgr.queryVolumeSnapShots(regionUuid, tokenId, projectUuid, null);
        if (VerifyUtil.isEmpty(volSnapShotList)) {
            LOG.info((Object)"VolumesId=%s, volSnapShotList is null", new Object[]{volumesId});
            return;
        }
        HashMap<String, String> volSnapShotMap = new HashMap<String, String>();
        for (VolumeSnapShotInfo snapShot : volSnapShotList) {
            LOG.debug((Object)"Vol have snapShot volid is: %s,snapShot creatime:%s", new Object[]{snapShot.getVolumeId(), snapShot.getCreateTime()});
            volSnapShotMap.put(snapShot.getVolumeId(), snapShot.getId());
        }
        for (String volId : volumesId) {
            if (!volSnapShotMap.containsKey(volId)) continue;
            LOG.error((Object)("Vol exit snapShot, vol id: " + volId + " snapShot id is: " + (String)volSnapShotMap.get(volId)));
            throw new LegoCheckedException(1073948127L);
        }
    }

    public String getAvalibleVolumeType(String regionId, String drRegionId, String projectId, String drProjectId, String volumetypeId) {
        JSONArray array = new JSONArray();
        String drResult = array.toString();
        this.checkRegionId(regionId, drRegionId, projectId, drProjectId, volumetypeId);
        VolumeTypeInfo srcVolType = this.getVolumeTypeById(regionId, projectId, volumetypeId);
        FusionSphereOpenStack openStack = OpenStackCommonUtil.getOpenstack();
        String openstackUuid = openStack.getUuid();
        String regionUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, regionId);
        String drRegionUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, drRegionId);
        String projectUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, projectId);
        String drProjectUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, drProjectId);
        List<VolumeTypeInfo> result = this.queryVolumeTypes(drRegionId, drProjectId);
        if (VerifyUtil.isEmpty(result)) {
            LOG.error((Object)("Get volume type failed:drRegionUuid=" + drRegionUuid + " projectUuid=" + drProjectUuid));
            return drResult;
        }
        String extraSpecs = JsonUtil.beanToJson(srcVolType.getExtraSpecs());
        LOG.debug((Object)"Source voltype extraSpecs:%s", new Object[]{extraSpecs});
        JSONObject obj = JSONObject.fromObject((Object)extraSpecs);
        String localdevSn = this.getLocaldevSn(srcVolType, obj);
        boolean isRDM = this.isPassthrough(obj);
        OpenStackStorageResourcePool localPool = this.getLocalPool(openstackUuid, localdevSn, regionUuid, projectUuid);
        if (null == localPool || VerifyUtil.isEmpty((String)localPool.getRemoteDevsStr())) {
            LOG.error((Object)("There is no pool match localdevSn:" + localdevSn));
            return drResult;
        }
        List<OpenStackStorageResourcePool> remotePools = this.getStorageResourcePools(openstackUuid, drRegionUuid, drProjectUuid);
        if (VerifyUtil.isEmpty(remotePools)) {
            LOG.error((Object)("There is no match pool in remote:drRegionUuid=" + drRegionUuid + " drProjectUuid=" + drProjectUuid));
            return drResult;
        }
        Map<String, String> poolAndLinktypeMap = this.getResoucePoolMap(localPool, remotePools);
        LOG.info((Object)"Remote device Info:%s", new Object[]{poolAndLinktypeMap});
        this.filterVolumeType(result, isRDM, poolAndLinktypeMap);
        return this.constructVolTypeJSONStr(result);
    }

    private String getLocaldevSn(VolumeTypeInfo srcVolType, JSONObject obj) {
        boolean isExistKey = obj.containsKey((Object)"hw:localdev");
        if (!isExistKey) {
            LOG.error((Object)("Volume type is not config hw:localdev , volume type is " + srcVolType.getName()));
            throw new LegoCheckedException(1073948129L);
        }
        String localdevSn = obj.getString("hw:localdev");
        if (null == localdevSn) {
            LOG.error((Object)"LocaldevSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        return localdevSn;
    }

    private void checkRegionId(String regionId, String drRegionId, String projectId, String drProjectId, String volumetypeId) {
        if (VerifyUtil.isEmpty((String)regionId) || VerifyUtil.isEmpty((String)drRegionId) || VerifyUtil.isEmpty((String)volumetypeId) || VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((String)drProjectId)) {
            LOG.error((Object)("GetAvalibleVolumeType param is empty. regionId=" + regionId + " drRegionId=" + drRegionId + " projectId=" + projectId + " drProjectId=" + drProjectId + " volumetypeId=" + volumetypeId));
            throw new LegoCheckedException(1073947393L);
        }
    }

    private VolumeTypeInfo getVolumeTypeById(String regionId, String projectId, String volumetypeId) {
        List<VolumeTypeInfo> list = this.queryVolumeTypes(regionId, projectId);
        VolumeTypeInfo srcVolType = null;
        for (VolumeTypeInfo type : list) {
            if (!volumetypeId.equals(type.getId())) continue;
            srcVolType = type;
            break;
        }
        if (null == srcVolType) {
            LOG.error((Object)("SrcVolType is not exist, volumetypeId is: " + volumetypeId));
            throw new LegoCheckedException(201L);
        }
        return srcVolType;
    }

    private OpenStackStorageResourcePool getLocalPool(String openstackUuid, String localdevSn, String regionUuid, String projectUuid) {
        OpenStackStorageResourcePool localPool = null;
        List<OpenStackStorageResourcePool> localPools = this.getStorageResourcePools(openstackUuid, regionUuid, projectUuid);
        for (OpenStackStorageResourcePool pool : localPools) {
            if (!localdevSn.equals(pool.getLocalDevSn())) continue;
            localPool = pool;
            break;
        }
        return localPool;
    }

    private void filterVolumeType(List<VolumeTypeInfo> result, boolean isRDM, Map<String, String> poolAndLinktypeMap) {
        Iterator<VolumeTypeInfo> itrator = result.iterator();
        while (itrator.hasNext()) {
            VolumeTypeInfo remoteType = itrator.next();
            String extraSpecs = JsonUtil.beanToJson(remoteType.getExtraSpecs());
            JSONObject json = JSONObject.fromObject((Object)extraSpecs);
            boolean isExistKey = json.containsKey((Object)"hw:localdev");
            if (!isExistKey) {
                LOG.error((Object)("Volume type is not config hw:localdev , volume type is " + remoteType.getName()));
                itrator.remove();
                continue;
            }
            Object remotedevSn = json.get("hw:localdev");
            if (null == remotedevSn) {
                LOG.error((Object)"RemotedevSn is empty.");
                itrator.remove();
                continue;
            }
            if (poolAndLinktypeMap.containsKey(remotedevSn) && isRDM == this.isPassthrough(json)) continue;
            itrator.remove();
        }
    }

    private Map<String, String> getResoucePoolMap(OpenStackStorageResourcePool localPool, List<OpenStackStorageResourcePool> remotePools) {
        LOG.debug((Object)"Enter getResoucePoolMap");
        localPool.generateRemoteDevInfo();
        HashMap<String, String> remotePoolMap = new HashMap<String, String>();
        block0: for (OpenStackStorageResourcePool remotePool : remotePools) {
            for (OpenStackStoragePoolRemoteDevInfo o : localPool.getRemoteDevs()) {
                if (null == o.getDevSn() || !o.getDevSn().equals(remotePool.getLocalDevSn())) continue;
                remotePoolMap.put(remotePool.getLocalDevSn(), o.getLinkType());
                continue block0;
            }
        }
        return remotePoolMap;
    }

    private boolean isPassthrough(JSONObject obj) {
        try {
            return obj.getBoolean("hw:passthrough");
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)("Parse isPassthrough error." + ExceptionUtil.getErrorMessage((Throwable)e)));
            return false;
        }
    }

    private String constructVolTypeJSONStr(List<VolumeTypeInfo> volTypeList) {
        LOG.debug((Object)"Enter constructVolTypeJSONStr");
        JSONArray array = new JSONArray();
        for (VolumeTypeInfo volType : volTypeList) {
            JSONObject json = new JSONObject();
            json.put((Object)"id", (Object)volType.getId());
            json.put((Object)"name", (Object)volType.getName());
            array.add((Object)json);
        }
        return array.toString();
    }

    public void openRing(String regionUuid, String projUuid, String ringUUID) {
        String ringID = OpenStackCommonUtil.getIdFromUuid(ringUUID);
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)ringID)) {
            LOG.error((Object)"RingID is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        DrExtendManager mgr = new DrExtendManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        VhaCsdrRingInfo ringInfo = mgr.queryVolumeReplicationRing(regionUuid, tokenId, projUuid, ringUUID);
        if (null == ringInfo) {
            LOG.error((Object)("The ring is not exist:ringID=" + ringUUID));
            throw new LegoCheckedException(1073947394L);
        }
        if (OpenstackEnumDefine.DrStarStatus.ENABLE.getValue().equals(ringInfo.getReplicationStatus())) {
            LOG.info((Object)"The ring is already open:ringID=%s", new Object[]{ringUUID});
            return;
        }
        try {
            AsyncTaskResponse response = mgr.openRing(regionUuid, tokenId, projUuid, ringUUID);
            if (!response.isSuccess()) {
                LOG.error((Object)("Open ringID " + ringID + "is failed. Error Code: " + response.getErrorCode()));
                throw new LegoCheckedException(1073948143L);
            }
        }
        catch (LegoCheckedException e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("open ringID " + ringID + "is failed. Error Code: " + e.getErrorCode()), (long)1073948143L, null, (Log)LOG);
        }
    }

    public void closeRing(String regionUuid, String projUuid, String ringUUID, boolean singleClose) {
        String ringID = OpenStackCommonUtil.getIdFromUuid(ringUUID);
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)ringID)) {
            LOG.error((Object)("RingID is empty, ringID\uff1a" + ringID + ", regionUuid: " + regionUuid + ", projUuid: " + projUuid));
            throw new LegoCheckedException(1073947393L);
        }
        DrExtendManager mgr = new DrExtendManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        VhaCsdrRingInfo ringInfo = mgr.queryVolumeReplicationRing(regionUuid, tokenId, projUuid, ringUUID);
        if (null == ringInfo) {
            LOG.info((Object)"Close Ring and the ring is not exist:ringID=%s", new Object[]{ringUUID});
            return;
        }
        if (OpenstackEnumDefine.ReplicationRepStatusE.DISABLED.getValue().equals(ringInfo.getReplicationStatus()) || OpenstackEnumDefine.ReplicationRepStatusE.ERROR.getValue().equals(ringInfo.getReplicationStatus())) {
            LOG.info((Object)"Close Ring and the ring is disabled or error status,ringID=%s,ring info:%s", new Object[]{ringUUID, ringInfo});
            return;
        }
        AsyncTaskResponse response = mgr.closeRing(regionUuid, tokenId, projUuid, ringUUID, singleClose);
        if (!response.isSuccess()) {
            LOG.error((Object)("Close ringID " + ringID + "is failed. single_close status is : " + singleClose));
            throw new LegoCheckedException(1073948142L, new String[]{ringID});
        }
    }

    public void delRing(String regionUuid, String projUuid, String ringID, boolean isForce, boolean isSingleDel) {
        String newRingId = OpenStackCommonUtil.getIdFromUuid(ringID);
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)newRingId)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        LOG.info((Object)"Start to delete ring:ringID=%s", new Object[]{ringID});
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        DrExtendManager mgr = new DrExtendManager();
        VhaCsdrRingInfo ringInfo = mgr.queryVolumeReplicationRing(regionUuid, tokenId, projUuid, newRingId);
        if (null == ringInfo) {
            LOG.info((Object)"The ring is not exist:ringID=%s", new Object[]{newRingId});
            return;
        }
        AsyncTaskResponse response = mgr.deleteRing(regionUuid, tokenId, projUuid, newRingId, isForce, isSingleDel);
        if (!response.isSuccess()) {
            LOG.error((Object)("Delete ring failed:ringID=" + newRingId));
            throw new LegoCheckedException(1073948141L, new String[]{newRingId});
        }
        LOG.info((Object)"Delete ring successfully: ringID=%s", new Object[]{newRingId});
    }

    public OpenStackVolume querySingleVolumeByUuid(String regionUuid, String projectUuid, String volumeUUID) {
        if (VerifyUtil.isEmpty((String)volumeUUID)) {
            return null;
        }
        if (VerifyUtil.isEmpty((String)regionUuid)) {
            LOG.error((Object)"Regionuuid is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)projectUuid)) {
            LOG.error((Object)"Projuuid is empty");
            throw new LegoCheckedException(1073947393L);
        }
        CinderManager cinderMgr = new CinderManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
        return cinderMgr.getVolumeForOpenstackVolume(regionUuid, tokenId, projectUuid, volumeUUID);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setVolumeOffsetForXENVolume(Map<String, String> volumeDriverMetadata, VolumeCreateInfo volCreateInfo) {
        if (null == volumeDriverMetadata) {
            LOG.info((Object)"Create dr volume is not xen type volume , drVolumeName= %s", new Object[]{volCreateInfo.getName()});
            return;
        }
        if (null != volumeDriverMetadata.get("xen_clock_offset") && null != volumeDriverMetadata.get("xen_clock_size")) {
            LOG.info((Object)"Create dr volume is xen type volume , drVolumeName= %s", new Object[]{volCreateInfo.getName()});
            JSONObject metaJson = new JSONObject();
            metaJson.put((Object)"include_xen_clock_offset", (Object)"true");
            volCreateInfo.setMetadata(metaJson);
            return;
        }
        if (null == volumeDriverMetadata.get("xen_clock_offset") && null == volumeDriverMetadata.get("xen_clock_size")) {
            LOG.info((Object)"Create dr volume is not xen type volume , drVolumeName= %s", new Object[]{volCreateInfo.getName()});
            return;
        }
        LOG.error((Object)"Create dr volume failed. Source volume is xen type volume,xen_clock_offset and xen_clock_size must be not null ,xen_clock_offset is %s, xen_clock_size is %s, srcVolumeName= %s", new Object[]{volumeDriverMetadata.get("xen_clock_offset"), volumeDriverMetadata.get("xen_clock_size"), volCreateInfo.getName()});
        throw new LegoCheckedException(1073948156L);
    }

    static {
        REPLICATIONCG_STATUS_FOR_ADDORREMOVE_PAIR.add(OpenstackEnumDefine.ReplicationStatusE.AVAILABLE.getValue());
        REPLICATIONCG_STATUS_FOR_ADDORREMOVE_PAIR.add(OpenstackEnumDefine.ReplicationStatusE.ERROR.getValue());
        REPLICATIONCG_STATUS_FOR_ADDORREMOVE_PAIR.add(OpenstackEnumDefine.ReplicationStatusE.ERROR_DELETING.getValue());
    }

    static class OpenStackVolumeTask
    extends RecursiveTask<List<OpenStackVolume>> {
        private static final long serialVersionUID = -100164329337063102L;
        private String regionUuid;
        private String projectUuid;
        private List<String> uuidList;
        private int start;

        public OpenStackVolumeTask(String regionUuid, String projectUuid, List<String> uuidList, int start) {
            this.regionUuid = regionUuid;
            this.projectUuid = projectUuid;
            this.uuidList = uuidList;
            this.start = start;
        }

        @Override
        protected List<OpenStackVolume> compute() {
            ArrayList<OpenStackVolume> volumeList = new ArrayList<OpenStackVolume>();
            if (this.start >= 0) {
                OpenStackVolume tempOpenStackVolume = ((IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class)).querySingleVolumeByUuid(this.regionUuid, this.projectUuid, this.uuidList.get(this.start));
                if (!VerifyUtil.isEmpty((Object)tempOpenStackVolume)) {
                    volumeList.add(tempOpenStackVolume);
                }
            } else {
                ArrayList<OpenStackVolumeTask> openStackVolumeTasks = new ArrayList<OpenStackVolumeTask>();
                int size = this.uuidList.size();
                for (int i = 0; i < size; ++i) {
                    OpenStackVolumeTask processTask = new OpenStackVolumeTask(this.regionUuid, this.projectUuid, this.uuidList, i);
                    openStackVolumeTasks.add(processTask);
                    processTask.fork();
                }
                for (OpenStackVolumeTask openStackVmsTask : openStackVolumeTasks) {
                    volumeList.addAll((Collection)openStackVmsTask.join());
                }
            }
            return volumeList;
        }
    }
}

