/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.resource.authentication;

import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.resource.authentication.AuthenticationHelper;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.ism.drm.rest.client.util.ServiceResponse;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class CertificateCache {
    private static final Log LOG = LogFactory.getInstance(CertificateCache.class);
    private static final Object CERTIFICATE_LOCK = new Object();
    private static final int REST_STATUS_SUCCESS_CODE = 200;
    private static CertificateCache crtificateCache = new CertificateCache();
    private String certificate = "";
    private boolean needUpdate = true;

    public static CertificateCache getInstance() {
        return crtificateCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateCertificate(String url, String tokenId) {
        Object object = CERTIFICATE_LOCK;
        synchronized (object) {
            String certificateStr = this.sendGet(url, tokenId);
            if (VerifyUtil.isEmpty((String)certificateStr)) {
                return false;
            }
            if (!certificateStr.equals(this.certificate)) {
                this.certificate = certificateStr;
                LOG.info((Object)"Certificate has changed.");
                this.needUpdate = false;
                TokenUtil.getInstance().clearAllTokenCache();
            }
            LOG.info((Object)"Update certificate success.");
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCertificate() {
        Object object = CERTIFICATE_LOCK;
        synchronized (object) {
            if (VerifyUtil.isEmpty((String)this.certificate) || this.needUpdate) {
                OpenstackInfo open = AuthenticationHelper.getInstance().getOpenstackInfo();
                String urlStr = "https://" + open.getIp() + ":" + open.getPort() + OpenstackEnumDefine.RequestUrl.IAM_SIGNCA.getUri();
                String tokenId = TokenUtil.getInstance().getTokenId(open, null);
                this.updateCertificate(urlStr, tokenId);
            }
            return this.certificate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNeedUpdate(boolean needUpdate) {
        Object object = CERTIFICATE_LOCK;
        synchronized (object) {
            this.needUpdate = needUpdate;
        }
    }

    private String sendGet(String url, String tokenId) {
        try {
            AuthenticationHelper helper = AuthenticationHelper.getInstance();
            ServiceResponse response = helper.sendGet(url, helper.getHeaders(tokenId));
            if (200 == response.getStatusCode()) {
                return response.getResponseString();
            }
            LOG.error((Object)("UpdateCertificate sendGet failed:" + response.getStatusCode()));
        }
        catch (Exception e) {
            LOG.error((Object)("UpdateCertificate sendGet error:" + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return null;
    }
}

