/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.task;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.rollback.RollBackTaskManager;
import com.huawei.ism.drm.common.sdk.model.RollBackTaskInfo;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.manager.model.ReattchParam;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.protection.service.OpenstackPgRefreshServiceImpl;
import com.huawei.ism.drm.openstack.protection.service.ReattachProtectGroupVolumeBackTask;
import com.huawei.ism.drm.openstack.resource.OpenStackVmResRollBackExecutor;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.bo.ProtectedVolumeInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackConsts;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.msg.ReconnectVolumeInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCreateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicaSchedulerHintInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationInfo;
import com.huawei.ism.drm.openstack.sdk.service.IMeterService;
import com.huawei.ism.drm.openstack.sdk.service.IQuotaService;
import com.huawei.ism.drm.openstack.sdk.service.IScOperationService;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.openstack.serviceinstance.task.DrVolumeInfoAndHyperUUID;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.virtualization.sdk.service.IProtectGroupRefreshService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.TimeUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AddVolumesToVmBackTask
extends AbstractBackTask {
    private static final int DEFAULT_TIMEOUT = 7200;
    private static final Long WAITTIME = 0x6DDD00L;
    private static final Log LOG = LogFactory.getInstance(AddVolumesToVmBackTask.class);
    private String openstackUuid;
    private String regionUuid;
    private String drRegionUuid;
    private String projUuid;
    private String drProjUuid;
    private String cgUuid;
    private String drCgUuid;
    private String drAzName;
    private String replicaModel;
    private Set<ProtectedVolumeInfo> willAddVolumes;
    private Map<String, OpenStackVolume> volumesMapping = new HashMap<String, OpenStackVolume>();
    private Map<String, PoReplicaPairInfo> pairInfoMapping = new HashMap<String, PoReplicaPairInfo>();
    private Map<String, PoReplicaPairInfo> hyperMetroPairInfoMapping = new HashMap<String, PoReplicaPairInfo>();
    private PoReplicaInfo replicaInfo;
    private PoReplicaInfo replicaForRollBack;
    private String instanceId;
    private ProtectObject po;
    private String serverId;
    private ProtectGroup pg;
    private String serviceType;
    private IVolumeService volumeService;
    private IProtectGroupRefreshService pgRefreshService;
    private String proId;
    private String hyperCGUuid;
    private String hyperDrCGUuid;
    private String hyperRemoteCGUuid;
    private String hyperRemoteDrCGUuid;
    private PoReplicaInfo drHyperReplicaForRollBack;
    private PoReplicaInfo drHyperRemoteReplicaForRollBack;
    private PoReplicaInfo drHyperReplicaInfo;
    private PoReplicaInfo drHyperRemoteReplicaInfo;

    public AddVolumesToVmBackTask(String proId, String type, String instanceId, ProtectGroup pg, String serverId, Set<ProtectedVolumeInfo> addVolumes) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)pg.getName(), (String)"ism.drm.instance.add.volumes.tovm", (String)proId, (String)type, (String)"", (String[])new String[]{pg.getName()}), 7200, true);
        this.instanceId = instanceId;
        this.pg = pg;
        this.serverId = serverId;
        this.willAddVolumes = addVolumes;
        this.volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        this.pgRefreshService = new OpenstackPgRefreshServiceImpl();
        this.proId = proId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWork() {
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            IScOperationService scOperation = (IScOperationService)ServiceLocator.getInstance().getService(IScOperationService.class);
            scOperation.recordingOrder(this.getExtendParam());
        }
        this.checkQuota();
        try {
            ServiceInstanceHelper.getInstance().changeStatus(this.instanceId, ServiceInstaceEnumDefine.ServiceInstanceStatusE.LOCKED);
            boolean lockFlag = ProtectionJobUtil.getInstance().getLockPg(this.pg.getUuid());
            if (!lockFlag) {
                LOG.error((Object)("The pg is locked: " + this.pg.getUuid()), 90160758786893L);
                throw new LegoCheckedException(102401L);
            }
            this.pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(this.pg.getUuid(), false);
            IMeterService meterService = (IMeterService)ServiceLocator.getInstance().getService(IMeterService.class);
            Map meterInfos = meterService.calculateMeterInfos(this.pg);
            meterInfos.put("change_type", "inst_update");
            this.initParam();
            this.updateVolumes();
            this.reconnectVolumes();
            this.po.getProps().put("replicationInfo", JsonUtil.beanToJson(this.replicaInfo));
            if (this.is3DCInstance()) {
                this.po.getProps().put("hypermetor_replicationInfo", JsonUtil.beanToJson(this.drHyperReplicaInfo));
                this.po.getProps().put("remote_replicationInfo", JsonUtil.beanToJson(this.drHyperRemoteReplicaInfo));
            }
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)this.pg);
            this.reportMeter(meterService, meterInfos);
            this.handleLater();
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"Add volume to vm failed,", (Throwable)e);
            this.startRollBack();
            throw e;
        }
        catch (Exception e) {
            this.startRollBack();
            ExceptionUtil.rethrowException((Throwable)e, (String)"add volumes to vm failed", (long)0x300001L, (String[])new String[0], (Log)LOG);
        }
        finally {
            this.doWorkFinally();
        }
    }

    private void checkQuota() {
        OpenStackCommonUtil.checkPgVolumeCounts(this.pg.getUuid(), this.willAddVolumes.size());
        IQuotaService quotaService = (IQuotaService)ServiceLocator.getInstance().getService(IQuotaService.class);
        String result = quotaService.checkAddVolumesOutOfQuota(this.proId, this.pg, this.willAddVolumes);
        if (!VerifyUtil.isEmpty((String)result)) {
            String[] param = result.split(":");
            LOG.error((Object)("Add vols out of quota:pgName=" + this.pg.getName()));
            throw new LegoCheckedException(1073948125L, param, "add vols failed.");
        }
        if (!ServiceInstanceHelper.getInstance().getLock(this.instanceId)) {
            LOG.error((Object)("Not get this instance lock,instanceId:" + this.instanceId));
            throw new LegoCheckedException(1073948693L);
        }
    }

    private void reportMeter(IMeterService meterService, Map<String, Object> meterInfos) {
        ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)this.instanceId));
        meterInfos.put("meter_report_time", TimeUtil.getCurrentDate());
        meterService.reportChangedMeterInfo(this.regionUuid, instance, this.openstackUuid, meterInfos);
        meterService.reportChangedMeterInfo(this.drRegionUuid, instance, this.openstackUuid, meterInfos);
    }

    private void handleLater() {
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            OpenStackCommonUtil.putOrderResult(ServiceInstaceEnumDefine.ServiceInstanceOrderExecuteStatusE.SUCCESSED.getValue(), this.getExtendParam(), null, null);
        }
        if (OpenstackConsts.OPENSTACK_NEEDREATTACH_TYPES.contains(this.pg.getTemplate().getType())) {
            ReattachProtectGroupVolumeBackTask reattachTask = new ReattachProtectGroupVolumeBackTask(this.pg, "System");
            reattachTask.setTaskId(this.pg.getUuid() + "_reMappingVol");
            BackTaskHandler.getInstance().submitTask((AbstractBackTask)reattachTask);
        }
    }

    private void doWorkFinally() {
        ProtectionJobUtil.getInstance().releaseLockPg(this.pg.getUuid());
        this.refreshPg();
        ServiceInstanceHelper.getInstance().releaseLock(this.instanceId);
        try {
            ServiceInstanceHelper.getInstance().changeStatus(this.instanceId, ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL);
        }
        catch (Exception e) {
            LOG.error((Object)("Set instance(" + this.instanceId + ") normal error."), (Throwable)e);
        }
    }

    private void startRollBack() {
        if (null == this.replicaForRollBack || this.replicaForRollBack.getPairInfos().isEmpty()) {
            LOG.info((Object)"No replication to roll back");
            return;
        }
        LOG.info((Object)"Start to rollback:%s", new Object[]{JSONObject.fromObject((Object)this.replicaForRollBack)});
        RollBackTaskInfo taskInfo = new RollBackTaskInfo();
        taskInfo.setExecutor(OpenStackVmResRollBackExecutor.class.getSimpleName());
        JSONObject json = new JSONObject();
        json.put((Object)"operationType", (Object)OpenstackEnumDefine.RollbackOperationTypeE.MODIFY_VOLUME.getType());
        json.put((Object)"replicationInfo", (Object)JSONObject.fromObject((Object)this.replicaForRollBack));
        if (this.is3DCInstance()) {
            json.put((Object)"rollbackupside", (Object)"hypermetorside");
            json.put((Object)"remote_replicationInfo", (Object)JSONObject.fromObject((Object)this.drHyperRemoteReplicaForRollBack));
            json.put((Object)"hypermetor_replicationInfo", (Object)JSONObject.fromObject((Object)this.drHyperReplicaForRollBack));
            json.put((Object)"prodRingID", this.pg.getProps().get("prodRingID"));
            json.put((Object)"standbyDRRingUuid", this.pg.getProps().get("standbyDRRingUuid"));
            json.put((Object)"hyperDRRingID", this.pg.getProps().get("hyperDRRingID"));
            json.put((Object)"template", (Object)this.pg.getTemplate().getType());
            json.pick(this.pg.getProps(), new String[]{"projectId", "drProjectId", "regionId", "drRegionId"});
        }
        taskInfo.setExecuteParam(json.toString());
        taskInfo.setTaskId(this.replicaForRollBack.getMoUuid());
        taskInfo.setAlarmId(Long.valueOf(52625448L));
        taskInfo.setSourceUuid(OpenStackCommonUtil.getOpenstackUuidFromStr(this.replicaForRollBack.getProjUuid()));
        taskInfo.setSourceType(FaultEnum.AlarmResourceType.NETWORKENTITY.getValue());
        taskInfo.setAlarmParam(this.replicaForRollBack.getVmName());
        taskInfo.setTargetName(this.replicaForRollBack.getVmName());
        RollBackTaskManager.getInstance().addTask(taskInfo, true);
    }

    private void reconnectVolumes() {
        if (!OpenstackConsts.OPENSTACK_NEEDREATTACH_TYPES.contains(this.pg.getTemplate().getType())) {
            LOG.info((Object)"This serviceInstanse type is not hypermetro, instance_id is %s", new Object[]{this.instanceId});
            return;
        }
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(this.openstackUuid);
        String vmUuid = OpenStackCommonUtil.getObjectUuid(this.openstackUuid, this.serverId);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(this.regionUuid, this.projUuid);
        for (ProtectedVolumeInfo protectedVolume : this.willAddVolumes) {
            String volumeUuid = protectedVolume.getVolumeId();
            String volumeId = OpenStackCommonUtil.getIdFromUuid(volumeUuid);
            if (!this.volumeService.isAttachVM(this.regionUuid, this.projUuid, vmUuid, volumeId)) continue;
            ReconnectVolumeInfo reconnVolumeInfo = new ReconnectVolumeInfo();
            reconnVolumeInfo.setVolumeId(volumeId);
            reconnVolumeInfo.setIsHyperMetro(Boolean.valueOf(true));
            novaMgr.reattachVolume(new ReattchParam(this.regionUuid, this.projUuid, tokenId), vmUuid, reconnVolumeInfo);
        }
    }

    private void refreshPg() {
        try {
            if (!VerifyUtil.isEmpty((Object)this.pgRefreshService)) {
                this.pgRefreshService.refreshProtectGroup(this.pg);
            }
        }
        catch (Exception e) {
            LOG.error((Object)(this.pg.getName() + "refresh failed:" + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    private void initParam() {
        this.projUuid = (String)this.pg.getProps().get("projectId");
        this.drProjUuid = (String)this.pg.getProps().get("drProjectId");
        this.regionUuid = (String)this.pg.getProps().get("regionId");
        this.drRegionUuid = (String)this.pg.getProps().get("drRegionId");
        this.cgUuid = (String)this.pg.getProps().get("replicaCgUuid");
        this.drCgUuid = (String)this.pg.getProps().get("drReplicaCgUuid");
        if (this.pg.getTemplate().getType() == 34 || this.pg.getTemplate().getType() == 37) {
            this.hyperCGUuid = (String)this.pg.getProps().get("hyperProCgUuid");
            this.hyperDrCGUuid = (String)this.pg.getProps().get("hyperProdrCgUuid");
            this.hyperRemoteCGUuid = (String)this.pg.getProps().get("hyperProRemoteCgUuid");
            this.hyperRemoteDrCGUuid = (String)this.pg.getProps().get("hyperProRemotedrCgUuid");
        }
        this.drAzName = (String)this.pg.getProps().get("drZoneName");
        this.replicaModel = this.getReplicaModel(this.pg.getTemplate().getType());
        this.openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(this.regionUuid);
        this.volumesMapping = this.getAddVolumesMapping();
        this.po = this.getPoByServerId();
        this.initReplicaInfo();
    }

    private String getReplicaModel(int type) {
        String ret = "";
        switch (type) {
            case 22: {
                ret = "async";
                break;
            }
            case 21: {
                ret = "sync";
                break;
            }
            case 25: {
                ret = "hypermetro";
                break;
            }
            case 29: {
                ret = "hypermetro";
                break;
            }
            case 34: {
                ret = "async";
                break;
            }
            case 37: {
                ret = "async";
                break;
            }
            default: {
                LOG.error((Object)("Not support templateType,type=" + type));
            }
        }
        return ret;
    }

    private Map<String, OpenStackVolume> getAddVolumesMapping() {
        if (VerifyUtil.isEmpty(this.willAddVolumes)) {
            return new HashMap<String, OpenStackVolume>();
        }
        ArrayList<String> volumeUuids = new ArrayList<String>();
        for (ProtectedVolumeInfo volumeInfo : this.willAddVolumes) {
            volumeUuids.add(volumeInfo.getVolumeId());
        }
        List addVolumesList = this.volumeService.queryVolumesByUuid(this.regionUuid, this.projUuid, volumeUuids, false);
        HashMap<String, OpenStackVolume> result = new HashMap<String, OpenStackVolume>();
        for (OpenStackVolume vol : addVolumesList) {
            result.put(vol.getUuid(), vol);
        }
        return result;
    }

    private void updateVolumes() {
        HashSet<String> srcReplicaUuids = new HashSet<String>();
        HashSet<String> drReplicaUuids = new HashSet<String>();
        HashMap<String, VolumeInfo> srcUuidToDrVolumeInfo = new HashMap<String, VolumeInfo>();
        LOG.info((Object)"Start to update vols, protectGroup name=%s", new Object[]{this.pg.getName()});
        String replicaStatus = this.queryActiveReplicaStatus();
        for (ProtectedVolumeInfo volumeInfo : this.willAddVolumes) {
            String drVolumeType = volumeInfo.getDrVolumeType();
            OpenStackVolume srcVolume = this.volumesMapping.get(volumeInfo.getVolumeId());
            PoReplicaPairInfo pairInfo = this.pairInfoMapping.get(volumeInfo.getVolumeId());
            if (null == srcVolume || null == pairInfo) {
                LOG.error((Object)("SrcVolume/pairInfo parameter illegal, volumeId=" + volumeInfo.getVolumeId()));
                throw new LegoCheckedException(0x300001L);
            }
            this.replicaForRollBack.getPairInfos().add(pairInfo);
            VolumeInfo drVolume = this.createDrVolume(srcVolume, pairInfo, drVolumeType);
            if (null == drVolume) {
                LOG.error((Object)("Create dr volume failed:src volumeName=" + srcVolume.getName()));
                throw new LegoCheckedException(0x300001L);
            }
            pairInfo.setDrVolumeUuid(OpenStackCommonUtil.getObjectUuid(this.openstackUuid, drVolume.getId()));
            if (!OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue().equals(replicaStatus)) {
                this.doUpdateVolume(srcVolume, drVolume, pairInfo, srcReplicaUuids, drReplicaUuids, false);
            }
            srcUuidToDrVolumeInfo.put(volumeInfo.getVolumeId(), drVolume);
        }
        if (!OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue().equals(replicaStatus)) {
            OpenStackCommonUtil.switchAllRing(this.pg, false);
            this.updateVolumeReplicationCG(srcReplicaUuids, this.cgUuid, true);
            this.updateVolumeReplicationCG(drReplicaUuids, this.drCgUuid, false);
        }
        if (this.is3DCInstance()) {
            this.updateVolumeForCSDRVHA(srcUuidToDrVolumeInfo, replicaStatus);
        }
    }

    private String queryActiveReplicaStatus() {
        if (this.is3DCInstance()) {
            String replicaStatus = OpenStackCommonUtil.getRealTimeCGReplicaStatus(this.pg);
            LOG.info((Object)"Add volume vha+csdr first cg replication status :%s", new Object[]{replicaStatus});
            ArrayList<String> allowRepStatus = new ArrayList<String>();
            allowRepStatus.add(OpenstackEnumDefine.ReplicationRepStatusE.ACTIVE.getValue());
            allowRepStatus.add(OpenstackEnumDefine.ReplicationRepStatusE.COPYING.getValue());
            allowRepStatus.add(OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue());
            if (!allowRepStatus.contains(replicaStatus)) {
                LOG.error((Object)("Add volume first cg replication error: replication status:" + replicaStatus));
                throw new LegoCheckedException(1073948462L);
            }
            return replicaStatus;
        }
        return null;
    }

    private void doUpdateVolume(OpenStackVolume srcVolume, VolumeInfo drVolume, PoReplicaPairInfo pairInfo, Set<String> srcReplicaUuids, Set<String> drReplicaUuids, boolean isSetStandby) {
        VolumeReplicationInfo newSrcReplicaInfo = this.createReplication(srcVolume, drVolume, true, isSetStandby);
        pairInfo.setReplicaUuid(OpenStackCommonUtil.getObjectUuid(this.openstackUuid, newSrcReplicaInfo.getId()));
        srcReplicaUuids.add(newSrcReplicaInfo.getId());
        HashMap<String, String> metadataMap = new HashMap<String, String>();
        metadataMap.put("occupied_volume", "false");
        this.volumeService.updateVolumeMetadata(OpenStackCommonUtil.getIdFromUuid(srcVolume.getUuid()), metadataMap, this.regionUuid, this.projUuid);
        if ("hypermetro".equals(this.replicaModel)) {
            this.updateDrVolumeMetadata(drVolume);
        }
        VolumeReplicationInfo newDrReplicaInfo = this.createReplication(srcVolume, drVolume, false, isSetStandby);
        pairInfo.setDrReplicaUuid(OpenStackCommonUtil.getObjectUuid(this.openstackUuid, newDrReplicaInfo.getId()));
        drReplicaUuids.add(newDrReplicaInfo.getId());
        pairInfo.setVolumeStatus(OpenstackEnumDefine.VolProtectStatusE.PROTECTED.getStatus());
        this.addUsedStorageInfo(srcVolume);
        this.volumeService.reserveVolume(drVolume.getId(), this.drRegionUuid, this.drProjUuid);
    }

    private void updateVolumeReplicationCG(Set<String> replicaUuids, String optCgUuid, boolean isMaster) {
        if (isMaster) {
            this.volumeService.updateVolumeReplicationCG(this.regionUuid, this.projUuid, optCgUuid, replicaUuids, null);
        } else if ("hypermetro".equals(this.replicaModel) && this.is3DCInstance()) {
            this.volumeService.updateVolumeReplicationCG(this.regionUuid, this.projUuid, optCgUuid, replicaUuids, null);
        } else {
            this.volumeService.updateVolumeReplicationCG(this.drRegionUuid, this.drProjUuid, optCgUuid, replicaUuids, null);
        }
    }

    private void updateVolumeForCSDRVHA(Map<String, VolumeInfo> srcUuidToDrVolumeInfo, String replicaStatus) {
        HashSet<String> srcHyperReplicaUuids = new HashSet<String>();
        HashSet<String> drHyperReplicaUuids = new HashSet<String>();
        HashSet<String> hyperDRVolumeUuids = new HashSet<String>();
        HashMap<String, String> srcUuidTodrHyperUuid = new HashMap<String, String>();
        ArrayList<PoReplicaPairInfo> hyperReplicaPairInfoList = new ArrayList<PoReplicaPairInfo>();
        this.replicaModel = "hypermetro";
        LOG.info((Object)"Start to update csdr+vha/csdr+csha hypermetro vols");
        for (ProtectedVolumeInfo volumeInfo : this.willAddVolumes) {
            OpenStackVolume srcVolume = this.volumesMapping.get(volumeInfo.getVolumeId());
            String drVolumeType = volumeInfo.getDrHyperVolumeType();
            if (null == srcVolume || VerifyUtil.isEmpty((String)drVolumeType)) {
                LOG.error((Object)("SrcVolume/drVolumeType parameter illegal, volumeId=" + volumeInfo.getVolumeId()));
                throw new LegoCheckedException(0x300001L);
            }
            PoReplicaPairInfo hyperPairInfo = this.getHyperMetroPairInfo(volumeInfo.getVolumeId(), srcVolume, drVolumeType);
            hyperPairInfo.setSize(srcVolume.getSize().intValue());
            this.drHyperReplicaForRollBack.getPairInfos().add(hyperPairInfo);
            this.addHyperReplicaPairInfo(hyperReplicaPairInfoList, hyperPairInfo, volumeInfo);
            VolumeInfo drHyperVolume = this.createDrVolume(srcVolume, hyperPairInfo, drVolumeType);
            if (null == drHyperVolume) {
                LOG.error((Object)("Create dr drHyperVolume failed:src volumeName=" + srcVolume.getName()));
                throw new LegoCheckedException(0x300001L);
            }
            hyperPairInfo.setDrVolumeUuid(OpenStackCommonUtil.getObjectUuid(this.openstackUuid, drHyperVolume.getId()));
            this.createHyperSrcReplication(srcHyperReplicaUuids, srcVolume, hyperPairInfo, drHyperVolume);
            HashMap<String, String> metadataMap = new HashMap<String, String>();
            metadataMap.put("occupied_volume", "false");
            this.volumeService.updateVolumeMetadata(OpenStackCommonUtil.getIdFromUuid(srcVolume.getUuid()), metadataMap, this.regionUuid, this.projUuid);
            this.updateDrVolumeMetadata(drHyperVolume);
            this.createHyperDrReplication(drHyperReplicaUuids, srcVolume, hyperPairInfo, drHyperVolume);
            hyperPairInfo.setVolumeStatus(OpenstackEnumDefine.VolProtectStatusE.PROTECTED.getStatus());
            this.addUsedStorageInfo(srcVolume);
            this.volumeService.reserveVolume(drHyperVolume.getId(), this.regionUuid, this.projUuid);
            String drHyperVolumeUuid = OpenStackCommonUtil.getObjectUuid(this.openstackUuid, drHyperVolume.getId());
            hyperDRVolumeUuids.add(drHyperVolumeUuid);
            srcUuidTodrHyperUuid.put(volumeInfo.getVolumeId(), drHyperVolumeUuid);
        }
        if (OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue().equals(replicaStatus)) {
            OpenStackCommonUtil.switchAllRing(this.pg, false);
        }
        this.updateVolumeReplicationCG(srcHyperReplicaUuids, this.hyperCGUuid, true);
        this.updateVolumeReplicationCG(drHyperReplicaUuids, this.hyperDrCGUuid, false);
        this.updateVolumeForStandByCSDRVHA(hyperDRVolumeUuids, new DrVolumeInfoAndHyperUUID(srcUuidTodrHyperUuid, srcUuidToDrVolumeInfo), hyperReplicaPairInfoList, replicaStatus);
    }

    private void createHyperDrReplication(Set<String> drHyperReplicaUuids, OpenStackVolume srcVolume, PoReplicaPairInfo hyperPairInfo, VolumeInfo drHyperVolume) {
        VolumeReplicationInfo newHyperDrReplicaInfo = this.createReplication(srcVolume, drHyperVolume, false, false);
        hyperPairInfo.setDrReplicaUuid(OpenStackCommonUtil.getObjectUuid(this.openstackUuid, newHyperDrReplicaInfo.getId()));
        drHyperReplicaUuids.add(newHyperDrReplicaInfo.getId());
    }

    private void createHyperSrcReplication(Set<String> srcHyperReplicaUuids, OpenStackVolume srcVolume, PoReplicaPairInfo hyperPairInfo, VolumeInfo drHyperVolume) {
        VolumeReplicationInfo newHyperSrcReplicaInfo = this.createReplication(srcVolume, drHyperVolume, true, false);
        hyperPairInfo.setReplicaUuid(OpenStackCommonUtil.getObjectUuid(this.openstackUuid, newHyperSrcReplicaInfo.getId()));
        srcHyperReplicaUuids.add(newHyperSrcReplicaInfo.getId());
    }

    private void updateVolumeForStandByCSDRVHA(Set<String> hyperDRVolumeUuids, DrVolumeInfoAndHyperUUID drVolumeInfoAndHyperUUID, List<PoReplicaPairInfo> hyperReplicaPairInfoList, String replicaStatus) {
        HashMap<String, OpenStackVolume> drHyperUuidToOpenStackVol = new HashMap<String, OpenStackVolume>();
        HashSet<String> srcRemoteReplicaUuids = new HashSet<String>();
        HashSet<String> drRemoteReplicaUuids = new HashSet<String>();
        ArrayList<PoReplicaPairInfo> hyperRemoteReplicaPairInfoList = new ArrayList<PoReplicaPairInfo>();
        List hyperDrVolumesList = this.volumeService.queryVolumesByUuid(this.regionUuid, this.projUuid, new ArrayList<String>(hyperDRVolumeUuids), false);
        for (OpenStackVolume vol : hyperDrVolumesList) {
            drHyperUuidToOpenStackVol.put(vol.getUuid(), vol);
        }
        this.replicaModel = "async";
        LOG.info((Object)"Start to update csdr+vha standby vols");
        for (ProtectedVolumeInfo volumeInfo : this.willAddVolumes) {
            OpenStackVolume srcVolume = (OpenStackVolume)drHyperUuidToOpenStackVol.get(drVolumeInfoAndHyperUUID.getSrcUuidTodrHyperUuid().get(volumeInfo.getVolumeId()));
            VolumeInfo drVolume = drVolumeInfoAndHyperUUID.getSrcUuidToDrVolumeInfo().get(volumeInfo.getVolumeId());
            if (srcVolume == null || drVolume == null) {
                LOG.error((Object)("SrcVolume/drVolume parameter illegal, volumeId=" + volumeInfo.getVolumeId()));
                throw new LegoCheckedException(0x300001L);
            }
            PoReplicaPairInfo hyperRemotePairInfo = new PoReplicaPairInfo(srcVolume.getUuid(), srcVolume.getName(), srcVolume.getVolType(), drVolume.getVolumeType());
            hyperRemotePairInfo.setSize(srcVolume.getSize().intValue());
            hyperRemotePairInfo.setDrVolumeUuid(OpenStackCommonUtil.getObjectUuid(this.openstackUuid, drVolume.getId()));
            this.drHyperRemoteReplicaForRollBack.getPairInfos().add(hyperRemotePairInfo);
            hyperRemoteReplicaPairInfoList.add(hyperRemotePairInfo);
            this.createHyperRemoteReplication(replicaStatus, srcRemoteReplicaUuids, srcVolume, drVolume, hyperRemotePairInfo);
            HashMap<String, String> metadataMap = new HashMap<String, String>();
            metadataMap.put("occupied_volume", "false");
            this.volumeService.updateVolumeMetadata(OpenStackCommonUtil.getIdFromUuid(srcVolume.getUuid()), metadataMap, this.regionUuid, this.projUuid);
            this.createHyperRemoteDrReplication(replicaStatus, drRemoteReplicaUuids, srcVolume, drVolume, hyperRemotePairInfo);
            hyperRemotePairInfo.setVolumeStatus(OpenstackEnumDefine.VolProtectStatusE.PROTECTED.getStatus());
            this.volumeService.reserveVolume(drVolume.getId(), this.drRegionUuid, this.drProjUuid);
        }
        this.updateActiceSideVolume(replicaStatus, drVolumeInfoAndHyperUUID.getSrcUuidToDrVolumeInfo());
        OpenStackCommonUtil.switchAllRing(this.pg, true);
        this.drHyperReplicaInfo.getPairInfos().addAll(hyperReplicaPairInfoList);
        this.drHyperRemoteReplicaInfo.getPairInfos().addAll(hyperRemoteReplicaPairInfoList);
    }

    private void createHyperRemoteDrReplication(String replicaStatus, Set<String> drRemoteReplicaUuids, OpenStackVolume srcVolume, VolumeInfo drVolume, PoReplicaPairInfo hyperRemotePairInfo) {
        VolumeReplicationInfo newHyperRemoteDrReplicaInfo = OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue().equals(replicaStatus) ? this.createReplication(srcVolume, drVolume, false, false) : this.createReplication(srcVolume, drVolume, false, true);
        hyperRemotePairInfo.setDrReplicaUuid(OpenStackCommonUtil.getObjectUuid(this.openstackUuid, newHyperRemoteDrReplicaInfo.getId()));
        drRemoteReplicaUuids.add(newHyperRemoteDrReplicaInfo.getId());
        this.updateVolumeReplicationCG(drRemoteReplicaUuids, this.hyperRemoteDrCGUuid, false);
    }

    private void createHyperRemoteReplication(String replicaStatus, Set<String> srcRemoteReplicaUuids, OpenStackVolume srcVolume, VolumeInfo drVolume, PoReplicaPairInfo hyperRemotePairInfo) {
        VolumeReplicationInfo newHyperRemoteSrcReplicaInfo = OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue().equals(replicaStatus) ? this.createReplication(srcVolume, drVolume, true, false) : this.createReplication(srcVolume, drVolume, true, true);
        hyperRemotePairInfo.setReplicaUuid(OpenStackCommonUtil.getObjectUuid(this.openstackUuid, newHyperRemoteSrcReplicaInfo.getId()));
        srcRemoteReplicaUuids.add(newHyperRemoteSrcReplicaInfo.getId());
        this.updateVolumeReplicationCG(srcRemoteReplicaUuids, this.hyperRemoteCGUuid, true);
    }

    private void addHyperReplicaPairInfo(List<PoReplicaPairInfo> hyperReplicaPairInfoList, PoReplicaPairInfo hyperPairInfo, ProtectedVolumeInfo volumeInfo) {
        if (!this.hyperMetroPairInfoMapping.containsKey(volumeInfo.getVolumeId())) {
            hyperReplicaPairInfoList.add(hyperPairInfo);
        }
    }

    private PoReplicaPairInfo getHyperMetroPairInfo(String volumeId, OpenStackVolume srcVolume, String drVolumeType) {
        if (this.hyperMetroPairInfoMapping.containsKey(volumeId)) {
            return this.hyperMetroPairInfoMapping.get(volumeId);
        }
        return new PoReplicaPairInfo(srcVolume.getUuid(), srcVolume.getName(), srcVolume.getVolType(), drVolumeType);
    }

    private void updateActiceSideVolume(String replicaStatus, Map<String, VolumeInfo> srcUuidToDrVolumeInfo) {
        if (OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue().equals(replicaStatus)) {
            HashSet<String> srcReplicaUuids = new HashSet<String>();
            HashSet<String> drReplicaUuids = new HashSet<String>();
            for (ProtectedVolumeInfo volumeInfo : this.willAddVolumes) {
                OpenStackVolume srcVolume = this.volumesMapping.get(volumeInfo.getVolumeId());
                PoReplicaPairInfo pairInfo = this.pairInfoMapping.get(volumeInfo.getVolumeId());
                if (null == srcVolume || null == pairInfo) {
                    LOG.error((Object)("SrcVolume/pairInfo parameter illegal, volumeId=" + volumeInfo.getVolumeId()));
                    throw new LegoCheckedException(0x300001L);
                }
                VolumeInfo drVolume = srcUuidToDrVolumeInfo.get(volumeInfo.getVolumeId());
                this.doUpdateVolume(srcVolume, drVolume, pairInfo, srcReplicaUuids, drReplicaUuids, true);
                this.updateVolumeReplicationCG(srcReplicaUuids, this.cgUuid, true);
                this.updateVolumeReplicationCG(drReplicaUuids, this.drCgUuid, false);
            }
        }
    }

    private synchronized void addUsedStorageInfo(OpenStackVolume volume) {
        LOG.info((Object)"Enter addUsedStorageInfo, poname=%s", new Object[]{this.po.getName()});
        String bootDevName = (String)this.po.getProps().get("VM_ROOT_DEVNAME_KEY");
        String deviceName = "";
        volume.generateAttachmentInfo();
        for (Object attachment : volume.getAttachments()) {
            if (!this.po.getMoUuid().equals(attachment.getVmUuid())) continue;
            deviceName = attachment.getDevice();
            if (VerifyUtil.isEmpty((String)deviceName)) {
                LOG.error((Object)("DeviceName is empty : " + volume.getUuid()));
                throw new LegoCheckedException(0x300001L);
            }
            if (!deviceName.equals(bootDevName)) break;
            this.po.getProps().put("VM_BOOTABLE_VOLUME", volume.getUuid());
            break;
        }
        Set oldStorages = this.po.getUsedStorageResourceSet();
        for (ProtectObjectStorageInfo info : oldStorages) {
            if (!volume.getUuid().equals(info.getResourceId())) continue;
            info.setDeviceName(deviceName);
            info.setResourceName(volume.getName());
            LOG.info((Object)"The device Name has add.");
            return;
        }
        ProtectObjectStorageInfo storage = new ProtectObjectStorageInfo();
        storage.setId(UUIDGenerator.getUUID());
        storage.setResourceName(volume.getName());
        storage.setLunWWN(volume.getUuid());
        storage.setResourceId(volume.getUuid());
        storage.setResourceProviderSN(OpenStackCommonUtil.getOpenstackUuidFromStr(volume.getUuid()));
        storage.setDeviceName(deviceName);
        this.po.addHostStorageResourceInfo(storage);
    }

    private VolumeInfo createDrVolume(OpenStackVolume srcVolume, PoReplicaPairInfo pairInfo, String drVolumeType) {
        VolumeInfo drVolume;
        String drVolumeUuid = pairInfo.getDrVolumeUuid();
        LOG.info((Object)"Add volume to vm task, drvolume uuid : %s", new Object[]{drVolumeUuid});
        if (VerifyUtil.isEmpty((String)drVolumeUuid)) {
            if ("hypermetro".equals(this.replicaModel) && this.is3DCInstance()) {
                VolumeCreateInfo createVolume = new VolumeCreateInfo();
                createVolume = OpenStackCommonUtil.setDrVolumeMode(srcVolume, createVolume);
                createVolume.setProjectId(this.projUuid);
                createVolume.setSize(srcVolume.getSize().intValue());
                String drVolumeName = OpenStackCommonUtil.getNameBySuff(srcVolume.getName(), "-DR");
                createVolume.setName(drVolumeName);
                if (this.pg.getTemplate().getType() == 37) {
                    createVolume.setAzName((String)this.pg.getProps().get("prod_region_drZoneName"));
                } else {
                    createVolume.setAzName((String)this.pg.getProps().get("zoneName"));
                }
                createVolume.setVolTypeName(drVolumeType);
                createVolume.setShareable(srcVolume.getShareable());
                drVolume = this.volumeService.createVolume(srcVolume.getVolumeDriverMetadata(), createVolume, this.regionUuid, this.projUuid, srcVolume.getBootable().booleanValue());
            } else {
                VolumeCreateInfo createVolume = new VolumeCreateInfo();
                createVolume = OpenStackCommonUtil.setDrVolumeMode(srcVolume, createVolume);
                createVolume.setProjectId(this.drProjUuid);
                createVolume.setSize(srcVolume.getSize().intValue());
                String drVolumeName = OpenStackCommonUtil.getNameBySuff(srcVolume.getName(), "-DR");
                createVolume.setName(drVolumeName);
                createVolume.setAzName(this.drAzName);
                createVolume.setVolTypeName(drVolumeType);
                createVolume.setShareable(srcVolume.getShareable());
                drVolume = this.volumeService.createVolume(srcVolume.getVolumeDriverMetadata(), createVolume, this.drRegionUuid, this.drProjUuid, srcVolume.getBootable().booleanValue());
            }
            pairInfo.setDrVolumeUuid(OpenStackCommonUtil.getObjectUuid(this.openstackUuid, drVolume.getId()));
            pairInfo.setDrVolumeType(drVolumeType);
            pairInfo.setSize(srcVolume.getSize().intValue());
        } else {
            drVolume = "hypermetro".equals(this.replicaModel) && this.is3DCInstance() ? this.volumeService.queryVolumeInfoByUuid(this.regionUuid, this.projUuid, drVolumeUuid) : this.volumeService.queryVolumeInfoByUuid(this.drRegionUuid, this.drProjUuid, drVolumeUuid);
        }
        return drVolume;
    }

    private boolean is3DCInstance() {
        return 34 == this.pg.getTemplate().getType() || 37 == this.pg.getTemplate().getType();
    }

    private VolumeReplicationInfo createReplication(OpenStackVolume volume, VolumeInfo drVolume, boolean isMaster, boolean isSetStandby) {
        String remoteDriverData;
        String localDriverData;
        String replicaName;
        String volumeId;
        String azName;
        VolumeReplicaSchedulerHintInfo scheduleInfo;
        if (isMaster) {
            scheduleInfo = this.volumeService.getSchedulerHintInfoFromVolumeType(volume.getVolType(), this.regionUuid, this.projUuid);
            azName = volume.getAz();
            volumeId = OpenStackCommonUtil.getIdFromUuid(volume.getUuid());
            replicaName = "replica_" + volume.getName();
            localDriverData = volume.getReplicaDriverData();
            remoteDriverData = drVolume.getReplicaDriverData();
        } else if (this.is3DCInstance() && "hypermetro".equals(this.replicaModel)) {
            scheduleInfo = this.volumeService.getSchedulerHintInfoFromVolumeType(drVolume.getVolumeType(), this.regionUuid, this.projUuid);
            azName = volume.getAz();
            volumeId = drVolume.getId();
            replicaName = "replica_" + drVolume.getName();
            localDriverData = drVolume.getReplicaDriverData();
            remoteDriverData = volume.getReplicaDriverData();
        } else {
            scheduleInfo = this.volumeService.getSchedulerHintInfoFromVolumeType(drVolume.getVolumeType(), this.drRegionUuid, this.drProjUuid);
            azName = this.drAzName;
            volumeId = drVolume.getId();
            replicaName = "replica_" + drVolume.getName();
            localDriverData = drVolume.getReplicaDriverData();
            remoteDriverData = volume.getReplicaDriverData();
        }
        VolumeReplicationInfo replicaCreateInfo = new VolumeReplicationInfo();
        replicaCreateInfo.setAzName(azName);
        replicaCreateInfo.setReplicaModel(this.replicaModel);
        replicaCreateInfo.setVolumeId(volumeId);
        replicaCreateInfo.setLocalReplicationDriverData(localDriverData);
        replicaCreateInfo.setRemoteReplicationDriverData(remoteDriverData);
        replicaCreateInfo.setName(replicaName);
        replicaCreateInfo.setMasterFlag(isMaster);
        replicaCreateInfo.setSchedulerHint(scheduleInfo);
        return this.getVolumeReplicationInfo(isMaster, isSetStandby, replicaCreateInfo);
    }

    private VolumeReplicationInfo getVolumeReplicationInfo(boolean isMaster, boolean isSetStandby, VolumeReplicationInfo replicaCreateInfo) {
        if (isSetStandby) {
            replicaCreateInfo.setIsStandby(Boolean.TRUE.toString());
        }
        if (isMaster) {
            return this.volumeService.createVolReplica(replicaCreateInfo, this.regionUuid, this.projUuid);
        }
        if ("hypermetro".equals(this.replicaModel) && (this.pg.getTemplate().getType() == 34 || this.pg.getTemplate().getType() == 37)) {
            return this.volumeService.createVolReplica(replicaCreateInfo, this.regionUuid, this.projUuid);
        }
        return this.volumeService.createVolReplica(replicaCreateInfo, this.drRegionUuid, this.drProjUuid);
    }

    private void updateDrVolumeMetadata(VolumeInfo drVolumeInfo) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("__system__hypermetro", "true");
        try {
            if (this.is3DCInstance() && "hypermetro".equals(this.replicaModel)) {
                this.volumeService.updateVolumeMetadata(drVolumeInfo.getId(), metadata, this.regionUuid, this.projUuid);
            } else {
                this.volumeService.updateVolumeMetadata(drVolumeInfo.getId(), metadata, this.drRegionUuid, this.drProjUuid);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to update drVolume metadata, volumeID=" + drVolumeInfo.getId() + ", ProtectGroup Name=" + this.pg.getName()));
            throw e;
        }
    }

    private void initReplicaInfo() {
        String replicaStr = (String)this.po.getProps().get("replicationInfo");
        this.replicaInfo = JsonUtil.jsonToBean(replicaStr, PoReplicaInfo.class);
        if (null == this.replicaInfo) {
            LOG.error((Object)("Convert string to bean failed:repliaStr=" + replicaStr));
            throw new LegoCheckedException(1073947393L);
        }
        for (Object pairInfo : this.replicaInfo.getPairInfos()) {
            this.pairInfoMapping.put(pairInfo.getVolumeUuid(), (PoReplicaPairInfo)pairInfo);
        }
        this.replicaForRollBack = JsonUtil.jsonToBean(replicaStr, PoReplicaInfo.class);
        this.replicaForRollBack.getPairInfos().clear();
        if (this.is3DCInstance()) {
            String drHyperReplicaStr = (String)this.po.getProps().get("hypermetor_replicationInfo");
            this.drHyperReplicaInfo = JsonUtil.jsonToBean(drHyperReplicaStr, PoReplicaInfo.class);
            if (null == this.drHyperReplicaInfo) {
                LOG.error((Object)("Convert string to bean failed:drHyperRepliaStr=" + drHyperReplicaStr));
                throw new LegoCheckedException(1073947393L);
            }
            for (PoReplicaPairInfo pairInfo : this.drHyperReplicaInfo.getPairInfos()) {
                this.hyperMetroPairInfoMapping.put(pairInfo.getVolumeUuid(), pairInfo);
            }
            this.drHyperReplicaForRollBack = JsonUtil.jsonToBean(drHyperReplicaStr, PoReplicaInfo.class);
            this.drHyperReplicaForRollBack.getPairInfos().clear();
            String drHyperRemoteReplicaStr = (String)this.po.getProps().get("remote_replicationInfo");
            this.drHyperRemoteReplicaInfo = JsonUtil.jsonToBean(drHyperRemoteReplicaStr, PoReplicaInfo.class);
            if (null == this.drHyperRemoteReplicaInfo) {
                LOG.error((Object)("Convert string to bean failed:drHyperRemoteRepliaStr=" + drHyperRemoteReplicaStr));
                throw new LegoCheckedException(1073947393L);
            }
            this.drHyperRemoteReplicaForRollBack = JsonUtil.jsonToBean(drHyperRemoteReplicaStr, PoReplicaInfo.class);
            this.drHyperRemoteReplicaForRollBack.getPairInfos().clear();
        }
    }

    private ProtectObject getPoByServerId() {
        for (ProtectObject tempPo : this.pg.getPolist()) {
            if (!tempPo.getMoUuid().contains(this.serverId)) continue;
            return tempPo;
        }
        LOG.error((Object)("Cant find po by serverId:serverId=" + this.serverId));
        throw new LegoCheckedException(1073947393L);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public ProtectGroup getPg() {
        return this.pg;
    }

    public void setPg(ProtectGroup pg) {
        this.pg = pg;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public IVolumeService getVolumeService() {
        return this.volumeService;
    }

    public void setVolumeService(IVolumeService volumeService) {
        this.volumeService = volumeService;
    }

    public IProtectGroupRefreshService getPgRefreshService() {
        return this.pgRefreshService;
    }

    public void setPgRefreshService(IProtectGroupRefreshService pgRefreshService) {
        this.pgRefreshService = pgRefreshService;
    }

    protected void processFailure() {
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            OpenStackCommonUtil.putOrderResult(ServiceInstaceEnumDefine.ServiceInstanceOrderExecuteStatusE.FAILED.getValue(), this.getExtendParam(), this.getErrorCode(), this.getErrorParam());
        }
    }
}

