/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.task;

import com.huawei.ism.cbb.base.sdk.constant.CommonConstant;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.galax.recovery.common.RecoveryPlanUtil;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.openstack.sdk.msg.OrderInstanceInfo;
import com.huawei.ism.drm.openstack.sdk.service.IMeterService;
import com.huawei.ism.drm.openstack.sdk.service.IQuotaService;
import com.huawei.ism.drm.openstack.sdk.service.IScOperationService;
import com.huawei.ism.drm.openstack.sdk.service.IServiceInstanceService;
import com.huawei.ism.drm.openstack.serviceinstance.ProtectExecutingVmsQueue;
import com.huawei.ism.drm.openstack.serviceinstance.task.ServiceInstanceReplicationSyncTask;
import com.huawei.ism.drm.openstack.tools.OpenStackCheckPhVmUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.service.IBackTaskService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.TimeUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class CreateInstanceTask
extends AbstractBackTask {
    private static final Log LOG = LogFactory.getInstance(CreateInstanceTask.class);
    private static final int DEFAULT_TIMEOUT = 2147483;
    private static final int CREATE_PG_TIMEOUT = 2147468;
    private static final List<String> HAVE_RECOVERY_PLAN_INSTANCE_TYPE_LIST = Arrays.asList(ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue(), ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO.getValue(), ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue(), ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue());
    private static final int MONITORINTERVAL = 10;
    private ProtectGroup pg;
    private String proId;
    private ServiceInstanceReplicationSyncTask serviceInstanceReplicationSyncTask;

    public CreateInstanceTask(String proId, String type, ProtectGroup pg, ServiceInstanceReplicationSyncTask serviceInstanceReplicationSyncTask) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)pg.getName(), (String)"ism.drm.instance.create", (String)proId, (String)type, (String)"", null), 2147483, true);
        this.pg = pg;
        this.proId = proId;
        this.serviceInstanceReplicationSyncTask = serviceInstanceReplicationSyncTask;
    }

    protected void doWork() {
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            IScOperationService scOperation = (IScOperationService)ServiceLocator.getInstance().getService(IScOperationService.class);
            scOperation.recordingOrder(this.getExtendParam());
        }
        IServiceInstanceService instService = (IServiceInstanceService)ServiceLocator.getInstance().getService(IServiceInstanceService.class);
        instService.checkCreateInstanceParam(this.pg);
        OpenStackCommonUtil.checkPgVolumeCounts(this.pg, 0);
        OpenStackCommonUtil.checkPgVmCounts(this.pg, 0);
        OpenStackCheckPhVmUtil.checkPhVmsAndRun(this.pg.getPolist(), this::work);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void work() {
        IQuotaService quotaService = (IQuotaService)ServiceLocator.getInstance().getService(IQuotaService.class);
        String result = quotaService.checkCreateInstanceOutOfQuota(this.proId, this.pg);
        if (!VerifyUtil.isEmpty((String)result)) {
            String[] para = result.split(":");
            LOG.error((Object)("Create instance out of quota:pgName=" + this.pg.getName()));
            throw new LegoCheckedException(1073948125L, para, "Create instance failed.");
        }
        ILicenseControl licenseControl = (ILicenseControl)ServiceLocator.getInstance().getService(ILicenseControl.class);
        licenseControl.checkEnablePgCount(this.pg);
        String instanceUuid = UUIDGenerator.getUUID();
        this.pg.getProps().put("SERVICEINSTANCE_UUID", instanceUuid);
        String regionId = this.pg.getProperty("regionId");
        ArrayList poVmids = new ArrayList();
        try {
            this.pg.getPolist().stream().forEach(po -> {
                String poVmId = CommUtil.combineString((String[])new String[]{regionId, OpenStackCommonUtil.getIdFromUuid(po.getMoUuid())});
                if (ProtectExecutingVmsQueue.isContainVm(poVmId)) {
                    LOG.info((Object)"ProtectExecutingVmsQueue has poVmId:%s", new Object[]{poVmId});
                    return;
                }
                poVmids.add(poVmId);
                ProtectExecutingVmsQueue.offer(poVmId);
            });
            IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
            long createPgTaskId = pgService.createProtectGroup(this.pg, false);
            if (!this.monitorTaskResult(createPgTaskId)) {
                LOG.error((Object)("Create protectgroup failed:pgName=" + this.pg.getName()));
                throw new LegoCheckedException(1073948104L, "Create instance failed.");
            }
        }
        finally {
            poVmids.stream().forEach(poVmid -> ProtectExecutingVmsQueue.remove(poVmid));
        }
        String type = (String)this.pg.getProps().get("serviceInstanceType");
        String planId = null;
        if (HAVE_RECOVERY_PLAN_INSTANCE_TYPE_LIST.contains(type)) {
            planId = RecoveryPlanUtil.createRecoveryPlan((ProtectGroup)this.pg, (String)ServiceInstaceEnumDefine.ObjectType.ECS_BMS.getValue());
            LOG.debug((Object)"Create recoveyplan successfully,planId=%s", new Object[]{planId});
            OpenStackCommonUtil.updateRecoverySetting(planId, this.pg.getPolist());
        }
        ServiceInstance instance = this.getServiceInstance(instanceUuid, type, planId);
        this.serviceInstanceReplicationSyncTask.add(instanceUuid);
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            OrderInstanceInfo order = (OrderInstanceInfo)this.getExtendParam().get("order_instinfo");
            order.setInstanceId(instance.getId());
            OpenStackCommonUtil.putOrderResult(ServiceInstaceEnumDefine.ServiceInstanceOrderExecuteStatusE.SUCCESSED.getValue(), this.getExtendParam(), null, null);
        }
    }

    private ServiceInstance getServiceInstance(String instanceUuid, String type, String planId) {
        ServiceInstance instance = new ServiceInstance();
        instance.setDescription(this.pg.getDescription());
        instance.setName(this.pg.getName());
        instance.setOwnerId(this.pg.getOwnerId());
        instance.setStatus(ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL.getValue());
        String projectUuid = (String)this.pg.getProps().get("projectId");
        String projectId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        instance.setProjectId(projectId);
        instance.setProtectGroupId(this.pg.getUuid());
        instance.setRecoveryPlanId(planId);
        instance.setUuid(instanceUuid);
        instance.setCreateTime(Long.valueOf(new Date().getTime()));
        instance.setObjectType(ServiceInstaceEnumDefine.ObjectType.ECS_BMS.getValue());
        instance.setStartPriority(3);
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue().equals(type)) {
            instance.setType(ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue());
            instance.setProtectType("vha_csdr");
        } else if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue().equals(type)) {
            instance.setType(ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue());
            instance.setProtectType("csha_csdr");
        } else {
            instance.setType(type);
            instance.setProtectType(type);
        }
        this.saveServiceInstance(instance);
        return instance;
    }

    private void saveServiceInstance(ServiceInstance instance) {
        try {
            LOG.debug((Object)"Start save ServiceInstance.ServiceInstanceName=%s, ServiceInstanceID=%s,protectGroupID=%s", new Object[]{instance.getName(), instance.getId(), instance.getProtectGroupId()});
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)instance);
            String regionUuid = (String)this.pg.getProps().get("regionId");
            String drRegionUuid = (String)this.pg.getProps().get("drRegionId");
            String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
            IMeterService meterService = (IMeterService)ServiceLocator.getInstance().getService(IMeterService.class);
            Map meterInfos = meterService.calculateMeterInfos(this.pg);
            meterInfos.put("change_type", "inst_create");
            meterInfos.put("meter_report_time", TimeUtil.getCurrentDate());
            meterService.reportChangedMeterInfo(regionUuid, instance, openstackUuid, meterInfos);
            meterService.reportChangedMeterInfo(drRegionUuid, instance, openstackUuid, meterInfos);
            LOG.debug((Object)"End save ServiceInstance.ServiceInstanceName=%s, ServiceInstanceID=%s,protectGroupID=%s", new Object[]{instance.getName(), instance.getId(), instance.getProtectGroupId()});
        }
        catch (Exception e) {
            LOG.error((Object)("Create instance error." + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(1073948104L, "create instance error.", (Throwable)e);
        }
    }

    private boolean monitorTaskResult(long taskId) {
        int times;
        IBackTaskService taskService = (IBackTaskService)ServiceLocator.getInstance().getService(IBackTaskService.class);
        BackTask task = taskService.readTask(taskId);
        if (null == task) {
            return false;
        }
        for (times = 214746; times > 0; --times) {
            CommUtil.pauseThread((long)10000L);
            task = taskService.readTask(taskId);
            if (CommonConstant.BACKTASK_RESULT_FAIL != task.getTaskResult()) continue;
            LOG.error((Object)("The task result is fail,targetName=" + task.getTargetName() + ",reTryTimes=" + (214746 - times)));
            OpenStackCommonUtil.throwTaskError(task);
            return false;
        }
        LOG.error((Object)("The task is timeout,taskId=" + taskId + "" + task.getTargetName() + ",reTryTimes=" + (214746 - times)));
        return false;
    }

    protected void processFailure() {
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            OrderInstanceInfo order = (OrderInstanceInfo)this.getExtendParam().get("order_instinfo");
            order.setInstanceId((String)this.pg.getProps().get("SERVICEINSTANCE_UUID"));
            OpenStackCommonUtil.putOrderResult(ServiceInstaceEnumDefine.ServiceInstanceOrderExecuteStatusE.FAILED.getValue(), this.getExtendParam(), this.getErrorCode(), this.getErrorParam());
        }
    }
}

