/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.task;

import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.service.IMeterService;
import com.huawei.ism.drm.openstack.sdk.service.IQuotaService;
import com.huawei.ism.drm.openstack.sdk.service.IScOperationService;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.serviceinstance.task.base.AbstractDeleteInstanceTask;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Map;

public class DeleteInstanceTask
extends AbstractDeleteInstanceTask {
    private static final Log LOG = LogFactory.getInstance(DeleteInstanceTask.class);

    public DeleteInstanceTask(String proId, String type, String instanceId, String instanceName) {
        super(proId, type, instanceId, instanceName);
    }

    @Override
    protected void checkInstanceBeforeDeleteInstance(ServiceInstance instance) {
        this.checkVolSnapshots(instance);
    }

    @Override
    protected void deleteOtherRecoveryPlan(ServiceInstance instance) {
    }

    @Override
    protected void handleHighThan63() {
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            IScOperationService scOperation = (IScOperationService)ServiceLocator.getInstance().getService(IScOperationService.class);
            scOperation.recordingOrder(this.getExtendParam());
            IQuotaService quotaService = (IQuotaService)ServiceLocator.getInstance().getService(IQuotaService.class);
            String quotas = quotaService.calculateDeleteInstanceQuota(this.instanceId);
            Map param = this.getExtendParam();
            param.put("order_quotas", quotas);
            this.setExtendParam(param);
        }
    }

    @Override
    protected Map<String, Object> calcMeterBeforeUpdate(ServiceInstance instance, IMeterService meterService) {
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
        Map meterInfos = meterService.calculateMeterInfos(pg);
        meterInfos.put("change_type", "inst_delete");
        meterInfos.put("meter_pg", pg);
        return meterInfos;
    }

    private void checkVolSnapshots(ServiceInstance instance) {
        if (VerifyUtil.isEmpty((Object)instance)) {
            LOG.error((Object)"CheckVolSnapshots failed, instance is null");
            return;
        }
        String pgId = instance.getProtectGroupId();
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup pg = pgService.getProtectGroupBasicInfo(pgId, true);
        if (null == pg) {
            LOG.error((Object)"CheckVolSnapshots failed, pg is null,instance ID=%s,instance name=%s", new Object[]{instance.getId(), instance.getName()});
            return;
        }
        ArrayList<String> volumesId = new ArrayList<String>();
        ArrayList<String> volumesDRHyperMetorId = new ArrayList<String>();
        for (ProtectObject po : pg.getPolist()) {
            PoReplicaInfo poHyperMetorReplicaInfo;
            String replicationHyperMetorInfo;
            String replicationInfo = (String)po.getProps().get("replicationInfo");
            PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class);
            if (null != poReplicaInfo && !poReplicaInfo.getPairInfos().isEmpty()) {
                for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
                    String volId = OpenStackCommonUtil.getIdFromUuid(pairInfo.getDrVolumeUuid());
                    LOG.debug((Object)"Check volume snapshots.instance ID=%s,instance name=%s,remotevol id is: %s,producerVolid: %s", new Object[]{instance.getId(), instance.getName(), volId, OpenStackCommonUtil.getIdFromUuid(pairInfo.getVolumeUuid())});
                    volumesId.add(volId);
                }
            }
            if (VerifyUtil.isEmpty((String)(replicationHyperMetorInfo = (String)po.getProps().get("hypermetor_replicationInfo"))) || null == (poHyperMetorReplicaInfo = JsonUtil.jsonToBean(replicationHyperMetorInfo, PoReplicaInfo.class)) || poHyperMetorReplicaInfo.getPairInfos().isEmpty()) continue;
            for (PoReplicaPairInfo pairInfo : poHyperMetorReplicaInfo.getPairInfos()) {
                String volId = OpenStackCommonUtil.getIdFromUuid(pairInfo.getDrVolumeUuid());
                LOG.debug((Object)"Check volume snapshots.instance ID=%s,instance name=%s,hypermetor remotevol id: %s,producerVolid: %s", new Object[]{instance.getId(), instance.getName(), volId, OpenStackCommonUtil.getIdFromUuid(pairInfo.getVolumeUuid())});
                volumesDRHyperMetorId.add(volId);
            }
        }
        IVolumeService volService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        volService.checkVolumesExitSnapshots((String)pg.getProps().get("drRegionId"), (String)pg.getProps().get("drProjectId"), volumesId);
        volService.checkVolumesExitSnapshots((String)pg.getProps().get("regionId"), (String)pg.getProps().get("projectId"), volumesDRHyperMetorId);
    }
}

