/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.task;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.drm.openstack.adapter.util.ClientUtil;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.resource.authentication.AuthenticationHelper;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.ism.drm.openstack.serviceinstance.SDRRegisterHelper;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.om.meter.dao.impl.MeterDaoImpl;
import java.util.HashMap;

public class RegisterSDRTask
extends AbstractBackTask {
    private static final String IP_KEY = "float_ip";
    private static final String SDR_PATH = "https://float_ip:9443/sdr/v1/meter/plugin/add";
    private static final Log LOG = LogFactory.getInstance(RegisterSDRTask.class);
    private final String regionId;
    private final String floatIp;
    private final String serviceName;

    public RegisterSDRTask(String regionId, String floatIp, String serviceName) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)regionId, (String)"ism.drm.openstack.sdr.register", (String)"System", (String)"", null), true);
        this.regionId = regionId;
        this.floatIp = floatIp;
        this.serviceName = serviceName;
    }

    protected void doWork() {
        LOG.info((Object)"Registering SDR plugin task begin: %s", new Object[]{this.regionId});
        OpenstackInfo open = AuthenticationHelper.getInstance().getOpenstackInfo();
        String tokenId = TokenUtil.getInstance().getTokenId(open, null);
        String domain = LegoConfig.getInstance().getKeyValue("config.dr.domain");
        String dataResource = "https://" + domain + ":9443/ws/bcs/" + this.regionId + "/meter/" + this.serviceName + "?limit={0}&marker={1}&start_time={2}&end_time={3}";
        String url = SDR_PATH.replace(IP_KEY, this.floatIp);
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put("generationDelayTime", 900000);
        bodyMap.put("cycleTime", 3600000);
        bodyMap.put("regionId", this.regionId);
        bodyMap.put("service", this.serviceName);
        bodyMap.put("resourceType", this.serviceName);
        bodyMap.put("className", "CommonPluginImpl");
        bodyMap.put("enable", "true");
        bodyMap.put("dataSource", dataResource);
        bodyMap.put("version", "v2");
        bodyMap.put("limit", 1000);
        bodyMap.put("folder", this.serviceName);
        bodyMap.put("meterId", this.serviceName);
        String respStr = ClientUtil.sendPostRequest(url, JsonUtil.beanToJson(bodyMap), tokenId);
        LOG.info((Object)"Result of registering SDR plugin: %s", new Object[]{respStr});
        MeterDaoImpl meterDao = new MeterDaoImpl();
        meterDao.saveSDRRegion(this.regionId);
        SDRRegisterHelper.getInstance().registerSuccess(this.regionId);
    }
}

