/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.system.kms;

import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.resource.authentication.AuthenticationHelper;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.ism.drm.wcc.rest.client.RestClient;
import com.huawei.ism.drm.wcc.util.kms.IamAccessMgr;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Optional;

public class KmsProjectTask
implements SystemStatusChangedListener {
    private static final Log LOG = LogFactory.getInstance(KmsProjectTask.class);

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED) {
            LOG.info((Object)"Start check project_svc exist.");
            Optional projectToken = IamAccessMgr.getToken();
            if (projectToken.isPresent()) {
                LOG.info((Object)"Project_svc exist.");
                return;
            }
            try {
                OpenstackInfo open = AuthenticationHelper.getInstance().getOpenstackInfo();
                String tokenId = TokenUtil.getInstance().getTokenId(open, null);
                RestClient client = new RestClient(open.getIp(), open.getPort());
                String projectId = IamAccessMgr.createProject((RestClient)client, (String)tokenId);
                LOG.info((Object)"Create project_svc success. Project ID:%s", new Object[]{projectId});
            }
            catch (Exception e) {
                LOG.error((Object)"Create project_svc failed. Error:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
    }
}

