/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.system.unitepassword.task;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.drm.openstack.adapter.util.ClientUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.resource.authentication.AuthenticationHelper;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.ism.drm.system.thirdservice.sdk.model.Account;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.nodeagent.thrift.Command;
import com.huawei.nodeagent.thrift.Node;
import com.huawei.nodeagent.thrift.NodeAgentLocalService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UnitePasswordModifyPasswordBackTask
extends AbstractBackTask {
    private static final Log logger = LogFactory.getInstance(UnitePasswordModifyPasswordBackTask.class);
    private static final String MODIFY = "modify";
    private IUserMgr mgr = (IUserMgr)ServiceLocator.getBundleService((String)"user", (String)"usermgr");
    private Account account;
    private NodeAgentLocalService.Iface client;

    public UnitePasswordModifyPasswordBackTask(Account account, BackTask backTask, NodeAgentLocalService.Iface client) {
        super(account.getTaskId(), backTask, true);
        this.account = account;
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWork() {
        if ("DRManager".equals(this.account.getAccountName()) || "root".equals(this.account.getAccountName())) {
            boolean isSuccessful = false;
            try {
                ArrayList<Node> modifyNodeList = new ArrayList<Node>();
                List allNodes = this.client.getNodeList();
                for (Node node : allNodes) {
                    if (!node.addresses.contains(this.account.getIp())) continue;
                    modifyNodeList.add(node);
                    break;
                }
                ArrayList<String> params = new ArrayList<String>();
                params.add(MODIFY);
                params.add(this.account.getAccountName());
                params.add(this.account.getPasswd());
                params.add(this.account.getOldPasswd());
                Map responsesMap = this.client.execute(new Command("manage_passwd").setParams(params), modifyNodeList, null);
                isSuccessful = responsesMap.values().stream().allMatch(response -> response.code == 0L);
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"UnitePassword modify %s password failed!, exception is %s", new Object[]{this.account.getAccountName(), ExceptionUtil.getErrorMessage((Throwable)e)});
                    isSuccessful = false;
                }
                catch (Throwable throwable) {
                    logger.info((Object)"modify %s password result is %s", new Object[]{this.account.getAccountName(), isSuccessful});
                    UnitePasswordModifyPasswordBackTask.recordResult(this.account.getTaskId(), isSuccessful);
                    logger.info((Object)"Successful record modify %s password task result,", new Object[]{this.account.getAccountName()});
                    throw throwable;
                }
                logger.info((Object)"modify %s password result is %s", new Object[]{this.account.getAccountName(), isSuccessful});
                UnitePasswordModifyPasswordBackTask.recordResult(this.account.getTaskId(), isSuccessful);
                logger.info((Object)"Successful record modify %s password task result,", new Object[]{this.account.getAccountName()});
            }
            logger.info((Object)"modify %s password result is %s", new Object[]{this.account.getAccountName(), isSuccessful});
            UnitePasswordModifyPasswordBackTask.recordResult(this.account.getTaskId(), isSuccessful);
            logger.info((Object)"Successful record modify %s password task result,", new Object[]{this.account.getAccountName()});
        }
    }

    protected static void recordResult(String taskId, boolean isSuccessful) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"taskId", (Object)taskId);
        if (isSuccessful) {
            jsonObject.put((Object)"taskStatus", (Object)"1");
        } else {
            jsonObject.put((Object)"taskStatus", (Object)"2");
            jsonObject.put((Object)"errMsg", (Object)"Password modify failed");
        }
        ArrayList<JSONObject> resultList = new ArrayList<JSONObject>();
        resultList.add(jsonObject);
        String urlStr = LegoConfig.getInstance().getKeyValue("config.hcs.er.om.float");
        if (VerifyUtil.isEmpty((String)urlStr)) {
            logger.error((Object)"OpenStack Unite Password modify failed, server urlStr is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        OpenstackInfo open = AuthenticationHelper.getInstance().getOpenstackInfo();
        String tokenId = TokenUtil.getInstance().getTokenId(open, null);
        String fullUrl = "https://" + urlStr + "/rest/mounpwdservice/v1/passwd/modification/status";
        logger.debug((Object)"Unite Password password modify report: fullUrl is : %s", new Object[]{fullUrl});
        String response = ClientUtil.sendPostRequest(fullUrl, ((Object)resultList).toString(), tokenId);
        logger.info((Object)"Unite Password Report response: %s", new Object[]{response});
    }
}

