/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.task;

import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.nodeagent.thrift.Command;
import com.huawei.nodeagent.thrift.Node;
import com.huawei.nodeagent.thrift.NodeAgentLocalService;
import com.huawei.nodeagent.thrift.Response;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.thrift.TException;

public class DrmSchedualerTask {
    private static final Log LOG = LogFactory.getInstance(DrmSchedualerTask.class);
    private NodeAgentLocalService.Iface client;
    private final int paramNum = 5;

    public void ensureServerCpuMemSame() {
        try {
            List nodes = this.client.getNodeList();
            Map responsesMap = this.client.execute(new Command("query_cpu_mem"), nodes, null);
            responsesMap.values().stream().forEach(response -> LOG.debug((Object)"ensureServerCpuMemSame response msg:%s", new Object[]{JsonUtil.beanToJson(response)}));
            TreeMap<String, String> cpuMemMap = new TreeMap<String, String>();
            String standardCpuMem = null;
            for (Map.Entry item : responsesMap.entrySet()) {
                if (item == null || item.getKey() == null || item.getValue() == null) continue;
                Node itemKey = (Node)item.getKey();
                Response itemValue = (Response)item.getValue();
                if (itemValue.code != 0L || itemValue.getDetails() == null) continue;
                cpuMemMap.put((String)itemKey.getAddresses().get(0), itemValue.getDetails());
                standardCpuMem = itemValue.getDetails();
            }
            if (VerifyUtil.isEmpty(cpuMemMap) || cpuMemMap.size() < nodes.size()) {
                LOG.error((Object)"cpuMemMap size:%d, nodes.size:%d", new Object[]{cpuMemMap.size(), nodes.size()});
                return;
            }
            boolean isSame = true;
            for (String i : cpuMemMap.values()) {
                if (standardCpuMem == null || standardCpuMem.equals(i)) continue;
                isSame = false;
                break;
            }
            String[] params = this.generateParam(cpuMemMap);
            if (isSame) {
                AlarmReporter.restoreAlarm((long)52625512L, (String[])params);
            } else {
                LOG.info((Object)"ensureServerCpuMemSame send alarm,params:%s", new Object[]{JsonUtil.beanToJson(params)});
                AlarmReporter.sendNoRepeatAlarm((long)52625512L, null, (String)FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])params);
            }
        }
        catch (TException e) {
            LOG.error((Object)"getRemoteNodeList error, msg:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    private String[] generateParam(Map<String, String> cpuMemMap) {
        StringBuffer sb = new StringBuffer();
        sb.append(Long.toHexString(52625512L));
        sb.append(",");
        if (!VerifyUtil.isEmpty(cpuMemMap)) {
            for (Map.Entry<String, String> item : cpuMemMap.entrySet()) {
                sb.append(item.getKey());
                sb.append(",");
            }
        }
        String[] tmpResult = sb.toString().trim().split(",");
        for (int i = tmpResult.length; i < 5; ++i) {
            sb.append("NA,");
        }
        return sb.toString().trim().split(",");
    }

    public void setClient(NodeAgentLocalService.Iface client) {
        this.client = client;
    }
}

