/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cipher;

import com.huawei.cipher.KmcUtil;
import com.huawei.cipher.WccUtil;
import com.huawei.kmc.common.AppException;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import com.huawei.signer.EncryptFile;
import com.huawei.signer.FileSigner;
import com.huawei.signer.FileUtil;
import com.huawei.signer.ProperUtil;
import com.huawei.util.ExceptionUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.SAXException;

public class EncryptedPropertiesHandler {
    private static final Log LOG = LogFactory.getInstance(EncryptedPropertiesHandler.class);
    private static final String KMC_PRE = "AAAAAg";
    private static final String KMC_HMAC_PRE = "AAAAAgAAAAE";
    private static final String WCC_PRE = "d2Nj";
    private static final String PROPERTIES = "kmcUpgradeConf.properties";
    private static final String CONFIG_FILE = "/Runtime/bin/config/conf/config.properties";
    private static final String SYSCONFIG_SPLIT = "=";
    private static final String BACK_SQL_SPLIT = "\t";
    private List<EncryptFile> fileList;
    private Map<String, String> sysConfigMaps;
    private ProperUtil encryptProperties = new ProperUtil();
    private String installedPath;
    private String currentPath;

    public EncryptedPropertiesHandler(String installedConf, String currentConf) {
        this.encryptProperties.getEncryptedProperties(PROPERTIES);
        WccUtil.initWccConfig(installedConf);
        this.initKmcWithPath(currentConf);
        this.installedPath = installedConf;
        this.currentPath = currentConf;
        this.fileList = this.encryptProperties.getUtilList();
        this.sysConfigMaps = new HashMap<String, String>();
    }

    private void initKmcWithPath(String path) {
        KmcUtil.initKmc(path, this.encryptProperties);
    }

    public void updateEncryptedProperties(String installPath) throws Exception {
        this.scanFileToUpdateEncryptedProperties(installPath, HandleType.UPGRADE);
    }

    public void updateEncryptedPropertiesFromKmc(String installPath) throws Exception {
        KmcUtil.refreshCryptoConf();
        this.initKmcWithPath(this.installedPath);
        this.scanFileToUpdateEncryptedProperties(installPath, HandleType.BEFORE_IMPORT);
        KmcUtil.refreshCryptoConf();
        this.initKmcWithPath(this.currentPath);
        this.scanFileToUpdateEncryptedProperties(installPath, HandleType.AFTER_IMPORT);
    }

    public void updateEncrypedPropertiesCipher(String currentPath) throws Exception {
        this.scanFileToUpdateEncryptedProperties(currentPath, HandleType.CHANGE_CIPHER);
        this.changePropertiesSign(currentPath);
    }

    private void changePropertiesSign(String currentPath) {
        String configPath = currentPath + CONFIG_FILE;
        try (FileInputStream inputStream = new FileInputStream(FilenameUtils.normalize((String)configPath));){
            int len;
            byte[] buf = new byte[1024];
            StringBuilder sb = new StringBuilder();
            while ((len = ((InputStream)inputStream).read(buf)) != -1) {
                sb.append(new String(buf, 0, len, StandardCharsets.UTF_8));
            }
            String hash = KmcUtil.sign(sb.toString());
            FileSigner signTool = new FileSigner();
            signTool.writeHashToSign(configPath, hash);
        }
        catch (AppException | IOException e) {
            LOG.error((Object)"sign file [ %s ] failed.", configPath);
        }
    }

    private void scanFileToUpdateEncryptedProperties(String installPath, HandleType handle_type) throws Exception {
        if (this.fileList == null || this.fileList.isEmpty()) {
            LOG.error((Object)"fileList is null, return");
            return;
        }
        for (EncryptFile fileUtil : this.fileList) {
            String fileName = fileUtil.getFileName();
            String keyName = fileUtil.getKeyName();
            LOG.info((Object)String.format(Locale.ROOT, "Processing (%s) file: %s", handle_type.name(), fileName));
            if (fileName.endsWith(".xml")) {
                String nodeValue = fileUtil.getNodeValue();
                this.updateXmlFile(handle_type, installPath + fileName, nodeValue, keyName);
            }
            if (fileName.endsWith(".properties")) {
                this.updatePropertiesFile(handle_type, installPath + fileName, keyName);
            }
            if (!fileName.endsWith(".key")) continue;
            this.updateKeyFile(handle_type, installPath + fileName, keyName);
        }
    }

    private void updateKeyFile(HandleType handle_type, String filePath, String keyWord) {
        Path path = Paths.get(FilenameUtils.normalize((String)filePath), new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            LOG.error((Object)"File is not exist.");
            return;
        }
        try {
            String cipherText = new String(Files.readAllBytes(path));
            switch (handle_type) {
                case BEFORE_IMPORT: {
                    this.sysConfigMaps.putIfAbsent(keyWord, KmcUtil.decrypt(cipherText));
                    break;
                }
                case AFTER_IMPORT: {
                    String oldValue = this.sysConfigMaps.get(keyWord);
                    if (!StringUtils.isNotEmpty((CharSequence)oldValue)) break;
                    cipherText = KmcUtil.encrypt(oldValue);
                    break;
                }
                case CHANGE_CIPHER: {
                    cipherText = KmcUtil.encrypt(KmcUtil.decrypt(cipherText));
                }
            }
            Files.write(path, Collections.singletonList(cipherText), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (AppException | IOException e) {
            LOG.error((Object)String.format(Locale.ENGLISH, "Update file cipher failed. Error:%s", ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    public void updateSqlData(String sqlFilePath) throws Exception {
        this.scanFileToUpdateEncryptedSql(sqlFilePath, HandleType.UPGRADE);
    }

    public void updateSqlDataFromKmc(String sqlFilePath) throws Exception {
        KmcUtil.refreshCryptoConf();
        this.initKmcWithPath(this.installedPath);
        this.scanFileToUpdateEncryptedSql(sqlFilePath, HandleType.BEFORE_IMPORT);
        KmcUtil.refreshCryptoConf();
        this.initKmcWithPath(this.currentPath);
        this.scanFileToUpdateEncryptedSql(sqlFilePath, HandleType.AFTER_IMPORT);
    }

    private void scanFileToUpdateEncryptedSql(String sqlFilePath, HandleType handleType) throws IOException, AppException {
        LineIterator sqlLineIterator = FileUtils.lineIterator((File)new File(sqlFilePath), (String)StandardCharsets.UTF_8.name());
        String filePathTmp = sqlFilePath + ".tmp";
        BufferedWriter filePathTmpBw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePathTmp), StandardCharsets.UTF_8));
        while (sqlLineIterator.hasNext()) {
            String line = sqlLineIterator.next();
            if (line != null && line.contains(BACK_SQL_SPLIT) && (line.contains(WCC_PRE) || line.contains(KMC_PRE))) {
                String newLine = this.getSqlNewLine(handleType, line);
                filePathTmpBw.write(newLine);
                filePathTmpBw.newLine();
                continue;
            }
            filePathTmpBw.write(line);
            filePathTmpBw.newLine();
        }
        this.closeFile(sqlLineIterator, filePathTmpBw);
        if (handleType.value != HandleType.BEFORE_IMPORT.value) {
            new File(sqlFilePath).delete();
            FileUtils.moveFile((File)new File(filePathTmp), (File)new File(sqlFilePath));
        }
    }

    private String getSqlNewLine(HandleType handleType, String line) throws AppException {
        String[] wccStrs;
        String newLine = line;
        block5: for (String value : wccStrs = line.split(BACK_SQL_SPLIT)) {
            if (StringUtils.isEmpty((CharSequence)value)) continue;
            switch (handleType) {
                case UPGRADE: {
                    if (!value.startsWith(WCC_PRE)) continue block5;
                    newLine = newLine.replace(value, KmcUtil.encrypt(WccUtil.decrypt(value)));
                    continue block5;
                }
                case BEFORE_IMPORT: {
                    if (!value.startsWith(KMC_PRE) || value.startsWith(KMC_HMAC_PRE) || this.sysConfigMaps.containsKey(value)) continue block5;
                    this.sysConfigMaps.put(value, KmcUtil.decrypt(value));
                    continue block5;
                }
                case AFTER_IMPORT: {
                    String oldValue = this.sysConfigMaps.get(value);
                    if (!StringUtils.isNotEmpty((CharSequence)oldValue)) continue block5;
                    newLine = newLine.replace(value, KmcUtil.encrypt(oldValue));
                }
            }
        }
        return newLine;
    }

    public void beforeBackup(String path) throws Exception {
        if (this.fileList == null || this.fileList.isEmpty()) {
            LOG.error((Object)"fileList is null, return");
            return;
        }
        for (EncryptFile fileUtil : this.fileList) {
            String fileName = fileUtil.getFileName();
            String keyName = fileUtil.getKeyName();
            if (fileName.endsWith(".xml")) {
                String nodeValue = fileUtil.getNodeValue();
                this.updateXmlFile(HandleType.BEFORE_IMPORT, path + fileName, nodeValue, keyName);
            }
            if (fileName.endsWith(".properties")) {
                this.updatePropertiesFile(HandleType.BEFORE_IMPORT, path + fileName, keyName);
            }
            if (!fileName.endsWith(".key")) continue;
            this.updateKeyFile(HandleType.BEFORE_IMPORT, path + fileName, keyName);
        }
    }

    public void afterBackup(String path) throws Exception {
        if (this.fileList == null || this.fileList.isEmpty()) {
            LOG.error((Object)"fileList is null, return");
            return;
        }
        for (EncryptFile fileUtil : this.fileList) {
            String fileName = fileUtil.getFileName();
            String keyName = fileUtil.getKeyName();
            if (fileName.endsWith(".xml")) {
                String nodeValue = fileUtil.getNodeValue();
                this.updateXmlFile(HandleType.AFTER_IMPORT, path + fileName, nodeValue, keyName);
            }
            if (fileName.endsWith(".properties")) {
                this.updatePropertiesFile(HandleType.AFTER_IMPORT, path + fileName, keyName);
            }
            if (!fileName.endsWith(".key")) continue;
            this.updateKeyFile(HandleType.AFTER_IMPORT, path + fileName, keyName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateXmlFile(HandleType handleType, String xmlFile, String node, String key) throws IOException {
        File xml = new File(FilenameUtils.normalize((String)xmlFile));
        if (!xml.exists()) {
            LOG.error((Object)"File is not exists.");
            throw new IOException();
        }
        FileOutputStream fout = null;
        XMLWriter writer = null;
        SAXReader reader = new SAXReader();
        try {
            this.setSecurityFeatures(reader);
            Document document = reader.read(xml);
            List element = document.selectNodes(node);
            if (element == null) {
                LOG.error((Object)"select nodes failed.");
            }
            String[] keys = key.split(";");
            for (Node ele : element) {
                this.updateEncryptedNodes(handleType, keys, (Element)ele);
            }
            OutputFormat format = OutputFormat.createPrettyPrint();
            fout = new FileOutputStream(new File(xmlFile));
            writer = new XMLWriter((OutputStream)fout, format);
            writer.write(document);
            FileUtil.closeOutStream((FileOutputStream)fout, (XMLWriter)writer);
        }
        catch (Exception e) {
            LOG.error((Object)String.format(Locale.ROOT, "Update xmlFile failed, exception: %s", ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        finally {
            FileUtil.closeOutStream(fout, writer);
        }
    }

    private void updateEncryptedNodes(HandleType handleType, String[] keys, Element ele) throws AppException {
        for (int i = 0; i < keys.length; ++i) {
            String currentValue;
            String keyWord = keys[i];
            if (ele.attribute(keyWord) == null || "".equals(currentValue = ele.attribute(keyWord).getValue()) || currentValue == null) continue;
            this.updateEncryptedNodes(handleType, ele, keyWord, currentValue);
        }
    }

    private void setSecurityFeatures(SAXReader reader) throws SAXException {
        reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        reader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
    }

    private void updateEncryptedNodes(HandleType handleType, Element ele, String keyWord, String currentValue) throws AppException {
        switch (handleType) {
            case UPGRADE: {
                if (!currentValue.startsWith(WCC_PRE)) break;
                String decryptData = WccUtil.decrypt(currentValue);
                String kmcEcryptData = KmcUtil.encrypt(decryptData);
                ele.addAttribute(keyWord, kmcEcryptData);
                break;
            }
            case BEFORE_IMPORT: {
                if (!currentValue.startsWith(KMC_PRE) || this.sysConfigMaps.containsKey(currentValue)) break;
                this.sysConfigMaps.put(currentValue, KmcUtil.decrypt(currentValue));
                break;
            }
            case AFTER_IMPORT: {
                String oldValue = this.sysConfigMaps.get(currentValue);
                if (!StringUtils.isNotEmpty((CharSequence)oldValue)) break;
                ele.addAttribute(keyWord, KmcUtil.encrypt(oldValue));
                break;
            }
            case CHANGE_CIPHER: {
                ele.addAttribute(keyWord, KmcUtil.encrypt(KmcUtil.decrypt(currentValue)));
            }
        }
    }

    private void updatePropertiesFile(HandleType handleType, String file, String key) {
        Path filePath = Paths.get(FilenameUtils.normalize((String)file), new String[0]);
        if (!Files.exists(filePath, new LinkOption[0])) {
            LOG.error((Object)"The file is not exists.");
            return;
        }
        List keyMatchers = Arrays.stream(key.split(";")).map(pattern -> {
            if (pattern.contains("*")) {
                pattern = pattern.replaceAll("([.+?^$\\[\\](){}|\\\\/])", "\\\\$1");
                pattern = pattern.replace("*", "[^#\\s]*");
                pattern = "^" + pattern + "$";
                return Pattern.compile(pattern).asPredicate();
            }
            return pattern::equals;
        }).collect(Collectors.toList());
        try {
            List<String> fileLines = Files.readAllLines(filePath, StandardCharsets.UTF_8);
            ArrayList<String> newLines = new ArrayList<String>();
            for (String line : fileLines) {
                String value;
                if (StringUtils.isBlank((CharSequence)line) || !line.contains(SYSCONFIG_SPLIT)) {
                    newLines.add(line);
                    continue;
                }
                int splitIndex = line.indexOf(SYSCONFIG_SPLIT);
                String keyWord = line.substring(0, splitIndex);
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{keyWord, value = line.substring(splitIndex + 1)}) && keyMatchers.stream().anyMatch(matcher -> matcher.test(keyWord))) {
                    newLines.add(this.updateEncryptedValues(handleType, line, keyWord, value));
                    continue;
                }
                newLines.add(line);
            }
            Path tempFilePath = filePath.getParent().resolve("tmpConf.properties");
            Files.write(tempFilePath, newLines, StandardCharsets.UTF_8, new OpenOption[0]);
            if (handleType != HandleType.BEFORE_IMPORT) {
                Files.move(tempFilePath, filePath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            LOG.error((Object)"IO exception");
        }
        catch (AppException e) {
            LOG.error((Object)"Encrypt exception");
        }
    }

    private void closeFile(LineIterator lineIterator, BufferedWriter filePathTmpBw) throws IOException {
        if (lineIterator != null) {
            lineIterator.close();
        }
        if (filePathTmpBw != null) {
            filePathTmpBw.close();
        }
    }

    private String updateEncryptedValues(HandleType handleType, String newLine, String keyWord, String value) throws AppException {
        String result = newLine;
        switch (handleType) {
            case UPGRADE: {
                if (!value.startsWith(WCC_PRE)) break;
                String decryptDate = WccUtil.decrypt(value);
                String kmcEncryptDate = KmcUtil.encrypt(decryptDate);
                result = keyWord + SYSCONFIG_SPLIT + kmcEncryptDate;
                break;
            }
            case BEFORE_IMPORT: {
                if (!value.startsWith(KMC_PRE) || this.sysConfigMaps.containsKey(value)) break;
                String str = KmcUtil.decrypt(value);
                this.sysConfigMaps.put(value, str);
                break;
            }
            case AFTER_IMPORT: {
                String oldValue = this.sysConfigMaps.get(value);
                if (!StringUtils.isNotEmpty((CharSequence)oldValue)) break;
                String kmcEncryptDate = KmcUtil.encrypt(oldValue);
                result = keyWord + SYSCONFIG_SPLIT + kmcEncryptDate;
                break;
            }
            case CHANGE_CIPHER: {
                result = keyWord + SYSCONFIG_SPLIT + KmcUtil.encrypt(KmcUtil.decrypt(value));
            }
        }
        return result;
    }

    public static enum HandleType {
        UPGRADE(0),
        BEFORE_IMPORT(1),
        AFTER_IMPORT(2),
        CHANGE_CIPHER(3);

        private int value;

        private HandleType(int value) {
            this.value = value;
        }
    }
}

