/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cipher;

import com.huawei.cipher.KmcUtil;
import com.huawei.kmc.common.AppException;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import com.huawei.signer.FileSigner;
import com.huawei.signer.FileUtil;
import com.huawei.signer.ProperUtil;
import com.huawei.util.ExceptionUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;

public class FileSignHandler {
    private static final Log LOG = LogFactory.getInstance(FileSignHandler.class);
    private static final String SIGNFILE = "signFile";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSignHandler(String kmcConfPath, String installPath) {
        block8: {
            InputStream is = null;
            BufferedReader reader = null;
            try {
                ClassLoader clazzLoader = ProperUtil.class.getClassLoader();
                if (clazzLoader != null) {
                    is = clazzLoader.getResourceAsStream(SIGNFILE);
                }
                if (is != null) {
                    reader = new BufferedReader(new InputStreamReader(is));
                    ProperUtil properUtil = new ProperUtil();
                    properUtil.getEncryptedProperties(SIGNFILE);
                    KmcUtil.initKmc(kmcConfPath, properUtil);
                    this.signFile(installPath, reader);
                } else {
                    LOG.error((Object)"get resource failed.");
                }
                FileSignHandler.closeInputStream(is);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block8;
            }
            finally {
                FileSignHandler.closeInputStream(is);
                FileSignHandler.closeInputStream(reader);
            }
            FileSignHandler.closeInputStream(reader);
        }
    }

    private void signFile(String installPath, BufferedReader reader) throws IOException {
        String text;
        while ((text = reader.readLine()) != null) {
            if (FileUtil.isEmpty((String)text)) continue;
            if (text.startsWith(File.separator)) {
                FileSignHandler.signFile(text);
                continue;
            }
            FileSignHandler.signFile(installPath + text);
        }
    }

    private static void closeInputStream(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOG.error((Object)"close BufferedReader failed.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void signFile(String file) {
        FileInputStream input = null;
        try {
            input = new FileInputStream(FilenameUtils.normalize((String)file));
            byte[] bytes = new byte[((InputStream)input).available()];
            ((InputStream)input).read(bytes);
            String str = new String(bytes, Charset.defaultCharset());
            String hash = KmcUtil.sign(str);
            FileSigner signTool = new FileSigner();
            signTool.writeHashToSign(file, hash);
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"Sign file failed, can't find the file.");
            FileSignHandler.closeInputStream(input);
        }
        catch (Exception e2) {
            LOG.error((Object)String.format(Locale.ROOT, "Sign file failed, errMsg: %s.", ExceptionUtil.getErrorMessage((Throwable)e2)));
            {
                catch (Throwable throwable) {
                    FileSignHandler.closeInputStream(input);
                    throw throwable;
                }
            }
            FileSignHandler.closeInputStream(input);
        }
        FileSignHandler.closeInputStream(input);
    }

    public boolean signVerify(String file, String signFile) {
        try {
            file = FilenameUtils.normalize((String)file);
            signFile = FilenameUtils.normalize((String)signFile);
            String plain = new String(Files.readAllBytes(Paths.get(file, new String[0])), StandardCharsets.UTF_8);
            String hashCode = new String(Files.readAllBytes(Paths.get(signFile, new String[0])), StandardCharsets.UTF_8);
            return KmcUtil.signVerify(plain, hashCode);
        }
        catch (AppException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }
}

