/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cipher;

import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import com.huawei.ism.drm.wcc.util.kms.HardwareCallback;
import com.huawei.kmc.common.AppException;
import com.huawei.kmc.common.IHardwareCallback;
import com.huawei.kmc.common.InitStage;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import com.huawei.signer.ProperUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;

public class KmcUtil {
    private static final Log LOG = LogFactory.getInstance(KmcUtil.class);
    static String PRIMARY_KEY_STORE_FILE = "primary_key_store_file";
    static String STANDBY_KEY_STORE_FILE = "standby_key_store_file";
    static int KMC_DOMAIN = 1;
    private static final String KMC_CONFIG_FILE_NAME = "application.properties";
    private static final String KMC_SM_CONFIG_FILE_NAME = "application-sm.properties";
    private static final String KMC_SM_HW_CONFIG_FILE_NAME = "application-sm-hw.properties";
    private static final String GENERAL_CIPHER = "generalCipher";

    public static void initKmc(String path, ProperUtil properUtil) {
        Properties kmcProps;
        String cipherType = KmcUtil.getCurrentCipherType(path);
        Properties kmcHwProps = null;
        if (GENERAL_CIPHER.equals(cipherType)) {
            kmcProps = properUtil.getKmcConfFile(path + "/" + KMC_CONFIG_FILE_NAME);
        } else {
            kmcProps = properUtil.getKmcConfFile(path + "/" + KMC_SM_CONFIG_FILE_NAME);
            String hwFile = path + "/" + KMC_SM_HW_CONFIG_FILE_NAME;
            if (new File(FilenameUtils.normalize((String)hwFile)).exists()) {
                kmcHwProps = properUtil.getKmcConfFile(hwFile);
            }
        }
        KmcUtil.initKmcConfig(kmcProps, kmcHwProps, path);
    }

    private static String getCurrentCipherType(String kmcPath) {
        String legoConfigPath = kmcPath + "/../lego.properties";
        File file = new File(FilenameUtils.normalize((String)legoConfigPath));
        if (!file.exists()) {
            LOG.error((Object)"get lego.properties failed. file %s not exist.%n", legoConfigPath);
        }
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(file));
        }
        catch (IOException e) {
            LOG.error((Object)"read lego.properties error. init kmc failed.", "");
        }
        return properties.getProperty("cipher.type", GENERAL_CIPHER);
    }

    private static void initKmcConfig(Properties kmcProps, Properties hwProps, String path) {
        try {
            if (InitStage.INIT_KMC_DONE.getValue() == KmcInstance.getSoftInstance().getInitStage()) {
                return;
            }
            kmcProps.put(PRIMARY_KEY_STORE_FILE, path + "/" + kmcProps.get(PRIMARY_KEY_STORE_FILE));
            kmcProps.put(STANDBY_KEY_STORE_FILE, path + "/" + kmcProps.get(STANDBY_KEY_STORE_FILE));
            KmcInstance.getSoftInstance().initialize(kmcProps);
            if (KmcInstance.getSoftInstance().getMaxMkID(KMC_DOMAIN) == 0) {
                LOG.info((Object)"Kmc active new key for soft.");
                KmcInstance.getSoftInstance().activeNewKey(KMC_DOMAIN);
            }
            if (hwProps != null) {
                hwProps.put(PRIMARY_KEY_STORE_FILE, path + "/" + hwProps.get(PRIMARY_KEY_STORE_FILE));
                hwProps.put(STANDBY_KEY_STORE_FILE, path + "/" + hwProps.get(STANDBY_KEY_STORE_FILE));
                KmcInstance.getHwInstance().setHardCallBack((IHardwareCallback)new HardwareCallback());
                KmcInstance.getHwInstance().initialize(hwProps);
                if (KmcInstance.getHwInstance().getMaxMkID(KMC_DOMAIN) == 0) {
                    LOG.info((Object)"Kmc active new key for hw.");
                    KmcInstance.getHwInstance().activeNewKey(KMC_DOMAIN);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String encrypt(String plainText) throws AppException {
        return KmcInstance.encrypt((String)plainText);
    }

    public static String decrypt(String cipherText) throws AppException {
        return KmcInstance.decrypt((String)cipherText);
    }

    public static String sign(String plainText) throws AppException {
        return KmcInstance.hmac((String)plainText);
    }

    public static boolean signVerify(String plainText, String hmacData) throws AppException {
        return KmcInstance.hmacVerify((String)plainText, (String)hmacData);
    }

    public static void refreshCryptoConf() throws AppException {
        KmcInstance.releaseComponent();
    }
}

