/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.interceptor;

import com.huawei.ism.drm.rest.exception.ErrorResponse;
import com.huawei.ism.drm.rest.exception.RestException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.core.Response;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class OutExceptionInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Log LOGGER = LogFactory.getInstance(OutExceptionInterceptor.class);

    public OutExceptionInterceptor() {
        super("pre-stream");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message message) {
        if (message == null) {
            return;
        }
        OutputStream os = null;
        CachedOutputStream cs = null;
        try {
            String json = this.getResultContent(message);
            os = (OutputStream)message.getContent(OutputStream.class);
            cs = new CachedOutputStream();
            message.setContent(OutputStream.class, (Object)cs);
            message.getInterceptorChain().doIntercept(message);
            IOUtils.copy((InputStream)new ByteArrayInputStream(json.getBytes("UTF-8")), (OutputStream)os);
        }
        catch (IOException e) {
            LOGGER.error((Object)"writer stream is error.");
        }
        catch (Exception e) {
            LOGGER.error((Object)("writer stream is catch exception:" + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        finally {
            if (os != null) {
                try {
                    os.flush();
                    message.setContent(OutputStream.class, (Object)os);
                }
                catch (IOException e) {
                    LOGGER.error((Object)"close OutputStream error", (Throwable)e);
                }
            }
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"close CachedOutputStream error", (Throwable)e);
                }
            }
        }
    }

    private String getResultContent(Message message) {
        ErrorResponse er = new ErrorResponse();
        Fault fault = (Fault)message.getExchange().get((Object)"java.lang.Exception");
        if (fault != null) {
            RestException rs = null;
            Throwable cause = fault.getCause();
            if (cause instanceof RestException) {
                rs = (RestException)cause;
            }
            if (rs == null) {
                er.setErrorCode(1053L);
            } else {
                er.setErrorCode(rs.getErrorCode());
                if ((long)Response.Status.FORBIDDEN.getStatusCode() == rs.getErrorCode()) {
                    er.setErrorCode(1073947659L);
                }
                er.setDetailParam(rs.getErrorPara());
                er.setErrorMessage(rs.getErrorMsg());
            }
        } else {
            er.setErrorCode(1053L);
        }
        JSONObject obj = JSONObject.fromObject((Object)er);
        return obj.toString();
    }
}

