/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.base;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.framework.user.service.UserRestServiceValidator;
import com.huawei.ism.drm.rest.util.PageParameter;
import com.huawei.ism.drm.rest.util.SysOpLogBuilder;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.security.sdk.service.ISecurityService;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.util.ReverseObjectSerializableUtils;
import com.huawei.ism.drm.web.util.RequestUtil;
import com.huawei.ism.drm.web.util.ResourceUtil;
import com.huawei.ism.drm.web.util.UriUtil;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import com.huawei.lego.core.system.syslog.sdk.service.ISysOptLog;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Context;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;

public abstract class AbstractRestService {
    public static final String DEFUALT_BUNDLE_NAME = "DRM_Base";
    private static final String COMM_SERVICE_TYPE = "";
    private static final String MACHINE_TO_MACHINE_FLAG = "machine_to_machine_flag";
    private static final List<String> CLOUD_URIS = Arrays.asList("/ws/csha", "/ws/csdr", "/ws/bcs", "/ws/om");
    private static final Log LOGGER = LogFactory.getInstance(AbstractRestService.class);
    @Context
    private HttpServletRequest request;
    @Context
    private HttpServletResponse response;

    public HttpServletRequest getRequest() {
        Message message;
        if (VerifyUtil.isEmpty((Object)this.request) && (message = PhaseInterceptorChain.getCurrentMessage()).get((Object)"HTTP.REQUEST") instanceof HttpServletRequest) {
            return (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
        }
        return this.request;
    }

    protected HttpServletResponse getResponse() {
        Message message;
        if (VerifyUtil.isEmpty((Object)this.response) && (message = PhaseInterceptorChain.getCurrentMessage()).get((Object)"HTTP.RESPONSE") instanceof HttpServletResponse) {
            return (HttpServletResponse)message.get((Object)"HTTP.RESPONSE");
        }
        return this.response;
    }

    protected HttpSession getSession() {
        return this.getRequest().getSession(false);
    }

    protected boolean isMachineToMachineReq() {
        String machineFlag = this.getRequest().getHeader(MACHINE_TO_MACHINE_FLAG);
        return !VerifyUtil.isEmpty((String)machineFlag);
    }

    public Locale getLocale() {
        return RequestUtil.getLocale(this.getRequest());
    }

    protected String getAppPath() {
        return this.getSession().getServletContext().getRealPath(COMM_SERVICE_TYPE);
    }

    public static String getRemoteAddr(HttpServletRequest req) {
        return RequestUtil.getClientIpAddress(req);
    }

    public static boolean isIPValid(String strIP) {
        if (VerifyUtil.isEmpty((String)strIP) || strIP.endsWith(".0") || strIP.startsWith("0")) {
            return false;
        }
        return AddressUtil.isIpAddress((String)strIP);
    }

    @Deprecated
    protected Object getBundleService(String bundle, String service) {
        return ServiceLocator.getBundleService((String)bundle, (String)service);
    }

    protected String constructResponseData(Object resultObj) {
        if (null == resultObj) {
            LOGGER.error((Object)"ConstructResponseData failed.", 653110170615808L);
            throw new LegoCheckedException(-1L);
        }
        String messageObj = ReverseObjectSerializableUtils.serializableObj((Object)resultObj);
        JSONObject res = new JSONObject();
        res.put((Object)"type", (Object)resultObj.getClass().getName());
        res.put((Object)"message", (Object)messageObj);
        return res.toString();
    }

    public <T> T getBundleService(String bundleName, String serviceName, Class<T> serviceClass) {
        return (T)ServiceLocator.getBundleService((String)bundleName, (String)serviceName, serviceClass);
    }

    public <T> T getBundleService(String serviceName, Class<T> serviceClass) {
        return this.getBundleService(DEFUALT_BUNDLE_NAME, serviceName, serviceClass);
    }

    public <T> T getBundleService(Class<T> serviceClass) {
        return this.getBundleService(DEFUALT_BUNDLE_NAME, serviceClass.getName(), serviceClass);
    }

    public Long getCurrentUserId() {
        User user = this.getCurrentUser();
        return user.getUserId();
    }

    public User getCurrentUser() {
        User user = (User)this.getRequest().getAttribute("currentUser");
        if (user != null) {
            return user;
        }
        user = (User)this.getRequest().getSession().getAttribute("currentUser");
        if (user != null) {
            return user;
        }
        String userName = this.getRequest().getHeader("x-auth-user");
        if (!UserRestServiceValidator.checkUserName(userName).booleanValue()) {
            LOGGER.error((Object)"parameter[x-auth-user] is illegal!", 1073947393L);
            throw new LegoCheckedException(1073947659L);
        }
        String userPwd = this.getRequest().getHeader("x-auth-key");
        ISecurityService service = (ISecurityService)ServiceContext.getInstance().lookup("DRM_Base/ISecurityService");
        if (service == null) {
            LOGGER.error((Object)"Can not find security service.", 1073947393L);
            throw new LegoCheckedException(1073947659L);
        }
        if (!service.isValidUser(userName, userPwd)) {
            throw new LegoCheckedException(1073947659L);
        }
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        user = mgr.getUserByName(userName);
        if (user == null) {
            throw new LegoCheckedException(1073947659L);
        }
        this.getRequest().setAttribute("currentUser", (Object)user);
        return user;
    }

    protected String getUserJson() {
        return this.getCurrentUser().getUserName();
    }

    protected String getUserProjectId() {
        if (VerifyUtil.isEmpty((Object)this.getRequest())) {
            return null;
        }
        return (String)this.getRequest().getAttribute("iam-x-auth-user-project");
    }

    protected Map<String, Object> getExtParamInQueryParam() {
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        Map parameterMap = this.getRequest().getParameterMap();
        if (VerifyUtil.isEmpty((Map)parameterMap)) {
            return queryParam;
        }
        for (Map.Entry values : parameterMap.entrySet()) {
            String[] keys;
            String key = (String)values.getKey();
            Object[] value = (String[])values.getValue();
            if (VerifyUtil.isEmpty((Object[])value) || key.indexOf(".") == -1 || (keys = key.split("\\.")).length != 2) continue;
            String key1 = keys[1];
            Object value1 = value[0];
            if (VerifyUtil.isEmpty((String)key1) || VerifyUtil.isEmpty((String)value1)) continue;
            queryParam.put(key1, value1);
        }
        return queryParam;
    }

    protected void checkUserAuthority(String objectId) {
        IBizScopeManager scope = this.getBundleService("IBizScopeManager", IBizScopeManager.class);
        scope.checkUserGrantedObject(this.getCurrentUserId(), objectId);
    }

    protected void checkUserAuthorityByMoIds(long ... moIds) {
        IBizScopeManager scope = this.getBundleService("IBizScopeManager", IBizScopeManager.class);
        scope.checkUserGrantedMOObject(this.getCurrentUserId(), moIds);
    }

    protected void checkUserOperationAuthority(String operationName, int level, String i18nKey) {
        Long userId = this.getCurrentUserId();
        if (userId == null) {
            LOGGER.error((Object)"Cannot get current user.", 653110170615808L);
            throw new LegoCheckedException(1073947400L);
        }
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        boolean hasRight = mgr.checkUserRight(userId.longValue(), i18nKey);
        if (!hasRight) {
            throw new LegoCheckedException(1073947400L);
        }
    }

    protected void checkUserMoAuthority(String operationName, int level, long ... moIds) {
        IBizScopeManager scope = this.getBundleService("IBizScopeManager", IBizScopeManager.class);
        for (long moId : moIds) {
            try {
                scope.checkUserGrantedMOObject(this.getCurrentUserId(), new long[]{moId});
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)"checkUserMoAuthority failed");
                throw new LegoCheckedException(1073947400L);
            }
        }
    }

    protected void checkUserMoAuthority(String operationName, int level, String ... devSn) {
        IBizScopeManager scope = this.getBundleService("IBizScopeManager", IBizScopeManager.class);
        for (String sn : devSn) {
            try {
                scope.checkUserGrantedMOObject(this.getCurrentUserId(), sn);
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)"checkUserMoAuthority failed");
                throw new LegoCheckedException(1073947400L);
            }
        }
    }

    protected void checkUserBizObjAuthority(String operationName, int level, String objectId) {
        IBizScopeManager scope = this.getBundleService("IBizScopeManager", IBizScopeManager.class);
        try {
            scope.checkUserGrantedObject(this.getCurrentUserId(), objectId);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"checkUserBizObjAuthority failed.");
            throw e;
        }
    }

    protected void writeFailedOperationLog(String operationName, int level, String objectName, Exception ix) {
        this.writeFailedOperationLog(operationName, level, objectName, ix, COMM_SERVICE_TYPE);
    }

    protected void writeFailedOperationLog(String operationName, int level, String objectName, Exception ix, String serviceType) {
        if (ix instanceof LegoCheckedException) {
            LegoCheckedException ex = (LegoCheckedException)((Object)ix);
            SysOptLog sysOptLog = SysOpLogBuilder.buildeFailureSysOptLog(operationName, this.getCurrentUser().getUserName(), level, "lego.err." + ex.getErrorCode(), objectName, AbstractRestService.getRemoteAddr(this.getRequest()));
            this.initLog(sysOptLog, ex.getParameters(), serviceType);
            SysOpLogBuilder.writeOperateLog(sysOptLog);
            throw ex;
        }
        LOGGER.error((Object)("Operating failed. OptName:" + operationName + ",ObjName:" + objectName + "," + ExceptionUtil.getErrorMessage((Throwable)ix)));
        SysOptLog sysOptLog = SysOpLogBuilder.buildeFailureSysOptLog(operationName, this.getCurrentUser().getUserName(), level, "lego.err.-1", objectName, AbstractRestService.getRemoteAddr(this.getRequest()));
        this.initLog(sysOptLog, new String[0], serviceType);
        SysOpLogBuilder.writeOperateLog(sysOptLog);
        throw new LegoCheckedException(-1L);
    }

    protected void writeFailedOperationLogNoException(String operationName, int level, String objectName, Exception ix) {
        this.writeFailedOperationLogNoException(operationName, level, objectName, ix, COMM_SERVICE_TYPE);
    }

    protected void writeFailedOperationLogNoException(String operationName, int level, String objectName, Exception ix, String serviceType) {
        if (ix instanceof LegoCheckedException) {
            LegoCheckedException ex = (LegoCheckedException)((Object)ix);
            SysOptLog sysOptLog = SysOpLogBuilder.buildeFailureSysOptLog(operationName, this.getCurrentUser().getUserName(), level, "lego.err." + ex.getErrorCode(), objectName, AbstractRestService.getRemoteAddr(this.getRequest()));
            this.initLog(sysOptLog, ex.getParameters(), serviceType);
            SysOpLogBuilder.writeOperateLog(sysOptLog);
        } else {
            LOGGER.error((Object)("Operating failed. OptName:" + operationName + ",ObjName:" + objectName + "," + ExceptionUtil.getErrorMessage((Throwable)ix)));
            SysOptLog sysOptLog = SysOpLogBuilder.buildeFailureSysOptLog(operationName, this.getCurrentUser().getUserName(), level, "lego.err.-1", objectName, AbstractRestService.getRemoteAddr(this.getRequest()));
            this.initLog(sysOptLog, new String[0], serviceType);
            SysOpLogBuilder.writeOperateLog(sysOptLog);
        }
    }

    private void initLog(SysOptLog sysOptLog, String[] params, String serviceType) {
        sysOptLog.setDetailPara(params);
        this.setSysOptLogType(sysOptLog);
        sysOptLog.setTokenUser(this.getUserJson());
        sysOptLog.setProjectId(this.getUserProjectId());
        sysOptLog.setServiceType(serviceType);
        this.setSysOptLogContainOneTerminalIpForHCS(sysOptLog);
    }

    protected void writeSucOperationLog(String operationName, int level, String objectName, String detail, String[] parameters) {
        this.writeSucOperationLog(operationName, level, objectName, detail, parameters, COMM_SERVICE_TYPE);
    }

    protected void writeSucOperationLog(String operationName, int level, String objectName, String detail, String[] parameters, String serviceType) {
        SysOptLog sysOptLog = SysOpLogBuilder.buildeSuccussSysOptLog(operationName, this.getCurrentUser().getUserName(), level, detail, objectName, AbstractRestService.getRemoteAddr(this.getRequest()));
        if (null != parameters) {
            for (int i = 0; i < parameters.length; ++i) {
                if (null != parameters[i] && 0 != parameters[i].trim().length()) continue;
                parameters[i] = "--";
            }
        }
        this.initLog(sysOptLog, parameters, serviceType);
        SysOpLogBuilder.writeOperateLog(sysOptLog);
    }

    protected BatchOperationResult getBatchResult(String logKey, String[] logPara, long erroCode, String strMotionKey) {
        if (VerifyUtil.isEmpty((String)logKey) || VerifyUtil.isEmpty((Object[])logPara)) {
            return null;
        }
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> bos = new ArrayList<BatchOperation>();
        BatchOperation bo = new BatchOperation();
        bo.setOptDetail(logKey);
        bo.setDetailParam(logPara);
        bo.setErrorCode(erroCode);
        bo.setTargetName(logKey);
        String[] trgParam = new String[]{strMotionKey};
        bo.setTargetNameParam(trgParam);
        bos.add(bo);
        result.setResult(bos);
        result.setFailCount(1);
        result.setSucceedCount(0);
        result.setTotalCount(1);
        return result;
    }

    public String getText(String key) {
        Locale locale = RequestUtil.getLocale(this.getRequest());
        return ResourceUtil.getInstance().getText(key, locale);
    }

    public String getText(String key, String[] args) {
        return ResourceUtil.getInstance().getText(key, this.getLocale(), args);
    }

    protected ISysOptLog getysOptLog() {
        return (ISysOptLog)this.getBundleService("system", "sysLogService");
    }

    protected boolean checkIsRemoteSite(String siteId) {
        if (VerifyUtil.isEmpty((String)siteId)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserAuthority(siteId);
        ISiteService siteService = (ISiteService)this.getBundleService(DEFUALT_BUNDLE_NAME, ISiteService.class.getName());
        Site site = siteService.getSiteById(siteId);
        if (VerifyUtil.isEmpty((Object)site)) {
            throw new LegoCheckedException(1073947394L);
        }
        return site.getSiteType() == 1;
    }

    protected PageParameter getPageParameter() {
        PageParameter pageParameter = new PageParameter();
        HttpServletRequest req = this.getRequest();
        String startPage = req.getParameter("startPage");
        String pageSize = req.getParameter("pageSize");
        String orderBy = req.getParameter("orderBy");
        String orderType = req.getParameter("orderType");
        try {
            if (!VerifyUtil.isEmpty((String)startPage)) {
                if (!Validator.isNum(startPage) || Integer.parseInt(startPage) < 0) {
                    LOGGER.error((Object)"Invalid startPage!");
                    throw new LegoCheckedException(1073947393L);
                }
                pageParameter.setStartPage(Integer.parseInt(startPage));
            }
            if (!VerifyUtil.isEmpty((String)pageSize)) {
                if (!Validator.isNum(pageSize) || Integer.parseInt(pageSize) <= 0) {
                    LOGGER.error((Object)"Invalid pageSize!");
                    throw new LegoCheckedException(1073947393L);
                }
                pageParameter.setPageSize(Integer.parseInt(pageSize));
            }
            if (!VerifyUtil.isEmpty((String)orderBy)) {
                pageParameter.setOrderBy(orderBy);
            }
            if (!VerifyUtil.isEmpty((String)orderType)) {
                pageParameter.setOrderType(orderType);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"NumberFormatException", (Throwable)e, 1073947393L);
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
        return pageParameter;
    }

    protected Boolean isExportChecked() {
        String isChecked = this.getRequest().getParameter("isChecked");
        return !"false".equalsIgnoreCase(isChecked);
    }

    protected void batchOptLog(BatchOperationResult batchOperationResult, String operateName, int level) {
        this.batchOptLog(batchOperationResult, operateName, level, COMM_SERVICE_TYPE);
    }

    protected void batchOptLog(BatchOperationResult batchOperationResult, String operateName, int level, String serviceType) {
        if (batchOperationResult == null) {
            return;
        }
        for (BatchOperation result : batchOperationResult.getResult()) {
            String name = (String)(result.getTargetName() != null ? result.getTargetName() : result.getExtTargetId());
            if ("backendTask_delete_operateName".equals(operateName)) {
                name = result.getTaskName();
            }
            if (result.getErrorCode() == 0L) {
                this.writeSucOperationLog(operateName, level, name, null, null, serviceType);
                continue;
            }
            this.writeFailedOperationLogNoException(operateName, level, name, (Exception)((Object)new LegoCheckedException(result.getErrorCode(), result.getDetailParam())), serviceType);
        }
    }

    public String calcExecuteTime(String startTimeStr, String endTimeStr) {
        if (VerifyUtil.isEmpty((String)startTimeStr) || VerifyUtil.isEmpty((String)endTimeStr)) {
            return "--";
        }
        Long startTime = this.getTime(startTimeStr);
        Long endTime = this.getTime(endTimeStr);
        if (null == startTime || startTime == 0L || null == endTime || endTime == 0L) {
            return "--";
        }
        Long executeTime = endTime / 1000L - startTime / 1000L;
        if (executeTime < 0L) {
            return "--";
        }
        long temp = 3600L;
        long hour = executeTime / temp;
        executeTime = executeTime % temp;
        long minutes = executeTime / 60L;
        long seconds = executeTime % 60L;
        if (hour > 0L) {
            String[] param = new String[]{COMM_SERVICE_TYPE + hour, COMM_SERVICE_TYPE + minutes, COMM_SERVICE_TYPE + seconds};
            return this.getText("common_time_hour_min_second", param);
        }
        if (minutes > 0L) {
            String[] param = new String[]{COMM_SERVICE_TYPE + minutes, COMM_SERVICE_TYPE + seconds};
            return this.getText("common_time_min_second", param);
        }
        String[] param = new String[]{COMM_SERVICE_TYPE + seconds};
        return this.getText("common_time_second", param);
    }

    private Long getTime(String timeStr) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = format.parse(timeStr);
            return date.getTime();
        }
        catch (ParseException e) {
            return NumberUtil.convertToLong((Object)timeStr, (long)0L);
        }
    }

    private boolean isCloudRestService(String uri) {
        for (String s : CLOUD_URIS) {
            if (!uri.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private void setSysOptLogType(SysOptLog sysOptLog) {
        if (this.isCloudRestService(this.getRequestURL())) {
            sysOptLog.setLogType("tenantlog");
        } else {
            sysOptLog.setLogType("administratorlog");
        }
    }

    private String getRequestURL() {
        String uri = this.getRequest().getRequestURI();
        return UriUtil.canonicalPath(uri);
    }

    private void setSysOptLogContainOneTerminalIpForHCS(SysOptLog sysOptLog) {
        if (this.isCloudRestService(this.getRequestURL())) {
            sysOptLog.setTerminalIp(RequestUtil.getFirstIPFromIPStr(sysOptLog.getTerminalIp()));
        }
    }
}

