/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.alarm.service;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.framework.alarm.model.AlarmTransferStorageConfigVo;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.fault.sdk.model.AlertExperience;
import java.util.Set;

public final class AlarmRestSerivceValidator {
    private static final int ONE_HUNDRED_TWENTY = 120;
    private static final int SEVEN = 7;
    private static final Integer FILE_STYLE_CSV = 1;
    private static final Integer FILE_STYLE_EXCEL = 2;
    private static final Integer LANG_CHINESE = 2;
    private static final Integer LANG_ENGLISH = 1;
    private static final Log logger = LogFactory.getInstance(AlarmRestSerivceValidator.class);

    private AlarmRestSerivceValidator() {
    }

    public static void addAlertExperienceCheck(String alarmId, AlertExperience experience) {
        CommUtils.checkParamEmpty(alarmId, experience);
        if (VerifyUtil.isEmpty((String)experience.getExperience()) || !Validator.checkStringLength(experience.getExperience(), 128)) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static void modifyAlertExperience(AlertExperience experience, long experienceId) {
        if (VerifyUtil.isEmpty((Object)experience) || experienceId == -1L || null == experience.getExperience() || experience.getExperience().isEmpty() || !Validator.checkStringLength(experience.getExperience(), 128)) {
            logger.error((Object)"params: experience or experienceId error.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static void deleteExperienceCheck(Set<Long> ids) {
        if (VerifyUtil.isEmpty(ids)) {
            logger.error((Object)"param: ids is empty.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static void checkParameters(AlarmTransferStorageConfigVo vo) {
        if (null == vo) {
            logger.error((Object)"The vo is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (AlarmRestSerivceValidator.checkFileType(vo.getFileType())) {
            logger.error((Object)"Invalid fileType!");
            throw new LegoCheckedException(250L);
        }
        if (AlarmRestSerivceValidator.checkLang(vo.getLanguageType())) {
            logger.error((Object)"Invalid languageType!");
            throw new LegoCheckedException(250L);
        }
        String time = vo.getTransferStartTime();
        if (Validator.stringisNull(time) || !Validator.validateTime(time)) {
            logger.error((Object)"Invalid transferStartTime!");
            throw new LegoCheckedException(250L);
        }
        if (AlarmRestSerivceValidator.checkCycleDate(vo.getPeriod())) {
            logger.error((Object)"Invalid period!");
            throw new LegoCheckedException(250L);
        }
        if (AlarmRestSerivceValidator.checkCycleDate(vo.getDataSavedTime())) {
            logger.error((Object)"Invalid dataSavedTime!");
            throw new LegoCheckedException(250L);
        }
    }

    private static boolean checkCycleDate(Integer cycleDate) {
        return VerifyUtil.isEmpty((Object)cycleDate) || cycleDate < 7 || cycleDate > 120;
    }

    private static boolean checkLang(Integer langValue) {
        return langValue == null || !LANG_ENGLISH.equals(langValue) && !LANG_CHINESE.equals(langValue);
    }

    private static boolean checkFileType(Integer filestyleValue) {
        return null == filestyleValue || !FILE_STYLE_CSV.equals(filestyleValue) && !FILE_STYLE_EXCEL.equals(filestyleValue);
    }
}

