/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.alarm.util;

import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class FaultExportUtil {
    private static final Map<Integer, String> WARNINGTYPEMAP = new HashMap<Integer, String>();

    private FaultExportUtil() {
    }

    public static void processField(Map<String, String> map, String fieldName, String value) {
        if (null == map) {
            return;
        }
        if (null != value && !value.equalsIgnoreCase("")) {
            map.put(fieldName, value);
        }
    }

    public static void processField(Map<String, String> map, String fieldName, long value) {
        if (null == map) {
            return;
        }
        if (!String.valueOf(value).equalsIgnoreCase("0")) {
            map.put(fieldName, String.valueOf(value));
        }
    }

    public static void processDateField(Map<String, String> map, String fieldName, String value) throws ParseException {
        if (null == map) {
            return;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (null != value && !value.equalsIgnoreCase("")) {
            map.put(fieldName, value);
        }
        if (value != null && !value.equalsIgnoreCase("")) {
            map.put(fieldName, String.valueOf(df.parse(value).getTime()));
        }
    }

    public static void convertAlarmType(int alarmType, List<String> tempLst, AbstractRestService restService) {
        if (null == tempLst || null == restService) {
            return;
        }
        String typeLocalizeKey = WARNINGTYPEMAP.get(alarmType);
        String value = "--";
        if (null != typeLocalizeKey) {
            value = restService.getText(typeLocalizeKey);
        }
        tempLst.add(value);
    }

    public static void convertAlarmLevel(int alarmLevel, List<String> tempLst, AbstractRestService restService) {
        if (null == tempLst || null == restService) {
            return;
        }
        switch (alarmLevel) {
            case 1: {
                tempLst.add(restService.getText("lego.lab.fault.alarmLevel.warning"));
                break;
            }
            case 2: {
                tempLst.add(restService.getText("lego.lab.fault.alarmLevel.minor"));
                break;
            }
            case 3: {
                tempLst.add(restService.getText("lego.lab.fault.alarmLevel.major"));
                break;
            }
            case 4: {
                tempLst.add(restService.getText("lego.lab.fault.alarmLevel.critical"));
                break;
            }
            default: {
                tempLst.add(String.valueOf(alarmLevel));
            }
        }
    }

    public static void convertConfirmStatus(int confirmStatus, List<String> tempLst, String userName, AbstractRestService restService) {
        if (null == tempLst) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        if (confirmStatus == 1) {
            buffer.append(restService.getText("lego.dic.confirmstatus.confirmed"));
            buffer.append(" ");
            buffer.append(userName);
        } else if (confirmStatus == 0) {
            buffer.append(restService.getText("lego.dic.confirmstatus.unconfirmed"));
        } else {
            buffer.append(String.valueOf(confirmStatus));
        }
        tempLst.add(buffer.toString());
    }

    static {
        WARNINGTYPEMAP.put(1, "lego.dic.warningtype.comm");
        WARNINGTYPEMAP.put(2, "lego.dic.warningtype.env");
        WARNINGTYPEMAP.put(3, "lego.dic.warningtype.dev");
        WARNINGTYPEMAP.put(4, "lego.dic.warningtype.business");
        WARNINGTYPEMAP.put(5, "lego.dic.warningtype.operation");
        WARNINGTYPEMAP.put(6, "lego.dic.warningtype.security");
    }
}

