/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.system.service;

import com.huawei.ism.cbb.base.sdk.util.ValidateUtil;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.coreenum.SyslogEncryptionModeEnum;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.system.model.SystemThresholdVo;
import com.huawei.ism.drm.rest.service.framework.system.service.ISystemRestService;
import com.huawei.ism.drm.rest.service.framework.system.util.SystemFileUtil;
import com.huawei.ism.drm.rest.util.OperationLog;
import com.huawei.ism.drm.rest.util.OperationLogAttrDefine;
import com.huawei.ism.drm.rest.util.ParamValidator;
import com.huawei.ism.drm.rest.util.Permission;
import com.huawei.ism.drm.system.cfgdata.sdk.model.FtpServerInfo;
import com.huawei.ism.drm.system.cfgdata.sdk.service.IConfigDataBackupService;
import com.huawei.ism.drm.system.info.sdk.service.ISoftwareInfoService;
import com.huawei.ism.drm.system.thirdservice.sdk.model.LogNotifyServer;
import com.huawei.ism.drm.system.thirdservice.sdk.service.ILogNotifierService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.ism.drm.web.util.HtmlStringConverter;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.ILogConfigService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import com.huawei.lego.core.system.sysmonitor.sdk.model.DataBaseInfo;
import com.huawei.lego.core.system.sysmonitor.sdk.model.DiskResouceUse;
import com.huawei.lego.core.system.sysmonitor.sdk.model.HostServerMonitorInfo;
import com.huawei.lego.core.system.sysmonitor.sdk.model.SysmTreshold;
import com.huawei.lego.core.system.sysmonitor.sdk.model.SysmTresholdType;
import com.huawei.lego.core.system.sysmonitor.sdk.service.ISysMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.DecimalFormat;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.config.Configurator;

public class SystemRestServiceImpl
extends AbstractRestService
implements ISystemRestService {
    private static final Log LOGGER = FELogFactory.getInstance((String)"ui");
    private static final String LOCAL_HOST_IP_FIRST = "127";
    private static final String AUTO_BACKUP_FLAG_TRUE = "true";
    private static final String AUTO_BACKUP_FLAG_FALSE = "false";
    private static final long DEFALTPERCENT = 90L;
    private static final String LOGGER_LEGO_NAME = "com.huawei.lego";
    private static final String LOGGER_ISM_NAME = "com.huawei.ism";
    private static final String EXPORT_CHECKED_TOKEN = "EXPORT_CHECKED_TOKEN";
    private static final String LOWER_CHAR = "[a-z]+";
    private static final String NUMBER = "[0-9]+";
    private static final String SPECIAL_CHAR = "[\\`|\\~|!|@|#|$|%|\\^|&|\\*|\\(|\\)|\\-|_|=|+|\\\\|\\||\\{|\\}|\\[|\\]|;|:|\\'|\\\"|\\,|\\.|\\<|\\>|\\/|\\s|?]+";
    private static final String UPPER_CHAR = "[A-Z]+";
    private static final int PWDMAXLEN = 15;
    private static final int PWDMINLEN = 8;
    private static final String CTS = "CTS";
    private static final String SYSLOG = "SYSLOG";
    private static final String ELK = "ELK";
    private static final List<String> LOG_TYPES = Arrays.asList("administratorlog", "tenantlog");
    private static Map<String, Level> levels = new HashMap<String, Level>(6);
    private static Object logExportLocker = new Object();
    private static final Object SYS_CONFIG_EXPORT_LOCKER = new Object();

    @Override
    @Permission(name="lego.sys.systemMonitor.scan")
    public SystemThresholdVo querySystemThreshold() {
        LOGGER.debug((Object)"enter querySystemThreshold");
        SystemThresholdVo vo = new SystemThresholdVo();
        long cpuPercent = 90L;
        long diskPercent = 90L;
        long memPercent = 90L;
        ISysMonitor mgr = (ISysMonitor)this.getBundleService("system", "sysMonitor");
        List list = mgr.getSysmTreshold();
        if (null != list && !list.isEmpty()) {
            for (SysmTreshold sysmTreshold : list) {
                if (sysmTreshold.getId().longValue() == SysmTresholdType.CPU.getValue()) {
                    cpuPercent = sysmTreshold.getPercent();
                    continue;
                }
                if (sysmTreshold.getId().longValue() == SysmTresholdType.DISK.getValue()) {
                    diskPercent = sysmTreshold.getPercent();
                    continue;
                }
                if (sysmTreshold.getId().longValue() != SysmTresholdType.MEM.getValue()) continue;
                memPercent = sysmTreshold.getPercent();
            }
        }
        vo.setCpuPercent(cpuPercent);
        vo.setDiskPercent(diskPercent);
        vo.setMemPercent(memPercent);
        return vo;
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="performance_setThreshold_operateName", operationModule="system", level=3)
    @Permission(name="lego.sys.systemMonitor.Threshold.modify")
    public Response modifySysmTreshold(SystemThresholdVo vo) {
        LOGGER.debug((Object)"Enter modifySysmTreshold");
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)"performanceThreshold_objectName");
        this.checkParam(vo);
        ISysMonitor mgr = (ISysMonitor)this.getBundleService("system", "sysMonitor");
        List list = mgr.getSysmTreshold();
        if (!VerifyUtil.isEmpty((Collection)list)) {
            for (SysmTreshold sysmTreshold : list) {
                if (sysmTreshold.getId().longValue() == SysmTresholdType.CPU.getValue()) {
                    sysmTreshold.setPercent(vo.getCpuPercent().longValue());
                    continue;
                }
                if (sysmTreshold.getId().longValue() == SysmTresholdType.DB.getValue()) {
                    sysmTreshold.setPercent(0L);
                    continue;
                }
                if (sysmTreshold.getId().longValue() == SysmTresholdType.DISK.getValue()) {
                    sysmTreshold.setPercent(vo.getDiskPercent().longValue());
                    continue;
                }
                if (sysmTreshold.getId().longValue() != SysmTresholdType.MEM.getValue()) continue;
                sysmTreshold.setPercent(vo.getMemPercent().longValue());
            }
        }
        try {
            mgr.updateSysmTreshold(list);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"modifySysmTreshold failed.");
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)"modifySysmTreshold failed.");
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    private void checkParam(SystemThresholdVo vo) {
        LOGGER.debug((Object)"Enter checkParam");
        if (VerifyUtil.isEmpty((Object)vo)) {
            LOGGER.error((Object)"The vo is invalid!");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Object)vo.getCpuPercent()) || VerifyUtil.isEmpty((Object)vo.getDiskPercent()) || VerifyUtil.isEmpty((Object)vo.getMemPercent())) {
            LOGGER.error((Object)"The cpuPercent or diskPercent or memPercent are invalid!");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkNumArea(vo.getCpuPercent(), 1, 99);
        this.checkNumArea(vo.getDiskPercent(), 1, 99);
        this.checkNumArea(vo.getMemPercent(), 1, 99);
    }

    private void checkNumArea(Long num, int min, int max) {
        if (num < (long)min || num > (long)max) {
            throw new LegoCheckedException(250L);
        }
    }

    @Override
    @Permission(name="lego.sys.systemMonitor.scan")
    public String queryCpuStatus() {
        JSONObject resultObject;
        block3: {
            Iterator iterator;
            resultObject = new JSONObject();
            Object object = null;
            try {
                object = this.getBundleService("system", "sysMonitor");
            }
            catch (Exception e) {
                LOGGER.error((Object)(" queryCpuStatus getBundleService error :" + (ISysMonitor)this.getBundleService("system", "sysMonitor")), 653110170615808L);
                throw new LegoCheckedException("queryCpuStatus getBundleService error", (Throwable)e);
            }
            ISysMonitor mgr = (ISysMonitor)object;
            List list = mgr.getHistoryhostInfo();
            List treshold = mgr.getSysmTreshold();
            if (VerifyUtil.isEmpty((Collection)treshold)) {
                LOGGER.error((Object)"treshold is empty.", 653110170615808L);
                throw new LegoCheckedException(1073947393L);
            }
            String maxCpu = String.valueOf(((SysmTreshold)treshold.get(0)).getPercent());
            resultObject.put((Object)"cpuMax", (Object)maxCpu);
            if (VerifyUtil.isEmpty((Collection)list) || !(iterator = list.iterator()).hasNext()) break block3;
            Map map = (Map)iterator.next();
            Set<Map.Entry<Long, HostServerMonitorInfo>> set = map.entrySet();
            this.getTimeAndPercent(resultObject, set);
        }
        return resultObject.toString();
    }

    private void getTimeAndPercent(JSONObject resultObject, Set<Map.Entry<Long, HostServerMonitorInfo>> set) {
        block2: {
            long time;
            LOGGER.debug((Object)"enter getTimeAndPercent");
            Iterator<Map.Entry<Long, HostServerMonitorInfo>> iterator = set.iterator();
            if (!iterator.hasNext()) break block2;
            Map.Entry<Long, HostServerMonitorInfo> entry = iterator.next();
            Long key = entry.getKey();
            if (key == null) {
                time = 0L;
            } else {
                Date date = new Date(key);
                time = date.getTime();
            }
            resultObject.put((Object)"time", (Object)time);
            HostServerMonitorInfo temp = entry.getValue();
            String cpuPer = temp.getCpuInfo().getPercent().trim().replace("%", "");
            resultObject.put((Object)"cpuPer", (Object)cpuPer);
        }
    }

    @Override
    @Permission(name="lego.sys.systemMonitor.scan")
    public String queryMemStatus() {
        JSONObject resultObject = new JSONObject();
        ISysMonitor mgr = null;
        try {
            mgr = (ISysMonitor)this.getBundleService("system", "sysMonitor");
        }
        catch (Exception e) {
            LOGGER.error((Object)(" queryMemStatus getBundleService error :" + (ISysMonitor)this.getBundleService("system", "sysMonitor")), 653110170615808L);
            throw new LegoCheckedException("queryMemStatus getBundleService error", (Throwable)e);
        }
        List list = mgr.getHistoryhostInfo();
        List treshold = mgr.getSysmTreshold();
        if (VerifyUtil.isEmpty((Collection)treshold) || treshold.size() < 2) {
            LOGGER.error((Object)"treshold is empty.", 653110170615808L);
            throw new LegoCheckedException(1073947393L);
        }
        String maxMemo = String.valueOf(((SysmTreshold)treshold.get(1)).getPercent());
        resultObject.put((Object)"memoMax", (Object)maxMemo);
        if (null != list && !list.isEmpty()) {
            this.getMemo(resultObject, list);
        }
        return resultObject.toString();
    }

    private void getMemo(JSONObject resultObject, List<Map<Long, HostServerMonitorInfo>> list) {
        block2: {
            long time;
            Map<Long, HostServerMonitorInfo> map;
            Set<Map.Entry<Long, HostServerMonitorInfo>> set;
            Iterator<Map.Entry<Long, HostServerMonitorInfo>> iterator;
            LOGGER.debug((Object)"enter getMemo");
            Iterator<Map<Long, HostServerMonitorInfo>> iterator2 = list.iterator();
            if (!iterator2.hasNext() || !(iterator = (set = (map = iterator2.next()).entrySet()).iterator()).hasNext()) break block2;
            Map.Entry<Long, HostServerMonitorInfo> entry = iterator.next();
            Long key = entry.getKey();
            if (key == null) {
                time = 0L;
            } else {
                Date date = new Date(key);
                time = date.getTime();
            }
            resultObject.put((Object)"time", (Object)time);
            HostServerMonitorInfo temp = entry.getValue();
            String memoPer = temp.getMemoryInfo().getPercent().trim().replace("%", "");
            resultObject.put((Object)"memoPer", (Object)memoPer);
        }
    }

    @Override
    @Permission(name="lego.sys.systemMonitor.scan")
    public String queryDiskStatus() {
        LOGGER.debug((Object)"enter queryDiskStatus");
        JSONArray resultArray = new JSONArray();
        Object object = this.getBundleService("system", "sysMonitor");
        ISysMonitor mgr = (ISysMonitor)object;
        Map tempMap = mgr.getCurrentHostServerInfo();
        if (tempMap != null) {
            double ten = 10.0;
            double diskMax = 10.0;
            StringBuffer diskString = new StringBuffer();
            diskString.append("<item>");
            Collection setKey = tempMap.values();
            diskMax = this.addEachObject(resultArray, diskMax, diskString, setKey);
            double diskStepMax = diskMax / 10.0;
            Iterator iterator = resultArray.iterator();
            while (iterator.hasNext()) {
                JSONObject obj = JSONObject.fromObject(iterator.next());
                obj.put((Object)"stepMax", (Object)diskStepMax);
            }
        }
        return resultArray.toString();
    }

    private double addEachObject(JSONArray resultArray, double diskMax, StringBuffer diskString, Collection<?> setKey) {
        LOGGER.debug((Object)"enter addEachObject");
        for (Object obj : setKey) {
            HostServerMonitorInfo tempHsInf = (HostServerMonitorInfo)obj;
            for (DiskResouceUse temp : tempHsInf.getDiskInfo()) {
                JSONObject resultObject = new JSONObject();
                String usedStr = temp.getUsed().trim().replace("G", "");
                String leftStr = temp.getAvail().trim().replace("G", "");
                if (null == usedStr || 0 == usedStr.length()) {
                    usedStr = "0";
                }
                if (null == leftStr || 0 == leftStr.length()) {
                    leftStr = "0";
                }
                diskString.append("<items label='" + temp.getDiskName().trim().replace(":", "") + "' data1='" + usedStr + "' data2='" + leftStr + "'/>");
                resultObject.put((Object)"partitionName", (Object)temp.getDiskName().trim().replace(":", ""));
                resultObject.put((Object)"used", (Object)usedStr.trim());
                resultObject.put((Object)"unused", (Object)leftStr.trim());
                double tempDiskStepMax = NumberUtil.parseDouble((Object)usedStr.trim()) + NumberUtil.parseDouble((Object)leftStr.trim());
                if (tempDiskStepMax > diskMax) {
                    diskMax = tempDiskStepMax;
                }
                resultArray.add((Object)resultObject);
            }
        }
        return diskMax;
    }

    @Override
    @Permission(name="lego.sys.systemMonitor.scan")
    public String queryDBStatus() {
        LOGGER.debug((Object)"enter queryDBStatus");
        DecimalFormat df = new DecimalFormat("##0.0 ");
        JSONArray resultArray = new JSONArray();
        Object object = this.getBundleService("system", "sysMonitor");
        ISysMonitor mgr = (ISysMonitor)object;
        Map tempMap1 = mgr.getDataBaseInfo();
        if (tempMap1 != null) {
            double ten = 10.0;
            double dbMax = 10.0;
            StringBuffer databaseString = new StringBuffer();
            databaseString.append("<item>");
            Collection setKey1 = tempMap1.values();
            List listDataBase = new ArrayList();
            for (Object obj : setKey1) {
                listDataBase = (List)obj;
            }
            for (DataBaseInfo temp : listDataBase) {
                JSONObject resultObject = new JSONObject();
                String usedStr = temp.getUsed().trim().replace("MB", "");
                String totalStr = temp.getTotal().trim().replace("MB", "");
                String leftStr = df.format(NumberUtil.parseDouble((Object)totalStr) - NumberUtil.parseDouble((Object)usedStr));
                if (VerifyUtil.isEmpty((String)usedStr)) {
                    usedStr = "0";
                }
                if (VerifyUtil.isEmpty((String)leftStr)) {
                    leftStr = "0";
                }
                resultObject.put((Object)"dbName", (Object)temp.getDataBaseName());
                resultObject.put((Object)"used", (Object)usedStr.trim());
                resultObject.put((Object)"unused", (Object)leftStr.trim());
                double tempdbStepMax = NumberUtil.parseDouble((Object)usedStr.trim()) + NumberUtil.parseDouble((Object)leftStr.trim());
                if (tempdbStepMax > dbMax) {
                    dbMax = tempdbStepMax;
                }
                resultArray.add((Object)resultObject);
            }
            double dbStepMax = dbMax / 10.0;
            Iterator iterator = resultArray.iterator();
            while (iterator.hasNext()) {
                JSONObject obj = JSONObject.fromObject(iterator.next());
                obj.put((Object)"stepMax", (Object)dbStepMax);
            }
        }
        return resultArray.toString();
    }

    private boolean checkPasswordComplex(String password) {
        boolean case3;
        LOGGER.debug((Object)"Enter checkPasswordComplex");
        if (VerifyUtil.isEmpty((String)password) || password.length() < 8 || password.length() > 15) {
            return false;
        }
        boolean isMatch = true;
        password = Normalizer.normalize(password, Normalizer.Form.NFKC);
        boolean case1 = !Pattern.compile(LOWER_CHAR).matcher(password).find() || !Pattern.compile(NUMBER).matcher(password).find() || !Pattern.compile(SPECIAL_CHAR).matcher(password).find();
        boolean case2 = !Pattern.compile(UPPER_CHAR).matcher(password).find() || !Pattern.compile(LOWER_CHAR).matcher(password).find() || !Pattern.compile(SPECIAL_CHAR).matcher(password).find();
        boolean bl = case3 = !Pattern.compile(UPPER_CHAR).matcher(password).find() || !Pattern.compile(NUMBER).matcher(password).find() || !Pattern.compile(SPECIAL_CHAR).matcher(password).find();
        if (case1 && case2 && case3) {
            isMatch = false;
        }
        return isMatch;
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="dataMaintainence_modifyBackupInfo_operateName", operationModule="system", level=3)
    @Permission(name="ism.drm.dump.configdata.setting.operateID")
    public Response setFTPInfo(FtpServerInfo info) {
        FtpServerInfo oldFtpServerInfo;
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)"systemDataBackupParams_objectName");
        if (VerifyUtil.isEmpty((Object)info)) {
            throw new LegoCheckedException(1073947393L);
        }
        String ftpServerId = info.getFtpServerId();
        String ftpIp = info.getIp();
        String ftpPort = info.getPort() + "";
        String ftpUserName = info.getFtpUserName();
        String ftpPwd = info.getFtpPassword();
        String autoBackupFlag = info.isAutoBackupFlag() + "";
        String dataPwd = info.getDataPassword();
        String hostKey = info.getHostKey();
        ftpUserName = HtmlStringConverter.decodeByLength(ftpUserName);
        boolean isAuthChanged = false;
        boolean exportPwdChanged = false;
        FtpServerInfo ftpServerInfo = new FtpServerInfo();
        if (!VerifyUtil.isEmpty((String)dataPwd)) {
            exportPwdChanged = true;
            if (!this.checkPasswordComplex(dataPwd)) {
                LOGGER.error((Object)"change ftp server failed, check password error.", 653110170615808L);
                throw new LegoCheckedException(1073947393L);
            }
            ftpServerInfo.setDataPassword(WccEncryptor.encrypt((String)dataPwd));
        }
        if (!VerifyUtil.isEmpty((String)ftpPwd)) {
            isAuthChanged = true;
            ftpServerInfo.setFtpPassword(WccEncryptor.encrypt((String)ftpPwd));
        }
        this.checkFtpParams(isAuthChanged, info);
        IConfigDataBackupService confDataBackupService = this.getBundleService(IConfigDataBackupService.class);
        if (!Boolean.parseBoolean(autoBackupFlag) && (oldFtpServerInfo = confDataBackupService.queryFtpServerInfo(null)) != null) {
            ftpServerId = oldFtpServerInfo.getFtpServerId();
            ftpIp = oldFtpServerInfo.getIp();
            ftpUserName = oldFtpServerInfo.getFtpUserName();
            ftpPort = "" + oldFtpServerInfo.getPort();
        }
        this.setFtpServerInfo(ftpServerInfo, ftpServerId, ftpIp, ftpUserName, ftpPort);
        if (!VerifyUtil.isEmpty((String)hostKey)) {
            ftpServerInfo.setHostKey(WccEncryptor.encrypt((String)hostKey));
        }
        this.setAutoBackup(autoBackupFlag, ftpServerInfo);
        this.saveFtpInfo(isAuthChanged, exportPwdChanged, ftpServerInfo, confDataBackupService);
        return Response.ok().build();
    }

    private void setFtpServerInfo(FtpServerInfo ftpServerInfo, String ftpServerId, String ftpIp, String ftpUserName, String ftpPort) {
        ftpServerInfo.setFtpServerId(ftpServerId);
        ftpServerInfo.setIp(ftpIp);
        ftpServerInfo.setFtpUserName(ftpUserName);
        ftpServerInfo.setPort(NumberUtil.convertToInteger((Object)ftpPort).intValue());
    }

    private void saveFtpInfo(boolean isAuthChanged, boolean exportPwdChanged, FtpServerInfo ftpServerInfo, IConfigDataBackupService confDataBackupService) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)"systemDataBackupParams_objectName");
        confDataBackupService.save(ftpServerInfo, isAuthChanged, exportPwdChanged);
    }

    private void setAutoBackup(String autoBackupFlag, FtpServerInfo ftpServerInfo) {
        LOGGER.debug((Object)"enter setAutoBackup");
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)"systemDataBackupSetting_objectName");
        ftpServerInfo.setAutoBackupFlag(Boolean.parseBoolean(autoBackupFlag));
    }

    private void checkFtpParams(boolean isAuthChanged, FtpServerInfo info) {
        String ftpServerId = info.getFtpServerId();
        String ftpIp = info.getIp();
        String ftpUserName = info.getFtpUserName();
        String ftpPwd = info.getFtpPassword();
        String autoBackupFlag = info.isAutoBackupFlag() + "";
        ftpUserName = HtmlStringConverter.decodeByLength(ftpUserName);
        boolean paraValidFlag = this.isAutoBackFlagValid(autoBackupFlag);
        if (paraValidFlag && !Boolean.parseBoolean(autoBackupFlag)) {
            return;
        }
        if (!ParamChecker.checkGeneralId((String)ftpServerId)) {
            paraValidFlag = false;
        }
        boolean ipIsValid = this.checkFtpIp(ftpIp);
        boolean bl = paraValidFlag = paraValidFlag && ipIsValid && Validator.isPort(info.getPort());
        if (this.checkParamsEmpty(ftpUserName, ftpPwd)) {
            paraValidFlag = false;
        }
        if (isAuthChanged && !this.between(ftpPwd.length(), 1, 255)) {
            paraValidFlag = false;
        }
        if (!this.between(ftpUserName.length(), 1, 255)) {
            paraValidFlag = false;
        }
        if (VerifyUtil.isEmpty((String)info.getHostKey()) || !CommUtil.checkParam((String)info.getHostKey(), (int)4096)) {
            paraValidFlag = false;
        }
        if (!paraValidFlag) {
            LOGGER.error((Object)"At least one of ftp server parameters is invalid.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private boolean checkFtpIp(String ftpIp) {
        String ipType = AddressUtil.ipType((String)ftpIp);
        return "IPV4".equals(ipType) && this.isIpValid(ftpIp) || "IPV6".equals(ipType) && Ipv6AddressUtil.isValidIPv6((String)ftpIp);
    }

    private boolean checkParamsEmpty(String ftpUserName, String ftpPwd) {
        return VerifyUtil.isEmpty((String)ftpUserName) || VerifyUtil.isEmpty((String)ftpPwd);
    }

    private boolean isAutoBackFlagValid(String autoBackupFlag) {
        if (VerifyUtil.isEmpty((String)autoBackupFlag)) {
            LOGGER.error((Object)"The parameter (autoBackupFlag) is empty.", 90160758787071L);
            return false;
        }
        if (!AUTO_BACKUP_FLAG_FALSE.equalsIgnoreCase(autoBackupFlag) && !AUTO_BACKUP_FLAG_TRUE.equalsIgnoreCase(autoBackupFlag)) {
            LOGGER.error((Object)"The parameter (autoBackupFlag) is not valid.", 90160758787071L);
            return false;
        }
        return true;
    }

    private boolean isIpValid(String ftpIp) {
        if (VerifyUtil.isEmpty((String)ftpIp) || ftpIp.startsWith(LOCAL_HOST_IP_FIRST)) {
            LOGGER.error((Object)"The parameter (ftpPort) is empty or localhost.", 90160758787071L);
            return false;
        }
        String reg = "(([1-9])|([1-9]\\d)|([1]\\d{2})|(22[0-3])|(2[0-1]\\d))(\\.((\\d)|([1-9]\\d)|([1]\\d{2})|([2][0-4]\\d)|([2][5][0-5]))){2}(\\.(([1-9])|([1-9]\\d)|([1]\\d{2})|([2][0-4]\\d)|([2][5][0-5])))";
        Matcher matcher = Pattern.compile(reg).matcher(Normalizer.normalize(ftpIp, Normalizer.Form.NFKC));
        if (!matcher.matches()) {
            LOGGER.error((Object)"The parameter (ftpPort) is invalid.", 90160758787071L);
            return false;
        }
        return true;
    }

    private boolean between(int length, int min, int max) {
        return min <= length && length <= max;
    }

    @Override
    @Permission(name="ism.drm.dump.configdata.setting.operateID")
    public FtpServerInfo getFTPInfo() {
        LOGGER.debug((Object)"enter getFTPInfo");
        IConfigDataBackupService confDataBackupService = this.getBundleService(IConfigDataBackupService.class);
        FtpServerInfo serverInfo = confDataBackupService.queryFtpServerInfo(null);
        if (serverInfo != null) {
            serverInfo.setFtpPassword("");
            serverInfo.setDataPassword("");
            serverInfo.setBaseDir("");
        }
        return serverInfo;
    }

    @Permission(name="ism.drm.sys.exportrlog.setting.operateID")
    public Response changeLogLevel(Map<String, String> entity) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)"debugLog_objectName");
        if (entity == null || entity.isEmpty()) {
            LOGGER.warn((Object)"Wrong param, level:");
            throw new LegoCheckedException(1073947393L);
        }
        String level = entity.get("level");
        if (level == null || level.trim().length() == 0 || levels.get(level.toUpperCase(Locale.US)) == null) {
            LOGGER.warn((Object)("Wrong param, level:" + level));
            throw new LegoCheckedException(1073947393L);
        }
        level = level.toUpperCase(Locale.US);
        String preLevel = LogManager.getLogger((String)LOGGER_LEGO_NAME).getLevel().toString().toUpperCase(Locale.US);
        try {
            Configurator.setAllLevels((String)LOGGER_LEGO_NAME, (Level)levels.get(level));
            Configurator.setAllLevels((String)LOGGER_ISM_NAME, (Level)levels.get(level));
        }
        catch (Exception e) {
            LOGGER.error((Object)"changeLogLevel failed");
            throw new LegoCheckedException(1073947434L, (Throwable)e);
        }
        boolean success = this.configBackgroundLog(level);
        if (!success) {
            Configurator.setAllLevels((String)LOGGER_LEGO_NAME, (Level)levels.get(preLevel));
            Configurator.setAllLevels((String)LOGGER_ISM_NAME, (Level)levels.get(preLevel));
            throw new LegoCheckedException(1073947434L);
        }
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_PARAM, (Object)new String[]{preLevel, level});
        return Response.ok().build();
    }

    @Permission(name="ism.drm.sys.exportrlog.setting.operateID")
    public String queryLogLevel() {
        LOGGER.debug((Object)"enter queryLogLevel");
        Level level = LogManager.getLogger((String)LOGGER_LEGO_NAME).getLevel();
        JSONObject resultObject = new JSONObject();
        resultObject.put((Object)"level", (Object)level.toString().toUpperCase(Locale.US));
        return resultObject.toString();
    }

    private boolean configBackgroundLog(String paramString) {
        ILogConfigService localILogConfigService = SystemRestServiceImpl.getService();
        if (localILogConfigService == null) {
            LOGGER.error((Object)"Get log config Service failed.");
            return false;
        }
        boolean bool = localILogConfigService.changeLevel(paramString);
        if (bool) {
            LOGGER.warn((Object)("Succeeded in modifying background log level. The level is \"" + paramString + "\""));
            return true;
        }
        LOGGER.error((Object)("Failed in modifying background log level. The level is \"" + paramString + "\""));
        return false;
    }

    public static ILogConfigService getService() {
        ServiceContext localServiceContext = ServiceContext.getInstance();
        return (ILogConfigService)localServiceContext.lookup("KernelApplication/logConfigService");
    }

    @Override
    @ParamValidator
    @Permission(name="ism.drm.dump.configdata.setting.operateID")
    public String getFtpHostKey(String ip, Integer port) {
        String ipType = AddressUtil.ipType((String)ip);
        if ("IPV4".equals(ipType)) {
            if (!this.isIpValid(ip)) {
                LOGGER.error((Object)"SFTP server ip address is invalid ipv4 address! please check!", 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
        } else if ("IPV6".equals(ipType)) {
            if (!Ipv6AddressUtil.isValidIPv6((String)ip)) {
                LOGGER.error((Object)"SFTP server ip address is invalid ipv6 address! please check!", 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
        } else {
            LOGGER.error((Object)"SFTP server ip address is invalid ip address! please check!", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Object)port) || !Validator.isPort(port)) {
            LOGGER.error((Object)"SFTP server port number is invalid.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        IConfigDataBackupService confDataBackupService = this.getBundleService(IConfigDataBackupService.class);
        String hostKey = confDataBackupService.getFtpHostKey(ip, port);
        JSONObject jsonObject = new JSONObject();
        if (VerifyUtil.isEmpty((String)hostKey)) {
            LOGGER.error((Object)("Get SFTP hostKey failed. IP:\"" + ip + "\""));
            throw new LegoCheckedException(1073947450L);
        }
        jsonObject.put((Object)"hostKey", (Object)hostKey);
        return jsonObject.toString();
    }

    private ILogNotifierService getOptLogNotifierService() {
        return this.getBundleService(ILogNotifierService.class);
    }

    @Override
    @ParamValidator
    @Permission(name="ism.drm.sys.log.notify.scan")
    public List<LogNotifyServer> getServers(String tarLogType) {
        return this.getOptLogNotifierService().getNotifyServerListBy(tarLogType);
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="dataMaintainence_setLogNotify_operateName", operationModule="system", level=2)
    @Permission(name="ism.drm.sys.log.notify.set")
    public Response saveServer(LogNotifyServer server) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)"sysLog_objectName");
        StringBuffer buffer = new StringBuffer();
        String protocolType = server.getProtocalType();
        if (VerifyUtil.isEmpty((String)protocolType) || !CTS.equalsIgnoreCase(protocolType) && !SYSLOG.equalsIgnoreCase(protocolType) && !ELK.equalsIgnoreCase(protocolType)) {
            LOGGER.error((Object)"protocolType is incorrect");
            throw new LegoCheckedException(1073947393L);
        }
        if (server.getIsEnabled()) {
            this.checkAndSetBuffer(server, buffer, protocolType);
        } else {
            buffer.append(AUTO_BACKUP_FLAG_FALSE);
        }
        try {
            this.getOptLogNotifierService().saveOrUpdateNofityServer(server);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_PARAM, (Object)new String[]{server.getLogType(), server.getProtocalType(), buffer.toString()});
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("save date error: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)("save date error: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    private void checkAndSetBuffer(LogNotifyServer server, StringBuffer buffer, String protocolType) {
        String protocolProps = server.getProtocalProps();
        if (!ParamChecker.checkLongText((String)protocolProps)) {
            LOGGER.error((Object)"protocalProps is incorrect");
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject props = JSONObject.fromObject((Object)protocolProps);
        String ip = props.getString("ip");
        if (!CommUtil.checkDrmIpParam((String)ip) && !CommUtil.checkDrmDomainParam((String)ip)) {
            LOGGER.error((Object)("ip or domain error :" + ip));
            throw new LegoCheckedException(1073947393L);
        }
        String port = props.getString("port");
        if (!ValidateUtil.checkPort((long)NumberUtil.convertToLong((Object)port))) {
            throw new LegoCheckedException(1073947393L);
        }
        String tarLogType = server.getLogType();
        if (VerifyUtil.isEmpty((String)tarLogType) || !LOG_TYPES.contains(tarLogType)) {
            throw new LegoCheckedException(1073947393L);
        }
        String encrytionMode = null;
        if (props.containsKey((Object)"encryptionMode")) {
            encrytionMode = props.getString("encryptionMode");
        }
        if (!CTS.equalsIgnoreCase(protocolType)) {
            if (!SyslogEncryptionModeEnum.checkMode((String)encrytionMode)) {
                throw new LegoCheckedException(1073947393L);
            }
            buffer.append(ip).append(',').append(port).append(',').append(encrytionMode);
        } else {
            if (!VerifyUtil.isEmpty((String)encrytionMode)) {
                LOGGER.error((Object)("config CTS contains encryptionMode, encryptionMode : " + encrytionMode));
                throw new LegoCheckedException(1073947393L);
            }
            buffer.append(ip).append(',').append(port);
        }
    }

    @Override
    @OperationLog(operationName="dataMaintainence_Test_AutoBackupInfo_operateName", operationModule="system", level=3)
    @Permission(name="ism.drm.dump.configdata.setting.operateID")
    public Response testAutoBackupConfig() {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)"systemDataBackupParams_objectName");
        IConfigDataBackupService confDataBackupService = this.getBundleService(IConfigDataBackupService.class);
        try {
            confDataBackupService.testAutoBackupConfig();
        }
        catch (LegoCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OperationLog(operationName="dataMaintainence_exportConfigData_operateName", operationModule="system", level=1)
    public Response exportSysConfigData(String dataPassword, String isDataAnonymous) throws FileNotFoundException {
        this.checkUserOperationAuthority("dataMaintainence_exportConfigData_operateName", 1, "ism.drm.dump.configdata.scan");
        this.checkDataPassword(dataPassword);
        if (!this.isExportChecked().booleanValue()) {
            return Response.ok().build();
        }
        try {
            File fileToDownload;
            IConfigDataBackupService confDataBackupService = this.getBundleService(IConfigDataBackupService.class);
            Object object = SYS_CONFIG_EXPORT_LOCKER;
            synchronized (object) {
                fileToDownload = confDataBackupService.backupConfig(dataPassword, !VerifyUtil.isEmpty((String)isDataAnonymous) && Boolean.parseBoolean(isDataAnonymous));
            }
            if (VerifyUtil.isEmpty((Object)fileToDownload)) {
                throw new FileNotFoundException();
            }
            SystemFileUtil.downloadFile(this.getResponse(), fileToDownload, confDataBackupService, "ConfigData.zip");
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"exportConfigData error: file not found!", 653110170615808L);
            throw new LegoCheckedException(1073947393L);
        }
        catch (Exception e) {
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    private void checkDataPassword(String dataPassword) {
        if (!this.checkPasswordComplex(dataPassword)) {
            LOGGER.error((Object)"The encrypt password is error, export config data failed.", 653110170615808L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OperationLog(operationName="dataMaintainence_exportDebugLog_operateName", operationModule="system", level=1)
    public Response exportDebugLog() {
        this.checkUserOperationAuthority("dataMaintainence_exportDebugLog_operateName", 1, "ism.drm.sys.exportrlog.scan");
        String file = null;
        Object object = logExportLocker;
        synchronized (object) {
            boolean fileGenerated;
            HttpSession currentSession = this.getRequest().getSession(false);
            String exportToken = (String)currentSession.getAttribute(EXPORT_CHECKED_TOKEN);
            boolean bl = fileGenerated = !VerifyUtil.isEmpty((String)exportToken);
            if (!fileGenerated) {
                try {
                    ISoftwareInfoService softwareService = this.getBundleService(ISoftwareInfoService.class.getName(), ISoftwareInfoService.class);
                    file = softwareService.exportLogs();
                    currentSession.setAttribute(EXPORT_CHECKED_TOKEN, (Object)file);
                    return Response.ok().build();
                }
                catch (Exception e) {
                    LOGGER.error((Object)("exportLogs" + ExceptionUtil.getErrorMessage((Throwable)e)), 653110170615808L);
                    throw new LegoCheckedException(-1L);
                }
            }
            file = exportToken;
            currentSession.removeAttribute(EXPORT_CHECKED_TOKEN);
            try {
                IConfigDataBackupService confDataBackupService = this.getBundleService(IConfigDataBackupService.class);
                File fileToDownload = new File(file);
                SystemFileUtil.downloadFile(this.getResponse(), fileToDownload, confDataBackupService, null);
            }
            catch (Exception e) {
                LOGGER.error((Object)"exportLogs", 653110170615808L);
                throw new LegoCheckedException(-1L);
            }
        }
        return Response.ok().build();
    }

    static {
        levels.put("DEBUG", Level.DEBUG);
        levels.put("INFO", Level.INFO);
        levels.put("WARN", Level.WARN);
        levels.put("ERROR", Level.ERROR);
    }
}

