/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.protection.group;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLog;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.report.sdk.model.ProtectGroupStatisticInfo;
import com.huawei.ism.drm.report.sdk.service.IProtectGroupReportService;
import com.huawei.ism.drm.rest.service.platform.protection.group.AbstractProtectGroupRestService;
import com.huawei.ism.drm.rest.service.platform.protection.group.ProtectGroupValidator;
import com.huawei.ism.drm.rest.service.platform.protection.group.ScheduleFormater;
import com.huawei.ism.drm.rest.service.platform.protection.util.ProtectGroupExcelDetailsOperator;
import com.huawei.ism.drm.rest.service.platform.protection.util.ProtectGroupExcelUtil;
import com.huawei.ism.drm.rest.util.DownloadFileUtil;
import com.huawei.ism.drm.rest.util.OperationLog;
import com.huawei.ism.drm.rest.util.OperationLogAttrDefine;
import com.huawei.ism.drm.rest.util.PageParameter;
import com.huawei.ism.drm.rest.util.Permission;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.drm.web.util.FileExcelUtil;
import com.huawei.ism.drm.web.util.RequestUtil;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.service.IBackTaskService;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.system.syslog.sdk.service.SysoplogLevel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.net.URLEncodedUtils;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class ProtectGroupBaseRestServiceImpl
extends AbstractProtectGroupRestService {
    private static final Log LOGGER = LogFactory.getInstance(ProtectGroupBaseRestServiceImpl.class);
    private static final String TASK_ID = "taskId";

    @Override
    @Permission(name="ism.drm.protectgroup.auth.scan")
    public String protectgroups(int poType, String orderBy, String orderType, int pageSize, int startPage, String siteId) {
        if (!Validator.checkPageQueryParams(orderType, pageSize, startPage)) {
            LOGGER.error((Object)("orderType:" + orderType + ", pageSize:" + pageSize + ", startPage:" + startPage));
            throw new LegoCheckedException(1073947393L);
        }
        if (!this.checkProtectObjectType(poType)) {
            LOGGER.error((Object)("poType is incorrect. poType:" + poType));
            throw new LegoCheckedException(1073947393L);
        }
        Validator.canOrderBy(orderBy);
        if (!ParamChecker.checkGeneralId((String)siteId)) {
            LOGGER.error((Object)"Invalid siteId");
            throw new LegoCheckedException(1073947393L);
        }
        boolean orderByAscend = "asc".equalsIgnoreCase(orderType);
        List<QueryCondition> queryConditions = this.constructQueryCondition(poType, siteId);
        Page page = this.getBundleService(IProtectGroupService.class).pagedQueryProtectGroup(startPage, pageSize, orderBy, orderByAscend, queryConditions, this.getCurrentUserId());
        JSONObject result = new JSONObject();
        if (VerifyUtil.isEmpty((Object)page) || VerifyUtil.isEmpty((Collection)page.getResult())) {
            result.put((Object)"totalCount", (Object)0);
            result.put((Object)"records", (Object)"[]");
            return result.toString();
        }
        List protectGrsours = page.getResult();
        result.put((Object)"totalCount", (Object)page.getTotalCount());
        result.put((Object)"records", (Object)this.toProtectGroupJson(protectGrsours));
        return result.toString();
    }

    private List<QueryCondition> constructQueryCondition(int poType, String siteId) {
        String filterName = this.getRequest().getParameter("filterName");
        String filterValue = this.getRequest().getParameter("filterValue");
        if (!ParamChecker.checkGeneralText((String)filterName) || !ParamChecker.checkGeneralText((String)filterValue)) {
            LOGGER.error((Object)"Invalid filterName or filterValue");
            throw new LegoCheckedException(1073947393L);
        }
        LOGGER.debug((Object)String.format(Locale.ROOT, "poType: %s, siteId: %s", poType, siteId));
        List<QueryCondition> queryConditions = this.queryCondition(filterName, filterValue);
        if (poType != -1) {
            queryConditions.add(new QueryCondition("poType", (Object)poType));
        }
        if (!"-1".equals(siteId)) {
            this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), siteId);
            queryConditions.add(new QueryCondition("productSiteId", (Object)siteId));
        }
        return queryConditions;
    }

    @Override
    @Permission(name="ism.drm.protectgroup.auth.scan")
    public String protectgroups(String protectgroupId) {
        LOGGER.debug((Object)String.format(Locale.ROOT, "protectgroupId: %s", protectgroupId));
        this.validateProtectGroupId(protectgroupId);
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), protectgroupId);
        ProtectGroup protectGroup = this.getBundleService(IProtectGroupService.class).getProtectGroupByID(protectgroupId, false);
        this.validateProtectGroup(protectGroup);
        return this.toProtectGroupJson(protectGroup);
    }

    @Override
    @OperationLog(operationName="protectedGroup_modify_operateName", operationModule="protect", level=3)
    @Permission(name="ism.drm.protectgroup.auth.modify")
    public Response updateProtectGroupBasicInfo(String protectGroupId, ProtectGroup pg) {
        long taskId;
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)protectGroupId);
        if (VerifyUtil.isEmpty((String)protectGroupId) || !ParamChecker.checkGeneralId((String)protectGroupId) || VerifyUtil.isEmpty((Object)pg)) {
            LOGGER.debug((Object)String.format(Locale.ROOT, "protectgroupId: %s, pg: %s", protectGroupId, pg));
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup oldProtectGroup = null;
        ProtectGroupValidator.updateProtectGroupBasicInfoCheck(protectGroupId, pg.getName(), pg.getDescription());
        this.checkUserBizObjAuthority("protectedGroup_modify_operateName", SysoplogLevel.NORMAL.getValue(), protectGroupId);
        try {
            oldProtectGroup = this.getService().getProtectGroupBasicInfo(protectGroupId, false);
            if (oldProtectGroup == null) {
                LOGGER.error((Object)("protectgroup [id:" + protectGroupId + "] is not existed!"), 653110170615808L);
                throw new LegoCheckedException(1073947394L);
            }
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)oldProtectGroup.getName());
            if (this.validateIsHypermetro(oldProtectGroup) || this.validateIsReplication(oldProtectGroup)) {
                throw new LegoCheckedException(1073947453L);
            }
            pg.setUuid(protectGroupId);
            taskId = this.getService().updateProtectGroupBasicInfo(pg, Boolean.valueOf(this.isMachineToMachineReq()));
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_PARAM, (Object)new String[]{oldProtectGroup.getName(), pg.getName(), VerifyUtil.isEmpty((String)oldProtectGroup.getDescription()) ? "" : oldProtectGroup.getDescription(), VerifyUtil.isEmpty((String)pg.getDescription()) ? "" : pg.getDescription()});
        }
        catch (LegoCheckedException le) {
            String pgName = pg.getName();
            if (oldProtectGroup != null) {
                pgName = oldProtectGroup.getName();
            }
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)pgName);
            throw le;
        }
        catch (Exception le) {
            String pgName = pg.getName();
            if (null != oldProtectGroup) {
                pgName = oldProtectGroup.getName();
            }
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)pgName);
            throw new LegoCheckedException(-1L);
        }
        JSONObject obj = new JSONObject();
        obj.put((Object)TASK_ID, (Object)taskId);
        return Response.ok((Object)obj.toString()).build();
    }

    @Override
    @Permission(name="ism.drm.protectgroup.auth.scan")
    public String getProtectGroupReplicas(String protectGroupId, Integer status, Long startTime, Long endTime) {
        this.validateProtectGroupId(protectGroupId);
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), protectGroupId);
        List<ProtectGroupReplica> replicas = null;
        try {
            IReplicaService replicaService = this.getBundleService(IReplicaService.class);
            replicas = replicaService.queryProtectGroupReplicaByGroup(protectGroupId, "TIME_STAMP", false, false);
        }
        catch (Exception e) {
            LOGGER.debug((Object)String.format(Locale.ROOT, "protectgroupId: %s, status: %s", protectGroupId, status));
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        IProtectGroupService pgServices = this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        ProtectGroup pg = pgServices.getProtectGroupBasicInfo(protectGroupId, false);
        this.filterReplicas(pg, replicas, status, startTime, endTime);
        replicas = this.sortReplicaByLocation(replicas);
        return this.protectGroupReplicaListToJsonStr(replicas).toString();
    }

    @Override
    @Permission(name="ism.drm.protectgroup.auth.scan")
    public String pageQueryProtectGroupReplicas(String protectGroupId, Integer status, Long startTime, Long endTime, String siteId, Integer pageNum, Integer replicaType) {
        Integer pageSize = 10;
        this.checkPartialParams(protectGroupId, siteId);
        List<Object> replicas = null;
        IProtectGroupService pgServices = this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        ProtectGroup pg = pgServices.getProtectGroupByID(protectGroupId, false);
        IReplicaService replicaService = this.getBundleService(IReplicaService.class);
        Set schedules = pg.getTemplate().getSchedules();
        Integer totalCount = 0;
        boolean isHyperCDP = false;
        try {
            replicas = replicaService.queryProtectGroupReplicaByGroup(protectGroupId, "TIME_STAMP", false, true);
            if (!VerifyUtil.isEmpty((Collection)replicas)) {
                replicas = this.getSiteProtectGroupReplicas((List<ProtectGroupReplica>)replicas, siteId);
            }
            for (Schedule schedule : schedules) {
                if (schedule.getScheduleMode() != 0 || schedule.getPeriodType() != 5 || !schedule.getSourceSiteId().equals(siteId)) continue;
                replicas.addAll(replicaService.querySecondProtectGroupReplica(protectGroupId, schedule, pageNum, pageSize, startTime, endTime));
                if (schedule.getProtectedType() != ScheduleProtectedType.HYPERCDP.getValue() || replicaType != 4) continue;
                isHyperCDP = true;
                totalCount = replicaService.querySecondProtectGroupReplicaCount(protectGroupId, schedule, startTime, endTime);
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)String.format(Locale.ROOT, "protectgroupId: %s, status: %s", protectGroupId, status));
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        if (null != replicaType) {
            replicas = replicas.stream().filter(replica -> replica.getType() == replicaType.intValue()).collect(Collectors.toList());
        }
        if (!isHyperCDP) {
            this.filterReplicas(pg, replicas, status, startTime, endTime);
            totalCount = replicas.size();
            replicas = this.getGroupReplicasByPages(replicas, pageNum, pageSize);
        }
        replicas = this.sortReplicaByLocation(replicas);
        JSONObject jsonObj = this.getjObj(replicas, totalCount);
        return jsonObj.toString();
    }

    private JSONObject getjObj(List<ProtectGroupReplica> replicas, Integer totalCount) {
        String jArray = this.protectGroupReplicaListToJsonStr(replicas).toString();
        JSONArray jsonArray = JSONArray.fromObject((Object)jArray);
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"replicas", (Object)jsonArray);
        jsonObj.put((Object)"totalCount", (Object)totalCount);
        return jsonObj;
    }

    private void checkPartialParams(String protectGroupId, String siteId) {
        this.validateProtectGroupId(protectGroupId);
        if (!ParamChecker.checkGeneralId((String)siteId)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), protectGroupId);
    }

    private List<ProtectGroupReplica> sortReplicaByLocation(List<ProtectGroupReplica> replicas) {
        if (VerifyUtil.isEmpty(replicas)) {
            LOGGER.debug((Object)"replicas is empty!");
        }
        ArrayList<ProtectGroupReplica> result = new ArrayList<ProtectGroupReplica>(replicas);
        ArrayList<ProtectGroupReplica> toSortList = new ArrayList<ProtectGroupReplica>();
        for (ProtectGroupReplica replica : replicas) {
            if (!VerifyUtil.isEmpty((String)replica.getTimeStamp())) continue;
            toSortList.add(replica);
        }
        result.removeAll(toSortList);
        Collections.sort(toSortList, new Comparator<ProtectGroupReplica>(){

            @Override
            public int compare(ProtectGroupReplica paramT1, ProtectGroupReplica paramT2) {
                return paramT1.getProtectLocation() - paramT2.getProtectLocation();
            }
        });
        result.addAll(toSortList);
        return result;
    }

    @Override
    @Permission(name="ism.drm.protectgroup.auth.scan")
    public String getProtectGroupHistoryLogs(String protectGroupId, int startPage, int pageSize, String orderBy, String orderType) {
        this.validateProtectGroupId(protectGroupId);
        if (!Validator.checkPageQueryParams(pageSize, startPage)) {
            LOGGER.error((Object)"Invalid pageSize or startPage!");
            throw new LegoCheckedException(1073947393L);
        }
        Validator.canOrderBy(orderBy);
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), protectGroupId);
        boolean isAsc = true;
        if (orderType == null || orderType.equalsIgnoreCase("desc")) {
            isAsc = false;
        }
        Page page = this.getService().pageQueryHistoryLogFromAll(startPage, pageSize, orderBy, isAsc, protectGroupId);
        List result = page.getResult();
        long totalCount = page.getTotalCount();
        JSONObject jasonObject = new JSONObject();
        jasonObject.put((Object)"totalCount", (Object)totalCount);
        JSONArray array = new JSONArray();
        List logList = result;
        for (ProtectGroupLog groupLog : logList) {
            JSONObject obj = new JSONObject();
            try {
                obj.put((Object)"historyLogId", (Object)groupLog.getHistoryLogId());
                obj.put((Object)"info", (Object)groupLog.getInfo());
                String startTime = groupLog.getStartTime();
                obj.put((Object)"startTime", (Object)(startTime != null ? this.formatData(startTime) : "--"));
                String endTime = groupLog.getEndTime();
                obj.put((Object)"endTime", (Object)(endTime != null ? this.formatData(endTime) : "--"));
                String executeTime = this.calcExecuteTime(startTime, endTime);
                obj.put((Object)"executeTime", (Object)executeTime);
                obj.put((Object)"result", (Object)groupLog.getResult());
                array.add((Object)obj);
            }
            catch (Exception e) {
                LOGGER.error((Object)"JSON operation failed.", (Throwable)e, 653110170615808L);
            }
        }
        jasonObject.put((Object)"records", (Object)array);
        return jasonObject.toString();
    }

    @Override
    @Permission(name="ism.drm.protectgroup.auth.scan")
    public String getProtectGroupLogDetails(String protectGroupId, int logId) {
        this.validateProtectGroupId(protectGroupId);
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), protectGroupId);
        List result = null;
        result = -1 == logId ? this.getService().queryRunningHistoryLog(protectGroupId) : this.getService().queryHistoryLogDetailFromAll(logId, protectGroupId);
        JSONArray array = new JSONArray();
        if (!VerifyUtil.isEmpty((Collection)result)) {
            for (ProtectGroupLogDetail groupLogDetail : result) {
                JSONObject obj = new JSONObject();
                try {
                    this.addGroupDetailToJson(array, groupLogDetail, obj);
                }
                catch (LegoCheckedException e) {
                    LOGGER.error((Object)"JSON operation failed.", (Throwable)e, 653110170615808L);
                }
            }
        }
        return array.toString();
    }

    @Override
    @Permission(name="ism.drm.protectgroup.auth.scan")
    public String getAvailableProtectObject(int poType, String deviceSn) {
        Map<String, Object> queryParam = this.getExtParamInQueryParam();
        if (VerifyUtil.isEmpty((String)deviceSn) || !ParamChecker.checkGeneralId((String)deviceSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        IResourceService resourceService = (IResourceService)this.getBundleService("DRM_Base", IResourceService.class.getName());
        DrResource resource = resourceService.getDrResourceBySn(deviceSn);
        if (VerifyUtil.isEmpty((Object)resource)) {
            throw new LegoCheckedException(1073947394L);
        }
        this.checkUserMoAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), deviceSn);
        if (!this.checkProtectObjectType(poType)) {
            LOGGER.error((Object)("poType is incorrect. poType:" + poType));
            throw new LegoCheckedException(1073947393L);
        }
        IProtectObjectProviderDelegate poProvider = this.getBundleService(IProtectObjectProviderDelegate.class.getName(), IProtectObjectProviderDelegate.class);
        List poList = poProvider.getAvailableProtectObject(poType, deviceSn, queryParam);
        return this.protectObjectListToJsonStr(poList).toString();
    }

    @Override
    @OperationLog(operationName="protectedGroup_create_operateName", operationModule="protect", level=1)
    @Permission(name="ism.drm.protectgroup.auth.add")
    public Response getProtectObjectStorageInfo(ProtectObject po) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)po.getName());
        if (VerifyUtil.isEmpty((Object)po)) {
            LOGGER.error((Object)"po is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)po.getMoUuid()) || !ParamChecker.checkGeneralId((String)po.getMoUuid())) {
            LOGGER.error((Object)"moUuid is empty or incorrect!");
            throw new LegoCheckedException(1073947393L);
        }
        if (!this.checkProtectObjectType(po.getPoType())) {
            LOGGER.error((Object)"poType is incorrect!");
            throw new LegoCheckedException(1073947393L);
        }
        String moProviderSn = this.getMoProviderSn(po);
        if (VerifyUtil.isEmpty((String)moProviderSn)) {
            LOGGER.error((Object)"moProviderSn is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserMoAuthority("protectedGroup_create_operateName", SysoplogLevel.INFO.getValue(), moProviderSn);
        IProtectObjectProviderDelegate poProviderDelegate = this.getBundleService(IProtectObjectProviderDelegate.class.getName(), IProtectObjectProviderDelegate.class);
        poProviderDelegate.discoveryProtectObjectStorageInfo(po.getPoType(), po, null);
        return Response.ok().build();
    }

    @Override
    @Permission(name="ism.drm.protectgroup.auth.scan")
    public String getProtectObjcetInProtectGroupByPage(String orderBy, String orderType, int pageSize, int startPage, String protectgroupId, int poType) {
        this.validateProtectGroupId(protectgroupId);
        if (!Validator.checkPageQueryParams(pageSize, startPage)) {
            LOGGER.error((Object)"Invalid pageSize or startPage!");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), protectgroupId);
        Validator.canOrderBy(orderBy);
        if (!this.checkProtectObjectType(poType)) {
            LOGGER.error((Object)("poType is incorrect. poType:" + poType));
            throw new LegoCheckedException(1073947393L);
        }
        IProtectGroupService pgServices = this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        String orderByField = "name";
        if (!VerifyUtil.isEmpty((String)orderBy)) {
            orderByField = orderBy;
        }
        JSONObject jsonObject = new JSONObject();
        try {
            Page page = pgServices.pagedQueryProtectObjectByPg(startPage, pageSize, orderByField, !"desc".equalsIgnoreCase(orderType), protectgroupId, Integer.valueOf(poType));
            long total = page.getTotalCount();
            List protectObjects = page.getResult();
            jsonObject.put((Object)"totalCount", (Object)total);
            jsonObject.put((Object)"records", this.protectObjectListToJsonStr(protectObjects));
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("Querying protect object by pg failed. PgId:" + protectgroupId), (Throwable)e, 90160758784001L);
            throw e;
        }
        catch (Exception e) {
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return jsonObject.toString();
    }

    private String getMoProviderSn(ProtectObject po) {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("uuid", po.getMoUuid());
        List moLists = this.getBundleService(IResourceService.class).queryMoList(ManagedObject.class, query);
        if (!VerifyUtil.isEmpty((Collection)moLists)) {
            ManagedObject mo = (ManagedObject)moLists.get(0);
            po.setName(mo.getName());
            while (mo.getParentMo() != null) {
                mo = mo.getParentMo();
            }
            if (mo instanceof NetworkEntity) {
                return ((NetworkEntity)mo).getSn();
            }
        }
        LOGGER.debug((Object)"cannot get the sn!");
        return null;
    }

    @Override
    @OperationLog(operationName="protectedGroup_activeProtectedGroup_operateName", operationModule="protect", level=3)
    @Permission(name="ism.drm.protectgroup.auth.enable")
    public Response enableProtectGroup(String protectgroupId) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)protectgroupId);
        ProtectGroup pg = null;
        this.validateProtectGroupId(protectgroupId);
        this.checkUserBizObjAuthority("protectedGroup_activeProtectedGroup_operateName", SysoplogLevel.NORMAL.getValue(), protectgroupId);
        try {
            IProtectGroupService pgServices = this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
            pg = pgServices.getProtectGroupBasicInfo(protectgroupId, false);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)pg.getName());
            pgServices.enableProtectGroup(protectgroupId);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("enableProtectGroup error!" + ExceptionUtil.getErrorMessage((Throwable)e)));
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(pg == null ? "" : (VerifyUtil.isEmpty((String)pg.getName()) ? "" : pg.getName())));
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)("enableProtectGroup error!" + ExceptionUtil.getErrorMessage((Throwable)e)));
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(pg == null ? "" : (VerifyUtil.isEmpty((String)pg.getName()) ? "" : pg.getName())));
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    @Override
    @OperationLog(operationName="protectedGroup_disableProtectedGroup_operateName", operationModule="protect", level=3)
    @Permission(name="ism.drm.protectgroup.auth.disable")
    public Response disableProtectGroup(String protectgroupId) {
        ProtectGroup pg = null;
        this.validateProtectGroupId(protectgroupId);
        this.checkUserBizObjAuthority("protectedGroup_disableProtectedGroup_operateName", SysoplogLevel.WARNING.getValue(), protectgroupId);
        try {
            IProtectGroupService pgServices = this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
            pg = pgServices.getProtectGroupBasicInfo(protectgroupId, false);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)pg.getName());
            pgServices.disableProtectGroup(protectgroupId);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("disableProtectGroup error!" + ExceptionUtil.getErrorMessage((Throwable)e)));
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(pg == null ? "" : (VerifyUtil.isEmpty((String)pg.getName()) ? "" : pg.getName())));
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)("disableProtectGroup error!" + ExceptionUtil.getErrorMessage((Throwable)e)));
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(pg == null ? "" : (VerifyUtil.isEmpty((String)pg.getName()) ? "" : pg.getName())));
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    @Override
    @OperationLog(operationName="protectedGroup_refreshProtectedGroup_operateName", operationModule="protect", level=3)
    @Permission(name="ism.drm.protectgroup.auth.refresh")
    public Response refreshProtectGroup(String protectgroupId) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)protectgroupId);
        ProtectGroup pg = null;
        this.validateProtectGroupId(protectgroupId);
        this.checkUserBizObjAuthority("protectedGroup_refreshProtectedGroup_operateName", SysoplogLevel.INFO.getValue(), protectgroupId);
        try {
            IProtectGroupService pgServices = this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
            pg = pgServices.getProtectGroupBasicInfo(protectgroupId, false);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)pg.getName());
            if (this.validateIsHypermetro(pg) || this.validateIsReplication(pg)) {
                throw new LegoCheckedException(1073947453L);
            }
            pgServices.refreshProtectGroup(protectgroupId);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("refreshProtectGroup error!" + ExceptionUtil.getErrorMessage((Throwable)e)));
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(pg == null ? "" : (VerifyUtil.isEmpty((String)pg.getName()) ? "" : pg.getName())));
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)("refreshProtectGroup error!" + ExceptionUtil.getErrorMessage((Throwable)e)));
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(pg == null ? "" : (VerifyUtil.isEmpty((String)pg.getName()) ? "" : pg.getName())));
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    @Override
    @OperationLog(operationName="protectedGroup_delete_operateName", operationModule="protect", level=2)
    @Permission(name="ism.drm.protectgroup.auth.delete")
    public Response delProtectGroup(String protectgroupId) {
        long taskId;
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)protectgroupId);
        ProtectGroup pg = null;
        this.validateProtectGroupId(protectgroupId);
        this.checkUserBizObjAuthority("protectedGroup_delete_operateName", SysoplogLevel.WARNING.getValue(), protectgroupId);
        try {
            IProtectGroupService pgServices = this.getService();
            pg = pgServices.getProtectGroupBasicInfo(protectgroupId, false);
            if (pg == null) {
                LOGGER.error((Object)("protectgroup [id:" + protectgroupId + "] is not existed!"), 90160758784001L);
                throw new LegoCheckedException(1073947394L);
            }
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)pg.getName());
            if (this.validateIsHypermetro(pg) || this.validateIsReplication(pg)) {
                throw new LegoCheckedException(1073947453L);
            }
            taskId = pgServices.deleteProtectGroup(protectgroupId, Boolean.valueOf(this.isMachineToMachineReq()));
        }
        catch (LegoCheckedException e) {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(pg == null ? "" : (VerifyUtil.isEmpty((String)pg.getName()) ? "" : pg.getName())));
            throw e;
        }
        catch (Exception e) {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(pg == null ? "" : (VerifyUtil.isEmpty((String)pg.getName()) ? "" : pg.getName())));
            throw new LegoCheckedException(-1L);
        }
        JSONObject obj = new JSONObject();
        obj.put((Object)TASK_ID, (Object)taskId);
        return Response.ok((Object)obj.toString()).build();
    }

    @Override
    public String getSupportProtectObjectTypes() {
        IProtectObjectProviderDelegate iProtectObjectProvider = this.getBundleService(IProtectObjectProviderDelegate.class.getName(), IProtectObjectProviderDelegate.class);
        LOGGER.error((Object)"interface method [getSupportProtectObjectTypes] is invoked!");
        return this.protectObjectListToJsonStr(iProtectObjectProvider.getSupportProtectObjectTypes()).toString();
    }

    @Override
    @Permission(name="ism.drm.protectgroup.auth.scan")
    public String getGroupBriefInfo(String pgId) {
        Map protectGroupDataMap;
        this.validateProtectGroupId(pgId);
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), pgId);
        try {
            Long replicaCount;
            IProtectGroupService pgServices = this.getService();
            protectGroupDataMap = pgServices.getProtectGroupBriefInfo(pgId);
            Object propObj = protectGroupDataMap.get("props");
            JSONArray rpoJsonArray = null;
            JSONArray rtoJsonArray = null;
            ProtectGroup pg = pgServices.getProtectGroupBasicInfo(pgId, false);
            if (propObj != null) {
                Map props = (Map)propObj;
                rpoJsonArray = this.extractRPOorRTO(props, "RPO_ITEM_KEY", pg);
                rtoJsonArray = this.extractRPOorRTO(props, "RTO_ITEM_KEY", pg);
            }
            if (PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(pg.getTemplate().getType()) && (replicaCount = Long.valueOf(protectGroupDataMap.get("replicaCount").toString())) != null) {
                protectGroupDataMap.put("replicaCount", replicaCount - 1L);
            }
            ProtectGroup protectGroup = pgServices.getProtectGroupByID(pgId, false);
            Set schedules = protectGroup.getTemplate().getSchedules();
            Long replicaCount2 = Long.valueOf(protectGroupDataMap.get("replicaCount").toString());
            IReplicaService replicaService = this.getBundleService(IReplicaService.class);
            for (Schedule schedule : schedules) {
                if (schedule.getScheduleMode() != 0 || schedule.getPeriodType() != 5 || schedule.getProtectedType() != ScheduleProtectedType.HYPERCDP.getValue() || pg.getPoCount() == 0) continue;
                replicaCount2 = replicaCount2 + (long)replicaService.querySecondProtectGroupReplicaCount(pgId, schedule, null, null).intValue();
            }
            ScheduleFormater.format(new ArrayList<Schedule>(schedules));
            protectGroupDataMap.put("template", protectGroup.getTemplate());
            protectGroupDataMap.put("replicaCount", replicaCount2);
            protectGroupDataMap.put("RPO_ITEM_KEY", rpoJsonArray);
            protectGroupDataMap.put("RTO_ITEM_KEY", rtoJsonArray);
            this.removeNullValue(protectGroupDataMap);
        }
        catch (Exception e) {
            LOGGER.error((Object)("getGroupBriefInfo error!errormsg:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return JSONObject.fromObject((Object)protectGroupDataMap).toString();
    }

    private void removeNullValue(Map<String, Object> protectGroupDataMap) {
        Iterator<Map.Entry<String, Object>> it = protectGroupDataMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            String key = entry.getKey();
            if (protectGroupDataMap.get(key) != null) continue;
            it.remove();
        }
    }

    @Override
    @Permission(name="ism.drm.protectgroup.auth.scan")
    public String getPGStatisticInfo(String pgId, DrmEnumDefine.ReportTimeRangeE range) {
        int failCount;
        int successCount;
        this.validateProtectGroupId(pgId);
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), pgId);
        IProtectGroupService pgService = this.getBundleService("DRM_Base", IProtectGroupService.class.getName(), IProtectGroupService.class);
        ProtectGroup protectGroup = pgService.getProtectGroupBasicInfo(pgId, false);
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            LOGGER.error((Object)"protectgroup is null");
            throw new LegoCheckedException(1073947394L);
        }
        IProtectGroupReportService reportService = this.getBundleService("DRM_Report", IProtectGroupReportService.class.getName(), IProtectGroupReportService.class);
        if (VerifyUtil.isEmpty((Object)range)) {
            range = DrmEnumDefine.ReportTimeRangeE.LAST_24_HOURS;
        }
        ProtectGroupStatisticInfo result = null;
        result = protectGroup.isPrimary() ? reportService.getProtectGroupExecutedInfo(pgId, range, this.getCurrentUserId()) : reportService.getRemoteProtectGroupExecutedInfo(pgId, range, this.getCurrentUserId());
        if (result == null) {
            successCount = 0;
            failCount = 0;
        } else {
            successCount = result.getSuccessNum();
            failCount = result.getTotalNum() - result.getSuccessNum();
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"successCount", (Object)successCount);
        jsonObject.put((Object)"failCount", (Object)failCount);
        return jsonObject.toString();
    }

    @Override
    @Permission(name="ism.drm.protectgroup.auth.scan")
    public String getAddAvailableProtectObject(int poType, String pgId) {
        this.validateProtectGroupId(pgId);
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), pgId);
        if (!this.checkProtectObjectType(poType)) {
            LOGGER.error((Object)("poType is incorrect. poType:" + poType));
            throw new LegoCheckedException(1073947393L);
        }
        IProtectObjectProviderDelegate poService = this.getBundleService(IProtectObjectProviderDelegate.class.getName(), IProtectObjectProviderDelegate.class);
        IProtectGroupService pgService = this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        Map<String, Object> extParamInQueryParam = this.getExtParamInQueryParam();
        ProtectGroup group = pgService.getProtectGroupByID(pgId, false);
        CommUtils.checkObjectExists(group);
        Set polist = group.getPolist();
        if (polist == null) {
            throw new LegoCheckedException(1073947393L);
        }
        String poProviderSN = null;
        String providerSN = null;
        for (ProtectObject po : polist) {
            if (po.getPoType() == poType) {
                poProviderSN = po.getProviderSN();
                break;
            }
            if (VerifyUtil.isEmpty((Collection)po.getUsedStorageResourceSet())) {
                LOGGER.error((Object)("UsedStorageResourceSet is empty!. poName:" + po.getName()));
                throw new LegoCheckedException(1073947393L);
            }
            Iterator iterator = po.getUsedStorageResourceSet().iterator();
            if (!iterator.hasNext()) continue;
            providerSN = ((ProtectObjectStorageInfo)iterator.next()).getResourceProviderSN();
        }
        if (poProviderSN == null) {
            poProviderSN = providerSN;
        }
        if (poProviderSN == null) {
            LOGGER.error((Object)"poProviderSN is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        List poList = poService.getAddAvailableProtectObject(poType, poProviderSN, pgId, extParamInQueryParam);
        return this.protectObjectListToJsonStr(poList).toString();
    }

    @Override
    @OperationLog(operationName="protectedGroup_exportProtectedGuop_operateName", operationModule="protect", level=1)
    @Permission(name="ism.drm.protectgroup.auth.export")
    public Response exportProtectGroup(int poType) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)"allProtectedGroup_objectName");
        try {
            if (!this.checkProtectObjectType(poType)) {
                LOGGER.error((Object)"poType is incorrect. poType: %s", new Object[]{String.valueOf(poType)});
                throw new LegoCheckedException(1073947393L);
            }
            IProtectGroupService pgServices = this.getBundleService(IProtectGroupService.class);
            Locale locale = RequestUtil.getLocale(super.getRequest());
            pgServices.exportProtectGroupByType(super.getCurrentUser(), poType, locale, this.isExportChecked().booleanValue());
            return Response.ok().build();
        }
        catch (LegoCheckedException e) {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)("poType" + poType));
            throw e;
        }
        catch (Exception le) {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)("poType" + poType));
            throw new LegoCheckedException(-1L);
        }
    }

    @Override
    @OperationLog(operationName="protectedGroup_downLoadProtectedGuop_operateName", operationModule="protect", level=1)
    @Permission(name="ism.drm.protectgroup.auth.export")
    public Response downloadfile(Long taskId) throws IOException {
        BatchOperationResult result = new BatchOperationResult();
        CommUtils.checkParamEmpty(taskId);
        IBackTaskService service = (IBackTaskService)this.getBundleService("task", "backTask");
        BackTask backTask = service.readTask(taskId.longValue());
        String fileName = this.getFileName(taskId, backTask);
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)fileName);
        CommUtils.checkParamEmpty(fileName);
        ProtectGroupExcelUtil util = new ProtectGroupExcelUtil();
        File realPathFile = new File(this.getSession().getServletContext().getRealPath("")).getParentFile();
        if (realPathFile == null || realPathFile.getParentFile() == null) {
            LOGGER.error((Object)"Get parent file failed: TaskId:%s", new Object[]{String.valueOf(taskId)});
            throw new LegoCheckedException(1073947394L);
        }
        String exportFolderPath = realPathFile.getParentFile().getCanonicalPath();
        File file = new File(exportFolderPath + "/LegoRuntime/data/export/" + fileName);
        if (!file.exists() || !file.isFile()) {
            LOGGER.error((Object)"no file exist:%s", new Object[]{fileName});
            throw new LegoCheckedException(1073947394L);
        }
        String displayName = file.getName();
        int index = displayName.indexOf("-");
        if (index == 0 && displayName.startsWith("-")) {
            index = displayName.indexOf("-", 1);
        }
        if (index < 0) {
            LOGGER.error((Object)"no file exist:%s", new Object[]{fileName});
            throw new LegoCheckedException(1073947394L);
        }
        String userIdStr = displayName.substring(0, index);
        this.checkUserIdStr(fileName, userIdStr);
        if (!this.isExportChecked().booleanValue()) {
            return Response.ok().build();
        }
        displayName = "ExportProtectGroup" + displayName.substring(index);
        util.downloadFile(this.getResponse(), file, displayName);
        return Response.ok((Object)result).build();
    }

    private void checkUserIdStr(String fileName, String userIdStr) {
        if (!NumberUtil.convertToLong((Object)userIdStr).equals(this.getCurrentUserId())) {
            LOGGER.error((Object)"file not belongs current user:%s", new Object[]{fileName});
            throw new LegoCheckedException(1073947400L);
        }
    }

    private String getFileName(Long taskId, BackTask backTask) {
        if (backTask == null) {
            LOGGER.error((Object)"no backTask exist:%s", new Object[]{String.valueOf(taskId)});
            throw new LegoCheckedException(1073947394L);
        }
        List nameList = URLEncodedUtils.parse((CharSequence)backTask.getTaskLink(), (Charset)StandardCharsets.UTF_8);
        String fileName = null;
        for (NameValuePair pair : nameList) {
            if (!"file".equalsIgnoreCase(pair.getName())) continue;
            fileName = pair.getValue();
            break;
        }
        return fileName;
    }

    @Override
    @OperationLog(operationName="protectedGroup_exportProtectedGroupLogDetail_operateName", operationModule="protect", level=1)
    @Permission(name="ism.drm.protectgroup.auth.scan")
    public Response exportProtectGroupLogDetails(String protectGroupId, int logId) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)protectGroupId);
        this.validateProtectGroupId(protectGroupId);
        this.validateLogId(logId);
        this.checkUserBizObjAuthority("protectedGroup_exportProtectedGroupLogDetail_operateName", SysoplogLevel.INFO.getValue(), protectGroupId);
        BatchOperationResult result = new BatchOperationResult();
        ProtectGroup pg = null;
        try {
            List pgLogDetails = this.getService().queryHistoryLogDetailFromAll(logId, protectGroupId);
            CommUtils.checkObjectExists(pgLogDetails);
            if (!this.isExportChecked().booleanValue()) {
                return Response.ok().build();
            }
            pg = this.getService().getProtectGroupByID(protectGroupId, false);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)pg.getName());
            this.exportDetailsHelper(pgLogDetails, result, pg.getName());
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("Export protectGroup log details failed >>>>>>. msg:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(pg == null ? "" : pg.getName()));
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Export protectGroup log details failed >>>>>>. msg:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(pg == null ? "" : pg.getName()));
            throw new LegoCheckedException(-1L);
        }
        return Response.ok((Object)result).build();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exportDetailsHelper(List<ProtectGroupLogDetail> pgList, BatchOperationResult result, String pgName) {
        File excelFile;
        block10: {
            ProtectGroupExcelDetailsOperator details = new ProtectGroupExcelDetailsOperator(this);
            FileOutputStream fileOutputStream = null;
            excelFile = null;
            try {
                Workbook wb = details.createExportExcel(pgList, result);
                excelFile = new File(FileExcelUtil.getExportCSVFilePath(this.getSession(), pgName, pgList));
                fileOutputStream = new FileOutputStream(excelFile);
                wb.write((OutputStream)fileOutputStream);
                DownloadFileUtil.downloadFile(this.getResponse(), this.getRequest(), excelFile);
                if (fileOutputStream == null) break block10;
            }
            catch (LegoCheckedException e) {
                try {
                    LOGGER.error((Object)"Creating exported excel failed.", (Throwable)e, 90160758784001L);
                    throw e;
                    catch (Exception ex) {
                        LOGGER.error((Object)("Export protectGroup log details failed >>>>>>. msg:" + ExceptionUtil.getErrorMessage((Throwable)ex)));
                        throw new LegoCheckedException(1073948423L, (Throwable)ex);
                    }
                }
                catch (Throwable throwable) {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException e2) {
                            LOGGER.error((Object)e2, 90160758784000L);
                        }
                    }
                    this.deleteTempFile(excelFile);
                    throw throwable;
                }
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)e, 90160758784000L);
            }
        }
        this.deleteTempFile(excelFile);
    }

    private void deleteTempFile(File excelFile) {
        if (excelFile != null && excelFile.exists() && !excelFile.delete()) {
            LOGGER.error((Object)"Delete file error.");
        }
    }

    @Override
    @Permission(name="ism.drm.protectgroup.auth.scan")
    public String checkProtectGroupName(String pgname) {
        if (!CommUtil.checkDrmNameParam((String)pgname)) {
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject resultObject = new JSONObject();
        boolean isNotExisted = true;
        try {
            IProtectGroupService pgServices = this.getService();
            isNotExisted = pgServices.checkGroupName(null, pgname);
        }
        catch (Exception e) {
            LOGGER.error((Object)("checkGroupName failed. msg:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        resultObject.put((Object)"isExisted", (Object)(!isNotExisted ? 1 : 0));
        return resultObject.toString();
    }

    @Override
    @Permission(name="ism.drm.protectgroup.auth.scan")
    public String pageQueryAddAvailableProtectObject(String protectGroupId, int poType, String orderBy, String orderType, String filterName, String filterValue) {
        Map<String, Object> queryParam = this.getExtParamInQueryParam();
        PageParameter pageParame = this.getPageParameter();
        Integer startPage = pageParame.getStartPage();
        Integer pageSize = pageParame.getPageSize();
        this.checkParams(protectGroupId, poType, filterName, filterValue);
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), protectGroupId);
        IProtectGroupService pgServices = this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        ProtectGroup pg = pgServices.getProtectGroupByID(protectGroupId, false);
        String deviceSn = pg.getPoProviderSN();
        queryParam.put("orderBy", orderBy);
        queryParam.put("pageSize", pageSize);
        queryParam.put("pageIndex", startPage);
        queryParam.put("orderType", orderType);
        queryParam.put("userId", this.getCurrentUserId());
        queryParam.put("pg", pg);
        if (!VerifyUtil.isEmpty((String)filterName) && !VerifyUtil.isEmpty((String)filterValue)) {
            queryParam.put("filterName", filterName);
            queryParam.put("filterValue", filterValue);
        }
        IProtectObjectProviderDelegate poProvider = this.getBundleService(IProtectObjectProviderDelegate.class.getName(), IProtectObjectProviderDelegate.class);
        List poList = poProvider.getAddAvailableProtectObject(poType, deviceSn, protectGroupId, queryParam);
        Map<String, Object> queryAllParam = this.getExtParamInQueryParam();
        queryAllParam.put("pg", pg);
        if (!VerifyUtil.isEmpty((String)filterName) && !VerifyUtil.isEmpty((String)filterValue)) {
            queryAllParam.put("filterName", filterName);
            queryAllParam.put("filterValue", filterValue);
        }
        queryAllParam.put("userId", this.getCurrentUserId());
        List poAllList = poProvider.getAddAvailableProtectObject(poType, deviceSn, protectGroupId, queryAllParam);
        int totalCount = 0;
        if (null != poAllList) {
            totalCount = poAllList.size();
        }
        String records = this.protectObjectListToJsonStr(poList).toString();
        JSONObject result = new JSONObject();
        result.put((Object)"totalCount", (Object)totalCount);
        result.put((Object)"records", (Object)records);
        return result.toString();
    }

    private void checkParams(String protectGroupId, int poType, String filterName, String filterValue) {
        if (!this.checkProtectObjectType(poType)) {
            LOGGER.error((Object)("poType is incorrect. poType:" + poType));
            throw new LegoCheckedException(1073947393L);
        }
        this.validateProtectGroupId(protectGroupId);
        if (!VerifyUtil.isEmpty((String)filterName) && !CommonUtil.isValidDbColumn((String)filterName)) {
            LOGGER.error((Object)"filterName is incorrect.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkLongText((String)filterValue)) {
            LOGGER.error((Object)"filterValue is incorrect.");
            throw new LegoCheckedException(1073947393L);
        }
    }
}

