/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.recovery;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.reprotect.sdk.service.IReprotectService;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.platform.recovery.IRecoveryPlanRestService;
import com.huawei.ism.drm.rest.service.platform.recovery.RecoveryPlanEntity;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractRecoveryPlanRestService
extends AbstractRestService
implements IRecoveryPlanRestService {
    private static final Log LOGGER = LogFactory.getInstance(AbstractRecoveryPlanRestService.class);

    protected boolean isLocalSite(String siteId) {
        if (VerifyUtil.isEmpty((String)siteId)) {
            return false;
        }
        Site site = this.getSiteService().getSiteById(siteId);
        return !VerifyUtil.isEmpty((Object)site) && 0 == site.getSiteType();
    }

    protected boolean isExistLocalRecoverySite(Set<String> disasterSiteIds) {
        ISiteService siteService = this.getBundleService(ISiteService.class.getName(), ISiteService.class);
        List localSites = siteService.getAllLocalSites();
        boolean isLoacalDisasterSite = false;
        for (String disasterSiteId : disasterSiteIds) {
            Site disasterSite = siteService.getSiteById(disasterSiteId);
            if (null == disasterSite || !localSites.contains(disasterSite)) continue;
            isLoacalDisasterSite = true;
            break;
        }
        return isLoacalDisasterSite;
    }

    protected void checkOperationPrivilegeBySite(RecoveryPlan rp) {
        boolean isLocalRecoverySite;
        Set<String> disasterSiteIds;
        if (null == rp || VerifyUtil.isEmpty((Collection)rp.getProtectGroups())) {
            throw new LegoCheckedException(1073947393L);
        }
        ISiteService siteService = this.getBundleService(ISiteService.class.getName(), ISiteService.class);
        Iterator iterator = rp.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(2117645L);
        }
        String productSiteId = ((ProtectGroup)iterator.next()).getProductSiteId();
        Site productSite = siteService.getSiteById(productSiteId);
        List localSites = siteService.getAllLocalSites();
        if (localSites.contains(productSite) && !VerifyUtil.isEmpty(disasterSiteIds = this.getDisasterSiteIds(rp)) && 1 == disasterSiteIds.size() && !(isLocalRecoverySite = this.isExistLocalRecoverySite(disasterSiteIds))) {
            throw new LegoCheckedException(1073948711L);
        }
    }

    protected void initTestInfo(String recoveryPlanId, RecoveryPlanEntity selectedRP) {
        IRecoveryPlanService rpService = this.getRecoveryPlanService();
        Map statisticsInfo = new HashMap();
        if (!VerifyUtil.isEmpty((String)recoveryPlanId)) {
            statisticsInfo = rpService.getDrillingStatisticsInfo(recoveryPlanId);
        }
        int successCount = 0;
        int errorCount = 0;
        int totalCount = 0;
        if (!VerifyUtil.isEmpty(statisticsInfo)) {
            successCount = (Integer)statisticsInfo.get("successCount");
            errorCount = (Integer)statisticsInfo.get("failCount");
            totalCount = (Integer)statisticsInfo.get("totalCount");
        }
        selectedRP.setTestCount(totalCount);
        selectedRP.setTestFailureCount(errorCount);
        selectedRP.setTestSuccessCount(successCount);
    }

    protected String constructSiteDisplayById(String siteId) {
        Site site = this.getSiteService().getSiteById(siteId);
        if (null == site) {
            LOGGER.info((Object)"The site is not registered.", 90160758787071L);
            throw new LegoCheckedException(1073948692L);
        }
        return site.getName();
    }

    protected Set<String> getDisasterSiteIds(RecoveryPlan rp) {
        HashSet<String> disasterSites = new HashSet<String>();
        Set protectGroups = rp.getProtectGroups();
        for (ProtectGroup protectGroup : protectGroups) {
            Set gpReplicas = protectGroup.getReplicaList();
            for (ProtectGroupReplica gpReplica : gpReplicas) {
                disasterSites.add(gpReplica.getRecoverySite());
            }
        }
        return disasterSites;
    }

    protected String getKeyByType(DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        switch (procType) {
            case DISASTER_RECOVERY: {
                return "recovery.term.abstact.excute.type.disaster_recovery";
            }
            case PLANED_MOTION: {
                return "recovery.term.abstact.excute.type.planed_motion";
            }
            case DRILLING: {
                return "recovery.term.abstact.excute.type.drilling";
            }
            case CLEAN_DRILLING: {
                return "recovery.term.abstact.excute.type.clean_drilling";
            }
            case REPROTECT: {
                return "recovery.term.abstact.excute.type.reprotect";
            }
        }
        return "recovery.term.abstact.excute.type.-1";
    }

    protected IRecoveryPlanService getRecoveryPlanService() {
        return (IRecoveryPlanService)this.getBundleService("DRM_Base", IRecoveryPlanService.class.getSimpleName());
    }

    protected IReprotectService getReprotectService() {
        return (IReprotectService)this.getBundleService("DRM_Base", IReprotectService.class.getSimpleName());
    }

    protected ISiteService getSiteService() {
        return (ISiteService)this.getBundleService("DRM_Base", ISiteService.class.getName());
    }

    protected void checkLicenseControl(RecoveryPlan recoveryPlan) {
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            throw new LegoCheckedException(1073947394L);
        }
        ILicenseControl licenseControl = this.getBundleService("DRM_Base", ILicenseControl.class.getSimpleName(), ILicenseControl.class);
        PolicyTemplate policyTemplate = null;
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        ProtectGroup pg = null;
        if (iterator.hasNext()) {
            pg = (ProtectGroup)iterator.next();
            policyTemplate = pg.getTemplate();
        }
        if (VerifyUtil.isEmpty(policyTemplate)) {
            throw new LegoCheckedException(1073947394L);
        }
        licenseControl.isEnableRecoveryPlan(pg);
    }

    protected void checkLicenseControl(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE rpOptType) {
        if (null == recoveryPlan || null == recoveryPlan.getProtectGroup()) {
            LOGGER.error((Object)"recoveryPlan is null or recoveryPlan.getProtectGroups() is null ");
            throw new LegoCheckedException(1073947394L);
        }
        ILicenseControl licenseControl = this.getBundleService("DRM_Base", ILicenseControl.class.getSimpleName(), ILicenseControl.class);
        if (null == licenseControl) {
            LOGGER.error((Object)"licenseControl is null  ");
            throw new LegoCheckedException(1073947394L);
        }
        ProtectGroup pg = recoveryPlan.getProtectGroup();
        if (null == pg) {
            LOGGER.error((Object)"ProtectGroup is null  ");
            throw new LegoCheckedException(1073947394L);
        }
        licenseControl.isEnableRecoveryPlan(pg);
    }

    protected void checkLicenseCount(ProtectGroup pg) {
        ILicenseControl licenseControl = this.getBundleService("DRM_Base", ILicenseControl.class.getSimpleName(), ILicenseControl.class);
        licenseControl.checkEnablePgCount(pg);
    }

    protected String stringToJSONString(String string) {
        JSONArray jsonArray;
        if (VerifyUtil.isEmpty((String)string)) {
            return string;
        }
        String jsonString = null;
        try {
            jsonArray = JSONArray.fromObject((Object)string);
        }
        catch (Exception e) {
            String[] strArray;
            jsonArray = new JSONArray();
            for (String str : strArray = string.split(";")) {
                jsonArray.add((Object)str);
            }
        }
        if (jsonArray != null) {
            jsonString = jsonArray.toString();
        }
        return jsonString;
    }
}

