/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.util;

import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Properties;
import org.springframework.util.StringUtils;

public class WeakPasswordCheckUtil {
    private static final Log LOG = FELogFactory.getInstance((String)"weakPasswordCheck");
    private static final String WEAK_PASSWORD_PROPERTIES = "weak_password_dict.properties";
    private static final String WEAK_PASSWORD_DICT_KEY = "WeakPasswordKey";
    private static final String SPLIT_KEY = ";";
    private static final int MAX_FILE_SIZE = 5;
    private static final int NUMBER = 1024;
    private static volatile WeakPasswordCheckUtil weakPasswordCheckUtil;
    private Properties props;

    private WeakPasswordCheckUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WeakPasswordCheckUtil getInstance() {
        if (weakPasswordCheckUtil != null) return weakPasswordCheckUtil;
        Class<WeakPasswordCheckUtil> clazz = WeakPasswordCheckUtil.class;
        synchronized (WeakPasswordCheckUtil.class) {
            if (weakPasswordCheckUtil != null) return weakPasswordCheckUtil;
            weakPasswordCheckUtil = new WeakPasswordCheckUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return weakPasswordCheckUtil;
        }
    }

    public boolean checkWeakPassword(String password) {
        if (!StringUtils.hasText((String)password)) {
            return true;
        }
        if (this.props == null) {
            this.getProperties();
        }
        if (this.props.isEmpty()) {
            LOG.error((Object)"Weak Password Dict file is null");
            return false;
        }
        if (!this.props.containsKey(WEAK_PASSWORD_DICT_KEY)) {
            LOG.error((Object)"Weak Password Dict data is null");
            return false;
        }
        String dict = this.props.getProperty(WEAK_PASSWORD_DICT_KEY);
        if (!StringUtils.hasText((String)dict)) {
            LOG.error((Object)"Weak Password Dict key data is null");
            return false;
        }
        String[] data = dict.split(SPLIT_KEY);
        return Arrays.asList(data).contains(password);
    }

    private void getProperties() {
        ClassLoader clazzLoader = WeakPasswordCheckUtil.class.getClassLoader();
        this.props = new Properties();
        if (clazzLoader == null) {
            return;
        }
        URL url = clazzLoader.getResource(WEAK_PASSWORD_PROPERTIES);
        if (url == null) {
            LOG.error((Object)"get resource file does not exist.");
            return;
        }
        File pro = new File(url.getPath());
        int size = 0x500000;
        if (pro.length() > (long)size) {
            String msg = "get resource file size greater than 5M";
            LOG.error((Object)msg);
            return;
        }
        try (InputStream is = clazzLoader.getResourceAsStream(WEAK_PASSWORD_PROPERTIES);){
            this.props.load(is);
        }
        catch (IOException e) {
            LOG.error((Object)"read default.properties fail.", (Throwable)e);
        }
    }
}

