/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.filter;

import com.huawei.ism.drm.web.filter.ResponseWrapper;
import com.huawei.ism.drm.web.util.UriUtil;
import java.io.IOException;
import java.text.Normalizer;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CSRFResonseFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(CSRFResonseFilter.class);
    private boolean antiCSRF = false;
    private Pattern pattern1 = Pattern.compile("/ws/(?!\\w)\\?");
    private Pattern pattern2 = Pattern.compile("/ws/(?!\\w)('|\")");

    public void init(FilterConfig config) throws ServletException {
        if (null == config) {
            LOGGER.error((Object)"Invalid parameter");
            return;
        }
        String antiC = config.getInitParameter("AntiCSRF");
        if (StringUtils.isEmpty((CharSequence)antiC)) {
            this.antiCSRF = false;
        }
        this.antiCSRF = Boolean.valueOf(antiC);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpSession session = req.getSession(false);
        String str = req.getRequestURI();
        String uri = UriUtil.canonicalPath(str);
        if (!uri.startsWith("/ws/") || session == null) {
            chain.doFilter(request, response);
            return;
        }
        Object responseWrapper = response;
        if (this.antiCSRF && request instanceof HttpServletRequest) {
            responseWrapper = new ResponseWrapper((HttpServletResponse)response);
        }
        chain.doFilter(request, responseWrapper);
        if (this.antiCSRF && responseWrapper instanceof ResponseWrapper) {
            this.appendToken(req, response, (ResponseWrapper)((Object)responseWrapper));
        }
    }

    private void appendToken(HttpServletRequest req, ServletResponse response, ResponseWrapper responseWrapper) throws IOException {
        String text = responseWrapper.toString();
        if (!StringUtils.isEmpty((CharSequence)text)) {
            HttpSession session = req.getSession(false);
            if (null != session) {
                String replacePrefix;
                String randomStr = (String)session.getAttribute("rd_randomStr_HW");
                if (StringUtils.isEmpty((CharSequence)randomStr)) {
                    response.getWriter().write(text);
                    return;
                }
                if (!(text = text.replaceAll("</(?i)form>", "<input type='hidden' name='rd_randomStr_HW' value='" + randomStr + "' /></form>")).contains(replacePrefix = "\\?rd_randomStr_HW=")) {
                    text = this.replaceText(text, randomStr, replacePrefix);
                }
            }
            response.getWriter().write(text);
        }
    }

    private String replaceText(String text, String randomStr, String replacePrefix) {
        Matcher m = this.pattern1.matcher(Normalizer.normalize(text, Normalizer.Form.NFKC));
        if (m.find()) {
            String mg = m.group();
            text = text.replaceAll(mg.replaceAll("\\.", "\\\\.").replaceAll("\\?", "\\\\?").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)"), mg.replaceAll("\\?", replacePrefix + randomStr + "&"));
        }
        m = this.pattern2.matcher(Normalizer.normalize(text, Normalizer.Form.NFKC));
        HashSet<String> mfind = new HashSet<String>();
        while (m.find()) {
            if (mfind.contains(m.group())) continue;
            mfind.add(m.group());
        }
        for (String mg : mfind) {
            String last = mg.substring(mg.length() - 1);
            text = text.replaceAll(mg.replaceAll("\\.", "\\\\.").replaceAll("\\?", "\\\\?").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)"), mg.replaceAll("'|\"", replacePrefix + randomStr + last));
        }
        return text;
    }
}

